//
// Created by rainer on 23.02.24.
//
#include <string.h>
#include "javascript.h"
#include "javascript_callbacks.h"
#include "lib.h"
#include "charset.h"
#include "mem.h"
#include "logginghelpers.h"


static JSValue is_key_available(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"keycode", JS_TAG_INT, 0, 0, 0},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        uint32_t code = 0;
        JS_ToUint32(ctx, &code, argv[0]);
        ret = JS_NewBool(ctx, js_is_keycode_supported((int)code));
    }
    return ret;
}
static JSValue show_virtual_keyboard(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"screenpart", JS_TAG_INT, 1, 1, 3},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        uint32_t screenpart = 0;
        JS_ToUint32(ctx, &screenpart, argv[0]);
        js_request_virtual_keyboard((int) screenpart);
        ret = JS_UNDEFINED;
    }
    return ret;
}
static JSValue restore_virtual_keyboard_visibility(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        js_restore_virtual_keyboard();
        ret = JS_UNDEFINED;
    }
    return ret;
}

static JSValue take_test_screenshot(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"filename", JS_TAG_STRING, 1, 1, 255}
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        const char* filename = JS_ToCString(ctx, argv[0]);
        js_take_test_screenshot(filename);
        JS_FreeCString(ctx, filename);
        ret = JS_UNDEFINED;
    }
    return ret;


}

static JSValue get_system_language(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {

    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        const char* s = js_get_system_language();
        ret = s ? JS_NewString(ctx, s) : JS_UNDEFINED;
        lib_free((void*)s);
    }
    return ret;

}
static JSValue get_devicefeature(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"feature", JS_TAG_INT, 0, 0, 0},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        uint32_t feature = 0;
        JS_ToUint32(ctx, &feature, argv[0]);
        ret = JS_NewBool(ctx, js_get_devicefeature((int) feature));
    }
    return ret;
}
static JSValue get_initinal_snapshot_level(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        ret = JS_NewInt32(ctx, js_get_initial_snapshot_level());
    }
    return ret;
}
static JSValue store_initial_snapshot(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"level", JS_TAG_INT, 1, 0, 9}
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        uint32_t level = 0;
        JS_ToUint32(ctx, &level, argv[0]);
        js_store_initial_snapshot(level);
        ret = JS_UNDEFINED;
    }
    return ret;

}
const JSCFunctionListEntry environmentfunctions[] = {
        JS_CFUNC_DEF("storeInitialSnapshot", 1, store_initial_snapshot),
        JS_CFUNC_DEF("getInitialSnapshotLevel", 0, get_initinal_snapshot_level),
        JS_CFUNC_DEF("getDeviceFeature", 1, get_devicefeature),
        JS_CFUNC_DEF("isKeyAvailable", 1, is_key_available),
        JS_CFUNC_DEF("showVirtualKeyboard", 1, show_virtual_keyboard),
        JS_CFUNC_DEF("restoreVirtualKeyboardVisibility", 1, restore_virtual_keyboard_visibility),
        JS_CFUNC_DEF("_getSystemLanguage", 0, get_system_language),
        JS_CFUNC_DEF("takeTestScreenshot",1, take_test_screenshot)


};

int environmentfunctions_size = sizeof(environmentfunctions) / sizeof(environmentfunctions[0]);
