//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include "translate.h"
#include <stdio.h>
#include "translate_javastubs.h"
t_javaResId translate_resources_gen[]= {
	{IDMS_FILE,"IDMS_FILE"},
	{IDMS_AUTOSTART_IMAGE,"IDMS_AUTOSTART_IMAGE"},
	{IDMS_ATTACH_DISK_IMAGE,"IDMS_ATTACH_DISK_IMAGE"},
	{IDMS_DRIVE_8,"IDMS_DRIVE_8"},
	{IDMS_DRIVE_9,"IDMS_DRIVE_9"},
	{IDMS_DRIVE_10,"IDMS_DRIVE_10"},
	{IDMS_DRIVE_11,"IDMS_DRIVE_11"},
	{IDMS_DETACH_DISK_IMAGE,"IDMS_DETACH_DISK_IMAGE"},
	{IDMS_ALL,"IDMS_ALL"},
	{IDMS_FLIP_LIST,"IDMS_FLIP_LIST"},
	{IDMS_ADD_CURRENT_IMAGE,"IDMS_ADD_CURRENT_IMAGE"},
	{IDMS_REMOVE_CURRENT_IMAGE,"IDMS_REMOVE_CURRENT_IMAGE"},
	{IDMS_ATTACH_NEXT_IMAGE,"IDMS_ATTACH_NEXT_IMAGE"},
	{IDMS_ATTACH_PREVIOUS_IMAGE,"IDMS_ATTACH_PREVIOUS_IMAGE"},
	{IDMS_LOAD_FLIP_LIST,"IDMS_LOAD_FLIP_LIST"},
	{IDMS_SAVE_FLIP_LIST,"IDMS_SAVE_FLIP_LIST"},
	{IDMS_ATTACH_TAPE_IMAGE,"IDMS_ATTACH_TAPE_IMAGE"},
	{IDMS_DETACH_TAPE_IMAGE,"IDMS_DETACH_TAPE_IMAGE"},
	{IDMS_DATASSETTE_CONTROL,"IDMS_DATASSETTE_CONTROL"},
	{IDMS_STOP,"IDMS_STOP"},
	{IDMS_START,"IDMS_START"},
	{IDMS_FORWARD,"IDMS_FORWARD"},
	{IDMS_REWIND,"IDMS_REWIND"},
	{IDMS_RECORD,"IDMS_RECORD"},
	{IDMS_RESET,"IDMS_RESET"},
	{IDMS_ATTACH_CART_IMAGE,"IDMS_ATTACH_CART_IMAGE"},
	{IDMS_GENERIC_IMAGE,"IDMS_GENERIC_IMAGE"},
	{IDMS_MEGA_CART_IMAGE,"IDMS_MEGA_CART_IMAGE"},
	{IDMS_FINAL_EXPANSION_IMAGE,"IDMS_FINAL_EXPANSION_IMAGE"},
	{IDMS_FP_IMAGE,"IDMS_FP_IMAGE"},
	{IDMS_ADD_TO_GENERIC,"IDMS_ADD_TO_GENERIC"},
	{IDMS_SMART_ATTACH_IMAGE,"IDMS_SMART_ATTACH_IMAGE"},
	{IDMS_4_8_16KB_AT_2000,"IDMS_4_8_16KB_AT_2000"},
	{IDMS_4_8_16KB_AT_4000,"IDMS_4_8_16KB_AT_4000"},
	{IDMS_4_8_16KB_AT_6000,"IDMS_4_8_16KB_AT_6000"},
	{IDMS_4_8KB_AT_A000,"IDMS_4_8KB_AT_A000"},
	{IDMS_4KB_AT_B000,"IDMS_4KB_AT_B000"},
	{IDMS_DETACH_CART_IMAGE,"IDMS_DETACH_CART_IMAGE"},
	{IDMS_C0_LOW_IMAGE,"IDMS_C0_LOW_IMAGE"},
	{IDMS_C0_HIGH_IMAGE,"IDMS_C0_HIGH_IMAGE"},
	{IDMS_C1_LOW_IMAGE,"IDMS_C1_LOW_IMAGE"},
	{IDMS_C1_HIGH_IMAGE,"IDMS_C1_HIGH_IMAGE"},
	{IDMS_C2_LOW_IMAGE,"IDMS_C2_LOW_IMAGE"},
	{IDMS_C2_HIGH_IMAGE,"IDMS_C2_HIGH_IMAGE"},
	{IDMS_FUNCTION_LOW_3PLUS1,"IDMS_FUNCTION_LOW_3PLUS1"},
	{IDMS_FUNCTION_HIGH_3PLUS1,"IDMS_FUNCTION_HIGH_3PLUS1"},
	{IDMS_LOAD_CART_1XXX,"IDMS_LOAD_CART_1XXX"},
	{IDMS_UNLOAD_CART_1XXX,"IDMS_UNLOAD_CART_1XXX"},
	{IDMS_LOAD_CART_2_3XXX,"IDMS_LOAD_CART_2_3XXX"},
	{IDMS_UNLOAD_CART_2_3XXX,"IDMS_UNLOAD_CART_2_3XXX"},
	{IDMS_LOAD_CART_4_5XXX,"IDMS_LOAD_CART_4_5XXX"},
	{IDMS_UNLOAD_CART_4_5XXX,"IDMS_UNLOAD_CART_4_5XXX"},
	{IDMS_LOAD_CART_6_7XXX,"IDMS_LOAD_CART_6_7XXX"},
	{IDMS_UNLOAD_CART_6_7XXX,"IDMS_UNLOAD_CART_6_7XXX"},
	{IDMS_CRT_IMAGE,"IDMS_CRT_IMAGE"},
	{IDMS_GENERIC_8KB_IMAGE,"IDMS_GENERIC_8KB_IMAGE"},
	{IDMS_GENERIC_16KB_IMAGE,"IDMS_GENERIC_16KB_IMAGE"},
	{IDMS_ACTION_REPLAY_IMAGE,"IDMS_ACTION_REPLAY_IMAGE"},
	{IDMS_ACTION_REPLAY3_IMAGE,"IDMS_ACTION_REPLAY3_IMAGE"},
	{IDMS_ACTION_REPLAY4_IMAGE,"IDMS_ACTION_REPLAY4_IMAGE"},
	{IDMS_STARDOS_IMAGE,"IDMS_STARDOS_IMAGE"},
	{IDMS_ATOMIC_POWER_IMAGE,"IDMS_ATOMIC_POWER_IMAGE"},
	{IDMS_EPYX_FASTLOAD_IMAGE,"IDMS_EPYX_FASTLOAD_IMAGE"},
	{IDMS_IEEE488_INTERFACE_IMAGE,"IDMS_IEEE488_INTERFACE_IMAGE"},
	{IDMS_RETRO_REPLAY_IMAGE,"IDMS_RETRO_REPLAY_IMAGE"},
	{IDMS_IDE64_INTERFACE_IMAGE,"IDMS_IDE64_INTERFACE_IMAGE"},
	{IDMS_SUPER_SNAPSHOT_4_IMAGE,"IDMS_SUPER_SNAPSHOT_4_IMAGE"},
	{IDMS_SUPER_SNAPSHOT_5_IMAGE,"IDMS_SUPER_SNAPSHOT_5_IMAGE"},
	{IDMS_STRUCTURED_BASIC_IMAGE,"IDMS_STRUCTURED_BASIC_IMAGE"},
	{IDMS_ENABLE,"IDMS_ENABLE"},
	{IDMS_SET_CART_AS_DEFAULT,"IDMS_SET_CART_AS_DEFAULT"},
	{IDMS_RESET_ON_CART_CHANGE,"IDMS_RESET_ON_CART_CHANGE"},
	{IDMS_CART_FREEZE,"IDMS_CART_FREEZE"},
	{IDMS_PAUSE,"IDMS_PAUSE"},
	{IDMS_MONITOR,"IDMS_MONITOR"},
	{IDMS_HARD,"IDMS_HARD"},
	{IDMS_SOFT,"IDMS_SOFT"},
	{IDMS_EXIT,"IDMS_EXIT"},
	{IDMS_EDIT,"IDMS_EDIT"},
	{IDMS_COPY,"IDMS_COPY"},
	{IDMS_PASTE,"IDMS_PASTE"},
	{IDMS_SNAPSHOT,"IDMS_SNAPSHOT"},
	{IDMS_LOAD_SNAPSHOT_IMAGE,"IDMS_LOAD_SNAPSHOT_IMAGE"},
	{IDMS_SAVE_SNAPSHOT_IMAGE,"IDMS_SAVE_SNAPSHOT_IMAGE"},
	{IDMS_START_STOP_RECORDING,"IDMS_START_STOP_RECORDING"},
	{IDMS_START_STOP_PLAYBACK,"IDMS_START_STOP_PLAYBACK"},
	{IDMS_SET_MILESTONE,"IDMS_SET_MILESTONE"},
	{IDMS_RETURN_TO_MILESTONE,"IDMS_RETURN_TO_MILESTONE"},
	{IDMS_RECORDING_START_MODE,"IDMS_RECORDING_START_MODE"},
	{IDMS_SAVE_NEW_SNAPSHOT,"IDMS_SAVE_NEW_SNAPSHOT"},
	{IDMS_LOAD_EXISTING_SNAPSHOT,"IDMS_LOAD_EXISTING_SNAPSHOT"},
	{IDMS_START_WITH_RESET,"IDMS_START_WITH_RESET"},
	{IDMS_OVERWRITE_PLAYBACK,"IDMS_OVERWRITE_PLAYBACK"},
	{IDMS_SELECT_HISTORY_DIR,"IDMS_SELECT_HISTORY_DIR"},
	{IDMS_SAVE_STOP_MEDIA_FILE,"IDMS_SAVE_STOP_MEDIA_FILE"},
	{IDMS_NETPLAY,"IDMS_NETPLAY"},
	{IDMS_OPTIONS,"IDMS_OPTIONS"},
	{IDMS_REFRESH_RATE,"IDMS_REFRESH_RATE"},
	{IDMS_AUTO,"IDMS_AUTO"},
	{IDMS_1_1,"IDMS_1_1"},
	{IDMS_1_2,"IDMS_1_2"},
	{IDMS_1_3,"IDMS_1_3"},
	{IDMS_1_4,"IDMS_1_4"},
	{IDMS_1_5,"IDMS_1_5"},
	{IDMS_1_6,"IDMS_1_6"},
	{IDMS_1_7,"IDMS_1_7"},
	{IDMS_1_8,"IDMS_1_8"},
	{IDMS_1_9,"IDMS_1_9"},
	{IDMS_1_10,"IDMS_1_10"},
	{IDMS_MAXIMUM_SPEED,"IDMS_MAXIMUM_SPEED"},
	{IDMS_200_PERCENT,"IDMS_200_PERCENT"},
	{IDMS_100_PERCENT,"IDMS_100_PERCENT"},
	{IDMS_50_PERCENT,"IDMS_50_PERCENT"},
	{IDMS_20_PERCENT,"IDMS_20_PERCENT"},
	{IDMS_10_PERCENT,"IDMS_10_PERCENT"},
	{IDMS_NO_LIMIT,"IDMS_NO_LIMIT"},
	{IDMS_CUSTOM,"IDMS_CUSTOM"},
	{IDMS_WARP_MODE,"IDMS_WARP_MODE"},
	{IDMS_FULLSCREEN,"IDMS_FULLSCREEN"},
	{IDMS_VIDEO_CACHE,"IDMS_VIDEO_CACHE"},
	{IDMS_DOUBLE_SIZE,"IDMS_DOUBLE_SIZE"},
	{IDMS_DOUBLE_SCAN,"IDMS_DOUBLE_SCAN"},
	{IDMS_VERTICAL_STRETCH,"IDMS_VERTICAL_STRETCH"},
	{IDMS_VDC_SETTINGS,"IDMS_VDC_SETTINGS"},
	{IDMS_64KB_VIDEO_MEMORY,"IDMS_64KB_VIDEO_MEMORY"},
	{IDMS_VDC_REVISION,"IDMS_VDC_REVISION"},
	{IDMS_VDC_REV_0,"IDMS_VDC_REV_0"},
	{IDMS_VDC_REV_1,"IDMS_VDC_REV_1"},
	{IDMS_VDC_REV_2,"IDMS_VDC_REV_2"},
	{IDMS_SWAP_JOYSTICKS,"IDMS_SWAP_JOYSTICKS"},
	{IDMS_SWAP_USERPORT_JOYSTICKS,"IDMS_SWAP_USERPORT_JOYSTICKS"},
	{IDMS_CGA_USERPORT_JOY_ADAPTER,"IDMS_CGA_USERPORT_JOY_ADAPTER"},
	{IDMS_PET_USERPORT_JOY_ADAPTER,"IDMS_PET_USERPORT_JOY_ADAPTER"},
	{IDMS_HUMMER_USERPORT_JOY_ADAPTER,"IDMS_HUMMER_USERPORT_JOY_ADAPTER"},
	{IDMS_OEM_USERPORT_JOY_ADAPTER,"IDMS_OEM_USERPORT_JOY_ADAPTER"},
	{IDMS_HIT_USERPORT_JOY_ADAPTER,"IDMS_HIT_USERPORT_JOY_ADAPTER"},
	{IDMS_KINGSOFT_USERPORT_JOY_ADAPTER,"IDMS_KINGSOFT_USERPORT_JOY_ADAPTER"},
	{IDMS_STARBYTE_USERPORT_JOY_ADAPTER,"IDMS_STARBYTE_USERPORT_JOY_ADAPTER"},
	{IDMS_ENABLE_JOY_KEYS,"IDMS_ENABLE_JOY_KEYS"},
	{IDMS_OPPOSITE_JOY_DIR,"IDMS_OPPOSITE_JOY_DIR"},
	{IDMS_SOUND_PLAYBACK,"IDMS_SOUND_PLAYBACK"},
	{IDMS_TRUE_DRIVE_EMU,"IDMS_TRUE_DRIVE_EMU"},
	{IDMS_DRIVE_SOUND,"IDMS_DRIVE_SOUND"},
	{IDMS_AUTOSTART_HANDLE_TDE,"IDMS_AUTOSTART_HANDLE_TDE"},
	{IDMS_VIRTUAL_DEVICE_TRAPS,"IDMS_VIRTUAL_DEVICE_TRAPS"},
	{IDMS_DRIVE_SYNC_FACTOR,"IDMS_DRIVE_SYNC_FACTOR"},
	{IDMS_PAL,"IDMS_PAL"},
	{IDMS_NTSC,"IDMS_NTSC"},
	{IDMS_VIDEO_STANDARD,"IDMS_VIDEO_STANDARD"},
	{IDMS_PAL_G,"IDMS_PAL_G"},
	{IDMS_NTSC_M,"IDMS_NTSC_M"},
	{IDMS_OLD_NTSC_M,"IDMS_OLD_NTSC_M"},
	{IDMS_VIC_1112_IEEE_488,"IDMS_VIC_1112_IEEE_488"},
	{IDMS_ENABLE_PADDLES,"IDMS_ENABLE_PADDLES"},
	{IDMS_IEEE_488_INTERFACE,"IDMS_IEEE_488_INTERFACE"},
	{IDMS_GRAB_MOUSE,"IDMS_GRAB_MOUSE"},
	{IDMS_PS2_MOUSE,"IDMS_PS2_MOUSE"},
	{IDMS_SETTINGS,"IDMS_SETTINGS"},
	{IDMS_C64_MODEL_SETTINGS,"IDMS_C64_MODEL_SETTINGS"},
	{IDMS_C64_PAL,"IDMS_C64_PAL"},
	{IDMS_C64C_PAL,"IDMS_C64C_PAL"},
	{IDMS_C64_OLD_PAL,"IDMS_C64_OLD_PAL"},
	{IDMS_C64_NTSC,"IDMS_C64_NTSC"},
	{IDMS_C64C_NTSC,"IDMS_C64C_NTSC"},
	{IDMS_C64_OLD_NTSC,"IDMS_C64_OLD_NTSC"},
	{IDMS_DREAN,"IDMS_DREAN"},
	{IDMS_CUSTOM_C64_MODEL,"IDMS_CUSTOM_C64_MODEL"},
	{IDMS_PLUS4_MODEL_SETTINGS,"IDMS_PLUS4_MODEL_SETTINGS"},
	{IDMS_C16_PAL,"IDMS_C16_PAL"},
	{IDMS_C16_NTSC,"IDMS_C16_NTSC"},
	{IDMS_PLUS4_PAL,"IDMS_PLUS4_PAL"},
	{IDMS_PLUS4_NTSC,"IDMS_PLUS4_NTSC"},
	{IDMS_V364_NTSC,"IDMS_V364_NTSC"},
	{IDMS_C232_NTSC,"IDMS_C232_NTSC"},
	{IDMS_C64DTV_MODEL_SETTINGS,"IDMS_C64DTV_MODEL_SETTINGS"},
	{IDMS_C64DTV2_PAL,"IDMS_C64DTV2_PAL"},
	{IDMS_C64DTV2_NTSC,"IDMS_C64DTV2_NTSC"},
	{IDMS_C64DTV3_PAL,"IDMS_C64DTV3_PAL"},
	{IDMS_C64DTV3_NTSC,"IDMS_C64DTV3_NTSC"},
	{IDMS_HUMMER_NTSC,"IDMS_HUMMER_NTSC"},
	{IDMS_C128_MODEL_SETTINGS,"IDMS_C128_MODEL_SETTINGS"},
	{IDMS_C128_PAL,"IDMS_C128_PAL"},
	{IDMS_C128DCR_PAL,"IDMS_C128DCR_PAL"},
	{IDMS_C128_NTSC,"IDMS_C128_NTSC"},
	{IDMS_C128DCR_NTSC,"IDMS_C128DCR_NTSC"},
	{IDMS_PET_MODEL_SETTINGS,"IDMS_PET_MODEL_SETTINGS"},
	{IDMS_2001,"IDMS_2001"},
	{IDMS_3008,"IDMS_3008"},
	{IDMS_3016,"IDMS_3016"},
	{IDMS_3032,"IDMS_3032"},
	{IDMS_4016,"IDMS_4016"},
	{IDMS_4032,"IDMS_4032"},
	{IDMS_8032,"IDMS_8032"},
	{IDMS_8096,"IDMS_8096"},
	{IDMS_8296,"IDMS_8296"},
	{IDMS_SUPERPET,"IDMS_SUPERPET"},
	{IDMS_CBM2_MODEL_SETTINGS,"IDMS_CBM2_MODEL_SETTINGS"},
	{IDMS_610_PAL,"IDMS_610_PAL"},
	{IDMS_610_NTSC,"IDMS_610_NTSC"},
	{IDMS_620_PAL,"IDMS_620_PAL"},
	{IDMS_620_NTSC,"IDMS_620_NTSC"},
	{IDMS_620PLUS_PAL,"IDMS_620PLUS_PAL"},
	{IDMS_620PLUS_NTSC,"IDMS_620PLUS_NTSC"},
	{IDMS_710_NTSC,"IDMS_710_NTSC"},
	{IDMS_720_NTSC,"IDMS_720_NTSC"},
	{IDMS_720PLUS_NTSC,"IDMS_720PLUS_NTSC"},
	{IDMS_CBM5X0_MODEL_SETTINGS,"IDMS_CBM5X0_MODEL_SETTINGS"},
	{IDMS_510_PAL,"IDMS_510_PAL"},
	{IDMS_510_NTSC,"IDMS_510_NTSC"},
	{IDMS_AUTOSTART_SETTINGS,"IDMS_AUTOSTART_SETTINGS"},
	{IDMS_VICII_VIDEO_SETTINGS,"IDMS_VICII_VIDEO_SETTINGS"},
	{IDMS_VIC_VIDEO_SETTINGS,"IDMS_VIC_VIDEO_SETTINGS"},
	{IDMS_VDC_VIDEO_SETTINGS,"IDMS_VDC_VIDEO_SETTINGS"},
	{IDMS_CRTC_VIDEO_SETTINGS,"IDMS_CRTC_VIDEO_SETTINGS"},
	{IDMS_TED_VIDEO_SETTINGS,"IDMS_TED_VIDEO_SETTINGS"},
	{IDMS_AUDIO_LEAK,"IDMS_AUDIO_LEAK"},
	{IDMS_PALETTE_SETTINGS,"IDMS_PALETTE_SETTINGS"},
	{IDMS_COLOR_SETTINGS,"IDMS_COLOR_SETTINGS"},
	{IDMS_RENDER_FILTER,"IDMS_RENDER_FILTER"},
	{IDMS_CRT_EMULATION_SETTINGS,"IDMS_CRT_EMULATION_SETTINGS"},
	{IDMS_VIC20_SETTINGS,"IDMS_VIC20_SETTINGS"},
	{IDMS_CBM2_SETTINGS,"IDMS_CBM2_SETTINGS"},
	{IDMS_CBM5X0_SETTINGS,"IDMS_CBM5X0_SETTINGS"},
	{IDMS_PET_SETTINGS,"IDMS_PET_SETTINGS"},
	{IDMS_PERIPHERAL_SETTINGS,"IDMS_PERIPHERAL_SETTINGS"},
	{IDMS_DRIVE_SETTINGS,"IDMS_DRIVE_SETTINGS"},
	{IDMS_PRINTER_SETTINGS,"IDMS_PRINTER_SETTINGS"},
	{IDMS_DATASETTE_SETTINGS,"IDMS_DATASETTE_SETTINGS"},
	{IDMS_PLUS4_SETTINGS,"IDMS_PLUS4_SETTINGS"},
	{IDMS_VICII_SETTINGS,"IDMS_VICII_SETTINGS"},
	{IDMS_VIC_SETTINGS,"IDMS_VIC_SETTINGS"},
	{IDMS_TED_SETTINGS,"IDMS_TED_SETTINGS"},
	{IDMS_JOYSTICK_SETTINGS,"IDMS_JOYSTICK_SETTINGS"},
	{IDMS_JOYSTICK_DEVICE_SELECT,"IDMS_JOYSTICK_DEVICE_SELECT"},
	{IDMS_JOYSTICK_FIRE_SELECT,"IDMS_JOYSTICK_FIRE_SELECT"},
	{IDMS_KEYBOARD_SETTINGS,"IDMS_KEYBOARD_SETTINGS"},
	{IDMS_MOUSE_SETTINGS,"IDMS_MOUSE_SETTINGS"},
	{IDMS_SOUND_SETTINGS,"IDMS_SOUND_SETTINGS"},
	{IDMS_SID_SETTINGS,"IDMS_SID_SETTINGS"},
	{IDMS_CIA_SETTINGS,"IDMS_CIA_SETTINGS"},
	{IDMS_COMPUTER_ROM_SETTINGS,"IDMS_COMPUTER_ROM_SETTINGS"},
	{IDMS_DRIVE_ROM_SETTINGS,"IDMS_DRIVE_ROM_SETTINGS"},
	{IDMS_RAM_SETTINGS,"IDMS_RAM_SETTINGS"},
	{IDMS_RS232_SETTINGS,"IDMS_RS232_SETTINGS"},
	{IDMS_C128_SETTINGS,"IDMS_C128_SETTINGS"},
	{IDMS_CART_IO_SETTINGS,"IDMS_CART_IO_SETTINGS"},
	{IDMS_REU_SETTINGS,"IDMS_REU_SETTINGS"},
	{IDMS_MAGIC_VOICE_SETTINGS,"IDMS_MAGIC_VOICE_SETTINGS"},
	{IDMS_GEORAM_SETTINGS,"IDMS_GEORAM_SETTINGS"},
	{IDMS_RAMCART_SETTINGS,"IDMS_RAMCART_SETTINGS"},
	{IDMS_DQBB_SETTINGS,"IDMS_DQBB_SETTINGS"},
	{IDMS_ISEPIC_SETTINGS,"IDMS_ISEPIC_SETTINGS"},
	{IDMS_EXPERT_SETTINGS,"IDMS_EXPERT_SETTINGS"},
	{IDMS_PLUS60K_SETTINGS,"IDMS_PLUS60K_SETTINGS"},
	{IDS_PLUS256K_FILENAME,"IDS_PLUS256K_FILENAME"},
	{IDMS_PLUS256K_SETTINGS,"IDMS_PLUS256K_SETTINGS"},
	{IDMS_256K_SETTINGS,"IDMS_256K_SETTINGS"},
	{IDMS_IDE64_SETTINGS,"IDMS_IDE64_SETTINGS"},
	{IDMS_MMC64_SETTINGS,"IDMS_MMC64_SETTINGS"},
	{IDMS_MMCREPLAY_SETTINGS,"IDMS_MMCREPLAY_SETTINGS"},
	{IDMS_RETROREPLAY_SETTINGS,"IDMS_RETROREPLAY_SETTINGS"},
	{IDMS_DIGIMAX_SETTINGS,"IDMS_DIGIMAX_SETTINGS"},
	{IDMS_DS12C887RTC_SETTINGS,"IDMS_DS12C887RTC_SETTINGS"},
	{IDMS_SFX_SE_SETTINGS,"IDMS_SFX_SE_SETTINGS"},
	{IDMS_SFX_SS_SETTINGS_MASCUERADE,"IDMS_SFX_SS_SETTINGS_MASCUERADE"},
	{IDMS_EASYFLASH_SETTINGS,"IDMS_EASYFLASH_SETTINGS"},
	{IDMS_ENABLE_SFX_SS,"IDMS_ENABLE_SFX_SS"},
	{IDMS_ENABLE_USERPORT_RTC,"IDMS_ENABLE_USERPORT_RTC"},
	{IDMS_BURST_MOD_SETTINGS,"IDMS_BURST_MOD_SETTINGS"},
	{IDMS_ENABLE_USERPORT_DAC,"IDMS_ENABLE_USERPORT_DAC"},
	{IDMS_ETHERNET_SETTINGS,"IDMS_ETHERNET_SETTINGS"},
	{IDMS_ACIA_SETTINGS,"IDMS_ACIA_SETTINGS"},
	{IDMS_PETREU_SETTINGS,"IDMS_PETREU_SETTINGS"},
	{IDMS_V364_SPEECH_SETTINGS,"IDMS_V364_SPEECH_SETTINGS"},
	{IDMS_SIDCART_SETTINGS,"IDMS_SIDCART_SETTINGS"},
	{IDMS_PETDWW_SETTINGS,"IDMS_PETDWW_SETTINGS"},
	{IDMS_FINAL_EXPANSION_WRITEBACK,"IDMS_FINAL_EXPANSION_WRITEBACK"},
	{IDMS_FP_WRITEBACK,"IDMS_FP_WRITEBACK"},
	{IDMS_MEGACART_WRITEBACK,"IDMS_MEGACART_WRITEBACK"},
	{IDMS_C64DTV_SETTINGS,"IDMS_C64DTV_SETTINGS"},
	{IDMS_RS232_USERPORT_SETTINGS,"IDMS_RS232_USERPORT_SETTINGS"},
	{IDMS_SAVE_CURRENT_SETTINGS_FILE,"IDMS_SAVE_CURRENT_SETTINGS_FILE"},
	{IDMS_LOAD_SAVED_SETTINGS_FILE,"IDMS_LOAD_SAVED_SETTINGS_FILE"},
	{IDMS_SAVE_CURRENT_SETTINGS,"IDMS_SAVE_CURRENT_SETTINGS"},
	{IDMS_LOAD_SAVED_SETTINGS,"IDMS_LOAD_SAVED_SETTINGS"},
	{IDMS_SET_DEFAULT_SETTINGS,"IDMS_SET_DEFAULT_SETTINGS"},
	{IDMS_SAVE_SETTING_ON_EXIT,"IDMS_SAVE_SETTING_ON_EXIT"},
	{IDMS_CONFIRM_ON_EXIT,"IDMS_CONFIRM_ON_EXIT"},
	{IDMS_HELP,"IDMS_HELP"},
	{IDMS_ABOUT,"IDMS_ABOUT"},
	{IDMS_COMMAND_LINE_OPTIONS,"IDMS_COMMAND_LINE_OPTIONS"},
	{IDMS_CONTRIBUTORS,"IDMS_CONTRIBUTORS"},
	{IDMS_LICENSE,"IDMS_LICENSE"},
	{IDMS_NO_WARRANTY,"IDMS_NO_WARRANTY"},
	{IDMS_LANGUAGE_INTERNATIONAL,"IDMS_LANGUAGE_INTERNATIONAL"},
	{IDMS_LANGUAGE_ENGLISH,"IDMS_LANGUAGE_ENGLISH"},
	{IDMS_LANGUAGE_DANISH,"IDMS_LANGUAGE_DANISH"},
	{IDMS_LANGUAGE_GERMAN,"IDMS_LANGUAGE_GERMAN"},
	{IDMS_LANGUAGE_SPANISH,"IDMS_LANGUAGE_SPANISH"},
	{IDMS_LANGUAGE_FINNISH,"IDMS_LANGUAGE_FINNISH"},
	{IDMS_LANGUAGE_FRENCH,"IDMS_LANGUAGE_FRENCH"},
	{IDMS_LANGUAGE_HUNGARIAN,"IDMS_LANGUAGE_HUNGARIAN"},
	{IDMS_LANGUAGE_ITALIAN,"IDMS_LANGUAGE_ITALIAN"},
	{IDMS_LANGUAGE_KOREAN,"IDMS_LANGUAGE_KOREAN"},
	{IDMS_LANGUAGE_DUTCH,"IDMS_LANGUAGE_DUTCH"},
	{IDMS_LANGUAGE_POLISH,"IDMS_LANGUAGE_POLISH"},
	{IDMS_LANGUAGE_NORWEGIAN,"IDMS_LANGUAGE_NORWEGIAN"},
	{IDMS_LANGUAGE_RUSSIAN,"IDMS_LANGUAGE_RUSSIAN"},
	{IDMS_LANGUAGE_SWEDISH,"IDMS_LANGUAGE_SWEDISH"},
	{IDMS_LANGUAGE_TURKISH,"IDMS_LANGUAGE_TURKISH"},
	{IDMS_LANGUAGE,"IDMS_LANGUAGE"},
	{IDMS_FULLSCREEN_STATUSBAR,"IDMS_FULLSCREEN_STATUSBAR"},
	{IDMS_VIDEO_OVERLAY,"IDMS_VIDEO_OVERLAY"},
	{IDMS_START_SOUND_RECORD,"IDMS_START_SOUND_RECORD"},
	{IDMS_STOP_SOUND_RECORD,"IDMS_STOP_SOUND_RECORD"},
	{IDMS_LOAD_PSID_FILE,"IDMS_LOAD_PSID_FILE"},
	{IDMS_NEXT_TUNE,"IDMS_NEXT_TUNE"},
	{IDMS_PREVIOUS_TUNE,"IDMS_PREVIOUS_TUNE"},
	{IDMS_MEDIA,"IDMS_MEDIA"},
	{IDMS_OVERRIDE_PSID_SETTINGS,"IDMS_OVERRIDE_PSID_SETTINGS"},
	{IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD,"IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD"},
	{IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD,"IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD"},
	{IDMES_SETTINGS_SAVED_SUCCESS,"IDMES_SETTINGS_SAVED_SUCCESS"},
	{IDMES_SETTINGS_LOAD_SUCCESS,"IDMES_SETTINGS_LOAD_SUCCESS"},
	{IDMES_DFLT_SETTINGS_RESTORED,"IDMES_DFLT_SETTINGS_RESTORED"},
	{IDMES_VICE_MESSAGE,"IDMES_VICE_MESSAGE"},
	{IDMES_OK,"IDMES_OK"},
	{IDMES_VICE_CONTRIBUTORS,"IDMES_VICE_CONTRIBUTORS"},
	{IDMES_WHO_MADE_WHAT,"IDMES_WHO_MADE_WHAT"},
	{IDMES_VICE_DIST_NO_WARRANTY,"IDMES_VICE_DIST_NO_WARRANTY"},
	{IDMES_WHICH_COMMANDS_AVAILABLE,"IDMES_WHICH_COMMANDS_AVAILABLE"},
	{IDMES_CANNOT_SAVE_SETTINGS,"IDMES_CANNOT_SAVE_SETTINGS"},
	{IDMES_CANNOT_LOAD_SETTINGS,"IDMES_CANNOT_LOAD_SETTINGS"},
	{IDMES_VICE_ERROR,"IDMES_VICE_ERROR"},
	{IDMES_DEVICE_NOT_GAMEPAD,"IDMES_DEVICE_NOT_GAMEPAD"},
	{IDMES_NOT_MAPPED_TO_AMIGA_PORT,"IDMES_NOT_MAPPED_TO_AMIGA_PORT"},
	{IDMES_CANNOT_AUTOSTART_FILE,"IDMES_CANNOT_AUTOSTART_FILE"},
	{IDMES_CANNOT_ATTACH_FILE,"IDMES_CANNOT_ATTACH_FILE"},
	{IDMES_INVALID_CART,"IDMES_INVALID_CART"},
	{IDMES_BAD_CART_CONFIG_IN_UI,"IDMES_BAD_CART_CONFIG_IN_UI"},
	{IDMES_INVALID_CART_IMAGE,"IDMES_INVALID_CART_IMAGE"},
	{IDMES_CANNOT_CREATE_IMAGE,"IDMES_CANNOT_CREATE_IMAGE"},
	{IDMES_ERROR_STARTING_SERVER,"IDMES_ERROR_STARTING_SERVER"},
	{IDMES_ERROR_CONNECTING_CLIENT,"IDMES_ERROR_CONNECTING_CLIENT"},
	{IDMES_INVALID_PORT_NUMBER,"IDMES_INVALID_PORT_NUMBER"},
	{IDMES_THIS_MACHINE_NO_SID,"IDMES_THIS_MACHINE_NO_SID"},
	{IDMES_SCREENSHOT_SAVE_S_FAILED,"IDMES_SCREENSHOT_SAVE_S_FAILED"},
	{IDMES_SCREENSHOT_S_SAVED,"IDMES_SCREENSHOT_S_SAVED"},
	{IDS_PRESS_KEY_BUTTON,"IDS_PRESS_KEY_BUTTON"},
	{IDS_SAVE,"IDS_SAVE"},
	{IDS_BROWSE,"IDS_BROWSE"},
	{IDS_CURRENT_MODE,"IDS_CURRENT_MODE"},
	{IDS_TCP_PORT,"IDS_TCP_PORT"},
	{IDS_START_SERVER,"IDS_START_SERVER"},
	{IDS_SERVER_BIND,"IDS_SERVER_BIND"},
	{IDS_CONNECT_TO,"IDS_CONNECT_TO"},
	{IDS_DISCONNECT,"IDS_DISCONNECT"},
	{IDS_IDLE,"IDS_IDLE"},
	{IDS_SERVER_LISTENING,"IDS_SERVER_LISTENING"},
	{IDS_CONNECTED_SERVER,"IDS_CONNECTED_SERVER"},
	{IDS_CONNECTED_CLIENT,"IDS_CONNECTED_CLIENT"},
	{IDS_NETPLAY_SETTINGS,"IDS_NETPLAY_SETTINGS"},
	{IDS_SAVE_SCREENSHOT,"IDS_SAVE_SCREENSHOT"},
	{IDS_CANCEL,"IDS_CANCEL"},
	{IDS_CHOOSE_SCREENSHOT_FORMAT,"IDS_CHOOSE_SCREENSHOT_FORMAT"},
	{IDS_SAVE_S_SCREENSHOT,"IDS_SAVE_S_SCREENSHOT"},
	{IDS_DETACHED_DEVICE_D,"IDS_DETACHED_DEVICE_D"},
	{IDS_ATTACHED_S_TO_DEVICE_D,"IDS_ATTACHED_S_TO_DEVICE_D"},
	{IDS_VICE_QUESTION,"IDS_VICE_QUESTION"},
	{IDS_EXTEND_TO_40_TRACK,"IDS_EXTEND_TO_40_TRACK"},
	{IDS_YES_NO,"IDS_YES_NO"},
	{IDS_DETACHED_TAPE,"IDS_DETACHED_TAPE"},
	{IDS_ATTACHED_TAPE_S,"IDS_ATTACHED_TAPE_S"},
	{IDS_SELECT_START_SNAPSHOT,"IDS_SELECT_START_SNAPSHOT"},
	{IDS_SELECT_END_SNAPSHOT,"IDS_SELECT_END_SNAPSHOT"},
	{IDS_REALLY_EXIT,"IDS_REALLY_EXIT"},
	{IDS_ATTACH_CRT_IMAGE,"IDS_ATTACH_CRT_IMAGE"},
	{IDS_ATTACH_RAW_8KB_IMAGE,"IDS_ATTACH_RAW_8KB_IMAGE"},
	{IDS_ATTACH_RAW_16KB_IMAGE,"IDS_ATTACH_RAW_16KB_IMAGE"},
	{IDS_ATTACH_ACTION_REPLAY_IMAGE,"IDS_ATTACH_ACTION_REPLAY_IMAGE"},
	{IDS_ATTACH_ACTION_REPLAY3_IMAGE,"IDS_ATTACH_ACTION_REPLAY3_IMAGE"},
	{IDS_ATTACH_ACTION_REPLAY4_IMAGE,"IDS_ATTACH_ACTION_REPLAY4_IMAGE"},
	{IDS_ATTACH_STARDOS_IMAGE,"IDS_ATTACH_STARDOS_IMAGE"},
	{IDS_ATTACH_ATOMIC_POWER_IMAGE,"IDS_ATTACH_ATOMIC_POWER_IMAGE"},
	{IDS_ATTACH_EPYX_FASTLOAD_IMAGE,"IDS_ATTACH_EPYX_FASTLOAD_IMAGE"},
	{IDS_ATTACH_IEEE488_IMAGE,"IDS_ATTACH_IEEE488_IMAGE"},
	{IDS_ATTACH_RETRO_REPLAY_IMAGE,"IDS_ATTACH_RETRO_REPLAY_IMAGE"},
	{IDS_ATTACH_IDE64_IMAGE,"IDS_ATTACH_IDE64_IMAGE"},
	{IDS_ATTACH_SS4_IMAGE,"IDS_ATTACH_SS4_IMAGE"},
	{IDS_ATTACH_SS5_IMAGE,"IDS_ATTACH_SS5_IMAGE"},
	{IDS_ATTACH_SB_IMAGE,"IDS_ATTACH_SB_IMAGE"},
	{IDS_AVAILABLE_CMDLINE_OPTIONS,"IDS_AVAILABLE_CMDLINE_OPTIONS"},
	{IDS_ATTACH_4_8_16KB_AT_2000,"IDS_ATTACH_4_8_16KB_AT_2000"},
	{IDS_ATTACH_4_8_16KB_AT_4000,"IDS_ATTACH_4_8_16KB_AT_4000"},
	{IDS_ATTACH_4_8_16KB_AT_6000,"IDS_ATTACH_4_8_16KB_AT_6000"},
	{IDS_ATTACH_4_8KB_AT_A000,"IDS_ATTACH_4_8KB_AT_A000"},
	{IDS_ATTACH_4KB_AT_B000,"IDS_ATTACH_4KB_AT_B000"},
	{IDS_S_AT_D_SPEED,"IDS_S_AT_D_SPEED"},
	{IDS_ATTACH,"IDS_ATTACH"},
	{IDS_PARENT,"IDS_PARENT"},
	{IDS_ATTACH_READ_ONLY,"IDS_ATTACH_READ_ONLY"},
	{IDS_NAME,"IDS_NAME"},
	{IDS_CREATE_IMAGE,"IDS_CREATE_IMAGE"},
	{IDS_NEW_IMAGE,"IDS_NEW_IMAGE"},
	{IDS_NEW_TAP_IMAGE,"IDS_NEW_TAP_IMAGE"},
	{IDS_OVERWRITE_EXISTING_IMAGE,"IDS_OVERWRITE_EXISTING_IMAGE"},
	{IDS_ABOUT,"IDS_ABOUT"},
	{IDS_IMAGE_CONTENTS,"IDS_IMAGE_CONTENTS"},
	{IDMS_DISABLED,"IDMS_DISABLED"},
	{IDS_ENABLED,"IDS_ENABLED"},
	{IDS_RS232_DEVICE_1,"IDS_RS232_DEVICE_1"},
	{IDS_RS232_DEVICE_2,"IDS_RS232_DEVICE_2"},
	{IDS_RS232_DEVICE_3,"IDS_RS232_DEVICE_3"},
	{IDS_RS232_DEVICE_4,"IDS_RS232_DEVICE_4"},
	{IDS_NONE,"IDS_NONE"},
	{IDS_STANDARD,"IDS_STANDARD"},
	{IDS_DD3,"IDS_DD3"},
	{IDS_FORMEL64,"IDS_FORMEL64"},
	{IDS_FILESYSTEM,"IDS_FILESYSTEM"},
	{IDS_RAW,"IDS_RAW"},
	{IDS_JOYSTICK,"IDS_JOYSTICK"},
	{IDS_IRQ,"IDS_IRQ"},
	{IDS_NMI,"IDS_NMI"},
	{IDS_ACIA_DEVICE,"IDS_ACIA_DEVICE"},
	{IDS_ACIA_BASE,"IDS_ACIA_BASE"},
	{IDS_ACIA_INTERRUPT,"IDS_ACIA_INTERRUPT"},
	{IDS_ACIA_MODE,"IDS_ACIA_MODE"},
	{IDS_ACIA_SETTINGS,"IDS_ACIA_SETTINGS"},
	{IDS_256K_ENABLED,"IDS_256K_ENABLED"},
	{IDS_256K_BASE,"IDS_256K_BASE"},
	{IDS_256K_FILENAME,"IDS_256K_FILENAME"},
	{IDS_256K_SETTINGS,"IDS_256K_SETTINGS"},
	{IDS_C64DTV_ROM_FILENAME_SELECT,"IDS_C64DTV_ROM_FILENAME_SELECT"},
	{IDS_C64DTV_ROM_FILENAME,"IDS_C64DTV_ROM_FILENAME"},
	{IDS_C64DTV_REVISION,"IDS_C64DTV_REVISION"},
	{IDS_C64DTV_WRITE_ENABLE,"IDS_C64DTV_WRITE_ENABLE"},
	{IDS_C64DTV_HUMMER_ADC,"IDS_C64DTV_HUMMER_ADC"},
	{IDS_C64DTV_SETTINGS,"IDS_C64DTV_SETTINGS"},
	{IDS_MODEL_LINE,"IDS_MODEL_LINE"},
	{IDS_RAM_SIZE,"IDS_RAM_SIZE"},
	{IDS_RAM_BLOCK_0400_0FFF,"IDS_RAM_BLOCK_0400_0FFF"},
	{IDS_RAM_BLOCK_0800_0FFF,"IDS_RAM_BLOCK_0800_0FFF"},
	{IDS_RAM_BLOCK_1000_1FFF,"IDS_RAM_BLOCK_1000_1FFF"},
	{IDS_RAM_BLOCK_2000_3FFF,"IDS_RAM_BLOCK_2000_3FFF"},
	{IDS_RAM_BLOCK_4000_5FFF,"IDS_RAM_BLOCK_4000_5FFF"},
	{IDS_RAM_BLOCK_6000_7FFF,"IDS_RAM_BLOCK_6000_7FFF"},
	{IDS_RAM_BLOCK_A000_BFFF,"IDS_RAM_BLOCK_A000_BFFF"},
	{IDS_RAM_BLOCK_C000_CFFF,"IDS_RAM_BLOCK_C000_CFFF"},
	{IDS_CBM2_SETTINGS,"IDS_CBM2_SETTINGS"},
	{IDS_CBM5X0_SETTINGS,"IDS_CBM5X0_SETTINGS"},
	{IDS_RESET_DATASETTE_WITH_CPU,"IDS_RESET_DATASETTE_WITH_CPU"},
	{IDS_ADDITIONAL_DELAY,"IDS_ADDITIONAL_DELAY"},
	{IDS_DELAY_AT_ZERO_VALUES,"IDS_DELAY_AT_ZERO_VALUES"},
	{IDS_DATASETTE_SETTINGS,"IDS_DATASETTE_SETTINGS"},
	{IDS_NEVER_EXTEND,"IDS_NEVER_EXTEND"},
	{IDS_ASK_ON_EXTEND,"IDS_ASK_ON_EXTEND"},
	{IDS_EXTEND_ON_ACCESS,"IDS_EXTEND_ON_ACCESS"},
	{IDS_NO_TRAPS,"IDS_NO_TRAPS"},
	{IDS_SKIP_CYCLES,"IDS_SKIP_CYCLES"},
	{IDS_TRAP_IDLE,"IDS_TRAP_IDLE"},
	{IDS_DRIVE_TYPE,"IDS_DRIVE_TYPE"},
	{IDS_40_TRACK_HANDLING,"IDS_40_TRACK_HANDLING"},
	{IDS_DRIVE_EXPANSION,"IDS_DRIVE_EXPANSION"},
	{IDS_IDLE_METHOD,"IDS_IDLE_METHOD"},
	{IDS_PARALLEL_CABLE,"IDS_PARALLEL_CABLE"},
	{IDS_DRIVE_SETTINGS,"IDS_DRIVE_SETTINGS"},
	{IDS_GEORAM_SIZE,"IDS_GEORAM_SIZE"},
	{IDS_MASCUERADE_IO_SWAP,"IDS_MASCUERADE_IO_SWAP"},
	{IDS_GEORAM_FILENAME,"IDS_GEORAM_FILENAME"},
	{IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED,"IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED"},
	{IDS_GEORAM_FILENAME_SELECT,"IDS_GEORAM_FILENAME_SELECT"},
	{IDS_GEORAM_SETTINGS,"IDS_GEORAM_SETTINGS"},
	{IDS_EXPERT_MODE,"IDS_EXPERT_MODE"},
	{IDS_OFF,"IDS_OFF"},
	{IDS_PRG,"IDS_PRG"},
	{IDS_ON,"IDS_ON"},
	{IDS_EXPERT_FILENAME,"IDS_EXPERT_FILENAME"},
	{IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED,"IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED"},
	{IDS_EXPERT_FILENAME_SELECT,"IDS_EXPERT_FILENAME_SELECT"},
	{IDS_EXPERT_SETTINGS,"IDS_EXPERT_SETTINGS"},
	{IDS_DQBB_FILENAME,"IDS_DQBB_FILENAME"},
	{IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED,"IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED"},
	{IDS_DQBB_FILENAME_SELECT,"IDS_DQBB_FILENAME_SELECT"},
	{IDS_DQBB_SETTINGS,"IDS_DQBB_SETTINGS"},
	{IDS_ISEPIC_SETTINGS,"IDS_ISEPIC_SETTINGS"},
	{IDS_ISEPIC_SWITCH,"IDS_ISEPIC_SWITCH"},
	{IDS_ISEPIC_FILENAME,"IDS_ISEPIC_FILENAME"},
	{IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED,"IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED"},
	{IDS_ISEPIC_FILENAME_SELECT,"IDS_ISEPIC_FILENAME_SELECT"},
	{IDS_EASYFLASH_SETTINGS,"IDS_EASYFLASH_SETTINGS"},
	{IDS_CONFIG_FILENAME_SELECT,"IDS_CONFIG_FILENAME_SELECT"},
	{IDS_JOYSTICK_IN_PORT_1,"IDS_JOYSTICK_IN_PORT_1"},
	{IDS_JOYSTICK_IN_PORT_2,"IDS_JOYSTICK_IN_PORT_2"},
	{IDS_USERPORT_ADAPTER,"IDS_USERPORT_ADAPTER"},
	{IDS_JOYSTICK_IN_USERPORT_PORT_1,"IDS_JOYSTICK_IN_USERPORT_PORT_1"},
	{IDS_JOYSTICK_IN_USERPORT_PORT_2,"IDS_JOYSTICK_IN_USERPORT_PORT_2"},
	{IDS_SIDCART_JOY,"IDS_SIDCART_JOY"},
	{IDS_JOYSTICK_IN_SIDCART_PORT,"IDS_JOYSTICK_IN_SIDCART_PORT"},
	{IDS_JOYSTICK_SETTINGS,"IDS_JOYSTICK_SETTINGS"},
	{IDS_KEYPAD,"IDS_KEYPAD"},
	{IDS_JOY_PORT_0,"IDS_JOY_PORT_0"},
	{IDS_JOY_PORT_1,"IDS_JOY_PORT_1"},
	{IDS_JOY_PORT_2,"IDS_JOY_PORT_2"},
	{IDS_JOY_PORT_3,"IDS_JOY_PORT_3"},
	{IDS_STOP_BLUE,"IDS_STOP_BLUE"},
	{IDS_SELECT_RED,"IDS_SELECT_RED"},
	{IDS_REPEAT_YELLOW,"IDS_REPEAT_YELLOW"},
	{IDS_SHUFFLE_GREEN,"IDS_SHUFFLE_GREEN"},
	{IDS_FORWARD_CHARCOAL,"IDS_FORWARD_CHARCOAL"},
	{IDS_REVERSE_CHARCOAL,"IDS_REVERSE_CHARCOAL"},
	{IDS_PLAY_PAUSE_GREY,"IDS_PLAY_PAUSE_GREY"},
	{IDS_JOY_1_DEVICE,"IDS_JOY_1_DEVICE"},
	{IDS_JOY_2_DEVICE,"IDS_JOY_2_DEVICE"},
	{IDS_USERPORT_JOY_1_DEVICE,"IDS_USERPORT_JOY_1_DEVICE"},
	{IDS_USERPORT_JOY_2_DEVICE,"IDS_USERPORT_JOY_2_DEVICE"},
	{IDS_SIDCART_JOY_DEVICE,"IDS_SIDCART_JOY_DEVICE"},
	{IDS_JOY_1_FIRE,"IDS_JOY_1_FIRE"},
	{IDS_JOY_2_FIRE,"IDS_JOY_2_FIRE"},
	{IDS_USERPORT_JOY_1_FIRE,"IDS_USERPORT_JOY_1_FIRE"},
	{IDS_USERPORT_JOY_2_FIRE,"IDS_USERPORT_JOY_2_FIRE"},
	{IDS_SIDCART_JOY_FIRE,"IDS_SIDCART_JOY_FIRE"},
	{IDS_SET_INPUT_JOYSTICK_1,"IDS_SET_INPUT_JOYSTICK_1"},
	{IDS_SET_INPUT_JOYSTICK_2,"IDS_SET_INPUT_JOYSTICK_2"},
	{IDS_SET_INPUT_EXTRA_JOYSTICK_1,"IDS_SET_INPUT_EXTRA_JOYSTICK_1"},
	{IDS_SET_INPUT_EXTRA_JOYSTICK_2,"IDS_SET_INPUT_EXTRA_JOYSTICK_2"},
	{IDS_SET_INPUT_JOYLL_1,"IDS_SET_INPUT_JOYLL_1"},
	{IDS_SET_INPUT_JOYLL_2,"IDS_SET_INPUT_JOYLL_2"},
	{IDS_SET_INPUT_EXTRA_JOYLL_1,"IDS_SET_INPUT_EXTRA_JOYLL_1"},
	{IDS_SET_INPUT_EXTRA_JOYLL_2,"IDS_SET_INPUT_EXTRA_JOYLL_2"},
	{IDS_SAVE_SETTINGS_ON_EXIT,"IDS_SAVE_SETTINGS_ON_EXIT"},
	{IDS_NEVER_SAVE_SETTINGS_EXIT,"IDS_NEVER_SAVE_SETTINGS_EXIT"},
	{IDS_CONFIRM_QUITING_VICE,"IDS_CONFIRM_QUITING_VICE"},
	{IDS_NEVER_CONFIRM_QUITING_VICE,"IDS_NEVER_CONFIRM_QUITING_VICE"},
	{IDS_PET_REU_SIZE,"IDS_PET_REU_SIZE"},
	{IDS_PET_REU_FILENAME,"IDS_PET_REU_FILENAME"},
	{IDS_PET_REU_SETTINGS,"IDS_PET_REU_SETTINGS"},
	{IDS_V364_SPEECH_FILENAME,"IDS_V364_SPEECH_FILENAME"},
	{IDS_V364_SPEECH_SETTINGS,"IDS_V364_SPEECH_SETTINGS"},
	{IDS_PET_DWW_FILENAME,"IDS_PET_DWW_FILENAME"},
	{IDS_PET_DWW_SETTINGS,"IDS_PET_DWW_SETTINGS"},
	{IDS_PLUS256K_SETTINGS,"IDS_PLUS256K_SETTINGS"},
	{IDS_PLUS60K_BASE,"IDS_PLUS60K_BASE"},
	{IDS_PLUS60K_FILENAME,"IDS_PLUS60K_FILENAME"},
	{IDS_PLUS60K_SETTINGS,"IDS_PLUS60K_SETTINGS"},
	{IDS_VALUE_FIRST_BYTE,"IDS_VALUE_FIRST_BYTE"},
	{IDS_LENGTH_CONSTANT_VALUES,"IDS_LENGTH_CONSTANT_VALUES"},
	{IDS_LENGTH_CONSTANT_PATTERN,"IDS_LENGTH_CONSTANT_PATTERN"},
	{IDS_RAM_SETTINGS,"IDS_RAM_SETTINGS"},
	{IDS_READ_WRITE,"IDS_READ_WRITE"},
	{IDS_READ_ONLY,"IDS_READ_ONLY"},
	{IDS_RAMCART_READ_WRITE,"IDS_RAMCART_READ_WRITE"},
	{IDS_RAMCART_SIZE,"IDS_RAMCART_SIZE"},
	{IDS_RAMCART_FILENAME,"IDS_RAMCART_FILENAME"},
	{IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED,"IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED"},
	{IDS_RAMCART_FILENAME_SELECT,"IDS_RAMCART_FILENAME_SELECT"},
	{IDS_RAMCART_SETTINGS,"IDS_RAMCART_SETTINGS"},
	{IDS_REU_SIZE,"IDS_REU_SIZE"},
	{IDS_REU_FILENAME,"IDS_REU_FILENAME"},
	{IDS_SAVE_REU_IMAGE_WHEN_CHANGED,"IDS_SAVE_REU_IMAGE_WHEN_CHANGED"},
	{IDS_REU_FILENAME_SELECT,"IDS_REU_FILENAME_SELECT"},
	{IDS_REU_SETTINGS,"IDS_REU_SETTINGS"},
	{IDS_BURST_MOD_SETTINGS,"IDS_BURST_MOD_SETTINGS"},
	{IDS_PALETTE_SETTINGS,"IDS_PALETTE_SETTINGS"},
	{IDS_COLOR_SETTINGS,"IDS_COLOR_SETTINGS"},
	{IDS_RENDER_FILTER_SETTINGS,"IDS_RENDER_FILTER_SETTINGS"},
	{IDS_CRT_SETTINGS,"IDS_CRT_SETTINGS"},
	{IDS_VICII_PALETTE_FILENAME,"IDS_VICII_PALETTE_FILENAME"},
	{IDS_VIC_PALETTE_FILENAME,"IDS_VIC_PALETTE_FILENAME"},
	{IDS_VDC_PALETTE_FILENAME,"IDS_VDC_PALETTE_FILENAME"},
	{IDS_CRTC_PALETTE_FILENAME,"IDS_CRTC_PALETTE_FILENAME"},
	{IDS_TED_PALETTE_FILENAME,"IDS_TED_PALETTE_FILENAME"},
	{IDS_PRINTER_OUTPUT_FILENAME_SELECT,"IDS_PRINTER_OUTPUT_FILENAME_SELECT"},
	{IDS_PRINTER_4_EMULATION,"IDS_PRINTER_4_EMULATION"},
	{IDS_PRINTER_5_EMULATION,"IDS_PRINTER_5_EMULATION"},
	{IDS_USERPORT_PRINTER_EMULATION,"IDS_USERPORT_PRINTER_EMULATION"},
	{IDS_PRINTER_4_DRIVER,"IDS_PRINTER_4_DRIVER"},
	{IDS_PRINTER_5_DRIVER,"IDS_PRINTER_5_DRIVER"},
	{IDS_USERPORT_PRINTER_DRIVER,"IDS_USERPORT_PRINTER_DRIVER"},
	{IDS_PRINTER_4_OUTPUT_TYPE,"IDS_PRINTER_4_OUTPUT_TYPE"},
	{IDS_PRINTER_5_OUTPUT_TYPE,"IDS_PRINTER_5_OUTPUT_TYPE"},
	{IDS_USERPORT_PRINTER_OUTPUT_TYPE,"IDS_USERPORT_PRINTER_OUTPUT_TYPE"},
	{IDS_PRINTER_4_OUTPUT_DEVICE,"IDS_PRINTER_4_OUTPUT_DEVICE"},
	{IDS_PRINTER_5_OUTPUT_DEVICE,"IDS_PRINTER_5_OUTPUT_DEVICE"},
	{IDS_USERPORT_PRINTER_OUTPUT_DEVICE,"IDS_USERPORT_PRINTER_OUTPUT_DEVICE"},
	{IDS_PRINTER_4_SEND_FORMFEED,"IDS_PRINTER_4_SEND_FORMFEED"},
	{IDS_PRINTER_5_SEND_FORMFEED,"IDS_PRINTER_5_SEND_FORMFEED"},
	{IDS_USERPORT_PRINTER_SEND_FORMFEED,"IDS_USERPORT_PRINTER_SEND_FORMFEED"},
	{IDS_PRINTER_DEVICE_1_FILENAME,"IDS_PRINTER_DEVICE_1_FILENAME"},
	{IDS_PRINTER_DEVICE_2_FILENAME,"IDS_PRINTER_DEVICE_2_FILENAME"},
	{IDS_PRINTER_DEVICE_3_FILENAME,"IDS_PRINTER_DEVICE_3_FILENAME"},
	{IDS_ENABLE_IEC_PRINTER_4,"IDS_ENABLE_IEC_PRINTER_4"},
	{IDS_ENABLE_IEC_PRINTER_5,"IDS_ENABLE_IEC_PRINTER_5"},
	{IDS_PRINTER_SETTINGS,"IDS_PRINTER_SETTINGS"},
	{IDS_MAGIC_VOICE_FILENAME,"IDS_MAGIC_VOICE_FILENAME"},
	{IDS_MAGIC_VOICE_SETTINGS,"IDS_MAGIC_VOICE_SETTINGS"},
	{IDS_USERPORT_RS232,"IDS_USERPORT_RS232"},
	{IDS_USERPORT_DEVICE,"IDS_USERPORT_DEVICE"},
	{IDS_USERPORT_BAUD_RATE,"IDS_USERPORT_BAUD_RATE"},
	{IDS_RS232_USERPORT_SETTINGS,"IDS_RS232_USERPORT_SETTINGS"},
	{IDS_FAST,"IDS_FAST"},
	{IDS_INTERPOLATING,"IDS_INTERPOLATING"},
	{IDS_RESAMPLING,"IDS_RESAMPLING"},
	{IDS_FAST_RESAMPLING,"IDS_FAST_RESAMPLING"},
	{IDS_SID_STEREO,"IDS_SID_STEREO"},
	{IDS_AMOUNT_OF_EXTRA_SIDS,"IDS_AMOUNT_OF_EXTRA_SIDS"},
	{IDS_STEREO_SID_AT,"IDS_STEREO_SID_AT"},
	{IDS_TRIPLE_SID_AT,"IDS_TRIPLE_SID_AT"},
	{IDS_SID_FILTERS,"IDS_SID_FILTERS"},
	{IDS_SAMPLE_METHOD,"IDS_SAMPLE_METHOD"},
	{IDS_PASSBAND_0_90,"IDS_PASSBAND_0_90"},
	{IDS_NOT_IMPLEMENTED_YET,"IDS_NOT_IMPLEMENTED_YET"},
	{IDS_SID_SETTINGS,"IDS_SID_SETTINGS"},
	{IDS_FLEXIBLE,"IDS_FLEXIBLE"},
	{IDS_ADJUSTING,"IDS_ADJUSTING"},
	{IDS_EXACT,"IDS_EXACT"},
	{IDS_SAMPLE_RATE,"IDS_SAMPLE_RATE"},
	{IDS_BUFFER_SIZE,"IDS_BUFFER_SIZE"},
	{IDS_FRAGMENT_SIZE,"IDS_FRAGMENT_SIZE"},
	{IDS_SPEED_ADJUSTMENT,"IDS_SPEED_ADJUSTMENT"},
	{IDS_SOUND_SETTINGS,"IDS_SOUND_SETTINGS"},
	{IDS_VIC20_SETTINGS,"IDS_VIC20_SETTINGS"},
	{IDS_SPRITE_SPRITE_COL,"IDS_SPRITE_SPRITE_COL"},
	{IDS_SPRITE_BACKGROUND_COL,"IDS_SPRITE_BACKGROUND_COL"},
	{IDS_NEW_LUMINANCES,"IDS_NEW_LUMINANCES"},
	{IDS_VICII_SETTINGS,"IDS_VICII_SETTINGS"},
	{IDS_VIC_SETTINGS,"IDS_VIC_SETTINGS"},
	{IDS_TED_SETTINGS,"IDS_TED_SETTINGS"},
	{IDS_ATTACH_TAPE_IMAGE,"IDS_ATTACH_TAPE_IMAGE"},
	{IDS_AUTOSTART_IMAGE,"IDS_AUTOSTART_IMAGE"},
	{IDS_IDE64_FILENAME,"IDS_IDE64_FILENAME"},
	{IDS_IDE64_HD_1_SETTINGS,"IDS_IDE64_HD_1_SETTINGS"},
	{IDS_IDE64_HD_2_SETTINGS,"IDS_IDE64_HD_2_SETTINGS"},
	{IDS_IDE64_HD_3_SETTINGS,"IDS_IDE64_HD_3_SETTINGS"},
	{IDS_IDE64_HD_4_SETTINGS,"IDS_IDE64_HD_4_SETTINGS"},
	{IDS_IDE64_V4,"IDS_IDE64_V4"},
	{IDS_AUTODETECT,"IDS_AUTODETECT"},
	{IDS_CYLINDERS,"IDS_CYLINDERS"},
	{IDS_HEADS,"IDS_HEADS"},
	{IDS_SECTORS,"IDS_SECTORS"},
	{IDS_IDE64_SETTINGS,"IDS_IDE64_SETTINGS"},
	{IDS_BIOS_REVISION,"IDS_BIOS_REVISION"},
	{IDS_BIOS_FLASH_JUMPER,"IDS_BIOS_FLASH_JUMPER"},
	{IDS_BANK_JUMPER,"IDS_BANK_JUMPER"},
	{IDS_SAVE_BIOS_WHEN_CHANGED,"IDS_SAVE_BIOS_WHEN_CHANGED"},
	{IDS_BIOS_FILE,"IDS_BIOS_FILE"},
	{IDS_SELECT_BIOS_FILE,"IDS_SELECT_BIOS_FILE"},
	{IDS_MMC64_IMAGE_READ_ONLY,"IDS_MMC64_IMAGE_READ_ONLY"},
	{IDS_MMC64_IMAGE_FILE,"IDS_MMC64_IMAGE_FILE"},
	{IDS_SD_TYPE,"IDS_SD_TYPE"},
	{IDS_SELECT_MMC64_IMAGE_FILE,"IDS_SELECT_MMC64_IMAGE_FILE"},
	{IDS_MMC64_SETTINGS,"IDS_MMC64_SETTINGS"},
	{IDS_SELECT_EEPROM_FILE,"IDS_SELECT_EEPROM_FILE"},
	{IDS_SELECT_CARD_IMAGE_FILE,"IDS_SELECT_CARD_IMAGE_FILE"},
	{IDS_CARD_FILE,"IDS_CARD_FILE"},
	{IDS_CARD_READ_WRITE,"IDS_CARD_READ_WRITE"},
	{IDS_EEPROM_FILE,"IDS_EEPROM_FILE"},
	{IDS_WRITE_TO_EEPROM_WHEN_CHANGED,"IDS_WRITE_TO_EEPROM_WHEN_CHANGED"},
	{IDS_EEPROM_READ_WRITE,"IDS_EEPROM_READ_WRITE"},
	{IDS_RESCUE_MODE,"IDS_RESCUE_MODE"},
	{IDS_MMCREPLAY_SETTINGS,"IDS_MMCREPLAY_SETTINGS"},
	{IDS_RETROREPLAY_SETTINGS,"IDS_RETROREPLAY_SETTINGS"},
	{IDS_SELECT_GENERIC,"IDS_SELECT_GENERIC"},
	{IDS_SELECT_FP,"IDS_SELECT_FP"},
	{IDS_SELECT_MEGACART,"IDS_SELECT_MEGACART"},
	{IDS_SELECT_FINAL_EXPANSION,"IDS_SELECT_FINAL_EXPANSION"},
	{IDS_SELECT_CARTRIDGE_IMAGE,"IDS_SELECT_CARTRIDGE_IMAGE"},
	{IDS_SID_CART,"IDS_SID_CART"},
	{IDS_SID_ENGINE_MODEL,"IDS_SID_ENGINE_MODEL"},
	{IDS_SID_ENGINE,"IDS_SID_ENGINE"},
	{IDS_SID_MODEL,"IDS_SID_MODEL"},
	{IDS_SID_ADDRESS,"IDS_SID_ADDRESS"},
	{IDS_SID_CLOCK,"IDS_SID_CLOCK"},
	{IDS_SID_DIGIBLASTER,"IDS_SID_DIGIBLASTER"},
	{IDS_SIDCART_SETTINGS,"IDS_SIDCART_SETTINGS"},
	{IDS_LOAD_FLIP_LIST_FILE,"IDS_LOAD_FLIP_LIST_FILE"},
	{IDS_CANNOT_READ_FLIP_LIST,"IDS_CANNOT_READ_FLIP_LIST"},
	{IDS_SAVE_FLIP_LIST_FILE,"IDS_SAVE_FLIP_LIST_FILE"},
	{IDS_CANNOT_WRITE_FLIP_LIST,"IDS_CANNOT_WRITE_FLIP_LIST"},
	{IDS_ATTACH_CART0_LOW,"IDS_ATTACH_CART0_LOW"},
	{IDS_ATTACH_CART0_HIGH,"IDS_ATTACH_CART0_HIGH"},
	{IDS_ATTACH_CART1_LOW,"IDS_ATTACH_CART1_LOW"},
	{IDS_ATTACH_CART1_HIGH,"IDS_ATTACH_CART1_HIGH"},
	{IDS_ATTACH_CART2_LOW,"IDS_ATTACH_CART2_LOW"},
	{IDS_ATTACH_CART2_HIGH,"IDS_ATTACH_CART2_HIGH"},
	{IDS_ATTACH_CART,"IDS_ATTACH_CART"},
	{IDS_SAVE_SNAPSHOT_IMAGE,"IDS_SAVE_SNAPSHOT_IMAGE"},
	{IDS_LOAD_SNAPSHOT_IMAGE,"IDS_LOAD_SNAPSHOT_IMAGE"},
	{IDS_SAVE_CURRENTLY_ATTACHED_DISKS,"IDS_SAVE_CURRENTLY_ATTACHED_DISKS"},
	{IDS_SAVE_CURRENTLY_ATTACHED_ROMS,"IDS_SAVE_CURRENTLY_ATTACHED_ROMS"},
	{IDS_CANNOT_WRITE_SNAPSHOT_S,"IDS_CANNOT_WRITE_SNAPSHOT_S"},
	{IDS_CANNOT_READ_SNAPSHOT_IMG,"IDS_CANNOT_READ_SNAPSHOT_IMG"},
	{IDS_SNAPSHOT_FILE,"IDS_SNAPSHOT_FILE"},
	{IDS_SELECT_SNAPSHOT_FILE,"IDS_SELECT_SNAPSHOT_FILE"},
	{IDS_CRT_EMULATION,"IDS_CRT_EMULATION"},
	{IDS_SCALE2X,"IDS_SCALE2X"},
	{IDS_RENDER_FILTER,"IDS_RENDER_FILTER"},
	{IDS_EXTERNAL_PALETTE_SELECT,"IDS_EXTERNAL_PALETTE_SELECT"},
	{IDS_GAMMA_0_4,"IDS_GAMMA_0_4"},
	{IDS_SCANLINE_SHADE_0_1,"IDS_SCANLINE_SHADE_0_1"},
	{IDS_BLUR_0_1,"IDS_BLUR_0_1"},
	{IDS_TINT_0_2,"IDS_TINT_0_2"},
	{IDS_ODDLINE_PHASE_0_2,"IDS_ODDLINE_PHASE_0_2"},
	{IDS_ODDLINE_OFFSET_0_2,"IDS_ODDLINE_OFFSET_0_2"},
	{IDS_VICII_EXTERNAL_PALETTE,"IDS_VICII_EXTERNAL_PALETTE"},
	{IDS_VIC_EXTERNAL_PALETTE,"IDS_VIC_EXTERNAL_PALETTE"},
	{IDS_TED_EXTERNAL_PALETTE,"IDS_TED_EXTERNAL_PALETTE"},
	{IDS_VDC_EXTERNAL_PALETTE,"IDS_VDC_EXTERNAL_PALETTE"},
	{IDS_CRTC_EXTERNAL_PALETTE,"IDS_CRTC_EXTERNAL_PALETTE"},
	{IDS_VICII_PALETTE_NAME,"IDS_VICII_PALETTE_NAME"},
	{IDS_VIC_PALETTE_NAME,"IDS_VIC_PALETTE_NAME"},
	{IDS_TED_PALETTE_NAME,"IDS_TED_PALETTE_NAME"},
	{IDS_VDC_PALETTE_NAME,"IDS_VDC_PALETTE_NAME"},
	{IDS_CRTC_PALETTE_NAME,"IDS_CRTC_PALETTE_NAME"},
	{IDS_SATURATION_0_2,"IDS_SATURATION_0_2"},
	{IDS_CONTRAST_0_2,"IDS_CONTRAST_0_2"},
	{IDS_BRIGHTNESS_0_2,"IDS_BRIGHTNESS_0_2"},
	{IDS_VIDEO_SETTINGS,"IDS_VIDEO_SETTINGS"},
	{IDS_AUTO_FROM_ROM,"IDS_AUTO_FROM_ROM"},
	{IDS_40_COLUMNS,"IDS_40_COLUMNS"},
	{IDS_80_COLUMNS,"IDS_80_COLUMNS"},
	{IDS_256_BYTE,"IDS_256_BYTE"},
	{IDS_2_KBYTE,"IDS_2_KBYTE"},
	{IDS_GRAPHICS,"IDS_GRAPHICS"},
	{IDS_TEXT,"IDS_TEXT"},
	{IDS_BUSINESS_UK,"IDS_BUSINESS_UK"},
	{IDS_MEMORY,"IDS_MEMORY"},
	{IDS_VIDEO_SIZE,"IDS_VIDEO_SIZE"},
	{IDS_IO_SIZE,"IDS_IO_SIZE"},
	{IDS_KEYBOARD,"IDS_KEYBOARD"},
	{IDS_CRTC_CHIP,"IDS_CRTC_CHIP"},
	{IDS_SUPERPET_IO,"IDS_SUPERPET_IO"},
	{IDS_9xxx_AS_RAM,"IDS_9xxx_AS_RAM"},
	{IDS_Axxx_AS_RAM,"IDS_Axxx_AS_RAM"},
	{IDS_PET_SETTINGS,"IDS_PET_SETTINGS"},
	{IDS_CURRENT_MODEL,"IDS_CURRENT_MODEL"},
	{IDS_PET_MODEL,"IDS_PET_MODEL"},
	{IDS_PLUS4_SETTINGS,"IDS_PLUS4_SETTINGS"},
	{IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME,"IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME"},
	{IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME,"IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME"},
	{IDS_MACHINE_TYPE,"IDS_MACHINE_TYPE"},
	{IDS_INTERNAL_FUNCTION_ROM,"IDS_INTERNAL_FUNCTION_ROM"},
	{IDS_EXTERNAL_FUNCTION_ROM,"IDS_EXTERNAL_FUNCTION_ROM"},
	{IDS_RAM_BANKS_2_AND_3,"IDS_RAM_BANKS_2_AND_3"},
	{IDS_C128_SETTINGS,"IDS_C128_SETTINGS"},
	{IDS_SELECT_ROM_FILE,"IDS_SELECT_ROM_FILE"},
	{IDS_COMPUTER_ROM_SETTINGS,"IDS_COMPUTER_ROM_SETTINGS"},
	{IDS_DRIVE_ROM_SETTINGS,"IDS_DRIVE_ROM_SETTINGS"},
	{IDS_DIGIMAX_ENABLED,"IDS_DIGIMAX_ENABLED"},
	{IDS_DIGIMAX_BASE,"IDS_DIGIMAX_BASE"},
	{IDS_DIGIMAX_SETTINGS,"IDS_DIGIMAX_SETTINGS"},
	{IDS_DS12C887RTC_ENABLED,"IDS_DS12C887RTC_ENABLED"},
	{IDS_DS12C887RTC_BASE,"IDS_DS12C887RTC_BASE"},
	{IDS_DS12C887RTC_SETTINGS,"IDS_DS12C887RTC_SETTINGS"},
	{IDS_SFX_SE_ENABLED,"IDS_SFX_SE_ENABLED"},
	{IDS_SFX_SE_CHIP,"IDS_SFX_SE_CHIP"},
	{IDS_SFX_SS_ENABLED,"IDS_SFX_SS_ENABLED"},
	{IDS_SFX_SE_SETTINGS,"IDS_SFX_SE_SETTINGS"},
	{IDS_SFX_SS_SETTINGS,"IDS_SFX_SS_SETTINGS"},
	{IDS_SOUND_RECORDING_STOPPED,"IDS_SOUND_RECORDING_STOPPED"},
	{IDS_SOUND_RECORDING_STARTED,"IDS_SOUND_RECORDING_STARTED"},
	{IDS_SELECT_RECORD_FILE,"IDS_SELECT_RECORD_FILE"},
	{IDS_SOUND_RECORD_FORMAT,"IDS_SOUND_RECORD_FORMAT"},
	{IDS_SOUND_RECORD_FILE,"IDS_SOUND_RECORD_FILE"},
	{IDS_SOUND_RECORD_SETTINGS,"IDS_SOUND_RECORD_SETTINGS"},
	{IDS_SMALL,"IDS_SMALL"},
	{IDS_MEDIUM,"IDS_MEDIUM"},
	{IDS_LARGE,"IDS_LARGE"},
	{IDS_BORDER_MODE,"IDS_BORDER_MODE"},
	{IDMS_NORMAL,"IDMS_NORMAL"},
	{IDS_FULL,"IDS_FULL"},
	{IDS_DEBUG,"IDS_DEBUG"},
	{IDS_VOLUME,"IDS_VOLUME"},
	{IDS_SOUND_OUTPUT_MODE,"IDS_SOUND_OUTPUT_MODE"},
	{IDS_SYSTEM,"IDS_SYSTEM"},
	{IDS_MONO,"IDS_MONO"},
	{IDS_STEREO,"IDS_STEREO"},
	{IDS_MOUSE_TYPE,"IDS_MOUSE_TYPE"},
	{IDS_MOUSE_SETTINGS,"IDS_MOUSE_SETTINGS"},
	{IDS_MOUSE_PORT,"IDS_MOUSE_PORT"},
	{IDS_MOUSE_1351,"IDS_MOUSE_1351"},
	{IDS_MOUSE_NEOS,"IDS_MOUSE_NEOS"},
	{IDS_MOUSE_AMIGA,"IDS_MOUSE_AMIGA"},
	{IDS_MOUSE_PADDLES,"IDS_MOUSE_PADDLES"},
	{IDS_MOUSE_CX22,"IDS_MOUSE_CX22"},
	{IDS_MOUSE_ST,"IDS_MOUSE_ST"},
	{IDS_MOUSE_SMART,"IDS_MOUSE_SMART"},
	{IDS_MOUSE_MICROMYS,"IDS_MOUSE_MICROMYS"},
	{IDS_AUTOSTART_VIRTUAL_FS,"IDS_AUTOSTART_VIRTUAL_FS"},
	{IDS_AUTOSTART_INJECT,"IDS_AUTOSTART_INJECT"},
	{IDS_AUTOSTART_DISK,"IDS_AUTOSTART_DISK"},
	{IDS_WARP_ON_AUTOSTART,"IDS_WARP_ON_AUTOSTART"},
	{IDS_AUTOSTART_RANDOM_DELAY,"IDS_AUTOSTART_RANDOM_DELAY"},
	{IDS_RUN_WITH_COLON,"IDS_RUN_WITH_COLON"},
	{IDS_AUTOSTART_PRG_MODE,"IDS_AUTOSTART_PRG_MODE"},
	{IDS_AUTOSTART_LOAD_TO_BASIC_START,"IDS_AUTOSTART_LOAD_TO_BASIC_START"},
	{IDS_AUTOSTART_DISK_IMAGE_FILENAME,"IDS_AUTOSTART_DISK_IMAGE_FILENAME"},
	{IDS_AUTOSTART_SETTINGS,"IDS_AUTOSTART_SETTINGS"},
	{IDS_ERROR_SAVING_EASYFLASH_CRT,"IDS_ERROR_SAVING_EASYFLASH_CRT"},
	{IDS_EASYFLASH_JUMPER,"IDS_EASYFLASH_JUMPER"},
	{IDS_SAVE_EASYFLASH_CRT_ON_DETACH,"IDS_SAVE_EASYFLASH_CRT_ON_DETACH"},
	{IDS_SAVE_EASYFLASH_CRT_NOW,"IDS_SAVE_EASYFLASH_CRT_NOW"},
	{IDS_6569_PAL,"IDS_6569_PAL"},
	{IDS_8565_PAL,"IDS_8565_PAL"},
	{IDS_6569R1_OLD_PAL,"IDS_6569R1_OLD_PAL"},
	{IDS_6567_NTSC,"IDS_6567_NTSC"},
	{IDS_8562_NTSC,"IDS_8562_NTSC"},
	{IDS_6567R56A_OLD_NTSC,"IDS_6567R56A_OLD_NTSC"},
	{IDS_6572_PAL_N,"IDS_6572_PAL_N"},
	{IDS_6526_OLD,"IDS_6526_OLD"},
	{IDS_6526A_NEW,"IDS_6526A_NEW"},
	{IDS_DISCRETE,"IDS_DISCRETE"},
	{IDS_CUSTOM_IC,"IDS_CUSTOM_IC"},
	{IDS_VICII_MODEL,"IDS_VICII_MODEL"},
	{IDS_CIA1_MODEL,"IDS_CIA1_MODEL"},
	{IDS_CIA2_MODEL,"IDS_CIA2_MODEL"},
	{IDS_GLUE_LOGIC,"IDS_GLUE_LOGIC"},
	{IDS_C64_MODEL_SETTINGS,"IDS_C64_MODEL_SETTINGS"},
	{IDS_CIA_MODEL_SETTINGS,"IDS_CIA_MODEL_SETTINGS"},
	{IDS_PSID_SELECT,"IDS_PSID_SELECT"},
	{IDGS_CANNOT_LOAD_SNAPSHOT_FILE,"IDGS_CANNOT_LOAD_SNAPSHOT_FILE"},
	{IDGS_PLAYBACK_ERROR_DIFFERENT,"IDGS_PLAYBACK_ERROR_DIFFERENT"},
	{IDGS_CANNOT_CREATE_IMAGE,"IDGS_CANNOT_CREATE_IMAGE"},
	{IDGS_CANNOT_WRITE_IMAGE_FILE_S,"IDGS_CANNOT_WRITE_IMAGE_FILE_S"},
	{IDGS_CANNOT_FIND_MAPPED_NAME_S,"IDGS_CANNOT_FIND_MAPPED_NAME_S"},
	{IDGS_CANT_CREATE_START_SNAP_S,"IDGS_CANT_CREATE_START_SNAP_S"},
	{IDGS_ERROR_READING_END_SNAP_S,"IDGS_ERROR_READING_END_SNAP_S"},
	{IDGS_CANT_CREATE_END_SNAP_S,"IDGS_CANT_CREATE_END_SNAP_S"},
	{IDGS_CANT_OPEN_END_SNAP_S,"IDGS_CANT_OPEN_END_SNAP_S"},
	{IDGS_CANT_FIND_SECTION_END_SNAP,"IDGS_CANT_FIND_SECTION_END_SNAP"},
	{IDGS_ERROR_READING_START_SNAP_TRIED,"IDGS_ERROR_READING_START_SNAP_TRIED"},
	{IDGS_ERROR_READING_START_SNAP,"IDGS_ERROR_READING_START_SNAP"},
	{IDGS_SORRY_NO_MULTI_RECORDING,"IDGS_SORRY_NO_MULTI_RECORDING"},
	{IDGS_WRITE_TO_SOUND_DEVICE_FAILED,"IDGS_WRITE_TO_SOUND_DEVICE_FAILED"},
	{IDGS_CANNOT_OPEN_SID_ENGINE,"IDGS_CANNOT_OPEN_SID_ENGINE"},
	{IDGS_CANNOT_INIT_SID_ENGINE,"IDGS_CANNOT_INIT_SID_ENGINE"},
	{IDGS_INIT_FAILED_FOR_DEVICE_S,"IDGS_INIT_FAILED_FOR_DEVICE_S"},
	{IDGS_DEVICE_S_NOT_FOUND_SUPPORT,"IDGS_DEVICE_S_NOT_FOUND_SUPPORT"},
	{IDGS_RECORD_DEVICE_S_NOT_EXIST,"IDGS_RECORD_DEVICE_S_NOT_EXIST"},
	{IDGS_RECORD_DIFFERENT_PLAYBACK,"IDGS_RECORD_DIFFERENT_PLAYBACK"},
	{IDGS_WARNING_RECORDING_REALTIME,"IDGS_WARNING_RECORDING_REALTIME"},
	{IDGS_RECORD_NOT_SUPPORT_SOUND_PAR,"IDGS_RECORD_NOT_SUPPORT_SOUND_PAR"},
	{IDGS_SOUND_BUFFER_OVERFLOW_CYCLE,"IDGS_SOUND_BUFFER_OVERFLOW_CYCLE"},
	{IDGS_SOUND_BUFFER_OVERFLOW,"IDGS_SOUND_BUFFER_OVERFLOW"},
	{IDGS_CANNOT_FLUSH,"IDGS_CANNOT_FLUSH"},
	{IDGS_FRAGMENT_PROBLEMS,"IDGS_FRAGMENT_PROBLEMS"},
	{IDGS_RUNNING_TOO_SLOW,"IDGS_RUNNING_TOO_SLOW"},
	{IDGS_STORE_SOUNDDEVICE_FAILED,"IDGS_STORE_SOUNDDEVICE_FAILED"},
	{IDGS_RESOURCE_S_BLOCKED_BY_S,"IDGS_RESOURCE_S_BLOCKED_BY_S"},
	{IDGS_TESTING_BEST_FRAME_DELAY,"IDGS_TESTING_BEST_FRAME_DELAY"},
	{IDGS_USING_D_FRAMES_DELAY,"IDGS_USING_D_FRAMES_DELAY"},
	{IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER,"IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER"},
	{IDGS_SENDING_SNAPSHOT_TO_CLIENT,"IDGS_SENDING_SNAPSHOT_TO_CLIENT"},
	{IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT,"IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT"},
	{IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S,"IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S"},
	{IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S,"IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S"},
	{IDGS_SERVER_IS_WAITING_FOR_CLIENT,"IDGS_SERVER_IS_WAITING_FOR_CLIENT"},
	{IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT,"IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT"},
	{IDGS_CANNOT_RESOLVE_S,"IDGS_CANNOT_RESOLVE_S"},
	{IDGS_CANNOT_CONNECT_TO_S,"IDGS_CANNOT_CONNECT_TO_S"},
	{IDGS_RECEIVING_SNAPSHOT_SERVER,"IDGS_RECEIVING_SNAPSHOT_SERVER"},
	{IDGS_NETWORK_OUT_OF_SYNC,"IDGS_NETWORK_OUT_OF_SYNC"},
	{IDGS_REMOTE_HOST_DISCONNECTED,"IDGS_REMOTE_HOST_DISCONNECTED"},
	{IDGS_REMOTE_HOST_SUSPENDING,"IDGS_REMOTE_HOST_SUSPENDING"},
	{IDGS_FFMPEG_CANNOT_OPEN_VSTREAM,"IDGS_FFMPEG_CANNOT_OPEN_VSTREAM"},
	{IDGS_FFMPEG_CANNOT_OPEN_ASTREAM,"IDGS_FFMPEG_CANNOT_OPEN_ASTREAM"},
	{IDGS_FFMPEG_CANNOT_OPEN_S,"IDGS_FFMPEG_CANNOT_OPEN_S"},
	{IDGS_IO_READ_COLL_AT_X_FROM,"IDGS_IO_READ_COLL_AT_X_FROM"},
	{IDGS_AND,"IDGS_AND"},
	{IDGS_ALL_DEVICES_DETACHED,"IDGS_ALL_DEVICES_DETACHED"},
	{IDGS_ALL_DEVICES_EXCEPT,"IDGS_ALL_DEVICES_EXCEPT"},
	{IDGS_WILL_BE_DETACHED,"IDGS_WILL_BE_DETACHED"},
	{IDGS_NO_FILENAME,"IDGS_NO_FILENAME"},
	{IDGS_ILLEGAL_FILENAME,"IDGS_ILLEGAL_FILENAME"},
	{IDGS_ERROR_CREATING_FILE_S,"IDGS_ERROR_CREATING_FILE_S"},
	{IDGS_ERROR_WRITING_TO_FILE_S,"IDGS_ERROR_WRITING_TO_FILE_S"},
	{IDGS_DTV_ROM_CREATED,"IDGS_DTV_ROM_CREATED"},
	{IDGS_TYPE,"IDGS_TYPE"},
	{IDGS_COMMAND_S_UNKNOWN,"IDGS_COMMAND_S_UNKNOWN"},
	{IDGS_NO_HELP_AVAILABLE_FOR_S,"IDGS_NO_HELP_AVAILABLE_FOR_S"},
	{IDGS_SYNTAX_S_S,"IDGS_SYNTAX_S_S"},
	{IDGS_ABBREVIATION_S,"IDGS_ABBREVIATION_S"},
	{IDGS_AVAILABLE_COMMANDS_ARE,"IDGS_AVAILABLE_COMMANDS_ARE"},
	{IDGS_MACHINE_STATE_COMMANDS,"IDGS_MACHINE_STATE_COMMANDS"},
	{IDGS_MEMSPACE,"IDGS_MEMSPACE"},
	{IDGS_BANKNAME,"IDGS_BANKNAME"},
	{IDGS_MON_BANK_DESCRIPTION,"IDGS_MON_BANK_DESCRIPTION"},
	{IDGS_MON_BACKTRACE_DESCRIPTION,"IDGS_MON_BACKTRACE_DESCRIPTION"},
	{IDGS_MON_CPU_DESCRIPTION,"IDGS_MON_CPU_DESCRIPTION"},
	{IDGS_COUNT,"IDGS_COUNT"},
	{IDGS_MON_CPUHISTORY_DESCRIPTION,"IDGS_MON_CPUHISTORY_DESCRIPTION"},
	{IDGS_FILENAME,"IDGS_FILENAME"},
	{IDGS_MON_DUMP_DESCRIPTION,"IDGS_MON_DUMP_DESCRIPTION"},
	{IDGS_ADDRESS,"IDGS_ADDRESS"},
	{IDGS_MON_GOTO_DESCRIPTION,"IDGS_MON_GOTO_DESCRIPTION"},
	{IDGS_MON_IO_DESCRIPTION,"IDGS_MON_IO_DESCRIPTION"},
	{IDGS_MON_EXPORT_DESCRIPTION,"IDGS_MON_EXPORT_DESCRIPTION"},
	{IDGS_MON_NEXT_DESCRIPTION,"IDGS_MON_NEXT_DESCRIPTION"},
	{IDGS_REG_NAME,"IDGS_REG_NAME"},
	{IDGS_NUMBER,"IDGS_NUMBER"},
	{IDGS_MON_REGISTERS_DESCRIPTION,"IDGS_MON_REGISTERS_DESCRIPTION"},
	{IDGS_MON_RESET_DESCRIPTION,"IDGS_MON_RESET_DESCRIPTION"},
	{IDGS_MON_RETURN_DESCRIPTION,"IDGS_MON_RETURN_DESCRIPTION"},
	{IDGS_MON_SCREEN_DESCRIPTION,"IDGS_MON_SCREEN_DESCRIPTION"},
	{IDGS_MON_STEP_DESCRIPTION,"IDGS_MON_STEP_DESCRIPTION"},
	{IDGS_MON_STOPWATCH_DESCRIPTION,"IDGS_MON_STOPWATCH_DESCRIPTION"},
	{IDGS_MON_UNDUMP_DESCRIPTION,"IDGS_MON_UNDUMP_DESCRIPTION"},
	{IDGS_SYMBOL_TABLE_COMMANDS,"IDGS_SYMBOL_TABLE_COMMANDS"},
	{IDGS_LABEL,"IDGS_LABEL"},
	{IDGS_MON_ADD_LABEL_DESCRIPTION,"IDGS_MON_ADD_LABEL_DESCRIPTION"},
	{IDGS_MON_DELETE_LABEL_DESCRIPTION,"IDGS_MON_DELETE_LABEL_DESCRIPTION"},
	{IDGS_MON_LOAD_LABELS_DESCRIPTION,"IDGS_MON_LOAD_LABELS_DESCRIPTION"},
	{IDGS_MON_SAVE_LABELS_DESCRIPTION,"IDGS_MON_SAVE_LABELS_DESCRIPTION"},
	{IDGS_MON_SHOW_LABELS_DESCRIPTION,"IDGS_MON_SHOW_LABELS_DESCRIPTION"},
	{IDGS_ASSEMBLER_AND_MEMORY_COMMANDS,"IDGS_ASSEMBLER_AND_MEMORY_COMMANDS"},
	{IDGS_DATA_LIST,"IDGS_DATA_LIST"},
	{IDGS_MON_WRITE_DESCRIPTION,"IDGS_MON_WRITE_DESCRIPTION"},
	{IDGS_INSTRUCTION,"IDGS_INSTRUCTION"},
	{IDGS_MON_ASSEMBLE_DESCRIPTION,"IDGS_MON_ASSEMBLE_DESCRIPTION"},
	{IDGS_ADDRESS_RANGE,"IDGS_ADDRESS_RANGE"},
	{IDGS_MON_COMPARE_DESCRIPTION,"IDGS_MON_COMPARE_DESCRIPTION"},
	{IDGS_CHECKNUM,"IDGS_CHECKNUM"},
	{IDGS_MON_DELETE_DESCRIPTION,"IDGS_MON_DELETE_DESCRIPTION"},
	{IDGS_MON_DISASS_DESCRIPTION,"IDGS_MON_DISASS_DESCRIPTION"},
	{IDGS_MON_FILL_DESCRIPTION,"IDGS_MON_FILL_DESCRIPTION"},
	{IDGS_MON_HUNT_DESCRIPTION,"IDGS_MON_HUNT_DESCRIPTION"},
	{IDGS_ADDRESS_OPT_RANGE,"IDGS_ADDRESS_OPT_RANGE"},
	{IDGS_MON_I_DESCRIPTION,"IDGS_MON_I_DESCRIPTION"},
	{IDGS_MON_II_DESCRIPTION,"IDGS_MON_II_DESCRIPTION"},
	{IDGS_DATA_TYPE,"IDGS_DATA_TYPE"},
	{IDGS_MON_MEM_DESCRIPTION,"IDGS_MON_MEM_DESCRIPTION"},
	{IDGS_MON_MEMCHAR_DESCRIPTION,"IDGS_MON_MEMCHAR_DESCRIPTION"},
	{IDGS_FORMAT,"IDGS_FORMAT"},
	{IDGS_MON_MEMMAPSAVE_DESCRIPTION,"IDGS_MON_MEMMAPSAVE_DESCRIPTION"},
	{IDGS_MASK,"IDGS_MASK"},
	{IDGS_MON_MEMMAPSHOW_DESCRIPTION,"IDGS_MON_MEMMAPSHOW_DESCRIPTION"},
	{IDGS_MON_MEMMAPZAP_DESCRIPTION,"IDGS_MON_MEMMAPZAP_DESCRIPTION"},
	{IDGS_MON_MEMSPRITE_DESCRIPTION,"IDGS_MON_MEMSPRITE_DESCRIPTION"},
	{IDGS_MON_MOVE_DESCRIPTION,"IDGS_MON_MOVE_DESCRIPTION"},
	{IDGS_CHECKPOINT_COMMANDS,"IDGS_CHECKPOINT_COMMANDS"},
	{IDGS_COND_EXPR,"IDGS_COND_EXPR"},
	{IDGS_MON_BREAK_DESCRIPTION,"IDGS_MON_BREAK_DESCRIPTION"},
	{IDGS_COMMAND,"IDGS_COMMAND"},
	{IDGS_MON_COMMAND_DESCRIPTION,"IDGS_MON_COMMAND_DESCRIPTION"},
	{IDGS_MON_CONDITION_DESCRIPTION,"IDGS_MON_CONDITION_DESCRIPTION"},
	{IDGS_MON_DISABLE_DESCRIPTION,"IDGS_MON_DISABLE_DESCRIPTION"},
	{IDGS_MON_ENABLE_DESCRIPTION,"IDGS_MON_ENABLE_DESCRIPTION"},
	{IDGS_MON_IGNORE_DESCRIPTION,"IDGS_MON_IGNORE_DESCRIPTION"},
	{IDGS_MON_UNTIL_DESCRIPTION,"IDGS_MON_UNTIL_DESCRIPTION"},
	{IDGS_MON_WATCH_DESCRIPTION,"IDGS_MON_WATCH_DESCRIPTION"},
	{IDGS_MON_TRACE_DESCRIPTION,"IDGS_MON_TRACE_DESCRIPTION"},
	{IDGS_MONITOR_STATE_COMMANDS,"IDGS_MONITOR_STATE_COMMANDS"},
	{IDGS_MON_DEVICE_DESCRIPTION,"IDGS_MON_DEVICE_DESCRIPTION"},
	{IDGS_MON_EXIT_DESCRIPTION,"IDGS_MON_EXIT_DESCRIPTION"},
	{IDGS_MON_QUIT_DESCRIPTION,"IDGS_MON_QUIT_DESCRIPTION"},
	{IDGS_MON_RADIX_DESCRIPTION,"IDGS_MON_RADIX_DESCRIPTION"},
	{IDGS_MON_SIDEFX_DESCRIPTION,"IDGS_MON_SIDEFX_DESCRIPTION"},
	{IDGS_DISK_COMMANDS,"IDGS_DISK_COMMANDS"},
	{IDGS_DISK_COMMAND,"IDGS_DISK_COMMAND"},
	{IDGS_MON_AT_DESCRIPTION,"IDGS_MON_AT_DESCRIPTION"},
	{IDGS_DEVICE,"IDGS_DEVICE"},
	{IDGS_FILE_INDEX,"IDGS_FILE_INDEX"},
	{IDGS_MON_AUTOSTART_DESCRIPTION,"IDGS_MON_AUTOSTART_DESCRIPTION"},
	{IDGS_MON_AUTOLOAD_DESCRIPTION,"IDGS_MON_AUTOLOAD_DESCRIPTION"},
	{IDGS_MON_ATTACH_DESCRIPTION,"IDGS_MON_ATTACH_DESCRIPTION"},
	{IDGS_MON_BLOAD_DESCRIPTION,"IDGS_MON_BLOAD_DESCRIPTION"},
	{IDGS_TRACK,"IDGS_TRACK"},
	{IDGS_SECTOR,"IDGS_SECTOR"},
	{IDGS_MON_BLOCK_READ_DESCRIPTION,"IDGS_MON_BLOCK_READ_DESCRIPTION"},
	{IDGS_MON_BSAVE_DESCRIPTION,"IDGS_MON_BSAVE_DESCRIPTION"},
	{IDGS_MON_BLOCK_WRITE_DESCRIPTION,"IDGS_MON_BLOCK_WRITE_DESCRIPTION"},
	{IDGS_DIRECTORY,"IDGS_DIRECTORY"},
	{IDGS_P_DIRECTORY,"IDGS_P_DIRECTORY"},
	{IDGS_MON_CD_DESCRIPTION,"IDGS_MON_CD_DESCRIPTION"},
	{IDGS_MON_DETACH_DESCRIPTION,"IDGS_MON_DETACH_DESCRIPTION"},
	{IDGS_MON_DIR_DESCRIPTION,"IDGS_MON_DIR_DESCRIPTION"},
	{IDGS_MON_LIST_DESCRIPTION,"IDGS_MON_LIST_DESCRIPTION"},
	{IDGS_MON_LOAD_DESCRIPTION,"IDGS_MON_LOAD_DESCRIPTION"},
	{IDGS_MON_PWD_DESCRIPTION,"IDGS_MON_PWD_DESCRIPTION"},
	{IDGS_MON_SAVE_DESCRIPTION,"IDGS_MON_SAVE_DESCRIPTION"},
	{IDGS_OTHER_COMMANDS,"IDGS_OTHER_COMMANDS"},
	{IDGS_MON_DISPLAY_NUMBER_DESCRIPTION,"IDGS_MON_DISPLAY_NUMBER_DESCRIPTION"},
	{IDGS_MON_CARTFREEZE_DESCRIPTION,"IDGS_MON_CARTFREEZE_DESCRIPTION"},
	{IDGS_MON_HELP_DESCRIPTION,"IDGS_MON_HELP_DESCRIPTION"},
	{IDGS_STRING,"IDGS_STRING"},
	{IDGS_MON_KEYBUF_DESCRIPTION,"IDGS_MON_KEYBUF_DESCRIPTION"},
	{IDGS_MON_PLAYBACK_DESCRIPTION,"IDGS_MON_PLAYBACK_DESCRIPTION"},
	{IDGS_EXPRESSION,"IDGS_EXPRESSION"},
	{IDGS_MON_PRINT_DESCRIPTION,"IDGS_MON_PRINT_DESCRIPTION"},
	{IDGS_MON_RECORD_DESCRIPTION,"IDGS_MON_RECORD_DESCRIPTION"},
	{IDGS_RESOURCE,"IDGS_RESOURCE"},
	{IDGS_MON_RESOURCEGET_DESCRIPTION,"IDGS_MON_RESOURCEGET_DESCRIPTION"},
	{IDGS_VALUE,"IDGS_VALUE"},
	{IDGS_MON_RESOURCESET_DESCRIPTION,"IDGS_MON_RESOURCESET_DESCRIPTION"},
	{IDGS_MON_LOAD_RESOURCES_DESCRIPTION,"IDGS_MON_LOAD_RESOURCES_DESCRIPTION"},
	{IDGS_MON_SAVE_RESOURCES_DESCRIPTION,"IDGS_MON_SAVE_RESOURCES_DESCRIPTION"},
	{IDGS_MON_STOP_DESCRIPTION,"IDGS_MON_STOP_DESCRIPTION"},
	{IDGS_MON_SCREENSHOT_DESCRIPTION,"IDGS_MON_SCREENSHOT_DESCRIPTION"},
	{IDGS_MON_TAPECTRL_DESCRIPTION,"IDGS_MON_TAPECTRL_DESCRIPTION"},
	{IDCLS_AUTOSTART_LOAD_TO_BASIC_START,"IDCLS_AUTOSTART_LOAD_TO_BASIC_START"},
	{IDCLS_AUTOSTART_LOAD_WITH_1,"IDCLS_AUTOSTART_LOAD_WITH_1"},
	{IDCLS_ENABLE_AUTOSTARTWITHCOLON,"IDCLS_ENABLE_AUTOSTARTWITHCOLON"},
	{IDCLS_DISABLE_AUTOSTARTWITHCOLON,"IDCLS_DISABLE_AUTOSTARTWITHCOLON"},
	{IDCLS_ENABLE_AUTOSTART_HANDLE_TDE,"IDCLS_ENABLE_AUTOSTART_HANDLE_TDE"},
	{IDCLS_DISABLE_AUTOSTART_HANDLE_TDE,"IDCLS_DISABLE_AUTOSTART_HANDLE_TDE"},
	{IDCLS_ENABLE_WARP_MODE_AUTOSTART,"IDCLS_ENABLE_WARP_MODE_AUTOSTART"},
	{IDCLS_DISABLE_WARP_MODE_AUTOSTART,"IDCLS_DISABLE_WARP_MODE_AUTOSTART"},
	{IDCLS_SET_AUTOSTART_MODE_FOR_PRG,"IDCLS_SET_AUTOSTART_MODE_FOR_PRG"},
	{IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG,"IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG"},
	{IDCLS_SET_AUTOSTART_DELAY,"IDCLS_SET_AUTOSTART_DELAY"},
	{IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY,"IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY"},
	{IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY,"IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY"},
	{IDCLS_USE_PAL_SYNC_FACTOR,"IDCLS_USE_PAL_SYNC_FACTOR"},
	{IDCLS_USE_NTSC_SYNC_FACTOR,"IDCLS_USE_NTSC_SYNC_FACTOR"},
	{IDCLS_USE_PALN_SYNC_FACTOR,"IDCLS_USE_PALN_SYNC_FACTOR"},
	{IDCLS_SET_BURST_MOD,"IDCLS_SET_BURST_MOD"},
	{IDCLS_P_NAME,"IDCLS_P_NAME"},
	{IDCLS_SPECIFY_INT_KERNEL_NAME,"IDCLS_SPECIFY_INT_KERNEL_NAME"},
	{IDCLS_SPECIFY_DE_KERNEL_NAME,"IDCLS_SPECIFY_DE_KERNEL_NAME"},
	{IDCLS_SPECIFY_FI_KERNEL_NAME,"IDCLS_SPECIFY_FI_KERNEL_NAME"},
	{IDCLS_SPECIFY_FR_KERNEL_NAME,"IDCLS_SPECIFY_FR_KERNEL_NAME"},
	{IDCLS_SPECIFY_IT_KERNEL_NAME,"IDCLS_SPECIFY_IT_KERNEL_NAME"},
	{IDCLS_SPECIFY_NO_KERNEL_NAME,"IDCLS_SPECIFY_NO_KERNEL_NAME"},
	{IDCLS_SPECIFY_SV_KERNEL_NAME,"IDCLS_SPECIFY_SV_KERNEL_NAME"},
	{IDCLS_SPECIFY_BASIC_ROM_NAME_LOW,"IDCLS_SPECIFY_BASIC_ROM_NAME_LOW"},
	{IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH,"IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH"},
	{IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME,"IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME"},
	{IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME,"IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME"},
	{IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME,"IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME"},
	{IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME,"IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME"},
	{IDCLS_SPECIFY_C64_MODE_KERNAL_NAME,"IDCLS_SPECIFY_C64_MODE_KERNAL_NAME"},
	{IDCLS_SPECIFY_C64_MODE_BASIC_NAME,"IDCLS_SPECIFY_C64_MODE_BASIC_NAME"},
	{IDCLS_ENABLE_OEM_JOY,"IDCLS_ENABLE_OEM_JOY"},
	{IDCLS_DISABLE_OEM_JOY,"IDCLS_DISABLE_OEM_JOY"},
	{IDCLS_ENABLE_IEE488,"IDCLS_ENABLE_IEE488"},
	{IDCLS_DISABLE_IEE488,"IDCLS_DISABLE_IEE488"},
	{IDCLS_P_REVISION,"IDCLS_P_REVISION"},
	{IDCLS_PATCH_KERNAL_TO_REVISION,"IDCLS_PATCH_KERNAL_TO_REVISION"},
	{IDCLS_ENABLE_DEXX_ACIA_RS232_EMU,"IDCLS_ENABLE_DEXX_ACIA_RS232_EMU"},
	{IDCLS_DISABLE_DEXX_ACIA_RS232_EMU,"IDCLS_DISABLE_DEXX_ACIA_RS232_EMU"},
	{IDCLS_ENABLE_ACIA_EMU,"IDCLS_ENABLE_ACIA_EMU"},
	{IDCLS_DISABLE_ACIA_EMU,"IDCLS_DISABLE_ACIA_EMU"},
	{IDCLS_P_NUMBER,"IDCLS_P_NUMBER"},
	{IDCLS_SPECIFY_KEYMAP_FILE_INDEX,"IDCLS_SPECIFY_KEYMAP_FILE_INDEX"},
	{IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME,"IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME"},
	{IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME,"IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME"},
	{IDCLS_ACTIVATE_40_COL_MODE,"IDCLS_ACTIVATE_40_COL_MODE"},
	{IDCLS_ACTIVATE_80_COL_MODE,"IDCLS_ACTIVATE_80_COL_MODE"},
	{IDCLS_GO64_MODE,"IDCLS_GO64_MODE"},
	{IDCLS_GO128_MODE,"IDCLS_GO128_MODE"},
	{IDCLS_SPECIFY_INT_FUNC_ROM_NAME,"IDCLS_SPECIFY_INT_FUNC_ROM_NAME"},
	{IDCLS_SPECIFY_EXT_FUNC_ROM_NAME,"IDCLS_SPECIFY_EXT_FUNC_ROM_NAME"},
	{IDCLS_ENABLE_INT_FUNC_ROM,"IDCLS_ENABLE_INT_FUNC_ROM"},
	{IDCLS_DISABLE_INT_FUNC_ROM,"IDCLS_DISABLE_INT_FUNC_ROM"},
	{IDCLS_ENABLE_EXT_FUNC_ROM,"IDCLS_ENABLE_EXT_FUNC_ROM"},
	{IDCLS_DISABLE_EXT_FUNC_ROM,"IDCLS_DISABLE_EXT_FUNC_ROM"},
	{IDCLS_USE_OLD_NTSC_SYNC_FACTOR,"IDCLS_USE_OLD_NTSC_SYNC_FACTOR"},
	{IDCLS_P_MODEL,"IDCLS_P_MODEL"},
	{IDCLS_SET_BOTH_CIA_MODELS,"IDCLS_SET_BOTH_CIA_MODELS"},
	{IDCLS_SET_CIA1_MODEL,"IDCLS_SET_CIA1_MODEL"},
	{IDCLS_SET_CIA2_MODEL,"IDCLS_SET_CIA2_MODEL"},
	{IDCLS_SET_C64_MODEL,"IDCLS_SET_C64_MODEL"},
	{IDCLS_SET_C128_MODEL,"IDCLS_SET_C128_MODEL"},
	{IDCLS_SET_PLUS4_MODEL,"IDCLS_SET_PLUS4_MODEL"},
	{IDCLS_SET_DTV_MODEL,"IDCLS_SET_DTV_MODEL"},
	{IDCLS_SPECIFY_KERNAL_ROM_NAME,"IDCLS_SPECIFY_KERNAL_ROM_NAME"},
	{IDCLS_SPECIFY_BASIC_ROM_NAME,"IDCLS_SPECIFY_BASIC_ROM_NAME"},
	{IDCLS_SPECIFY_CHARGEN_ROM_NAME,"IDCLS_SPECIFY_CHARGEN_ROM_NAME"},
	{IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2,"IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2"},
	{IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP,"IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP"},
	{IDCLS_SET_GLUE_LOGIC_TYPE,"IDCLS_SET_GLUE_LOGIC_TYPE"},
	{IDCLS_ENABLE_HUMMER_ADC,"IDCLS_ENABLE_HUMMER_ADC"},
	{IDCLS_DISABLE_HUMMER_ADC,"IDCLS_DISABLE_HUMMER_ADC"},
	{IDCLS_SELECT_CONFLICT_HANDLING,"IDCLS_SELECT_CONFLICT_HANDLING"},
	{IDCLS_ENABLE_IEEE488_INTERFACE,"IDCLS_ENABLE_IEEE488_INTERFACE"},
	{IDCLS_DISABLE_IEEE488_INTERFACE,"IDCLS_DISABLE_IEEE488_INTERFACE"},
	{IDCLS_SPECIFY_IEEE488_INTERFACE_NAME,"IDCLS_SPECIFY_IEEE488_INTERFACE_NAME"},
	{IDCLS_ENABLE_GEORAM,"IDCLS_ENABLE_GEORAM"},
	{IDCLS_DISABLE_GEORAM,"IDCLS_DISABLE_GEORAM"},
	{IDCLS_SPECIFY_GEORAM_NAME,"IDCLS_SPECIFY_GEORAM_NAME"},
	{IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE,"IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE,"IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE"},
	{IDCLS_SWAP_CART_IO,"IDCLS_SWAP_CART_IO"},
	{IDCLS_DONT_SWAP_CART_IO,"IDCLS_DONT_SWAP_CART_IO"},
	{IDCLS_MAP_CART_IO_2,"IDCLS_MAP_CART_IO_2"},
	{IDCLS_MAP_CART_IO_3,"IDCLS_MAP_CART_IO_3"},
	{IDCLS_P_SIZE_IN_KB,"IDCLS_P_SIZE_IN_KB"},
	{IDCLS_GEORAM_SIZE,"IDCLS_GEORAM_SIZE"},
	{IDCLS_ENABLE_PETREU,"IDCLS_ENABLE_PETREU"},
	{IDCLS_DISABLE_PETREU,"IDCLS_DISABLE_PETREU"},
	{IDCLS_SPECIFY_PETREU_NAME,"IDCLS_SPECIFY_PETREU_NAME"},
	{IDCLS_PETREU_SIZE,"IDCLS_PETREU_SIZE"},
	{IDCLS_SPECIFY_PETDWW_NAME,"IDCLS_SPECIFY_PETDWW_NAME"},
	{IDCLS_ENABLE_PETDWW,"IDCLS_ENABLE_PETDWW"},
	{IDCLS_DISABLE_PETDWW,"IDCLS_DISABLE_PETDWW"},
	{IDCLS_ENABLE_USERPORT_DAC,"IDCLS_ENABLE_USERPORT_DAC"},
	{IDCLS_DISABLE_USERPORT_DAC,"IDCLS_DISABLE_USERPORT_DAC"},
	{IDCLS_ENABLE_USERPORT_RTC,"IDCLS_ENABLE_USERPORT_RTC"},
	{IDCLS_DISABLE_USERPORT_RTC,"IDCLS_DISABLE_USERPORT_RTC"},
	{IDCLS_SID_PLAYER_MODE,"IDCLS_SID_PLAYER_MODE"},
	{IDCLS_OVERWRITE_PSID_SETTINGS,"IDCLS_OVERWRITE_PSID_SETTINGS"},
	{IDCLS_SPECIFY_PSID_TUNE_NUMBER,"IDCLS_SPECIFY_PSID_TUNE_NUMBER"},
	{IDCLS_ENABLE_RAMCART,"IDCLS_ENABLE_RAMCART"},
	{IDCLS_DISABLE_RAMCART,"IDCLS_DISABLE_RAMCART"},
	{IDCLS_SPECIFY_RAMCART_NAME,"IDCLS_SPECIFY_RAMCART_NAME"},
	{IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE,"IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE,"IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE"},
	{IDCLS_RAMCART_SIZE,"IDCLS_RAMCART_SIZE"},
	{IDCLS_ENABLE_DQBB,"IDCLS_ENABLE_DQBB"},
	{IDCLS_DISABLE_DQBB,"IDCLS_DISABLE_DQBB"},
	{IDCLS_SPECIFY_DQBB_NAME,"IDCLS_SPECIFY_DQBB_NAME"},
	{IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE,"IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE,"IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE"},
	{IDCLS_ENABLE_ISEPIC,"IDCLS_ENABLE_ISEPIC"},
	{IDCLS_DISABLE_ISEPIC,"IDCLS_DISABLE_ISEPIC"},
	{IDCLS_SET_ISEPIC_FILENAME,"IDCLS_SET_ISEPIC_FILENAME"},
	{IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE,"IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE,"IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE"},
	{IDCLS_ENABLE_MMC64,"IDCLS_ENABLE_MMC64"},
	{IDCLS_DISABLE_MMC64,"IDCLS_DISABLE_MMC64"},
	{IDCLS_SPECIFY_MMC64_BIOS_NAME,"IDCLS_SPECIFY_MMC64_BIOS_NAME"},
	{IDCLS_SPECIFY_MMC64_IMAGE_NAME,"IDCLS_SPECIFY_MMC64_IMAGE_NAME"},
	{IDCLS_MMC64_READONLY,"IDCLS_MMC64_READONLY"},
	{IDCLS_MMC64_READWRITE,"IDCLS_MMC64_READWRITE"},
	{IDCLS_MMC64_BIOS_WRITE,"IDCLS_MMC64_BIOS_WRITE"},
	{IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME,"IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME"},
	{IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE,"IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE"},
	{IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE,"IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE"},
	{IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE,"IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE"},
	{IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE,"IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE"},
	{IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE,"IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE"},
	{IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE,"IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE"},
	{IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE,"IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE"},
	{IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE,"IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE,"IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE"},
	{IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT,"IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT"},
	{IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT,"IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT"},
	{IDCLS_SET_RR_BANK_JUMPER,"IDCLS_SET_RR_BANK_JUMPER"},
	{IDCLS_UNSET_RR_BANK_JUMPER,"IDCLS_UNSET_RR_BANK_JUMPER"},
	{IDCLS_SET_RR_FLASH_JUMPER,"IDCLS_SET_RR_FLASH_JUMPER"},
	{IDCLS_UNSET_RR_FLASH_JUMPER,"IDCLS_UNSET_RR_FLASH_JUMPER"},
	{IDCLS_ENABLE_REU,"IDCLS_ENABLE_REU"},
	{IDCLS_DISABLE_REU,"IDCLS_DISABLE_REU"},
	{IDCLS_SPECIFY_REU_NAME,"IDCLS_SPECIFY_REU_NAME"},
	{IDCLS_ALLOW_WRITING_TO_REU_IMAGE,"IDCLS_ALLOW_WRITING_TO_REU_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_REU_IMAGE,"IDCLS_DO_NOT_WRITE_TO_REU_IMAGE"},
	{IDCLS_REU_SIZE,"IDCLS_REU_SIZE"},
	{IDCLS_ENABLE_TFE,"IDCLS_ENABLE_TFE"},
	{IDCLS_DISABLE_TFE,"IDCLS_DISABLE_TFE"},
	{IDCLS_TFE_INTERFACE,"IDCLS_TFE_INTERFACE"},
	{IDCLS_ENABLE_TFE_AS_RRNET,"IDCLS_ENABLE_TFE_AS_RRNET"},
	{IDCLS_DISABLE_TFE_AS_RRNET,"IDCLS_DISABLE_TFE_AS_RRNET"},
	{IDCLS_CART_ATTACH_DETACH_RESET,"IDCLS_CART_ATTACH_DETACH_RESET"},
	{IDCLS_CART_ATTACH_DETACH_NO_RESET,"IDCLS_CART_ATTACH_DETACH_NO_RESET"},
	{IDCLS_ATTACH_CRT_CART,"IDCLS_ATTACH_CRT_CART"},
	{IDCLS_ATTACH_GENERIC_8KB_CART,"IDCLS_ATTACH_GENERIC_8KB_CART"},
	{IDCLS_ATTACH_GENERIC_16KB_CART,"IDCLS_ATTACH_GENERIC_16KB_CART"},
	{IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART,"IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART"},
	{IDCLS_ATTACH_RAW_STARDOS_CART,"IDCLS_ATTACH_RAW_STARDOS_CART"},
	{IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART,"IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART"},
	{IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART,"IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART"},
	{IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART,"IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART"},
	{IDCLS_ATTACH_RAW_ACTION_REPLAY_CART,"IDCLS_ATTACH_RAW_ACTION_REPLAY_CART"},
	{IDCLS_ATTACH_RAW_CAPTURE_CART,"IDCLS_ATTACH_RAW_CAPTURE_CART"},
	{IDCLS_ATTACH_RAW_COMAL80_CART,"IDCLS_ATTACH_RAW_COMAL80_CART"},
	{IDCLS_ATTACH_RAW_DELA_EP256_CART,"IDCLS_ATTACH_RAW_DELA_EP256_CART"},
	{IDCLS_ATTACH_RAW_DELA_EP64_CART,"IDCLS_ATTACH_RAW_DELA_EP64_CART"},
	{IDCLS_ATTACH_RAW_DELA_EP7X8_CART,"IDCLS_ATTACH_RAW_DELA_EP7X8_CART"},
	{IDCLS_ATTACH_RAW_DINAMIC_CART,"IDCLS_ATTACH_RAW_DINAMIC_CART"},
	{IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART,"IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART"},
	{IDCLS_ATTACH_RAW_DQBB_CART,"IDCLS_ATTACH_RAW_DQBB_CART"},
	{IDCLS_ATTACH_RAW_EASY_FLASH_CART,"IDCLS_ATTACH_RAW_EASY_FLASH_CART"},
	{IDCLS_ATTACH_RAW_RETRO_REPLAY_CART,"IDCLS_ATTACH_RAW_RETRO_REPLAY_CART"},
	{IDCLS_ATTACH_RAW_REX_UTILITY_CART,"IDCLS_ATTACH_RAW_REX_UTILITY_CART"},
	{IDCLS_ATTACH_RAW_SS64_CART,"IDCLS_ATTACH_RAW_SS64_CART"},
	{IDCLS_ATTACH_RAW_IDE64_CART,"IDCLS_ATTACH_RAW_IDE64_CART"},
	{IDCLS_ATTACH_RAW_ATOMIC_POWER_CART,"IDCLS_ATTACH_RAW_ATOMIC_POWER_CART"},
	{IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART,"IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART"},
	{IDCLS_ATTACH_RAW_EXOS_CART,"IDCLS_ATTACH_RAW_EXOS_CART"},
	{IDCLS_ATTACH_RAW_EXPERT_CART,"IDCLS_ATTACH_RAW_EXPERT_CART"},
	{IDCLS_ATTACH_RAW_F64_CART,"IDCLS_ATTACH_RAW_F64_CART"},
	{IDCLS_ATTACH_RAW_FC1_CART,"IDCLS_ATTACH_RAW_FC1_CART"},
	{IDCLS_ATTACH_RAW_FC3_CART,"IDCLS_ATTACH_RAW_FC3_CART"},
	{IDCLS_ATTACH_RAW_FCPLUS_CART,"IDCLS_ATTACH_RAW_FCPLUS_CART"},
	{IDCLS_ATTACH_RAW_FREEZE_FRAME_CART,"IDCLS_ATTACH_RAW_FREEZE_FRAME_CART"},
	{IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART,"IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART"},
	{IDCLS_ATTACH_RAW_FP_PP_CART,"IDCLS_ATTACH_RAW_FP_PP_CART"},
	{IDCLS_ATTACH_RAW_SS4_CART,"IDCLS_ATTACH_RAW_SS4_CART"},
	{IDCLS_ATTACH_RAW_SS5_CART,"IDCLS_ATTACH_RAW_SS5_CART"},
	{IDCLS_ATTACH_CBM_IEEE488_CART,"IDCLS_ATTACH_CBM_IEEE488_CART"},
	{IDCLS_ATTACH_RAW_ISEPIC_CART,"IDCLS_ATTACH_RAW_ISEPIC_CART"},
	{IDCLS_ATTACH_RAW_KCS_CART,"IDCLS_ATTACH_RAW_KCS_CART"},
	{IDCLS_ATTACH_RAW_KINGSOFT_CART,"IDCLS_ATTACH_RAW_KINGSOFT_CART"},
	{IDCLS_ATTACH_RAW_MACH5_CART,"IDCLS_ATTACH_RAW_MACH5_CART"},
	{IDCLS_ATTACH_RAW_MAGIC_DESK_CART,"IDCLS_ATTACH_RAW_MAGIC_DESK_CART"},
	{IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART,"IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART"},
	{IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART,"IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART"},
	{IDCLS_ATTACH_RAW_MMC64_CART,"IDCLS_ATTACH_RAW_MMC64_CART"},
	{IDCLS_ATTACH_RAW_MMC_REPLAY_CART,"IDCLS_ATTACH_RAW_MMC_REPLAY_CART"},
	{IDCLS_ATTACH_RAW_MAGIC_VOICE_CART,"IDCLS_ATTACH_RAW_MAGIC_VOICE_CART"},
	{IDCLS_ATTACH_RAW_OCEAN_CART,"IDCLS_ATTACH_RAW_OCEAN_CART"},
	{IDCLS_ATTACH_RAW_WESTERMANN_CART,"IDCLS_ATTACH_RAW_WESTERMANN_CART"},
	{IDCLS_ATTACH_RAW_WARPSPEED_CART,"IDCLS_ATTACH_RAW_WARPSPEED_CART"},
	{IDCLS_ATTACH_RAW_ZAXXON_CART,"IDCLS_ATTACH_RAW_ZAXXON_CART"},
	{IDCLS_ATTACH_RAW_PAGEFOX_CART,"IDCLS_ATTACH_RAW_PAGEFOX_CART"},
	{IDCLS_ATTACH_RAW_P64_CART,"IDCLS_ATTACH_RAW_P64_CART"},
	{IDCLS_ATTACH_RAW_RAMCART_CART,"IDCLS_ATTACH_RAW_RAMCART_CART"},
	{IDCLS_ATTACH_RAW_REU_CART,"IDCLS_ATTACH_RAW_REU_CART"},
	{IDCLS_ATTACH_RAW_REX_EP256_CART,"IDCLS_ATTACH_RAW_REX_EP256_CART"},
	{IDCLS_ATTACH_RAW_ROSS_CART,"IDCLS_ATTACH_RAW_ROSS_CART"},
	{IDCLS_ATTACH_RAW_GAME_KILLER_CART,"IDCLS_ATTACH_RAW_GAME_KILLER_CART"},
	{IDCLS_ATTACH_RAW_GEORAM_CART,"IDCLS_ATTACH_RAW_GEORAM_CART"},
	{IDCLS_ATTACH_RAW_GAME_SYSTEM_CART,"IDCLS_ATTACH_RAW_GAME_SYSTEM_CART"},
	{IDCLS_ENABLE_EXPERT_CART,"IDCLS_ENABLE_EXPERT_CART"},
	{IDCLS_DISABLE_EXPERT_CART,"IDCLS_DISABLE_EXPERT_CART"},
	{IDCLS_SET_EXPERT_FILENAME,"IDCLS_SET_EXPERT_FILENAME"},
	{IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE,"IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE"},
	{IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE,"IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE"},
	{IDCLS_DISABLE_CART,"IDCLS_DISABLE_CART"},
	{IDCLS_SMART_ATTACH_CART,"IDCLS_SMART_ATTACH_CART"},
	{IDCLS_SPECIFY_IDE64_NAME,"IDCLS_SPECIFY_IDE64_NAME"},
	{IDCLS_P_VALUE,"IDCLS_P_VALUE"},
	{IDCLS_SET_AMOUNT_CYLINDERS_IDE64,"IDCLS_SET_AMOUNT_CYLINDERS_IDE64"},
	{IDCLS_SET_AMOUNT_HEADS_IDE64,"IDCLS_SET_AMOUNT_HEADS_IDE64"},
	{IDCLS_SET_AMOUNT_SECTORS_IDE64,"IDCLS_SET_AMOUNT_SECTORS_IDE64"},
	{IDCLS_AUTODETECT_IDE64_GEOMETRY,"IDCLS_AUTODETECT_IDE64_GEOMETRY"},
	{IDCLS_NO_AUTODETECT_IDE64_GEOMETRY,"IDCLS_NO_AUTODETECT_IDE64_GEOMETRY"},
	{IDCLS_IDE64_V4,"IDCLS_IDE64_V4"},
	{IDCLS_IDE64_PRE_V4,"IDCLS_IDE64_PRE_V4"},
	{IDCLS_P_MODELNUMBER,"IDCLS_P_MODELNUMBER"},
	{IDCLS_SPECIFY_CBM2_MODEL,"IDCLS_SPECIFY_CBM2_MODEL"},
	{IDCLS_SPECIFY_TO_USE_VIC_II,"IDCLS_SPECIFY_TO_USE_VIC_II"},
	{IDCLS_SPECIFY_TO_USE_CRTC,"IDCLS_SPECIFY_TO_USE_CRTC"},
	{IDCLS_P_LINENUMBER,"IDCLS_P_LINENUMBER"},
	{IDCLS_SPECIFY_CBM2_MODEL_HARDWARE,"IDCLS_SPECIFY_CBM2_MODEL_HARDWARE"},
	{IDCLS_P_RAMSIZE,"IDCLS_P_RAMSIZE"},
	{IDCLS_SPECIFY_SIZE_OF_RAM,"IDCLS_SPECIFY_SIZE_OF_RAM"},
	{IDCLS_SPECIFY_CART_ROM_1000_NAME,"IDCLS_SPECIFY_CART_ROM_1000_NAME"},
	{IDCLS_SPECIFY_CART_ROM_2000_NAME,"IDCLS_SPECIFY_CART_ROM_2000_NAME"},
	{IDCLS_SPECIFY_CART_ROM_4000_NAME,"IDCLS_SPECIFY_CART_ROM_4000_NAME"},
	{IDCLS_SPECIFY_CART_ROM_6000_NAME,"IDCLS_SPECIFY_CART_ROM_6000_NAME"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_0800,"IDCLS_ENABLE_RAM_MAPPING_IN_0800"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_0800,"IDCLS_DISABLE_RAM_MAPPING_IN_0800"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_1000,"IDCLS_ENABLE_RAM_MAPPING_IN_1000"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_1000,"IDCLS_DISABLE_RAM_MAPPING_IN_1000"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_2000,"IDCLS_ENABLE_RAM_MAPPING_IN_2000"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_2000,"IDCLS_DISABLE_RAM_MAPPING_IN_2000"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_4000,"IDCLS_ENABLE_RAM_MAPPING_IN_4000"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_4000,"IDCLS_DISABLE_RAM_MAPPING_IN_4000"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_6000,"IDCLS_ENABLE_RAM_MAPPING_IN_6000"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_6000,"IDCLS_DISABLE_RAM_MAPPING_IN_6000"},
	{IDCLS_ENABLE_RAM_MAPPING_IN_C000,"IDCLS_ENABLE_RAM_MAPPING_IN_C000"},
	{IDCLS_DISABLE_RAM_MAPPING_IN_C000,"IDCLS_DISABLE_RAM_MAPPING_IN_C000"},
	{IDCLS_SPECIFY_KEYMAP_INDEX,"IDCLS_SPECIFY_KEYMAP_INDEX"},
	{IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME,"IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME"},
	{IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME,"IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME"},
	{IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME,"IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME"},
	{IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME,"IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME"},
	{IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME,"IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME"},
	{IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME,"IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME"},
	{IDCLS_ENABLE_TRUE_DRIVE,"IDCLS_ENABLE_TRUE_DRIVE"},
	{IDCLS_DISABLE_TRUE_DRIVE,"IDCLS_DISABLE_TRUE_DRIVE"},
	{IDCLS_ENABLE_DRIVE_SOUND,"IDCLS_ENABLE_DRIVE_SOUND"},
	{IDCLS_DISABLE_DRIVE_SOUND,"IDCLS_DISABLE_DRIVE_SOUND"},
	{IDCLS_P_TYPE,"IDCLS_P_TYPE"},
	{IDCLS_SET_DRIVE_TYPE,"IDCLS_SET_DRIVE_TYPE"},
	{IDCLS_P_METHOD,"IDCLS_P_METHOD"},
	{IDCLS_P_COLOR,"IDCLS_P_COLOR"},
	{IDCLS_OVERSIZED_HANDLING,"IDCLS_OVERSIZED_HANDLING"},
	{IDCLS_MULTICOLOR_HANDLING,"IDCLS_MULTICOLOR_HANDLING"},
	{IDCLS_TED_LUM_HANDLING,"IDCLS_TED_LUM_HANDLING"},
	{IDCLS_CRTC_TEXT_COLOR,"IDCLS_CRTC_TEXT_COLOR"},
	{IDCLS_SET_DRIVE_EXTENSION_POLICY,"IDCLS_SET_DRIVE_EXTENSION_POLICY"},
	{IDCLS_SPECIFY_1541_DOS_ROM_NAME,"IDCLS_SPECIFY_1541_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1541_II_DOS_ROM_NAME,"IDCLS_SPECIFY_1541_II_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1570_DOS_ROM_NAME,"IDCLS_SPECIFY_1570_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1571_DOS_ROM_NAME,"IDCLS_SPECIFY_1571_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1581_DOS_ROM_NAME,"IDCLS_SPECIFY_1581_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_2000_DOS_ROM_NAME,"IDCLS_SPECIFY_2000_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_4000_DOS_ROM_NAME,"IDCLS_SPECIFY_4000_DOS_ROM_NAME"},
	{IDCLS_SET_IDLE_METHOD,"IDCLS_SET_IDLE_METHOD"},
	{IDCLS_ENABLE_DRIVE_RAM_2000,"IDCLS_ENABLE_DRIVE_RAM_2000"},
	{IDCLS_DISABLE_DRIVE_RAM_2000,"IDCLS_DISABLE_DRIVE_RAM_2000"},
	{IDCLS_ENABLE_DRIVE_RAM_4000,"IDCLS_ENABLE_DRIVE_RAM_4000"},
	{IDCLS_DISABLE_DRIVE_RAM_4000,"IDCLS_DISABLE_DRIVE_RAM_4000"},
	{IDCLS_ENABLE_DRIVE_RAM_6000,"IDCLS_ENABLE_DRIVE_RAM_6000"},
	{IDCLS_DISABLE_DRIVE_RAM_6000,"IDCLS_DISABLE_DRIVE_RAM_6000"},
	{IDCLS_ENABLE_DRIVE_RAM_8000,"IDCLS_ENABLE_DRIVE_RAM_8000"},
	{IDCLS_DISABLE_DRIVE_RAM_8000,"IDCLS_DISABLE_DRIVE_RAM_8000"},
	{IDCLS_ENABLE_DRIVE_RAM_A000,"IDCLS_ENABLE_DRIVE_RAM_A000"},
	{IDCLS_DISABLE_DRIVE_RAM_A000,"IDCLS_DISABLE_DRIVE_RAM_A000"},
	{IDCLS_PAR_CABLE_C64EXP_TYPE,"IDCLS_PAR_CABLE_C64EXP_TYPE"},
	{IDCLS_ENABLE_PROFDOS,"IDCLS_ENABLE_PROFDOS"},
	{IDCLS_DISABLE_PROFDOS,"IDCLS_DISABLE_PROFDOS"},
	{IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME,"IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME"},
	{IDCLS_ENABLE_SUPERCARD,"IDCLS_ENABLE_SUPERCARD"},
	{IDCLS_DISABLE_SUPERCARD,"IDCLS_DISABLE_SUPERCARD"},
	{IDCLS_SPECIFY_SUPERCARD_ROM_NAME,"IDCLS_SPECIFY_SUPERCARD_ROM_NAME"},
	{IDCLS_PAR_CABLE_PLUS4EXP_TYPE,"IDCLS_PAR_CABLE_PLUS4EXP_TYPE"},
	{IDCLS_SPECIFY_1571CR_DOS_ROM_NAME,"IDCLS_SPECIFY_1571CR_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_2031_DOS_ROM_NAME,"IDCLS_SPECIFY_2031_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_2040_DOS_ROM_NAME,"IDCLS_SPECIFY_2040_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_3040_DOS_ROM_NAME,"IDCLS_SPECIFY_3040_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_4040_DOS_ROM_NAME,"IDCLS_SPECIFY_4040_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1001_DOS_ROM_NAME,"IDCLS_SPECIFY_1001_DOS_ROM_NAME"},
	{IDCLS_SPECIFY_1551_DOS_ROM_NAME,"IDCLS_SPECIFY_1551_DOS_ROM_NAME"},
	{IDCLS_USE_AS_DIRECTORY_FSDEVICE_8,"IDCLS_USE_AS_DIRECTORY_FSDEVICE_8"},
	{IDCLS_USE_AS_DIRECTORY_FSDEVICE_9,"IDCLS_USE_AS_DIRECTORY_FSDEVICE_9"},
	{IDCLS_USE_AS_DIRECTORY_FSDEVICE_10,"IDCLS_USE_AS_DIRECTORY_FSDEVICE_10"},
	{IDCLS_USE_AS_DIRECTORY_FSDEVICE_11,"IDCLS_USE_AS_DIRECTORY_FSDEVICE_11"},
	{IDCLS_SET_AUDIO_STREAM_BITRATE,"IDCLS_SET_AUDIO_STREAM_BITRATE"},
	{IDCLS_SET_VIDEO_STREAM_BITRATE,"IDCLS_SET_VIDEO_STREAM_BITRATE"},
	{IDCLS_SPECIFY_PET_MODEL,"IDCLS_SPECIFY_PET_MODEL"},
	{IDCLS_SPECIFY_EDITOR_ROM_NAME,"IDCLS_SPECIFY_EDITOR_ROM_NAME"},
	{IDCLS_SPECIFY_4K_ROM_9XXX_NAME,"IDCLS_SPECIFY_4K_ROM_9XXX_NAME"},
	{IDCLS_SPECIFY_4K_ROM_AXXX_NAME,"IDCLS_SPECIFY_4K_ROM_AXXX_NAME"},
	{IDCLS_SPECIFY_4K_ROM_BXXX_NAME,"IDCLS_SPECIFY_4K_ROM_BXXX_NAME"},
	{IDCLS_PET8296_ENABLE_4K_RAM_AT_9000,"IDCLS_PET8296_ENABLE_4K_RAM_AT_9000"},
	{IDCLS_PET8296_DISABLE_4K_RAM_AT_9000,"IDCLS_PET8296_DISABLE_4K_RAM_AT_9000"},
	{IDCLS_PET8296_ENABLE_4K_RAM_AT_A000,"IDCLS_PET8296_ENABLE_4K_RAM_AT_A000"},
	{IDCLS_PET8296_DISABLE_4K_RAM_AT_A000,"IDCLS_PET8296_DISABLE_4K_RAM_AT_A000"},
	{IDCLS_ENABLE_SUPERPET_IO,"IDCLS_ENABLE_SUPERPET_IO"},
	{IDCLS_DISABLE_SUPERPET_IO,"IDCLS_DISABLE_SUPERPET_IO"},
	{IDCLS_ENABLE_ROM_1_KERNAL_PATCHES,"IDCLS_ENABLE_ROM_1_KERNAL_PATCHES"},
	{IDCLS_DISABLE_ROM_1_KERNAL_PATCHES,"IDCLS_DISABLE_ROM_1_KERNAL_PATCHES"},
	{IDCLS_SWITCH_UPPER_LOWER_CHARSET,"IDCLS_SWITCH_UPPER_LOWER_CHARSET"},
	{IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET,"IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET"},
	{IDCLS_EOI_BLANKS_SCREEN,"IDCLS_EOI_BLANKS_SCREEN"},
	{IDCLS_EOI_DOES_NOT_BLANK_SCREEN,"IDCLS_EOI_DOES_NOT_BLANK_SCREEN"},
	{IDCLS_ENABLE_USERPORT_DIAG_PIN,"IDCLS_ENABLE_USERPORT_DIAG_PIN"},
	{IDCLS_DISABLE_USERPORT_DIAG_PIN,"IDCLS_DISABLE_USERPORT_DIAG_PIN"},
	{IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME,"IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME"},
	{IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME,"IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME"},
	{IDCLS_SPECIFY_CART_1_LOW_ROM_NAME,"IDCLS_SPECIFY_CART_1_LOW_ROM_NAME"},
	{IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME,"IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME"},
	{IDCLS_SPECIFY_CART_2_LOW_ROM_NAME,"IDCLS_SPECIFY_CART_2_LOW_ROM_NAME"},
	{IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME,"IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME"},
	{IDCLS_SPECIFY_RAM_INSTALLED,"IDCLS_SPECIFY_RAM_INSTALLED"},
	{IDCLS_SET_SATURATION,"IDCLS_SET_SATURATION"},
	{IDCLS_SET_CONTRAST,"IDCLS_SET_CONTRAST"},
	{IDCLS_SET_BRIGHTNESS,"IDCLS_SET_BRIGHTNESS"},
	{IDCLS_SET_GAMMA,"IDCLS_SET_GAMMA"},
	{IDCLS_SET_TINT,"IDCLS_SET_TINT"},
	{IDCLS_SET_ODDLINES_PHASE,"IDCLS_SET_ODDLINES_PHASE"},
	{IDCLS_SET_ODDLINES_OFFSET,"IDCLS_SET_ODDLINES_OFFSET"},
	{IDCLS_SET_BLUR,"IDCLS_SET_BLUR"},
	{IDCLS_SET_SCANLINE_SHADE,"IDCLS_SET_SCANLINE_SHADE"},
	{IDCLS_SET_VICII_MODEL,"IDCLS_SET_VICII_MODEL"},
	{IDCLS_SPECIFY_PRT_DRIVER_4_NAME,"IDCLS_SPECIFY_PRT_DRIVER_4_NAME"},
	{IDCLS_SPECIFY_PRT_DRIVER_5_NAME,"IDCLS_SPECIFY_PRT_DRIVER_5_NAME"},
	{IDCLS_SPECIFY_PRT_DRIVER_USR_NAME,"IDCLS_SPECIFY_PRT_DRIVER_USR_NAME"},
	{IDCLS_SET_DEVICE_TYPE_4,"IDCLS_SET_DEVICE_TYPE_4"},
	{IDCLS_SET_DEVICE_TYPE_5,"IDCLS_SET_DEVICE_TYPE_5"},
	{IDCLS_ENABLE_USERPORT_PRINTER,"IDCLS_ENABLE_USERPORT_PRINTER"},
	{IDCLS_DISABLE_USERPORT_PRINTER,"IDCLS_DISABLE_USERPORT_PRINTER"},
	{IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME,"IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME"},
	{IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME,"IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME"},
	{IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME,"IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME"},
	{IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME,"IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME"},
	{IDCLS_SPECIFY_TEXT_DEVICE_4,"IDCLS_SPECIFY_TEXT_DEVICE_4"},
	{IDCLS_SPECIFY_TEXT_DEVICE_5,"IDCLS_SPECIFY_TEXT_DEVICE_5"},
	{IDCLS_SPECIFY_TEXT_USERPORT,"IDCLS_SPECIFY_TEXT_USERPORT"},
	{IDCLS_ENABLE_VIDEO_CACHE,"IDCLS_ENABLE_VIDEO_CACHE"},
	{IDCLS_DISABLE_VIDEO_CACHE,"IDCLS_DISABLE_VIDEO_CACHE"},
	{IDCLS_SPECIFY_RS232_1_NAME,"IDCLS_SPECIFY_RS232_1_NAME"},
	{IDCLS_SPECIFY_RS232_2_NAME,"IDCLS_SPECIFY_RS232_2_NAME"},
	{IDCLS_SPECIFY_RS232_3_NAME,"IDCLS_SPECIFY_RS232_3_NAME"},
	{IDCLS_SPECIFY_RS232_4_NAME,"IDCLS_SPECIFY_RS232_4_NAME"},
	{IDCLS_ENABLE_RS232_USERPORT,"IDCLS_ENABLE_RS232_USERPORT"},
	{IDCLS_DISABLE_RS232_USERPORT,"IDCLS_DISABLE_RS232_USERPORT"},
	{IDCLS_P_BAUD,"IDCLS_P_BAUD"},
	{IDCLS_SET_BAUD_RS232_USERPORT,"IDCLS_SET_BAUD_RS232_USERPORT"},
	{IDCLS_SPECIFY_RS232_DEVICE_USERPORT,"IDCLS_SPECIFY_RS232_DEVICE_USERPORT"},
	{IDCLS_ENABLE_IEC_4,"IDCLS_ENABLE_IEC_4"},
	{IDCLS_DISABLE_IEC_4,"IDCLS_DISABLE_IEC_4"},
	{IDCLS_ENABLE_IEC_5,"IDCLS_ENABLE_IEC_5"},
	{IDCLS_DISABLE_IEC_5,"IDCLS_DISABLE_IEC_5"},
	{IDCLS_ENABLE_IEC_8,"IDCLS_ENABLE_IEC_8"},
	{IDCLS_DISABLE_IEC_8,"IDCLS_DISABLE_IEC_8"},
	{IDCLS_ENABLE_IEC_9,"IDCLS_ENABLE_IEC_9"},
	{IDCLS_DISABLE_IEC_9,"IDCLS_DISABLE_IEC_9"},
	{IDCLS_ENABLE_IEC_10,"IDCLS_ENABLE_IEC_10"},
	{IDCLS_DISABLE_IEC_10,"IDCLS_DISABLE_IEC_10"},
	{IDCLS_ENABLE_IEC_11,"IDCLS_ENABLE_IEC_11"},
	{IDCLS_DISABLE_IEC_11,"IDCLS_DISABLE_IEC_11"},
	{IDCLS_P_ENGINE_MODEL,"IDCLS_P_ENGINE_MODEL"},
	{IDCLS_P_AMOUNT,"IDCLS_P_AMOUNT"},
	{IDCLS_AMOUNT_EXTRA_SIDS,"IDCLS_AMOUNT_EXTRA_SIDS"},
	{IDCLS_FASTSID_ENGINE_MODEL,"IDCLS_FASTSID_ENGINE_MODEL"},
	{IDCLS_RESID_ENGINE_MODEL,"IDCLS_RESID_ENGINE_MODEL"},
	{IDCLS_RESIDDTV_ENGINE_MODEL,"IDCLS_RESIDDTV_ENGINE_MODEL"},
	{IDCLS_CATWEASELMKIII_ENGINE_MODEL,"IDCLS_CATWEASELMKIII_ENGINE_MODEL"},
	{IDCLS_HARDSID_ENGINE_MODEL,"IDCLS_HARDSID_ENGINE_MODEL"},
	{IDCLS_PARSID_ENGINE_MODEL,"IDCLS_PARSID_ENGINE_MODEL"},
	{IDCLS_RESIDFP_ENGINE_MODEL,"IDCLS_RESIDFP_ENGINE_MODEL"},
	{IDCLS_ENABLE_SIDCART,"IDCLS_ENABLE_SIDCART"},
	{IDCLS_DISABLE_SIDCART,"IDCLS_DISABLE_SIDCART"},
	{IDCLS_P_BASE_ADDRESS,"IDCLS_P_BASE_ADDRESS"},
	{IDCLS_SPECIFY_SID_2_ADDRESS,"IDCLS_SPECIFY_SID_2_ADDRESS"},
	{IDCLS_SPECIFY_SID_3_ADDRESS,"IDCLS_SPECIFY_SID_3_ADDRESS"},
	{IDCLS_ENABLE_SID_FILTERS,"IDCLS_ENABLE_SID_FILTERS"},
	{IDCLS_DISABLE_SID_FILTERS,"IDCLS_DISABLE_SID_FILTERS"},
	{IDCLS_RESID_SAMPLING_METHOD,"IDCLS_RESID_SAMPLING_METHOD"},
	{IDCLS_P_PERCENT,"IDCLS_P_PERCENT"},
	{IDCLS_PASSBAND_PERCENTAGE,"IDCLS_PASSBAND_PERCENTAGE"},
	{IDCLS_RESID_FILTER_BIAS,"IDCLS_RESID_FILTER_BIAS"},
	{IDCLS_RESID_GAIN_PERCENTAGE,"IDCLS_RESID_GAIN_PERCENTAGE"},
	{IDCLS_ENABLE_STRETCH_VERTICAL,"IDCLS_ENABLE_STRETCH_VERTICAL"},
	{IDCLS_DISABLE_STRETCH_VERTICAL,"IDCLS_DISABLE_STRETCH_VERTICAL"},
	{IDCLS_SET_VDC_MEMORY_16KB,"IDCLS_SET_VDC_MEMORY_16KB"},
	{IDCLS_SET_VDC_MEMORY_64KB,"IDCLS_SET_VDC_MEMORY_64KB"},
	{IDCLS_SET_VDC_REVISION,"IDCLS_SET_VDC_REVISION"},
	{IDCLS_P_SPEC,"IDCLS_P_SPEC"},
	{IDCLS_SPECIFY_MEMORY_CONFIG,"IDCLS_SPECIFY_MEMORY_CONFIG"},
	{IDCLS_ENABLE_VIC1112_IEEE488,"IDCLS_ENABLE_VIC1112_IEEE488"},
	{IDCLS_DISABLE_VIC1112_IEEE488,"IDCLS_DISABLE_VIC1112_IEEE488"},
	{IDCLS_SPECIFY_EXT_ROM_2000_NAME,"IDCLS_SPECIFY_EXT_ROM_2000_NAME"},
	{IDCLS_SPECIFY_EXT_ROM_4000_NAME,"IDCLS_SPECIFY_EXT_ROM_4000_NAME"},
	{IDCLS_SPECIFY_EXT_ROM_6000_NAME,"IDCLS_SPECIFY_EXT_ROM_6000_NAME"},
	{IDCLS_SPECIFY_EXT_ROM_A000_NAME,"IDCLS_SPECIFY_EXT_ROM_A000_NAME"},
	{IDCLS_SPECIFY_EXT_ROM_B000_NAME,"IDCLS_SPECIFY_EXT_ROM_B000_NAME"},
	{IDCLS_SPECIFY_GENERIC_ROM_NAME,"IDCLS_SPECIFY_GENERIC_ROM_NAME"},
	{IDCLS_SPECIFY_MEGA_CART_ROM_NAME,"IDCLS_SPECIFY_MEGA_CART_ROM_NAME"},
	{IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME,"IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME"},
	{IDCLS_SPECIFY_VIC_FP_ROM_NAME,"IDCLS_SPECIFY_VIC_FP_ROM_NAME"},
	{IDCLS_ENABLE_FINALEXPANSION_WRITEBACK,"IDCLS_ENABLE_FINALEXPANSION_WRITEBACK"},
	{IDCLS_DISABLE_FINALEXPANSION_WRITEBACK,"IDCLS_DISABLE_FINALEXPANSION_WRITEBACK"},
	{IDCLS_SET_MEGACART_NVRAM_NAME,"IDCLS_SET_MEGACART_NVRAM_NAME"},
	{IDCLS_ENABLE_MEGACART_NVRAM_WRITE,"IDCLS_ENABLE_MEGACART_NVRAM_WRITE"},
	{IDCLS_DISABLE_MEGACART_NVRAM_WRITE,"IDCLS_DISABLE_MEGACART_NVRAM_WRITE"},
	{IDCLS_ENABLE_VICFP_ROM_WRITE,"IDCLS_ENABLE_VICFP_ROM_WRITE"},
	{IDCLS_DISABLE_VICFP_ROM_WRITE,"IDCLS_DISABLE_VICFP_ROM_WRITE"},
	{IDCLS_SET_BORDER_MODE,"IDCLS_SET_BORDER_MODE"},
	{IDCLS_ENABLE_SPRITE_BACKGROUND,"IDCLS_ENABLE_SPRITE_BACKGROUND"},
	{IDCLS_DISABLE_SPRITE_BACKGROUND,"IDCLS_DISABLE_SPRITE_BACKGROUND"},
	{IDCLS_ENABLE_SPRITE_SPRITE,"IDCLS_ENABLE_SPRITE_SPRITE"},
	{IDCLS_DISABLE_SPRITE_SPRITE,"IDCLS_DISABLE_SPRITE_SPRITE"},
	{IDCLS_USE_NEW_LUMINANCES,"IDCLS_USE_NEW_LUMINANCES"},
	{IDCLS_USE_OLD_LUMINANCES,"IDCLS_USE_OLD_LUMINANCES"},
	{IDCLS_ENABLE_DOUBLE_SIZE,"IDCLS_ENABLE_DOUBLE_SIZE"},
	{IDCLS_DISABLE_DOUBLE_SIZE,"IDCLS_DISABLE_DOUBLE_SIZE"},
	{IDCLS_ENABLE_DOUBLE_SCAN,"IDCLS_ENABLE_DOUBLE_SCAN"},
	{IDCLS_DISABLE_DOUBLE_SCAN,"IDCLS_DISABLE_DOUBLE_SCAN"},
	{IDCLS_ENABLE_AUDIO_LEAK,"IDCLS_ENABLE_AUDIO_LEAK"},
	{IDCLS_DISABLE_AUDIO_LEAK,"IDCLS_DISABLE_AUDIO_LEAK"},
	{IDCLS_ENABLE_HARDWARE_SCALING,"IDCLS_ENABLE_HARDWARE_SCALING"},
	{IDCLS_DISABLE_HARDWARE_SCALING,"IDCLS_DISABLE_HARDWARE_SCALING"},
	{IDCLS_SET_VIDEO_FILTER,"IDCLS_SET_VIDEO_FILTER"},
	{IDCLS_USE_INTERNAL_CALC_PALETTE,"IDCLS_USE_INTERNAL_CALC_PALETTE"},
	{IDCLS_USE_EXTERNAL_FILE_PALETTE,"IDCLS_USE_EXTERNAL_FILE_PALETTE"},
	{IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME,"IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME"},
	{IDCLS_P_DEVICE,"IDCLS_P_DEVICE"},
	{IDCLS_SELECT_FULLSCREEN_DEVICE,"IDCLS_SELECT_FULLSCREEN_DEVICE"},
	{IDCLS_P_MODE,"IDCLS_P_MODE"},
	{IDCLS_SELECT_FULLSCREEN_MODE,"IDCLS_SELECT_FULLSCREEN_MODE"},
	{IDCLS_SPECIFY_ACIA_RS232_DEVICE,"IDCLS_SPECIFY_ACIA_RS232_DEVICE"},
	{IDCLS_SET_DEVICE_TYPE_8,"IDCLS_SET_DEVICE_TYPE_8"},
	{IDCLS_SET_DEVICE_TYPE_9,"IDCLS_SET_DEVICE_TYPE_9"},
	{IDCLS_SET_DEVICE_TYPE_10,"IDCLS_SET_DEVICE_TYPE_10"},
	{IDCLS_SET_DEVICE_TYPE_11,"IDCLS_SET_DEVICE_TYPE_11"},
	{IDCLS_ATTACH_READ_ONLY_8,"IDCLS_ATTACH_READ_ONLY_8"},
	{IDCLS_ATTACH_READ_WRITE_8,"IDCLS_ATTACH_READ_WRITE_8"},
	{IDCLS_ATTACH_READ_ONLY_9,"IDCLS_ATTACH_READ_ONLY_9"},
	{IDCLS_ATTACH_READ_WRITE_9,"IDCLS_ATTACH_READ_WRITE_9"},
	{IDCLS_ATTACH_READ_ONLY_10,"IDCLS_ATTACH_READ_ONLY_10"},
	{IDCLS_ATTACH_READ_WRITE_10,"IDCLS_ATTACH_READ_WRITE_10"},
	{IDCLS_ATTACH_READ_ONLY_11,"IDCLS_ATTACH_READ_ONLY_11"},
	{IDCLS_ATTACH_READ_WRITE_11,"IDCLS_ATTACH_READ_WRITE_11"},
	{IDCLS_ENABLE_AUTO_DATASETTE_RESET,"IDCLS_ENABLE_AUTO_DATASETTE_RESET"},
	{IDCLS_DISABLE_AUTO_DATASETTE_RESET,"IDCLS_DISABLE_AUTO_DATASETTE_RESET"},
	{IDCLS_SET_ZERO_TAP_DELAY,"IDCLS_SET_ZERO_TAP_DELAY"},
	{IDCLS_SET_CYCLES_ADDED_GAP_TAP,"IDCLS_SET_CYCLES_ADDED_GAP_TAP"},
	{IDCLS_TRACE_MAIN_CPU,"IDCLS_TRACE_MAIN_CPU"},
	{IDCLS_DONT_TRACE_MAIN_CPU,"IDCLS_DONT_TRACE_MAIN_CPU"},
	{IDCLS_TRACE_DRIVE0_CPU,"IDCLS_TRACE_DRIVE0_CPU"},
	{IDCLS_DONT_TRACE_DRIVE0_CPU,"IDCLS_DONT_TRACE_DRIVE0_CPU"},
	{IDCLS_TRACE_DRIVE1_CPU,"IDCLS_TRACE_DRIVE1_CPU"},
	{IDCLS_DONT_TRACE_DRIVE1_CPU,"IDCLS_DONT_TRACE_DRIVE1_CPU"},
	{IDCLS_TRACE_DRIVE2_CPU,"IDCLS_TRACE_DRIVE2_CPU"},
	{IDCLS_DONT_TRACE_DRIVE2_CPU,"IDCLS_DONT_TRACE_DRIVE2_CPU"},
	{IDCLS_TRACE_DRIVE3_CPU,"IDCLS_TRACE_DRIVE3_CPU"},
	{IDCLS_DONT_TRACE_DRIVE3_CPU,"IDCLS_DONT_TRACE_DRIVE3_CPU"},
	{IDCLS_TRACE_MODE,"IDCLS_TRACE_MODE"},
	{IDCLS_PLAYBACK_RECORDED_EVENTS,"IDCLS_PLAYBACK_RECORDED_EVENTS"},
	{IDCLS_EXECUTE_MONITOR_FROM_FILE,"IDCLS_EXECUTE_MONITOR_FROM_FILE"},
	{IDCLS_SET_INITIAL_BREAKPOINT,"IDCLS_SET_INITIAL_BREAKPOINT"},
	{IDCLS_ENABLE_REMOTE_MONITOR,"IDCLS_ENABLE_REMOTE_MONITOR"},
	{IDCLS_DISABLE_REMOTE_MONITOR,"IDCLS_DISABLE_REMOTE_MONITOR"},
	{IDCLS_REMOTE_MONITOR_ADDRESS,"IDCLS_REMOTE_MONITOR_ADDRESS"},
	{IDCLS_SPECIFY_FLIP_LIST_NAME,"IDCLS_SPECIFY_FLIP_LIST_NAME"},
	{IDCLS_SHOW_COMMAND_LINE_OPTIONS,"IDCLS_SHOW_COMMAND_LINE_OPTIONS"},
	{IDCLS_CONSOLE_MODE,"IDCLS_CONSOLE_MODE"},
	{IDCLS_ALLOW_CORE_DUMPS,"IDCLS_ALLOW_CORE_DUMPS"},
	{IDCLS_DONT_ALLOW_CORE_DUMPS,"IDCLS_DONT_ALLOW_CORE_DUMPS"},
	{IDCLS_DONT_CALL_EXCEPTION_HANDLER,"IDCLS_DONT_CALL_EXCEPTION_HANDLER"},
	{IDCLS_CALL_EXCEPTION_HANDLER,"IDCLS_CALL_EXCEPTION_HANDLER"},
	{IDCLS_RESTORE_DEFAULT_SETTINGS,"IDCLS_RESTORE_DEFAULT_SETTINGS"},
	{IDCLS_P_FILE,"IDCLS_P_FILE"},
	{IDCLS_SPECIFY_CONFIG_FILE,"IDCLS_SPECIFY_CONFIG_FILE"},
	{IDCLS_ATTACH_AND_AUTOSTART,"IDCLS_ATTACH_AND_AUTOSTART"},
	{IDCLS_ATTACH_AND_AUTOLOAD,"IDCLS_ATTACH_AND_AUTOLOAD"},
	{IDCLS_ATTACH_AS_TAPE,"IDCLS_ATTACH_AS_TAPE"},
	{IDCLS_ATTACH_AS_DISK_8,"IDCLS_ATTACH_AS_DISK_8"},
	{IDCLS_ATTACH_AS_DISK_9,"IDCLS_ATTACH_AS_DISK_9"},
	{IDCLS_ATTACH_AS_DISK_10,"IDCLS_ATTACH_AS_DISK_10"},
	{IDCLS_ATTACH_AS_DISK_11,"IDCLS_ATTACH_AS_DISK_11"},
	{IDCLS_P_STRING,"IDCLS_P_STRING"},
	{IDCLS_PUT_STRING_INTO_KEYBUF,"IDCLS_PUT_STRING_INTO_KEYBUF"},
	{IDCLS_SPECIFY_LOG_FILE_NAME,"IDCLS_SPECIFY_LOG_FILE_NAME"},
	{IDCLS_ENABLE_VERBOSE_LOG_OUTPUT,"IDCLS_ENABLE_VERBOSE_LOG_OUTPUT"},
	{IDCLS_ENABLE_MOUSE_GRAB,"IDCLS_ENABLE_MOUSE_GRAB"},
	{IDCLS_DISABLE_MOUSE_GRAB,"IDCLS_DISABLE_MOUSE_GRAB"},
	{IDCLS_SELECT_MOUSE_JOY_PORT,"IDCLS_SELECT_MOUSE_JOY_PORT"},
	{IDCLS_SELECT_MOUSE_TYPE,"IDCLS_SELECT_MOUSE_TYPE"},
	{IDCLS_ENABLE_PS2MOUSE,"IDCLS_ENABLE_PS2MOUSE"},
	{IDCLS_DISABLE_PS2MOUSE,"IDCLS_DISABLE_PS2MOUSE"},
	{IDCLS_SET_FIRST_RAM_ADDRESS_VALUE,"IDCLS_SET_FIRST_RAM_ADDRESS_VALUE"},
	{IDCLS_P_NUM_OF_BYTES,"IDCLS_P_NUM_OF_BYTES"},
	{IDCLS_LENGTH_BLOCK_SAME_VALUE,"IDCLS_LENGTH_BLOCK_SAME_VALUE"},
	{IDCLS_LENGTH_BLOCK_SAME_PATTERN,"IDCLS_LENGTH_BLOCK_SAME_PATTERN"},
	{IDCLS_ENABLE_SOUND_PLAYBACK,"IDCLS_ENABLE_SOUND_PLAYBACK"},
	{IDCLS_DISABLE_SOUND_PLAYBACK,"IDCLS_DISABLE_SOUND_PLAYBACK"},
	{IDCLS_SET_SAMPLE_RATE_VALUE_HZ,"IDCLS_SET_SAMPLE_RATE_VALUE_HZ"},
	{IDCLS_SET_SOUND_BUFFER_SIZE_MSEC,"IDCLS_SET_SOUND_BUFFER_SIZE_MSEC"},
	{IDCLS_SET_SOUND_FRAGMENT_SIZE,"IDCLS_SET_SOUND_FRAGMENT_SIZE"},
	{IDCLS_SPECIFY_SOUND_DRIVER,"IDCLS_SPECIFY_SOUND_DRIVER"},
	{IDCLS_P_ARGS,"IDCLS_P_ARGS"},
	{IDCLS_SPECIFY_SOUND_DRIVER_PARAM,"IDCLS_SPECIFY_SOUND_DRIVER_PARAM"},
	{IDCLS_SPECIFY_RECORDING_SOUND_DRIVER,"IDCLS_SPECIFY_RECORDING_SOUND_DRIVER"},
	{IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM,"IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM"},
	{IDCLS_P_SYNC,"IDCLS_P_SYNC"},
	{IDCLS_SET_SOUND_SPEED_ADJUST,"IDCLS_SET_SOUND_SPEED_ADJUST"},
	{IDCLS_P_OUTPUT_MODE,"IDCLS_P_OUTPUT_MODE"},
	{IDCLS_SOUND_OUTPUT_MODE,"IDCLS_SOUND_OUTPUT_MODE"},
	{IDCLS_P_PATH,"IDCLS_P_PATH"},
	{IDCLS_DEFINE_SYSTEM_FILES_PATH,"IDCLS_DEFINE_SYSTEM_FILES_PATH"},
	{IDCLS_ENABLE_TRAPS_FAST_EMULATION,"IDCLS_ENABLE_TRAPS_FAST_EMULATION"},
	{IDCLS_DISABLE_TRAPS_FAST_EMULATION,"IDCLS_DISABLE_TRAPS_FAST_EMULATION"},
	{IDCLS_LIMIT_SPEED_TO_VALUE,"IDCLS_LIMIT_SPEED_TO_VALUE"},
	{IDCLS_UPDATE_EVERY_VALUE_FRAMES,"IDCLS_UPDATE_EVERY_VALUE_FRAMES"},
	{IDCLS_ENABLE_WARP_MODE,"IDCLS_ENABLE_WARP_MODE"},
	{IDCLS_DISABLE_WARP_MODE,"IDCLS_DISABLE_WARP_MODE"},
	{IDCLS_P_ISO_LANGUAGE_CODE,"IDCLS_P_ISO_LANGUAGE_CODE"},
	{IDCLS_SPECIFY_ISO_LANG_CODE,"IDCLS_SPECIFY_ISO_LANG_CODE"},
	{IDCLS_ENABLE_PLUS256K_EXPANSION,"IDCLS_ENABLE_PLUS256K_EXPANSION"},
	{IDCLS_DISABLE_PLUS256K_EXPANSION,"IDCLS_DISABLE_PLUS256K_EXPANSION"},
	{IDCLS_SPECIFY_PLUS256K_NAME,"IDCLS_SPECIFY_PLUS256K_NAME"},
	{IDCLS_ENABLE_PLUS60K_EXPANSION,"IDCLS_ENABLE_PLUS60K_EXPANSION"},
	{IDCLS_DISABLE_PLUS60K_EXPANSION,"IDCLS_DISABLE_PLUS60K_EXPANSION"},
	{IDCLS_SPECIFY_PLUS60K_NAME,"IDCLS_SPECIFY_PLUS60K_NAME"},
	{IDCLS_PLUS60K_BASE,"IDCLS_PLUS60K_BASE"},
	{IDCLS_ENABLE_C64_256K_EXPANSION,"IDCLS_ENABLE_C64_256K_EXPANSION"},
	{IDCLS_DISABLE_C64_256K_EXPANSION,"IDCLS_DISABLE_C64_256K_EXPANSION"},
	{IDCLS_SPECIFY_C64_256K_NAME,"IDCLS_SPECIFY_C64_256K_NAME"},
	{IDCLS_C64_256K_BASE,"IDCLS_C64_256K_BASE"},
	{IDCLS_ATTACH_RAW_STB_CART,"IDCLS_ATTACH_RAW_STB_CART"},
	{IDCLS_ATTACH_RAW_SE5_CART,"IDCLS_ATTACH_RAW_SE5_CART"},
	{IDCLS_ATTACH_RAW_SUPER_GAMES_CART,"IDCLS_ATTACH_RAW_SUPER_GAMES_CART"},
	{IDCLS_ATTACH_RAW_SILVERROCK_128_CART,"IDCLS_ATTACH_RAW_SILVERROCK_128_CART"},
	{IDCLS_ATTACH_RAW_SIMONS_BASIC_CART,"IDCLS_ATTACH_RAW_SIMONS_BASIC_CART"},
	{IDCLS_ENABLE_CS256K_EXPANSION,"IDCLS_ENABLE_CS256K_EXPANSION"},
	{IDCLS_ENABLE_H256K_EXPANSION,"IDCLS_ENABLE_H256K_EXPANSION"},
	{IDCLS_ENABLE_H1024K_EXPANSION,"IDCLS_ENABLE_H1024K_EXPANSION"},
	{IDCLS_ENABLE_H4096K_EXPANSION,"IDCLS_ENABLE_H4096K_EXPANSION"},
	{IDCLS_SPECIFY_DTV_REVISION,"IDCLS_SPECIFY_DTV_REVISION"},
	{IDCLS_ENABLE_DTV_BLITTER_LOG,"IDCLS_ENABLE_DTV_BLITTER_LOG"},
	{IDCLS_DISABLE_DTV_BLITTER_LOG,"IDCLS_DISABLE_DTV_BLITTER_LOG"},
	{IDCLS_ENABLE_DTV_DMA_LOG,"IDCLS_ENABLE_DTV_DMA_LOG"},
	{IDCLS_DISABLE_DTV_DMA_LOG,"IDCLS_DISABLE_DTV_DMA_LOG"},
	{IDCLS_SPECIFY_C64DTVROM_NAME,"IDCLS_SPECIFY_C64DTVROM_NAME"},
	{IDCLS_ENABLE_C64DTVROM_RW,"IDCLS_ENABLE_C64DTVROM_RW"},
	{IDCLS_DISABLE_C64DTVROM_RW,"IDCLS_DISABLE_C64DTVROM_RW"},
	{IDCLS_ENABLE_DTV_FLASH_LOG,"IDCLS_ENABLE_DTV_FLASH_LOG"},
	{IDCLS_DISABLE_DTV_FLASH_LOG,"IDCLS_DISABLE_DTV_FLASH_LOG"},
	{IDCLS_USE_AS_DIRECTORY_FLASH_FS,"IDCLS_USE_AS_DIRECTORY_FLASH_FS"},
	{IDCLS_ENABLE_TRUE_FLASH_FS,"IDCLS_ENABLE_TRUE_FLASH_FS"},
	{IDCLS_DISABLE_TRUE_FLASH_FS,"IDCLS_DISABLE_TRUE_FLASH_FS"},
	{IDCLS_ENABLE_MIDI_EMU,"IDCLS_ENABLE_MIDI_EMU"},
	{IDCLS_DISABLE_MIDI_EMU,"IDCLS_DISABLE_MIDI_EMU"},
	{IDCLS_SPECIFY_C64_MIDI_TYPE,"IDCLS_SPECIFY_C64_MIDI_TYPE"},
	{IDCLS_ENABLE_DIGIBLASTER,"IDCLS_ENABLE_DIGIBLASTER"},
	{IDCLS_DISABLE_DIGIBLASTER,"IDCLS_DISABLE_DIGIBLASTER"},
	{IDCLS_ENABLE_PLUS4SPEECH,"IDCLS_ENABLE_PLUS4SPEECH"},
	{IDCLS_DISABLE_PLUS4SPEECH,"IDCLS_DISABLE_PLUS4SPEECH"},
	{IDCLS_ATTACH_SPEECH_ROM_IMAGE,"IDCLS_ATTACH_SPEECH_ROM_IMAGE"},
	{IDCLS_ENABLE_SIDCARTJOY,"IDCLS_ENABLE_SIDCARTJOY"},
	{IDCLS_DISABLE_SIDCARTJOY,"IDCLS_DISABLE_SIDCARTJOY"},
	{IDCLS_ENABLE_SFX_SE,"IDCLS_ENABLE_SFX_SE"},
	{IDCLS_DISABLE_SFX_SE,"IDCLS_DISABLE_SFX_SE"},
	{IDCLS_SET_YM_CHIP_TYPE,"IDCLS_SET_YM_CHIP_TYPE"},
	{IDCLS_ENABLE_SFX_SS,"IDCLS_ENABLE_SFX_SS"},
	{IDCLS_DISABLE_SFX_SS,"IDCLS_DISABLE_SFX_SS"},
	{IDCLS_ENABLE_LIGHTPEN_EMULATION,"IDCLS_ENABLE_LIGHTPEN_EMULATION"},
	{IDCLS_DISABLE_LIGHTPEN_EMULATION,"IDCLS_DISABLE_LIGHTPEN_EMULATION"},
	{IDCLS_SET_LIGHTPEN_TYPE,"IDCLS_SET_LIGHTPEN_TYPE"},
	{IDCLS_ENABLE_EASYFLASH_JUMPER,"IDCLS_ENABLE_EASYFLASH_JUMPER"},
	{IDCLS_DISABLE_EASYFLASH_JUMPER,"IDCLS_DISABLE_EASYFLASH_JUMPER"},
	{IDCLS_ENABLE_EASYFLASH_CRT_WRITING,"IDCLS_ENABLE_EASYFLASH_CRT_WRITING"},
	{IDCLS_DISABLE_EASYFLASH_CRT_WRITING,"IDCLS_DISABLE_EASYFLASH_CRT_WRITING"},
	{IDCLS_ENABLE_DIGIMAX,"IDCLS_ENABLE_DIGIMAX"},
	{IDCLS_DISABLE_DIGIMAX,"IDCLS_DISABLE_DIGIMAX"},
	{IDCLS_DIGIMAX_BASE,"IDCLS_DIGIMAX_BASE"},
	{IDCLS_ENABLE_DS12C887RTC,"IDCLS_ENABLE_DS12C887RTC"},
	{IDCLS_DISABLE_DS12C887RTC,"IDCLS_DISABLE_DS12C887RTC"},
	{IDCLS_DS12C887RTC_BASE,"IDCLS_DS12C887RTC_BASE"},
	{IDS_VICE_ERROR,"IDS_VICE_ERROR"},
	{IDS_VICE_INFORMATION,"IDS_VICE_INFORMATION"},
	{IDS_FFMPEG_DLL_MISMATCH,"IDS_FFMPEG_DLL_MISMATCH"},
	{IDS_DIRECTDRAW_ERROR,"IDS_DIRECTDRAW_ERROR"},
	{IDS_CANNOT_SAVE_SETTINGS,"IDS_CANNOT_SAVE_SETTINGS"},
	{IDS_CANNOT_LOAD_SETTINGS,"IDS_CANNOT_LOAD_SETTINGS"},
	{IDS_DEFAULT_SETTINGS_RESTORED,"IDS_DEFAULT_SETTINGS_RESTORED"},
	{IDS_CANNOT_ATTACH_FILE,"IDS_CANNOT_ATTACH_FILE"},
	{IDS_START_MONITOR,"IDS_START_MONITOR"},
	{IDS_VICE_CPU_JAM,"IDS_VICE_CPU_JAM"},
	{IDS_EXTEND_TO_40_TRACKS,"IDS_EXTEND_TO_40_TRACKS"},
	{IDS_DETACHED_DEVICE_S,"IDS_DETACHED_DEVICE_S"},
	{IDS_ATTACHED_S_TO_DEVICE_S,"IDS_ATTACHED_S_TO_DEVICE_S"},
	{IDS_HISTORY_RECORDED_UNKNOWN,"IDS_HISTORY_RECORDED_UNKNOWN"},
	{IDS_HISTORY_RECORDED_VICE_S,"IDS_HISTORY_RECORDED_VICE_S"},
	{IDS_PAUSED,"IDS_PAUSED"},
	{IDS_FRAME_NUMBER,"IDS_FRAME_NUMBER"},
	{IDS_RESUMED,"IDS_RESUMED"},
	{IDS_TFE_PROBLEM,"IDS_TFE_PROBLEM"},
	{IDS_TFE_RRNET_SUPPORT,"IDS_TFE_RRNET_SUPPORT"},
	{IDS_CANNOT_AUTOSTART_FILE,"IDS_CANNOT_AUTOSTART_FILE"},
	{IDS_SETTINGS_SAVED_SUCCESS,"IDS_SETTINGS_SAVED_SUCCESS"},
	{IDS_SETTINGS_LOADED_SUCCESS,"IDS_SETTINGS_LOADED_SUCCESS"},
	{IDS_ATTACH_DISK_IMAGE,"IDS_ATTACH_DISK_IMAGE"},
	{IDS_INVALID_CARTRIDGE,"IDS_INVALID_CARTRIDGE"},
	{IDS_BAD_CARTRIDGE_CONFIG,"IDS_BAD_CARTRIDGE_CONFIG"},
	{IDS_INVALID_CARTRIDGE_IMAGE,"IDS_INVALID_CARTRIDGE_IMAGE"},
	{IDS_LOG_CONSOLE_OUTPUT_IMAGE,"IDS_LOG_CONSOLE_OUTPUT_IMAGE"},
	{IDS_LOG_FILES_TYPE,"IDS_LOG_FILES_TYPE"},
	{IDS_CANNOT_WRITE_LOGFILE_S,"IDS_CANNOT_WRITE_LOGFILE_S"},
	{IDS_SELECT_KEYMAP_FILE,"IDS_SELECT_KEYMAP_FILE"},
	{IDS_SAVE_KEYMAP_FILE,"IDS_SAVE_KEYMAP_FILE"},
	{IDS_CANNOT_WRITE_KEYMAP_FILE,"IDS_CANNOT_WRITE_KEYMAP_FILE"},
	{IDS_SAVE_CONFIG_FILE,"IDS_SAVE_CONFIG_FILE"},
	{IDS_LOAD_CONFIG_FILE,"IDS_LOAD_CONFIG_FILE"},
	{IDS_MAPPING,"IDS_MAPPING"},
	{IDS_KEYBOARD_SETTINGS,"IDS_KEYBOARD_SETTINGS"},
	{IDS_PLEASE_ENTER_A_FILENAME,"IDS_PLEASE_ENTER_A_FILENAME"},
	{IDS_CANNOT_CREATE_IMAGE,"IDS_CANNOT_CREATE_IMAGE"},
	{IDS_COMMAND_LINE_OPTIONS,"IDS_COMMAND_LINE_OPTIONS"},
	{IDS_COMMAND_OPTIONS_AVAIL,"IDS_COMMAND_OPTIONS_AVAIL"},
	{IDS_NO_DRIVER_SELECT_SUPPORT,"IDS_NO_DRIVER_SELECT_SUPPORT"},
	{IDS_CANT_WRITE_SCREENSHOT_S,"IDS_CANT_WRITE_SCREENSHOT_S"},
	{IDS_AUTOSTART_DISK_IMAGE,"IDS_AUTOSTART_DISK_IMAGE"},
	{IDS_SELECT_FS_DIRECTORY,"IDS_SELECT_FS_DIRECTORY"},
	{IDS_PRINTER_USERPORT,"IDS_PRINTER_USERPORT"},
	{IDS_PRINTER_4,"IDS_PRINTER_4"},
	{IDS_PRINTER_5,"IDS_PRINTER_5"},
	{IDS_DRIVE_8,"IDS_DRIVE_8"},
	{IDS_DRIVE_9,"IDS_DRIVE_9"},
	{IDS_DRIVE_10,"IDS_DRIVE_10"},
	{IDS_DRIVE_11,"IDS_DRIVE_11"},
	{IDS_PERIPHERAL_SETTINGS,"IDS_PERIPHERAL_SETTINGS"},
	{IDS_CANT_WRITE_SNAPSHOT_FILE,"IDS_CANT_WRITE_SNAPSHOT_FILE"},
	{IDS_LOAD_S_ROM_IMAGE,"IDS_LOAD_S_ROM_IMAGE"},
	{IDS_SELECT_ROMSET_ARCHIVE,"IDS_SELECT_ROMSET_ARCHIVE"},
	{IDS_CANNOT_LOAD_ROMSET_ARCH,"IDS_CANNOT_LOAD_ROMSET_ARCH"},
	{IDS_CANNOT_SAVE_ROMSET_ARCH,"IDS_CANNOT_SAVE_ROMSET_ARCH"},
	{IDS_CANNOT_LOAD_ROMSET_FILE,"IDS_CANNOT_LOAD_ROMSET_FILE"},
	{IDS_CANNOT_SAVE_ROMSET_FILE,"IDS_CANNOT_SAVE_ROMSET_FILE"},
	{IDS_SELECT_ROMSET_FILE,"IDS_SELECT_ROMSET_FILE"},
	{IDS_ROMSET,"IDS_ROMSET"},
	{IDS_COMPUTER,"IDS_COMPUTER"},
	{IDS_DRIVE,"IDS_DRIVE"},
	{IDS_ROM_SETTINGS,"IDS_ROM_SETTINGS"},
	{IDS_COULD_NOT_LOAD_PALETTE,"IDS_COULD_NOT_LOAD_PALETTE"},
	{IDS_LOAD_VICE_PALETTE_FILE,"IDS_LOAD_VICE_PALETTE_FILE"},
	{IDS_FULLSCREEN,"IDS_FULLSCREEN"},
	{IDS_FILE_SYSTEM,"IDS_FILE_SYSTEM"},
	{IDS_REAL_IEC_DEVICE,"IDS_REAL_IEC_DEVICE"},
	{IDS_RS232_DEVICE_I,"IDS_RS232_DEVICE_I"},
	{IDS_ATTACH_CRT_CART_IMAGE,"IDS_ATTACH_CRT_CART_IMAGE"},
	{IDS_ATTACH_RAW_8KB_CART_IMAGE,"IDS_ATTACH_RAW_8KB_CART_IMAGE"},
	{IDS_ATTACH_RAW_16KB_CART_IMG,"IDS_ATTACH_RAW_16KB_CART_IMG"},
	{IDS_ATTACH_AR_CART_IMAGE,"IDS_ATTACH_AR_CART_IMAGE"},
	{IDS_ATTACH_AR3_CART_IMAGE,"IDS_ATTACH_AR3_CART_IMAGE"},
	{IDS_ATTACH_AR4_CART_IMAGE,"IDS_ATTACH_AR4_CART_IMAGE"},
	{IDS_ATTACH_STARDOS_CART_IMAGE,"IDS_ATTACH_STARDOS_CART_IMAGE"},
	{IDS_ATTACH_ATOMIC_P_CART_IMG,"IDS_ATTACH_ATOMIC_P_CART_IMG"},
	{IDS_ATTACH_EPYX_FL_CART_IMG,"IDS_ATTACH_EPYX_FL_CART_IMG"},
	{IDS_ATTACH_IEEE488_CART_IMG,"IDS_ATTACH_IEEE488_CART_IMG"},
	{IDS_ATTACH_RETRO_R_CART_IMG,"IDS_ATTACH_RETRO_R_CART_IMG"},
	{IDS_ATTACH_MMC_REPLAY_CART_IMG,"IDS_ATTACH_MMC_REPLAY_CART_IMG"},
	{IDS_ATTACH_IDE64_CART_IMAGE,"IDS_ATTACH_IDE64_CART_IMAGE"},
	{IDS_ATTACH_SS4_CART_IMAGE,"IDS_ATTACH_SS4_CART_IMAGE"},
	{IDS_ATTACH_SS5_CART_IMAGE,"IDS_ATTACH_SS5_CART_IMAGE"},
	{IDS_ATTACH_STB_CART_IMAGE,"IDS_ATTACH_STB_CART_IMAGE"},
	{IDS_MODEL,"IDS_MODEL"},
	{IDS_SELECT_START_SNAP_EVENT,"IDS_SELECT_START_SNAP_EVENT"},
	{IDS_SELECT_END_SNAP_EVENT,"IDS_SELECT_END_SNAP_EVENT"},
	{IDS_VERSION_S_UNSTABLE,"IDS_VERSION_S_UNSTABLE"},
	{IDS_VERSION_S,"IDS_VERSION_S"},
	{IDS_VICE_CONTRIBUTORS,"IDS_VICE_CONTRIBUTORS"},
	{IDS_WHO_MADE_WHAT,"IDS_WHO_MADE_WHAT"},
	{IDS_LICENSE,"IDS_LICENSE"},
	{IDS_NO_WARRANTY,"IDS_NO_WARRANTY"},
	{IDS_VICE_WITHOUT_WARRANTY,"IDS_VICE_WITHOUT_WARRANTY"},
	{IDS_PRESS_KEY_NORTHWEST,"IDS_PRESS_KEY_NORTHWEST"},
	{IDS_PRESS_KEY_NORTH,"IDS_PRESS_KEY_NORTH"},
	{IDS_PRESS_KEY_NORTHEAST,"IDS_PRESS_KEY_NORTHEAST"},
	{IDS_PRESS_KEY_EAST,"IDS_PRESS_KEY_EAST"},
	{IDS_PRESS_KEY_SOUTHEAST,"IDS_PRESS_KEY_SOUTHEAST"},
	{IDS_PRESS_KEY_SOUTH,"IDS_PRESS_KEY_SOUTH"},
	{IDS_PRESS_KEY_SOUTHWEST,"IDS_PRESS_KEY_SOUTHWEST"},
	{IDS_PRESS_KEY_WEST,"IDS_PRESS_KEY_WEST"},
	{IDS_PRESS_KEY_FIRE,"IDS_PRESS_KEY_FIRE"},
	{IDS_NO_USERPORT_ADAPTER,"IDS_NO_USERPORT_ADAPTER"},
	{IDS_CGA_USERPORT_ADAPTER,"IDS_CGA_USERPORT_ADAPTER"},
	{IDS_PET_USERPORT_ADAPTER,"IDS_PET_USERPORT_ADAPTER"},
	{IDS_HUMMER_USERPORT_ADAPTER,"IDS_HUMMER_USERPORT_ADAPTER"},
	{IDS_OEM_USERPORT_ADAPTER,"IDS_OEM_USERPORT_ADAPTER"},
	{IDS_HIT_USERPORT_ADAPTER,"IDS_HIT_USERPORT_ADAPTER"},
	{IDS_KINGSOFT_USERPORT_ADAPTER,"IDS_KINGSOFT_USERPORT_ADAPTER"},
	{IDS_STARBYTE_USERPORT_ADAPTER,"IDS_STARBYTE_USERPORT_ADAPTER"},
	{IDS_NO_SIDCART_JOY,"IDS_NO_SIDCART_JOY"},
	{IDS_NUMPAD_AND_RCTRL,"IDS_NUMPAD_AND_RCTRL"},
	{IDS_KEYSET_A,"IDS_KEYSET_A"},
	{IDS_KEYSET_B,"IDS_KEYSET_B"},
	{IDS_ALL_BUTTONS_AS_FIRE,"IDS_ALL_BUTTONS_AS_FIRE"},
	{IDS_NUMERIC_SEE_ABOVE,"IDS_NUMERIC_SEE_ABOVE"},
	{IDS_NO_BUTTON_NO_AUTOFIRE,"IDS_NO_BUTTON_NO_AUTOFIRE"},
	{IDS_ALL_FILES_FILTER,"IDS_ALL_FILES_FILTER"},
	{IDS_PALETTE_FILES_FILTER,"IDS_PALETTE_FILES_FILTER"},
	{IDS_SNAPSHOT_FILES_FILTER,"IDS_SNAPSHOT_FILES_FILTER"},
	{IDS_CBM_IMAGE_FILES_FILTER,"IDS_CBM_IMAGE_FILES_FILTER"},
	{IDS_IDE64_IMAGE_FILES_FILTER,"IDS_IDE64_IMAGE_FILES_FILTER"},
	{IDS_DISK_IMAGE_FILES_FILTER,"IDS_DISK_IMAGE_FILES_FILTER"},
	{IDS_TAPE_IMAGE_FILES_FILTER,"IDS_TAPE_IMAGE_FILES_FILTER"},
	{IDS_ZIPPED_FILES_FILTER,"IDS_ZIPPED_FILES_FILTER"},
	{IDS_CRT_FILES_FILTER,"IDS_CRT_FILES_FILTER"},
	{IDS_RAW_CART_FILES_FILTER,"IDS_RAW_CART_FILES_FILTER"},
	{IDS_FLIP_LIST_FILES_FILTER,"IDS_FLIP_LIST_FILES_FILTER"},
	{IDS_ROMSET_FILES_FILTER,"IDS_ROMSET_FILES_FILTER"},
	{IDS_ROMSET_ARCHIVES_FILTER,"IDS_ROMSET_ARCHIVES_FILTER"},
	{IDS_KEYMAP_FILES_FILTER,"IDS_KEYMAP_FILES_FILTER"},
	{IDS_PRGP00_FILES_FILTER,"IDS_PRGP00_FILES_FILTER"},
	{IDS_SOUND_DRIVER_DIRECTX,"IDS_SOUND_DRIVER_DIRECTX"},
	{IDS_SOUND_DRIVER_WMM,"IDS_SOUND_DRIVER_WMM"},
	{IDS_MEDIA_FILES_FILTER,"IDS_MEDIA_FILES_FILTER"},
	{IDS_SPACE_KB,"IDS_SPACE_KB"},
	{IDS_CONFIGURE_KEYSET_A,"IDS_CONFIGURE_KEYSET_A"},
	{IDS_CONFIGURE_KEYSET_B,"IDS_CONFIGURE_KEYSET_B"},
	{IDS_SAVE_MEDIA_IMAGE,"IDS_SAVE_MEDIA_IMAGE"},
	{IDS_TAPE,"IDS_TAPE"},
	{IDS_JOYSTICK_C,"IDS_JOYSTICK_C"},
	{IDS_RECORDING,"IDS_RECORDING"},
	{IDS_PLAYBACK,"IDS_PLAYBACK"},
	{IDS_UNKNOWN,"IDS_UNKNOWN"},
	{IDS_P_NUMBER,"IDS_P_NUMBER"},
	{IDS_NO_SAVE_SETTINGS_ON_EXIT,"IDS_NO_SAVE_SETTINGS_ON_EXIT"},
	{IDS_CONFIRM_QUIT_VICE,"IDS_CONFIRM_QUIT_VICE"},
	{IDS_NO_CONFIRM_QUIT_VICE,"IDS_NO_CONFIRM_QUIT_VICE"},
	{IDS_USE_ALL_CPU_SMP,"IDS_USE_ALL_CPU_SMP"},
	{IDS_USE_FIRST_CPU_SMP,"IDS_USE_FIRST_CPU_SMP"},
	{IDS_START_VICE_FULLSCREEN_MODE,"IDS_START_VICE_FULLSCREEN_MODE"},
	{IDS_DISABLE_DX9,"IDS_DISABLE_DX9"},
	{IDS_RECEIVED_SIGNAL_D_S,"IDS_RECEIVED_SIGNAL_D_S"},
	{IDS_RECEIVED_SIGNAL_D,"IDS_RECEIVED_SIGNAL_D"},
	{IDS_INVALID_PORT_NUMBER,"IDS_INVALID_PORT_NUMBER"},
	{IDS_ERROR_STARTING_SERVER,"IDS_ERROR_STARTING_SERVER"},
	{IDS_ERROR_CONNECTING_CLIENT,"IDS_ERROR_CONNECTING_CLIENT"},
	{IDS_OK,"IDS_OK"},
	{IDS_SPECIFY_MIDI_IN,"IDS_SPECIFY_MIDI_IN"},
	{IDS_SPECIFY_MIDI_OUT,"IDS_SPECIFY_MIDI_OUT"},
	{IDS_NO_EASYFLASH_CART_INSERTED,"IDS_NO_EASYFLASH_CART_INSERTED"},
	{IDS_DATASETTE_CAPTION,"IDS_DATASETTE_CAPTION"},
	{IDS_DATASETTE_RESET_WITH_CPU,"IDS_DATASETTE_RESET_WITH_CPU"},
	{IDS_DATASETTE_MOTOR_GROUP,"IDS_DATASETTE_MOTOR_GROUP"},
	{IDS_DATASETTE_DELAY_TRIGGER,"IDS_DATASETTE_DELAY_TRIGGER"},
	{IDS_DATASETTE_DELAY_AT_ZERO,"IDS_DATASETTE_DELAY_AT_ZERO"},
	{IDS_TOGGLE_USEIECDEVICE,"IDS_TOGGLE_USEIECDEVICE"},
	{IDS_SELECTDISK,"IDS_SELECTDISK"},
	{IDS_SELECTDIR,"IDS_SELECTDIR"},
	{IDS_SELECTREAL,"IDS_SELECTREAL"},
	{IDS_SELECTNONE,"IDS_SELECTNONE"},
	{IDS_AUTOSTART,"IDS_AUTOSTART"},
	{IDS_BROWSEDIR,"IDS_BROWSEDIR"},
	{IDS_TOGGLE_ATTACH_READONLY,"IDS_TOGGLE_ATTACH_READONLY"},
	{IDS_TOGGLE_READP00,"IDS_TOGGLE_READP00"},
	{IDS_TOGGLE_WRITEP00,"IDS_TOGGLE_WRITEP00"},
	{IDS_TOGGLE_HIDENONP00,"IDS_TOGGLE_HIDENONP00"},
	{IDS_JOYSTICK_CAPTION,"IDS_JOYSTICK_CAPTION"},
	{IDS_SELECT_FIRE_BUTTON,"IDS_SELECT_FIRE_BUTTON"},
	{IDS_AUTO_FIRE_BUTTON_SETTINGS,"IDS_AUTO_FIRE_BUTTON_SETTINGS"},
	{IDS_AUTOFIRE_SPEED,"IDS_AUTOFIRE_SPEED"},
	{IDS_JOY_CONFIG_A,"IDS_JOY_CONFIG_A"},
	{IDS_JOY_CONFIG_B,"IDS_JOY_CONFIG_B"},
	{IDS_JOY_CALIBRATE,"IDS_JOY_CALIBRATE"},
	{IDS_EXTRA_JOYSTICK_CAPTION,"IDS_EXTRA_JOYSTICK_CAPTION"},
	{IDS_JOYSTICK_IN_EXTRA_PORT_1,"IDS_JOYSTICK_IN_EXTRA_PORT_1"},
	{IDS_JOYSTICK_IN_EXTRA_PORT_2,"IDS_JOYSTICK_IN_EXTRA_PORT_2"},
	{IDS_KEYSET_SW,"IDS_KEYSET_SW"},
	{IDS_KEYSET_S,"IDS_KEYSET_S"},
	{IDS_KEYSET_SE,"IDS_KEYSET_SE"},
	{IDS_KEYSET_W,"IDS_KEYSET_W"},
	{IDS_KEYSET_E,"IDS_KEYSET_E"},
	{IDS_KEYSET_NW,"IDS_KEYSET_NW"},
	{IDS_KEYSET_N,"IDS_KEYSET_N"},
	{IDS_KEYSET_NE,"IDS_KEYSET_NE"},
	{IDS_KEYSET_FIRE,"IDS_KEYSET_FIRE"},
	{IDS_SOUND_CAPTION,"IDS_SOUND_CAPTION"},
	{IDS_SOUND_DIRECTX,"IDS_SOUND_DIRECTX"},
	{IDS_SOUND_WMM,"IDS_SOUND_WMM"},
	{IDS_SOUND_SAMPLE_FREQUENCY,"IDS_SOUND_SAMPLE_FREQUENCY"},
	{IDS_SOUND_BUFFER_SIZE,"IDS_SOUND_BUFFER_SIZE"},
	{IDS_SOUND_FRAGMENT_SIZE_LABEL,"IDS_SOUND_FRAGMENT_SIZE_LABEL"},
	{IDS_SOUND_FRAGMENT_SIZE_SMALL,"IDS_SOUND_FRAGMENT_SIZE_SMALL"},
	{IDS_SOUND_FRAGMENT_SIZE_MEDIUM,"IDS_SOUND_FRAGMENT_SIZE_MEDIUM"},
	{IDS_SOUND_FRAGMENT_SIZE_LARGE,"IDS_SOUND_FRAGMENT_SIZE_LARGE"},
	{IDS_SOUND_SYNCH_METHOD,"IDS_SOUND_SYNCH_METHOD"},
	{IDS_TOGGLE_SNAPSHOT_SAVE_DISKS,"IDS_TOGGLE_SNAPSHOT_SAVE_DISKS"},
	{IDS_TOGGLE_SNAPSHOT_SAVE_ROMS,"IDS_TOGGLE_SNAPSHOT_SAVE_ROMS"},
	{IDS_FULLSCREEN_DRIVER,"IDS_FULLSCREEN_DRIVER"},
	{IDS_FULLSCREEN_DRVR_BITDEPTH,"IDS_FULLSCREEN_DRVR_BITDEPTH"},
	{IDS_FULLSCREEN_DRVR_RESOLUTION,"IDS_FULLSCREEN_DRVR_RESOLUTION"},
	{IDS_FULLSCREEN_DRVR_REFRESHRATE,"IDS_FULLSCREEN_DRVR_REFRESHRATE"},
	{IDS_TOGGLE_VIDEO_VBLANK_SYNC,"IDS_TOGGLE_VIDEO_VBLANK_SYNC"},
	{IDS_TOGGLE_VIDEO_DX_PRIMARY,"IDS_TOGGLE_VIDEO_DX_PRIMARY"},
	{IDS_TOGGLE_KEEP_ASPECT_RATIO,"IDS_TOGGLE_KEEP_ASPECT_RATIO"},
	{IDS_TOGGLE_TRUE_ASPECT_RATIO,"IDS_TOGGLE_TRUE_ASPECT_RATIO"},
	{IDS_VAL_F_FOR_S_OUT_RANGE_USE_F,"IDS_VAL_F_FOR_S_OUT_RANGE_USE_F"},
	{IDS_VAL_D_FOR_S_OUT_RANGE_USE_D,"IDS_VAL_D_FOR_S_OUT_RANGE_USE_D"},
	{IDS_AUDIO_LEAK,"IDS_AUDIO_LEAK"},
	{IDS_COLORS_GAMMA,"IDS_COLORS_GAMMA"},
	{IDS_COLORS_TINT,"IDS_COLORS_TINT"},
	{IDS_COLORS_SATURATION,"IDS_COLORS_SATURATION"},
	{IDS_COLORS_CONTRAST,"IDS_COLORS_CONTRAST"},
	{IDS_COLORS_BRIGHTNESS,"IDS_COLORS_BRIGHTNESS"},
	{IDS_CRT_SCANLINE_SHADE,"IDS_CRT_SCANLINE_SHADE"},
	{IDS_CRT_BLUR,"IDS_CRT_BLUR"},
	{IDS_CRT_ODDLINE_PHASE,"IDS_CRT_ODDLINE_PHASE"},
	{IDS_CRT_ODDLINE_OFFSET,"IDS_CRT_ODDLINE_OFFSET"},
	{IDS_VICII_PALETTE,"IDS_VICII_PALETTE"},
	{IDS_VIC_PALETTE,"IDS_VIC_PALETTE"},
	{IDS_CRTC_PALETTE,"IDS_CRTC_PALETTE"},
	{IDS_VDC_PALETTE,"IDS_VDC_PALETTE"},
	{IDS_TED_PALETTE,"IDS_TED_PALETTE"},
	{IDS_VICII_COLORS,"IDS_VICII_COLORS"},
	{IDS_VIC_COLORS,"IDS_VIC_COLORS"},
	{IDS_CRTC_COLORS,"IDS_CRTC_COLORS"},
	{IDS_VDC_COLORS,"IDS_VDC_COLORS"},
	{IDS_TED_COLORS,"IDS_TED_COLORS"},
	{IDS_VICII_CRT_EMULATION,"IDS_VICII_CRT_EMULATION"},
	{IDS_VIC_CRT_EMULATION,"IDS_VIC_CRT_EMULATION"},
	{IDS_CRTC_CRT_EMULATION,"IDS_CRTC_CRT_EMULATION"},
	{IDS_VDC_CRT_EMULATION,"IDS_VDC_CRT_EMULATION"},
	{IDS_TED_CRT_EMULATION,"IDS_TED_CRT_EMULATION"},
	{IDS_VICII_RENDER_FILTER,"IDS_VICII_RENDER_FILTER"},
	{IDS_VIC_RENDER_FILTER,"IDS_VIC_RENDER_FILTER"},
	{IDS_CRTC_RENDER_FILTER,"IDS_CRTC_RENDER_FILTER"},
	{IDS_VDC_RENDER_FILTER,"IDS_VDC_RENDER_FILTER"},
	{IDS_TED_RENDER_FILTER,"IDS_TED_RENDER_FILTER"},
	{IDS_VICII_AUDIO_LEAK,"IDS_VICII_AUDIO_LEAK"},
	{IDS_VIC_AUDIO_LEAK,"IDS_VIC_AUDIO_LEAK"},
	{IDS_CRTC_AUDIO_LEAK,"IDS_CRTC_AUDIO_LEAK"},
	{IDS_VDC_AUDIO_LEAK,"IDS_VDC_AUDIO_LEAK"},
	{IDS_TED_AUDIO_LEAK,"IDS_TED_AUDIO_LEAK"},
	{IDS_TOGGLE_VIDEO_EXTPALETTE,"IDS_TOGGLE_VIDEO_EXTPALETTE"},
	{IDS_RAM_CAPTION,"IDS_RAM_CAPTION"},
	{IDS_RAM_INIT_AT_POWERUP,"IDS_RAM_INIT_AT_POWERUP"},
	{IDS_RAM_VALUE_FIRST_BYTE,"IDS_RAM_VALUE_FIRST_BYTE"},
	{IDS_RAM_LENGTH_CONSTANT_VALUES,"IDS_RAM_LENGTH_CONSTANT_VALUES"},
	{IDS_RAM_LENGTH_CONSTANT_PATTERN,"IDS_RAM_LENGTH_CONSTANT_PATTERN"},
	{IDS_PRINTER_EMULATION,"IDS_PRINTER_EMULATION"},
	{IDS_PRINTER_FORMFEED,"IDS_PRINTER_FORMFEED"},
	{IDS_FILESYSTEM_PRINTER,"IDS_FILESYSTEM_PRINTER"},
	{IDS_PRINTER_DRVR,"IDS_PRINTER_DRVR"},
	{IDS_OUTPUT,"IDS_OUTPUT"},
	{IDS_OUTPUT_TO_FILE,"IDS_OUTPUT_TO_FILE"},
	{IDS_OUTPUT_FILE1_NAME,"IDS_OUTPUT_FILE1_NAME"},
	{IDS_OUTPUT_FILE2_NAME,"IDS_OUTPUT_FILE2_NAME"},
	{IDS_OUTPUT_FILE3_NAME,"IDS_OUTPUT_FILE3_NAME"},
	{IDS_ROMSET_SELECT_ARCHIVE,"IDS_ROMSET_SELECT_ARCHIVE"},
	{IDS_ROMSET_ARCHIVE_LOAD,"IDS_ROMSET_ARCHIVE_LOAD"},
	{IDS_ROMSET_ARCHIVE_SAVE,"IDS_ROMSET_ARCHIVE_SAVE"},
	{IDS_ROMSET_CONFIGURATION,"IDS_ROMSET_CONFIGURATION"},
	{IDS_ROMSET_ARCHIVE_APPLY,"IDS_ROMSET_ARCHIVE_APPLY"},
	{IDS_ROMSET_ARCHIVE_NEW,"IDS_ROMSET_ARCHIVE_NEW"},
	{IDS_ROMSET_ARCHIVE_DELETE,"IDS_ROMSET_ARCHIVE_DELETE"},
	{IDS_ROMSET_SELECT_FILE,"IDS_ROMSET_SELECT_FILE"},
	{IDS_ROMSET_FILE_LOAD,"IDS_ROMSET_FILE_LOAD"},
	{IDS_ROMSET_FILE_SAVE,"IDS_ROMSET_FILE_SAVE"},
	{IDS_CUSTOM_SPEED_CAPTION,"IDS_CUSTOM_SPEED_CAPTION"},
	{IDS_ENTER_CUSTOM_SPEED,"IDS_ENTER_CUSTOM_SPEED"},
	{IDS_NEW_CONFIGURATION,"IDS_NEW_CONFIGURATION"},
	{IDS_ENTER_CONFIGURATION_NAME,"IDS_ENTER_CONFIGURATION_NAME"},
	{IDS_RS232_CAPTION,"IDS_RS232_CAPTION"},
	{IDS_RS232_DEV_1,"IDS_RS232_DEV_1"},
	{IDS_RS232_DEV_2,"IDS_RS232_DEV_2"},
	{IDS_RS232_DEV_3,"IDS_RS232_DEV_3"},
	{IDS_RS232_DEV_4,"IDS_RS232_DEV_4"},
	{IDS_NETWORK_CAPTION,"IDS_NETWORK_CAPTION"},
	{IDS_NETWORK_SERVER,"IDS_NETWORK_SERVER"},
	{IDS_NETWORK_CLIENT,"IDS_NETWORK_CLIENT"},
	{IDS_NETWORK_DISCONNECT,"IDS_NETWORK_DISCONNECT"},
	{IDS_CONTROL,"IDS_CONTROL"},
	{IDS_SERVER,"IDS_SERVER"},
	{IDS_CLIENT,"IDS_CLIENT"},
	{IDS_JOYSTICK_1,"IDS_JOYSTICK_1"},
	{IDS_JOYSTICK_2,"IDS_JOYSTICK_2"},
	{IDS_DEVICES,"IDS_DEVICES"},
	{IDS_SETTINGS,"IDS_SETTINGS"},
	{IDS_TOGGLE_CONSOLE_APPEND,"IDS_TOGGLE_CONSOLE_APPEND"},
	{IDS_ID,"IDS_ID"},
	{IDS_TYPE,"IDS_TYPE"},
	{IDS_BLANK_IMAGE,"IDS_BLANK_IMAGE"},
	{IDS_SELECT_DRIVER,"IDS_SELECT_DRIVER"},
	{IDS_FFMPEG_SETTINGS,"IDS_FFMPEG_SETTINGS"},
	{IDS_FORMAT,"IDS_FORMAT"},
	{IDS_AUDIO_CODEC,"IDS_AUDIO_CODEC"},
	{IDS_BITRATE,"IDS_BITRATE"},
	{IDS_VIDEO_CODEC,"IDS_VIDEO_CODEC"},
	{IDS_SOUND_RECORD_CAPTION,"IDS_SOUND_RECORD_CAPTION"},
	{IDS_SOUND_RECORD_FORMAT_LABEL,"IDS_SOUND_RECORD_FORMAT_LABEL"},
	{IDS_SOUND_RECORD_FILE_LABEL,"IDS_SOUND_RECORD_FILE_LABEL"},
	{IDS_KERNAL,"IDS_KERNAL"},
	{IDS_BASIC,"IDS_BASIC"},
	{IDS_CHARACTER,"IDS_CHARACTER"},
	{IDS_COMPUTER_RESOURCES_CAPTION,"IDS_COMPUTER_RESOURCES_CAPTION"},
	{IDS_COMPUTER_RESOURCES,"IDS_COMPUTER_RESOURCES"},
	{IDS_DRIVE_RESOURCES_CAPTION,"IDS_DRIVE_RESOURCES_CAPTION"},
	{IDS_DRIVE_RESOURCES,"IDS_DRIVE_RESOURCES"},
	{IDS_SYMBOLIC,"IDS_SYMBOLIC"},
	{IDS_POSITIONAL,"IDS_POSITIONAL"},
	{IDS_DUMP_KEYSET,"IDS_DUMP_KEYSET"},
	{IDS_DUMP_SHORTCUTS,"IDS_DUMP_SHORTCUTS"},
	{IDS_SYMBOLIC_US,"IDS_SYMBOLIC_US"},
	{IDS_SYMBOLIC_DE,"IDS_SYMBOLIC_DE"},
	{IDS_GR_SYM,"IDS_GR_SYM"},
	{IDS_GR_POS,"IDS_GR_POS"},
	{IDS_UK_SYM,"IDS_UK_SYM"},
	{IDS_UK_POS,"IDS_UK_POS"},
	{IDS_DE_SYM,"IDS_DE_SYM"},
	{IDS_DE_POS,"IDS_DE_POS"},
	{IDS_SELECT_DRIVE_EXTEND_NEVER,"IDS_SELECT_DRIVE_EXTEND_NEVER"},
	{IDS_SELECT_DRIVE_EXTEND_ASK,"IDS_SELECT_DRIVE_EXTEND_ASK"},
	{IDS_SELECT_DRIVE_EXTEND_ACCESS,"IDS_SELECT_DRIVE_EXTEND_ACCESS"},
	{IDS_SELECT_DRIVE_IDLE_TRAP_IDLE,"IDS_SELECT_DRIVE_IDLE_TRAP_IDLE"},
	{IDS_SELECT_DRIVE_IDLE_SKIP_CYC,"IDS_SELECT_DRIVE_IDLE_SKIP_CYC"},
	{IDS_TOGGLE_DRIVE_PARALLEL_CABLE,"IDS_TOGGLE_DRIVE_PARALLEL_CABLE"},
	{IDS_TOGGLE_DRIVE_EXPANSION_2000,"IDS_TOGGLE_DRIVE_EXPANSION_2000"},
	{IDS_TOGGLE_DRIVE_EXPANSION_4000,"IDS_TOGGLE_DRIVE_EXPANSION_4000"},
	{IDS_TOGGLE_DRIVE_EXPANSION_6000,"IDS_TOGGLE_DRIVE_EXPANSION_6000"},
	{IDS_TOGGLE_DRIVE_EXPANSION_8000,"IDS_TOGGLE_DRIVE_EXPANSION_8000"},
	{IDS_TOGGLE_DRIVE_EXPANSION_A000,"IDS_TOGGLE_DRIVE_EXPANSION_A000"},
	{IDS_PLUS4_VIC20_MEMORY,"IDS_PLUS4_VIC20_MEMORY"},
	{IDS_SID_GENGROUP1,"IDS_SID_GENGROUP1"},
	{IDS_MP_FILE,"IDS_MP_FILE"},
	{IDS_MP_ATTACH_DISK_IMAGE,"IDS_MP_ATTACH_DISK_IMAGE"},
	{IDS_MP_DETACH_DISK_IMAGE,"IDS_MP_DETACH_DISK_IMAGE"},
	{IDS_MP_FLIP_LIST,"IDS_MP_FLIP_LIST"},
	{IDS_MP_DATASETTE_CONTROL,"IDS_MP_DATASETTE_CONTROL"},
	{IDS_MP_ATTACH_CARTRIDGE_IMAGE,"IDS_MP_ATTACH_CARTRIDGE_IMAGE"},
	{IDS_MP_RESET,"IDS_MP_RESET"},
	{IDS_MP_DEBUG,"IDS_MP_DEBUG"},
	{IDS_MP_MODE,"IDS_MP_MODE"},
	{IDS_MP_EDIT,"IDS_MP_EDIT"},
	{IDS_MP_SNAPSHOT,"IDS_MP_SNAPSHOT"},
	{IDS_MP_RECORDING_START_MODE,"IDS_MP_RECORDING_START_MODE"},
	{IDS_MP_OPTIONS,"IDS_MP_OPTIONS"},
	{IDS_MP_REFRESH_RATE,"IDS_MP_REFRESH_RATE"},
	{IDS_MP_MAXIMUM_SPEED,"IDS_MP_MAXIMUM_SPEED"},
	{IDS_MP_VIDEO_STANDARD,"IDS_MP_VIDEO_STANDARD"},
	{IDS_MP_DRIVE_SYNC_FACTOR,"IDS_MP_DRIVE_SYNC_FACTOR"},
	{IDS_MP_SETTINGS,"IDS_MP_SETTINGS"},
	{IDS_MP_CARTRIDGE_IO_SETTINGS,"IDS_MP_CARTRIDGE_IO_SETTINGS"},
	{IDS_MP_LANGUAGE,"IDS_MP_LANGUAGE"},
	{IDS_MP_HELP,"IDS_MP_HELP"},
	{IDS_MP_VIEW,"IDS_MP_VIEW"},
	{IDS_MP_WINDOW,"IDS_MP_WINDOW"},
	{IDS_MI_EXIT,"IDS_MI_EXIT"},
	{IDS_MI_ABOUT,"IDS_MI_ABOUT"},
	{IDS_MI_PAUSE,"IDS_MI_PAUSE"},
	{IDS_MI_EDIT_COPY,"IDS_MI_EDIT_COPY"},
	{IDS_MI_EDIT_PASTE,"IDS_MI_EDIT_PASTE"},
	{IDS_MI_AUTOSTART,"IDS_MI_AUTOSTART"},
	{IDS_MI_RESET_HARD,"IDS_MI_RESET_HARD"},
	{IDS_MI_RESET_SOFT,"IDS_MI_RESET_SOFT"},
	{IDS_MI_DRIVE8,"IDS_MI_DRIVE8"},
	{IDS_MI_DRIVE9,"IDS_MI_DRIVE9"},
	{IDS_MI_DRIVE10,"IDS_MI_DRIVE10"},
	{IDS_MI_DRIVE11,"IDS_MI_DRIVE11"},
	{IDS_MI_ATTACH_TAPE,"IDS_MI_ATTACH_TAPE"},
	{IDS_MI_DETACH_TAPE,"IDS_MI_DETACH_TAPE"},
	{IDS_MI_DETACH_ALL,"IDS_MI_DETACH_ALL"},
	{IDS_MI_TOGGLE_SOUND,"IDS_MI_TOGGLE_SOUND"},
	{IDS_MI_TOGGLE_DOUBLESIZE,"IDS_MI_TOGGLE_DOUBLESIZE"},
	{IDS_MI_TOGGLE_DOUBLESCAN,"IDS_MI_TOGGLE_DOUBLESCAN"},
	{IDS_MI_TOGGLE_DOUBLEVERTICAL,"IDS_MI_TOGGLE_DOUBLEVERTICAL"},
	{IDS_MI_DRIVE_TRUE_EMULATION,"IDS_MI_DRIVE_TRUE_EMULATION"},
	{IDS_MI_DRIVE_SOUND_EMULATION,"IDS_MI_DRIVE_SOUND_EMULATION"},
	{IDS_MI_AUTOSTART_HANDLE_TDE,"IDS_MI_AUTOSTART_HANDLE_TDE"},
	{IDS_MI_TOGGLE_VIDEOCACHE,"IDS_MI_TOGGLE_VIDEOCACHE"},
	{IDS_MI_DRIVE_SETTINGS,"IDS_MI_DRIVE_SETTINGS"},
	{IDS_MI_CART_SMART_ATTACH,"IDS_MI_CART_SMART_ATTACH"},
	{IDS_MI_CART_ATTACH_CRT,"IDS_MI_CART_ATTACH_CRT"},
	{IDS_MI_CART_ATTACH_8KB,"IDS_MI_CART_ATTACH_8KB"},
	{IDS_MI_CART_ATTACH_16KB,"IDS_MI_CART_ATTACH_16KB"},
	{IDS_MI_CART_ATTACH_AR,"IDS_MI_CART_ATTACH_AR"},
	{IDS_MI_CART_ATTACH_AR3,"IDS_MI_CART_ATTACH_AR3"},
	{IDS_MI_CART_ATTACH_AR4,"IDS_MI_CART_ATTACH_AR4"},
	{IDS_MI_CART_ATTACH_STARDOS,"IDS_MI_CART_ATTACH_STARDOS"},
	{IDS_MI_CART_ATTACH_AT,"IDS_MI_CART_ATTACH_AT"},
	{IDS_MI_CART_ATTACH_EPYX,"IDS_MI_CART_ATTACH_EPYX"},
	{IDS_MI_CART_ATTACH_IEEE488,"IDS_MI_CART_ATTACH_IEEE488"},
	{IDS_MI_CART_ATTACH_RR,"IDS_MI_CART_ATTACH_RR"},
	{IDS_MI_CART_ATTACH_MMC_REPLAY,"IDS_MI_CART_ATTACH_MMC_REPLAY"},
	{IDS_MI_CART_ATTACH_IDE64,"IDS_MI_CART_ATTACH_IDE64"},
	{IDS_MI_CART_ATTACH_SS4,"IDS_MI_CART_ATTACH_SS4"},
	{IDS_MI_CART_ATTACH_SS5,"IDS_MI_CART_ATTACH_SS5"},
	{IDS_MI_CART_ATTACH_STB,"IDS_MI_CART_ATTACH_STB"},
	{IDS_MI_FLIP_ADD,"IDS_MI_FLIP_ADD"},
	{IDS_MI_FLIP_REMOVE,"IDS_MI_FLIP_REMOVE"},
	{IDS_MI_FLIP_NEXT,"IDS_MI_FLIP_NEXT"},
	{IDS_MI_FLIP_PREVIOUS,"IDS_MI_FLIP_PREVIOUS"},
	{IDS_MI_FLIP_LOAD,"IDS_MI_FLIP_LOAD"},
	{IDS_MI_FLIP_SAVE,"IDS_MI_FLIP_SAVE"},
	{IDS_MI_DATASETTE_STOP,"IDS_MI_DATASETTE_STOP"},
	{IDS_MI_DATASETTE_START,"IDS_MI_DATASETTE_START"},
	{IDS_MI_DATASETTE_FORWARD,"IDS_MI_DATASETTE_FORWARD"},
	{IDS_MI_DATASETTE_REWIND,"IDS_MI_DATASETTE_REWIND"},
	{IDS_MI_DATASETTE_RECORD,"IDS_MI_DATASETTE_RECORD"},
	{IDS_MI_DATASETTE_RESET,"IDS_MI_DATASETTE_RESET"},
	{IDS_MI_DATASETTE_RESET_COUNTER,"IDS_MI_DATASETTE_RESET_COUNTER"},
	{IDS_MI_CART_SET_DEFAULT,"IDS_MI_CART_SET_DEFAULT"},
	{IDS_MI_TOGGLE_CART_RESET,"IDS_MI_TOGGLE_CART_RESET"},
	{IDS_MI_CART_DETACH,"IDS_MI_CART_DETACH"},
	{IDS_MI_CART_FREEZE,"IDS_MI_CART_FREEZE"},
	{IDS_MI_MONITOR,"IDS_MI_MONITOR"},
	{IDS_MI_DEBUG_MODE_NORMAL,"IDS_MI_DEBUG_MODE_NORMAL"},
	{IDS_MI_DEBUG_MODE_SMALL,"IDS_MI_DEBUG_MODE_SMALL"},
	{IDS_MI_DEBUG_MODE_HISTORY,"IDS_MI_DEBUG_MODE_HISTORY"},
	{IDS_MI_DEBUG_MODE_AUTOPLAY,"IDS_MI_DEBUG_MODE_AUTOPLAY"},
	{IDS_MI_TOGGLE_MAINCPU_TRACE,"IDS_MI_TOGGLE_MAINCPU_TRACE"},
	{IDS_MI_TOGGLE_DRIVE0CPU_TRACE,"IDS_MI_TOGGLE_DRIVE0CPU_TRACE"},
	{IDS_MI_TOGGLE_DRIVE1CPU_TRACE,"IDS_MI_TOGGLE_DRIVE1CPU_TRACE"},
	{IDS_MI_SNAPSHOT_LOAD,"IDS_MI_SNAPSHOT_LOAD"},
	{IDS_MI_SNAPSHOT_SAVE,"IDS_MI_SNAPSHOT_SAVE"},
	{IDS_MI_LOADQUICK,"IDS_MI_LOADQUICK"},
	{IDS_MI_SAVEQUICK,"IDS_MI_SAVEQUICK"},
	{IDS_MI_EVENT_TOGGLE_RECORD,"IDS_MI_EVENT_TOGGLE_RECORD"},
	{IDS_MI_EVENT_TOGGLE_PLAYBACK,"IDS_MI_EVENT_TOGGLE_PLAYBACK"},
	{IDS_MI_EVENT_SETMILESTONE,"IDS_MI_EVENT_SETMILESTONE"},
	{IDS_MI_EVENT_RESETMILESTONE,"IDS_MI_EVENT_RESETMILESTONE"},
	{IDS_MI_EVENT_START_MODE_SAVE,"IDS_MI_EVENT_START_MODE_SAVE"},
	{IDS_MI_EVENT_START_MODE_LOAD,"IDS_MI_EVENT_START_MODE_LOAD"},
	{IDS_MI_EVENT_START_MODE_RESET,"IDS_MI_EVENT_START_MODE_RESET"},
	{IDS_MI_EVENT_START_MODE_PLAYBCK,"IDS_MI_EVENT_START_MODE_PLAYBCK"},
	{IDS_MI_EVENT_DIRECTORY,"IDS_MI_EVENT_DIRECTORY"},
	{IDS_MI_MEDIAFILE,"IDS_MI_MEDIAFILE"},
	{IDS_MI_SOUND_RECORD_START,"IDS_MI_SOUND_RECORD_START"},
	{IDS_MI_SOUND_RECORD_STOP,"IDS_MI_SOUND_RECORD_STOP"},
	{IDS_MI_REFRESH_RATE_AUTO,"IDS_MI_REFRESH_RATE_AUTO"},
	{IDS_MI_MAXIMUM_SPEED_NO_LIMIT,"IDS_MI_MAXIMUM_SPEED_NO_LIMIT"},
	{IDS_MI_MAXIMUM_SPEED_CUSTOM,"IDS_MI_MAXIMUM_SPEED_CUSTOM"},
	{IDS_MI_TOGGLE_WARP_MODE,"IDS_MI_TOGGLE_WARP_MODE"},
	{IDS_MI_TOGGLE_ALWAYSONTOP,"IDS_MI_TOGGLE_ALWAYSONTOP"},
	{IDS_MI_TOGGLE_DX9DISABLE,"IDS_MI_TOGGLE_DX9DISABLE"},
	{IDS_MI_SWAP_JOYSTICK,"IDS_MI_SWAP_JOYSTICK"},
	{IDS_MI_SWAP_EXTRA_JOYSTICK,"IDS_MI_SWAP_EXTRA_JOYSTICK"},
	{IDS_MI_ALLOW_JOY_OPPOSITE,"IDS_MI_ALLOW_JOY_OPPOSITE"},
	{IDS_MI_JOYKEYS_TOGGLE,"IDS_MI_JOYKEYS_TOGGLE"},
	{IDS_MI_TOGGLE_VIRTUAL_DEVICES,"IDS_MI_TOGGLE_VIRTUAL_DEVICES"},
	{IDS_MI_MOUSE,"IDS_MI_MOUSE"},
	{IDS_MI_C64MODEL_SETTINGS,"IDS_MI_C64MODEL_SETTINGS"},
	{IDS_MI_AUTOSTART_SETTINGS,"IDS_MI_AUTOSTART_SETTINGS"},
	{IDS_MI_VIDEO_SETTINGS,"IDS_MI_VIDEO_SETTINGS"},
	{IDS_MI_DEVICEMANAGER,"IDS_MI_DEVICEMANAGER"},
	{IDS_MI_JOY_SETTINGS,"IDS_MI_JOY_SETTINGS"},
	{IDS_MI_USERPORT_JOY_SETTINGS,"IDS_MI_USERPORT_JOY_SETTINGS"},
	{IDS_MI_SIDCART_JOY_SETTINGS,"IDS_MI_SIDCART_JOY_SETTINGS"},
	{IDS_MI_KEYBOARD_SETTINGS,"IDS_MI_KEYBOARD_SETTINGS"},
	{IDS_MI_SOUND_SETTINGS,"IDS_MI_SOUND_SETTINGS"},
	{IDS_MI_ROM_SETTINGS,"IDS_MI_ROM_SETTINGS"},
	{IDS_MI_RAM_SETTINGS,"IDS_MI_RAM_SETTINGS"},
	{IDS_MI_DATASETTE_SETTINGS,"IDS_MI_DATASETTE_SETTINGS"},
	{IDS_MI_VICII_SETTINGS,"IDS_MI_VICII_SETTINGS"},
	{IDS_MI_MOUSE_SETTINGS,"IDS_MI_MOUSE_SETTINGS"},
	{IDS_MI_SID_SETTINGS,"IDS_MI_SID_SETTINGS"},
	{IDS_MI_RS232_SETTINGS,"IDS_MI_RS232_SETTINGS"},
	{IDS_MI_REU_SETTINGS,"IDS_MI_REU_SETTINGS"},
	{IDS_MI_GEORAM_SETTINGS,"IDS_MI_GEORAM_SETTINGS"},
	{IDS_MI_RAMCART_SETTINGS,"IDS_MI_RAMCART_SETTINGS"},
	{IDS_MI_DQBB_SETTINGS,"IDS_MI_DQBB_SETTINGS"},
	{IDS_MI_EXPERT_SETTINGS,"IDS_MI_EXPERT_SETTINGS"},
	{IDS_MI_ISEPIC_SETTINGS,"IDS_MI_ISEPIC_SETTINGS"},
	{IDS_MI_MMC64_SETTINGS,"IDS_MI_MMC64_SETTINGS"},
	{IDS_MI_MMCREPLAY_SETTINGS,"IDS_MI_MMCREPLAY_SETTINGS"},
	{IDS_MI_RR_SETTINGS,"IDS_MI_RR_SETTINGS"},
	{IDS_MI_MAGICVOICE_SETTINGS,"IDS_MI_MAGICVOICE_SETTINGS"},
	{IDS_MI_MIDI_SETTINGS,"IDS_MI_MIDI_SETTINGS"},
	{IDS_MI_DIGIMAX_SETTINGS,"IDS_MI_DIGIMAX_SETTINGS"},
	{IDS_MI_DS12C887RTC_SETTINGS,"IDS_MI_DS12C887RTC_SETTINGS"},
	{IDS_MI_LIGHTPEN_SETTINGS,"IDS_MI_LIGHTPEN_SETTINGS"},
	{IDS_MI_IDE64_SETTINGS,"IDS_MI_IDE64_SETTINGS"},
	{IDS_MI_TFE_SETTINGS,"IDS_MI_TFE_SETTINGS"},
	{IDS_MI_ACIA_SETTINGS,"IDS_MI_ACIA_SETTINGS"},
	{IDS_MI_RS232USER_SETTINGS,"IDS_MI_RS232USER_SETTINGS"},
	{IDS_MI_EASYFLASH_SETTINGS,"IDS_MI_EASYFLASH_SETTINGS"},
	{IDS_MI_SFX_SE_SETTINGS,"IDS_MI_SFX_SE_SETTINGS"},
	{IDS_MI_TOGGLE_SFX_SS,"IDS_MI_TOGGLE_SFX_SS"},
	{IDS_MI_TOGGLE_USERPORT_RTC,"IDS_MI_TOGGLE_USERPORT_RTC"},
	{IDS_MI_SETTINGS_SAVE_FILE,"IDS_MI_SETTINGS_SAVE_FILE"},
	{IDS_MI_SETTINGS_LOAD_FILE,"IDS_MI_SETTINGS_LOAD_FILE"},
	{IDS_MI_SETTINGS_SAVE,"IDS_MI_SETTINGS_SAVE"},
	{IDS_MI_SETTINGS_LOAD,"IDS_MI_SETTINGS_LOAD"},
	{IDS_MI_SETTINGS_DEFAULT,"IDS_MI_SETTINGS_DEFAULT"},
	{IDS_MI_SAVE_SETTINGS_ON_EXIT,"IDS_MI_SAVE_SETTINGS_ON_EXIT"},
	{IDS_MI_CONFIRM_ON_EXIT,"IDS_MI_CONFIRM_ON_EXIT"},
	{IDS_MI_LANG_EN,"IDS_MI_LANG_EN"},
	{IDS_MI_LANG_DA,"IDS_MI_LANG_DA"},
	{IDS_MI_LANG_DE,"IDS_MI_LANG_DE"},
	{IDS_MI_LANG_ES,"IDS_MI_LANG_ES"},
	{IDS_MI_LANG_FR,"IDS_MI_LANG_FR"},
	{IDS_MI_LANG_HU,"IDS_MI_LANG_HU"},
	{IDS_MI_LANG_IT,"IDS_MI_LANG_IT"},
	{IDS_MI_LANG_KO,"IDS_MI_LANG_KO"},
	{IDS_MI_LANG_NL,"IDS_MI_LANG_NL"},
	{IDS_MI_LANG_PL,"IDS_MI_LANG_PL"},
	{IDS_MI_LANG_RU,"IDS_MI_LANG_RU"},
	{IDS_MI_LANG_SV,"IDS_MI_LANG_SV"},
	{IDS_MI_LANG_TR,"IDS_MI_LANG_TR"},
	{IDS_MI_CMDLINE,"IDS_MI_CMDLINE"},
	{IDS_MI_CONTRIBUTORS,"IDS_MI_CONTRIBUTORS"},
	{IDS_MI_LICENSE,"IDS_MI_LICENSE"},
	{IDS_MI_WARRANTY,"IDS_MI_WARRANTY"},
	{IDS_MI_TOGGLE_FULLSCREEN,"IDS_MI_TOGGLE_FULLSCREEN"},
	{IDS_MI_SIDCART_SETTINGS,"IDS_MI_SIDCART_SETTINGS"},
	{IDS_MI_MON_OPEN,"IDS_MI_MON_OPEN"},
	{IDS_MI_MON_SAVE,"IDS_MI_MON_SAVE"},
	{IDS_MI_MON_PRINT,"IDS_MI_MON_PRINT"},
	{IDS_MI_MON_EXIT,"IDS_MI_MON_EXIT"},
	{IDS_MI_MON_STOP_DEBUG,"IDS_MI_MON_STOP_DEBUG"},
	{IDS_MI_MON_STOP_EXEC,"IDS_MI_MON_STOP_EXEC"},
	{IDS_MI_MON_STEP_INTO,"IDS_MI_MON_STEP_INTO"},
	{IDS_MI_MON_STEP_OVER,"IDS_MI_MON_STEP_OVER"},
	{IDS_MI_MON_SKIP_RETURN,"IDS_MI_MON_SKIP_RETURN"},
	{IDS_MI_MON_GOTO_CURSOR,"IDS_MI_MON_GOTO_CURSOR"},
	{IDS_MI_MON_EVAL,"IDS_MI_MON_EVAL"},
	{IDS_MI_MON_CURRENT,"IDS_MI_MON_CURRENT"},
	{IDS_MI_MON_WND_EVAL,"IDS_MI_MON_WND_EVAL"},
	{IDS_MI_MON_WND_REG,"IDS_MI_MON_WND_REG"},
	{IDS_MI_MON_WND_MEM,"IDS_MI_MON_WND_MEM"},
	{IDS_MI_MON_WND_DIS,"IDS_MI_MON_WND_DIS"},
	{IDS_MI_MON_WND_CONSOLE,"IDS_MI_MON_WND_CONSOLE"},
	{IDS_MI_MON_COMPUTER,"IDS_MI_MON_COMPUTER"},
	{IDS_MI_MON_DRIVE8,"IDS_MI_MON_DRIVE8"},
	{IDS_MI_MON_DRIVE9,"IDS_MI_MON_DRIVE9"},
	{IDS_MI_MON_CASCADE,"IDS_MI_MON_CASCADE"},
	{IDS_MI_MON_TILE_VERT,"IDS_MI_MON_TILE_VERT"},
	{IDS_MI_MON_TILE_HORIZ,"IDS_MI_MON_TILE_HORIZ"},
	{IDS_MI_MON_ARRANGE_ICONS,"IDS_MI_MON_ARRANGE_ICONS"},
	{0,NULL}
};