//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifndef VICE_TRANSLATE_H
#define VICE_TRANSLATE_H

#include "translate_funcs.h"

#define USE_PARAM_STRING 0
#define USE_PARAM_ID 1

#define USE_DESCRIPTION_STRING 0
#define USE_DESCRIPTION_ID 1

#define IDCLS_UNUSED 65536
#define IDGS_UNUSED IDCLS_UNUSED

#define IDCLS_SPECIFY_SIDCART_ENGINE_MODEL 0xffffff /* special case translation */
#define IDCLS_SPECIFY_SID_ENGINE_MODEL 0xfffffe /* special case translation */
#define IDCLS_SPECIFY_SIDDTV_ENGINE_MODEL 0xfffffd /* special case translation */
#define IDMS_FILE 65537
#define IDMS_AUTOSTART_IMAGE 65538
#define IDMS_ATTACH_DISK_IMAGE 65539
#define IDMS_DRIVE_8 65540
#define IDMS_DRIVE_9 65541
#define IDMS_DRIVE_10 65542
#define IDMS_DRIVE_11 65543
#define IDMS_DETACH_DISK_IMAGE 65544
#define IDMS_ALL 65545
#define IDMS_FLIP_LIST 65546
#define IDMS_ADD_CURRENT_IMAGE 65547
#define IDMS_REMOVE_CURRENT_IMAGE 65548
#define IDMS_ATTACH_NEXT_IMAGE 65549
#define IDMS_ATTACH_PREVIOUS_IMAGE 65550
#define IDMS_LOAD_FLIP_LIST 65551
#define IDMS_SAVE_FLIP_LIST 65552
#define IDMS_ATTACH_TAPE_IMAGE 65553
#define IDMS_DETACH_TAPE_IMAGE 65554
#define IDMS_DATASSETTE_CONTROL 65555
#define IDMS_STOP 65556
#define IDMS_START 65557
#define IDMS_FORWARD 65558
#define IDMS_REWIND 65559
#define IDMS_RECORD 65560
#define IDMS_RESET 65561
#define IDMS_ATTACH_CART_IMAGE 65562
#define IDMS_GENERIC_IMAGE 65563
#define IDMS_MEGA_CART_IMAGE 65564
#define IDMS_FINAL_EXPANSION_IMAGE 65565
#define IDMS_FP_IMAGE 65566
#define IDMS_ADD_TO_GENERIC 65567
#define IDMS_SMART_ATTACH_IMAGE 65568
#define IDMS_4_8_16KB_AT_2000 65569
#define IDMS_4_8_16KB_AT_4000 65570
#define IDMS_4_8_16KB_AT_6000 65571
#define IDMS_4_8KB_AT_A000 65572
#define IDMS_4KB_AT_B000 65573
#define IDMS_DETACH_CART_IMAGE 65574
#define IDMS_C0_LOW_IMAGE 65575
#define IDMS_C0_HIGH_IMAGE 65576
#define IDMS_C1_LOW_IMAGE 65577
#define IDMS_C1_HIGH_IMAGE 65578
#define IDMS_C2_LOW_IMAGE 65579
#define IDMS_C2_HIGH_IMAGE 65580
#define IDMS_FUNCTION_LOW_3PLUS1 65581
#define IDMS_FUNCTION_HIGH_3PLUS1 65582
#define IDMS_LOAD_CART_1XXX 65583
#define IDMS_UNLOAD_CART_1XXX 65584
#define IDMS_LOAD_CART_2_3XXX 65585
#define IDMS_UNLOAD_CART_2_3XXX 65586
#define IDMS_LOAD_CART_4_5XXX 65587
#define IDMS_UNLOAD_CART_4_5XXX 65588
#define IDMS_LOAD_CART_6_7XXX 65589
#define IDMS_UNLOAD_CART_6_7XXX 65590
#define IDMS_CRT_IMAGE 65591
#define IDMS_GENERIC_8KB_IMAGE 65592
#define IDMS_GENERIC_16KB_IMAGE 65593
#define IDMS_ACTION_REPLAY_IMAGE 65594
#define IDMS_ACTION_REPLAY3_IMAGE 65595
#define IDMS_ACTION_REPLAY4_IMAGE 65596
#define IDMS_STARDOS_IMAGE 65597
#define IDMS_ATOMIC_POWER_IMAGE 65598
#define IDMS_EPYX_FASTLOAD_IMAGE 65599
#define IDMS_IEEE488_INTERFACE_IMAGE 65600
#define IDMS_RETRO_REPLAY_IMAGE 65601
#define IDMS_IDE64_INTERFACE_IMAGE 65602
#define IDMS_SUPER_SNAPSHOT_4_IMAGE 65603
#define IDMS_SUPER_SNAPSHOT_5_IMAGE 65604
#define IDMS_STRUCTURED_BASIC_IMAGE 65605
#define IDMS_ENABLE 65606
#define IDMS_SET_CART_AS_DEFAULT 65607
#define IDMS_RESET_ON_CART_CHANGE 65608
#define IDMS_CART_FREEZE 65609
#define IDMS_PAUSE 65610
#define IDMS_MONITOR 65611
#define IDMS_HARD 65612
#define IDMS_SOFT 65613
#define IDMS_EXIT 65614
#define IDMS_EDIT 65615
#define IDMS_COPY 65616
#define IDMS_PASTE 65617
#define IDMS_SNAPSHOT 65618
#define IDMS_LOAD_SNAPSHOT_IMAGE 65619
#define IDMS_SAVE_SNAPSHOT_IMAGE 65620
#define IDMS_START_STOP_RECORDING 65621
#define IDMS_START_STOP_PLAYBACK 65622
#define IDMS_SET_MILESTONE 65623
#define IDMS_RETURN_TO_MILESTONE 65624
#define IDMS_RECORDING_START_MODE 65625
#define IDMS_SAVE_NEW_SNAPSHOT 65626
#define IDMS_LOAD_EXISTING_SNAPSHOT 65627
#define IDMS_START_WITH_RESET 65628
#define IDMS_OVERWRITE_PLAYBACK 65629
#define IDMS_SELECT_HISTORY_DIR 65630
#define IDMS_SAVE_STOP_MEDIA_FILE 65631
#define IDMS_NETPLAY 65632
#define IDMS_OPTIONS 65633
#define IDMS_REFRESH_RATE 65634
#define IDMS_AUTO 65635
#define IDMS_1_1 65636
#define IDMS_1_2 65637
#define IDMS_1_3 65638
#define IDMS_1_4 65639
#define IDMS_1_5 65640
#define IDMS_1_6 65641
#define IDMS_1_7 65642
#define IDMS_1_8 65643
#define IDMS_1_9 65644
#define IDMS_1_10 65645
#define IDMS_MAXIMUM_SPEED 65646
#define IDMS_200_PERCENT 65647
#define IDMS_100_PERCENT 65648
#define IDMS_50_PERCENT 65649
#define IDMS_20_PERCENT 65650
#define IDMS_10_PERCENT 65651
#define IDMS_NO_LIMIT 65652
#define IDMS_CUSTOM 65653
#define IDMS_WARP_MODE 65654
#define IDMS_FULLSCREEN 65655
#define IDMS_VIDEO_CACHE 65656
#define IDMS_DOUBLE_SIZE 65657
#define IDMS_DOUBLE_SCAN 65658
#define IDMS_VERTICAL_STRETCH 65659
#define IDMS_VDC_SETTINGS 65660
#define IDMS_64KB_VIDEO_MEMORY 65661
#define IDMS_VDC_REVISION 65662
#define IDMS_VDC_REV_0 65663
#define IDMS_VDC_REV_1 65664
#define IDMS_VDC_REV_2 65665
#define IDMS_SWAP_JOYSTICKS 65666
#define IDMS_SWAP_USERPORT_JOYSTICKS 65667
#define IDMS_CGA_USERPORT_JOY_ADAPTER 65668
#define IDMS_PET_USERPORT_JOY_ADAPTER 65669
#define IDMS_HUMMER_USERPORT_JOY_ADAPTER 65670
#define IDMS_OEM_USERPORT_JOY_ADAPTER 65671
#define IDMS_HIT_USERPORT_JOY_ADAPTER 65672
#define IDMS_KINGSOFT_USERPORT_JOY_ADAPTER 65673
#define IDMS_STARBYTE_USERPORT_JOY_ADAPTER 65674
#define IDMS_ENABLE_JOY_KEYS 65675
#define IDMS_OPPOSITE_JOY_DIR 65676
#define IDMS_SOUND_PLAYBACK 65677
#define IDMS_TRUE_DRIVE_EMU 65678
#define IDMS_DRIVE_SOUND 65679
#define IDMS_AUTOSTART_HANDLE_TDE 65680
#define IDMS_VIRTUAL_DEVICE_TRAPS 65681
#define IDMS_DRIVE_SYNC_FACTOR 65682
#define IDMS_PAL 65683
#define IDMS_NTSC 65684
#define IDMS_VIDEO_STANDARD 65685
#define IDMS_PAL_G 65686
#define IDMS_NTSC_M 65687
#define IDMS_OLD_NTSC_M 65688
#define IDMS_VIC_1112_IEEE_488 65689
#define IDMS_ENABLE_PADDLES 65690
#define IDMS_IEEE_488_INTERFACE 65691
#define IDMS_GRAB_MOUSE 65692
#define IDMS_PS2_MOUSE 65693
#define IDMS_SETTINGS 65694
#define IDMS_C64_MODEL_SETTINGS 65695
#define IDMS_C64_PAL 65696
#define IDMS_C64C_PAL 65697
#define IDMS_C64_OLD_PAL 65698
#define IDMS_C64_NTSC 65699
#define IDMS_C64C_NTSC 65700
#define IDMS_C64_OLD_NTSC 65701
#define IDMS_DREAN 65702
#define IDMS_CUSTOM_C64_MODEL 65703
#define IDMS_PLUS4_MODEL_SETTINGS 65704
#define IDMS_C16_PAL 65705
#define IDMS_C16_NTSC 65706
#define IDMS_PLUS4_PAL 65707
#define IDMS_PLUS4_NTSC 65708
#define IDMS_V364_NTSC 65709
#define IDMS_C232_NTSC 65710
#define IDMS_C64DTV_MODEL_SETTINGS 65711
#define IDMS_C64DTV2_PAL 65712
#define IDMS_C64DTV2_NTSC 65713
#define IDMS_C64DTV3_PAL 65714
#define IDMS_C64DTV3_NTSC 65715
#define IDMS_HUMMER_NTSC 65716
#define IDMS_C128_MODEL_SETTINGS 65717
#define IDMS_C128_PAL 65718
#define IDMS_C128DCR_PAL 65719
#define IDMS_C128_NTSC 65720
#define IDMS_C128DCR_NTSC 65721
#define IDMS_PET_MODEL_SETTINGS 65722
#define IDMS_2001 65723
#define IDMS_3008 65724
#define IDMS_3016 65725
#define IDMS_3032 65726
#define IDMS_4016 65727
#define IDMS_4032 65728
#define IDMS_8032 65729
#define IDMS_8096 65730
#define IDMS_8296 65731
#define IDMS_SUPERPET 65732
#define IDMS_CBM2_MODEL_SETTINGS 65733
#define IDMS_610_PAL 65734
#define IDMS_610_NTSC 65735
#define IDMS_620_PAL 65736
#define IDMS_620_NTSC 65737
#define IDMS_620PLUS_PAL 65738
#define IDMS_620PLUS_NTSC 65739
#define IDMS_710_NTSC 65740
#define IDMS_720_NTSC 65741
#define IDMS_720PLUS_NTSC 65742
#define IDMS_CBM5X0_MODEL_SETTINGS 65743
#define IDMS_510_PAL 65744
#define IDMS_510_NTSC 65745
#define IDMS_AUTOSTART_SETTINGS 65746
#define IDMS_VICII_VIDEO_SETTINGS 65747
#define IDMS_VIC_VIDEO_SETTINGS 65748
#define IDMS_VDC_VIDEO_SETTINGS 65749
#define IDMS_CRTC_VIDEO_SETTINGS 65750
#define IDMS_TED_VIDEO_SETTINGS 65751
#define IDMS_AUDIO_LEAK 65752
#define IDMS_PALETTE_SETTINGS 65753
#define IDMS_COLOR_SETTINGS 65754
#define IDMS_RENDER_FILTER 65755
#define IDMS_CRT_EMULATION_SETTINGS 65756
#define IDMS_VIC20_SETTINGS 65757
#define IDMS_CBM2_SETTINGS 65758
#define IDMS_CBM5X0_SETTINGS 65759
#define IDMS_PET_SETTINGS 65760
#define IDMS_PERIPHERAL_SETTINGS 65761
#define IDMS_DRIVE_SETTINGS 65762
#define IDMS_PRINTER_SETTINGS 65763
#define IDMS_DATASETTE_SETTINGS 65764
#define IDMS_PLUS4_SETTINGS 65765
#define IDMS_VICII_SETTINGS 65766
#define IDMS_VIC_SETTINGS 65767
#define IDMS_TED_SETTINGS 65768
#define IDMS_JOYSTICK_SETTINGS 65769
#define IDMS_JOYSTICK_DEVICE_SELECT 65770
#define IDMS_JOYSTICK_FIRE_SELECT 65771
#define IDMS_KEYBOARD_SETTINGS 65772
#define IDMS_MOUSE_SETTINGS 65773
#define IDMS_SOUND_SETTINGS 65774
#define IDMS_SID_SETTINGS 65775
#define IDMS_CIA_SETTINGS 65776
#define IDMS_COMPUTER_ROM_SETTINGS 65777
#define IDMS_DRIVE_ROM_SETTINGS 65778
#define IDMS_RAM_SETTINGS 65779
#define IDMS_RS232_SETTINGS 65780
#define IDMS_C128_SETTINGS 65781
#define IDMS_CART_IO_SETTINGS 65782
#define IDMS_REU_SETTINGS 65783
#define IDMS_MAGIC_VOICE_SETTINGS 65784
#define IDMS_GEORAM_SETTINGS 65785
#define IDMS_RAMCART_SETTINGS 65786
#define IDMS_DQBB_SETTINGS 65787
#define IDMS_ISEPIC_SETTINGS 65788
#define IDMS_EXPERT_SETTINGS 65789
#define IDMS_PLUS60K_SETTINGS 65790
#define IDS_PLUS256K_FILENAME 65791
#define IDMS_PLUS256K_SETTINGS 65792
#define IDMS_256K_SETTINGS 65793
#define IDMS_IDE64_SETTINGS 65794
#define IDMS_MMC64_SETTINGS 65795
#define IDMS_MMCREPLAY_SETTINGS 65796
#define IDMS_RETROREPLAY_SETTINGS 65797
#define IDMS_DIGIMAX_SETTINGS 65798
#define IDMS_DS12C887RTC_SETTINGS 65799
#define IDMS_SFX_SE_SETTINGS 65800
#define IDMS_SFX_SS_SETTINGS_MASCUERADE 65801
#define IDMS_EASYFLASH_SETTINGS 65802
#define IDMS_ENABLE_SFX_SS 65803
#define IDMS_ENABLE_USERPORT_RTC 65804
#define IDMS_BURST_MOD_SETTINGS 65805
#define IDMS_ENABLE_USERPORT_DAC 65806
#define IDMS_ETHERNET_SETTINGS 65807
#define IDMS_ACIA_SETTINGS 65808
#define IDMS_PETREU_SETTINGS 65809
#define IDMS_V364_SPEECH_SETTINGS 65810
#define IDMS_SIDCART_SETTINGS 65811
#define IDMS_PETDWW_SETTINGS 65812
#define IDMS_FINAL_EXPANSION_WRITEBACK 65813
#define IDMS_FP_WRITEBACK 65814
#define IDMS_MEGACART_WRITEBACK 65815
#define IDMS_C64DTV_SETTINGS 65816
#define IDMS_RS232_USERPORT_SETTINGS 65817
#define IDMS_SAVE_CURRENT_SETTINGS_FILE 65818
#define IDMS_LOAD_SAVED_SETTINGS_FILE 65819
#define IDMS_SAVE_CURRENT_SETTINGS 65820
#define IDMS_LOAD_SAVED_SETTINGS 65821
#define IDMS_SET_DEFAULT_SETTINGS 65822
#define IDMS_SAVE_SETTING_ON_EXIT 65823
#define IDMS_CONFIRM_ON_EXIT 65824
#define IDMS_HELP 65825
#define IDMS_ABOUT 65826
#define IDMS_COMMAND_LINE_OPTIONS 65827
#define IDMS_CONTRIBUTORS 65828
#define IDMS_LICENSE 65829
#define IDMS_NO_WARRANTY 65830
#define IDMS_LANGUAGE_INTERNATIONAL 65831
#define IDMS_LANGUAGE_ENGLISH 65832
#define IDMS_LANGUAGE_DANISH 65833
#define IDMS_LANGUAGE_GERMAN 65834
#define IDMS_LANGUAGE_SPANISH 65835
#define IDMS_LANGUAGE_FINNISH 65836
#define IDMS_LANGUAGE_FRENCH 65837
#define IDMS_LANGUAGE_HUNGARIAN 65838
#define IDMS_LANGUAGE_ITALIAN 65839
#define IDMS_LANGUAGE_KOREAN 65840
#define IDMS_LANGUAGE_DUTCH 65841
#define IDMS_LANGUAGE_POLISH 65842
#define IDMS_LANGUAGE_NORWEGIAN 65843
#define IDMS_LANGUAGE_RUSSIAN 65844
#define IDMS_LANGUAGE_SWEDISH 65845
#define IDMS_LANGUAGE_TURKISH 65846
#define IDMS_LANGUAGE 65847
#define IDMS_FULLSCREEN_STATUSBAR 65848
#define IDMS_VIDEO_OVERLAY 65849
#define IDMS_START_SOUND_RECORD 65850
#define IDMS_STOP_SOUND_RECORD 65851
#define IDMS_LOAD_PSID_FILE 65852
#define IDMS_NEXT_TUNE 65853
#define IDMS_PREVIOUS_TUNE 65854
#define IDMS_MEDIA 65855
#define IDMS_OVERRIDE_PSID_SETTINGS 65856
#define IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD 65857
#define IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD 65858
#define IDMES_SETTINGS_SAVED_SUCCESS 65859
#define IDMES_SETTINGS_LOAD_SUCCESS 65860
#define IDMES_DFLT_SETTINGS_RESTORED 65861
#define IDMES_VICE_MESSAGE 65862
#define IDMES_OK 65863
#define IDMES_VICE_CONTRIBUTORS 65864
#define IDMES_WHO_MADE_WHAT 65865
#define IDMES_VICE_DIST_NO_WARRANTY 65866
#define IDMES_WHICH_COMMANDS_AVAILABLE 65867
#define IDMES_CANNOT_SAVE_SETTINGS 65868
#define IDMES_CANNOT_LOAD_SETTINGS 65869
#define IDMES_VICE_ERROR 65870
#define IDMES_DEVICE_NOT_GAMEPAD 65871
#define IDMES_NOT_MAPPED_TO_AMIGA_PORT 65872
#define IDMES_CANNOT_AUTOSTART_FILE 65873
#define IDMES_CANNOT_ATTACH_FILE 65874
#define IDMES_INVALID_CART 65875
#define IDMES_BAD_CART_CONFIG_IN_UI 65876
#define IDMES_INVALID_CART_IMAGE 65877
#define IDMES_CANNOT_CREATE_IMAGE 65878
#define IDMES_ERROR_STARTING_SERVER 65879
#define IDMES_ERROR_CONNECTING_CLIENT 65880
#define IDMES_INVALID_PORT_NUMBER 65881
#define IDMES_THIS_MACHINE_NO_SID 65882
#define IDMES_SCREENSHOT_SAVE_S_FAILED 65883
#define IDMES_SCREENSHOT_S_SAVED 65884
#define IDS_PRESS_KEY_BUTTON 65885
#define IDS_SAVE 65886
#define IDS_BROWSE 65887
#define IDS_CURRENT_MODE 65888
#define IDS_TCP_PORT 65889
#define IDS_START_SERVER 65890
#define IDS_SERVER_BIND 65891
#define IDS_CONNECT_TO 65892
#define IDS_DISCONNECT 65893
#define IDS_IDLE 65894
#define IDS_SERVER_LISTENING 65895
#define IDS_CONNECTED_SERVER 65896
#define IDS_CONNECTED_CLIENT 65897
#define IDS_NETPLAY_SETTINGS 65898
#define IDS_SAVE_SCREENSHOT 65899
#define IDS_CANCEL 65900
#define IDS_CHOOSE_SCREENSHOT_FORMAT 65901
#define IDS_SAVE_S_SCREENSHOT 65902
#define IDS_DETACHED_DEVICE_D 65903
#define IDS_ATTACHED_S_TO_DEVICE_D 65904
#define IDS_VICE_QUESTION 65905
#define IDS_EXTEND_TO_40_TRACK 65906
#define IDS_YES_NO 65907
#define IDS_DETACHED_TAPE 65908
#define IDS_ATTACHED_TAPE_S 65909
#define IDS_SELECT_START_SNAPSHOT 65910
#define IDS_SELECT_END_SNAPSHOT 65911
#define IDS_REALLY_EXIT 65912
#define IDS_ATTACH_CRT_IMAGE 65913
#define IDS_ATTACH_RAW_8KB_IMAGE 65914
#define IDS_ATTACH_RAW_16KB_IMAGE 65915
#define IDS_ATTACH_ACTION_REPLAY_IMAGE 65916
#define IDS_ATTACH_ACTION_REPLAY3_IMAGE 65917
#define IDS_ATTACH_ACTION_REPLAY4_IMAGE 65918
#define IDS_ATTACH_STARDOS_IMAGE 65919
#define IDS_ATTACH_ATOMIC_POWER_IMAGE 65920
#define IDS_ATTACH_EPYX_FASTLOAD_IMAGE 65921
#define IDS_ATTACH_IEEE488_IMAGE 65922
#define IDS_ATTACH_RETRO_REPLAY_IMAGE 65923
#define IDS_ATTACH_IDE64_IMAGE 65924
#define IDS_ATTACH_SS4_IMAGE 65925
#define IDS_ATTACH_SS5_IMAGE 65926
#define IDS_ATTACH_SB_IMAGE 65927
#define IDS_AVAILABLE_CMDLINE_OPTIONS 65928
#define IDS_ATTACH_4_8_16KB_AT_2000 65929
#define IDS_ATTACH_4_8_16KB_AT_4000 65930
#define IDS_ATTACH_4_8_16KB_AT_6000 65931
#define IDS_ATTACH_4_8KB_AT_A000 65932
#define IDS_ATTACH_4KB_AT_B000 65933
#define IDS_S_AT_D_SPEED 65934
#define IDS_ATTACH 65935
#define IDS_PARENT 65936
#define IDS_ATTACH_READ_ONLY 65937
#define IDS_NAME 65938
#define IDS_CREATE_IMAGE 65939
#define IDS_NEW_IMAGE 65940
#define IDS_NEW_TAP_IMAGE 65941
#define IDS_OVERWRITE_EXISTING_IMAGE 65942
#define IDS_ABOUT 65943
#define IDS_IMAGE_CONTENTS 65944
#define IDMS_DISABLED 65945
#define IDS_ENABLED 65946
#define IDS_RS232_DEVICE_1 65947
#define IDS_RS232_DEVICE_2 65948
#define IDS_RS232_DEVICE_3 65949
#define IDS_RS232_DEVICE_4 65950
#define IDS_NONE 65951
#define IDS_STANDARD 65952
#define IDS_DD3 65953
#define IDS_FORMEL64 65954
#define IDS_FILESYSTEM 65955
#define IDS_RAW 65956
#define IDS_JOYSTICK 65957
#define IDS_IRQ 65958
#define IDS_NMI 65959
#define IDS_ACIA_DEVICE 65960
#define IDS_ACIA_BASE 65961
#define IDS_ACIA_INTERRUPT 65962
#define IDS_ACIA_MODE 65963
#define IDS_ACIA_SETTINGS 65964
#define IDS_256K_ENABLED 65965
#define IDS_256K_BASE 65966
#define IDS_256K_FILENAME 65967
#define IDS_256K_SETTINGS 65968
#define IDS_C64DTV_ROM_FILENAME_SELECT 65969
#define IDS_C64DTV_ROM_FILENAME 65970
#define IDS_C64DTV_REVISION 65971
#define IDS_C64DTV_WRITE_ENABLE 65972
#define IDS_C64DTV_HUMMER_ADC 65973
#define IDS_C64DTV_SETTINGS 65974
#define IDS_MODEL_LINE 65975
#define IDS_RAM_SIZE 65976
#define IDS_RAM_BLOCK_0400_0FFF 65977
#define IDS_RAM_BLOCK_0800_0FFF 65978
#define IDS_RAM_BLOCK_1000_1FFF 65979
#define IDS_RAM_BLOCK_2000_3FFF 65980
#define IDS_RAM_BLOCK_4000_5FFF 65981
#define IDS_RAM_BLOCK_6000_7FFF 65982
#define IDS_RAM_BLOCK_A000_BFFF 65983
#define IDS_RAM_BLOCK_C000_CFFF 65984
#define IDS_CBM2_SETTINGS 65985
#define IDS_CBM5X0_SETTINGS 65986
#define IDS_RESET_DATASETTE_WITH_CPU 65987
#define IDS_ADDITIONAL_DELAY 65988
#define IDS_DELAY_AT_ZERO_VALUES 65989
#define IDS_DATASETTE_SETTINGS 65990
#define IDS_NEVER_EXTEND 65991
#define IDS_ASK_ON_EXTEND 65992
#define IDS_EXTEND_ON_ACCESS 65993
#define IDS_NO_TRAPS 65994
#define IDS_SKIP_CYCLES 65995
#define IDS_TRAP_IDLE 65996
#define IDS_DRIVE_TYPE 65997
#define IDS_40_TRACK_HANDLING 65998
#define IDS_DRIVE_EXPANSION 65999
#define IDS_IDLE_METHOD 66000
#define IDS_PARALLEL_CABLE 66001
#define IDS_DRIVE_SETTINGS 66002
#define IDS_GEORAM_SIZE 66003
#define IDS_MASCUERADE_IO_SWAP 66004
#define IDS_GEORAM_FILENAME 66005
#define IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED 66006
#define IDS_GEORAM_FILENAME_SELECT 66007
#define IDS_GEORAM_SETTINGS 66008
#define IDS_EXPERT_MODE 66009
#define IDS_OFF 66010
#define IDS_PRG 66011
#define IDS_ON 66012
#define IDS_EXPERT_FILENAME 66013
#define IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED 66014
#define IDS_EXPERT_FILENAME_SELECT 66015
#define IDS_EXPERT_SETTINGS 66016
#define IDS_DQBB_FILENAME 66017
#define IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED 66018
#define IDS_DQBB_FILENAME_SELECT 66019
#define IDS_DQBB_SETTINGS 66020
#define IDS_ISEPIC_SETTINGS 66021
#define IDS_ISEPIC_SWITCH 66022
#define IDS_ISEPIC_FILENAME 66023
#define IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED 66024
#define IDS_ISEPIC_FILENAME_SELECT 66025
#define IDS_EASYFLASH_SETTINGS 66026
#define IDS_CONFIG_FILENAME_SELECT 66027
#define IDS_JOYSTICK_IN_PORT_1 66028
#define IDS_JOYSTICK_IN_PORT_2 66029
#define IDS_USERPORT_ADAPTER 66030
#define IDS_JOYSTICK_IN_USERPORT_PORT_1 66031
#define IDS_JOYSTICK_IN_USERPORT_PORT_2 66032
#define IDS_SIDCART_JOY 66033
#define IDS_JOYSTICK_IN_SIDCART_PORT 66034
#define IDS_JOYSTICK_SETTINGS 66035
#define IDS_KEYPAD 66036
#define IDS_JOY_PORT_0 66037
#define IDS_JOY_PORT_1 66038
#define IDS_JOY_PORT_2 66039
#define IDS_JOY_PORT_3 66040
#define IDS_STOP_BLUE 66041
#define IDS_SELECT_RED 66042
#define IDS_REPEAT_YELLOW 66043
#define IDS_SHUFFLE_GREEN 66044
#define IDS_FORWARD_CHARCOAL 66045
#define IDS_REVERSE_CHARCOAL 66046
#define IDS_PLAY_PAUSE_GREY 66047
#define IDS_JOY_1_DEVICE 66048
#define IDS_JOY_2_DEVICE 66049
#define IDS_USERPORT_JOY_1_DEVICE 66050
#define IDS_USERPORT_JOY_2_DEVICE 66051
#define IDS_SIDCART_JOY_DEVICE 66052
#define IDS_JOY_1_FIRE 66053
#define IDS_JOY_2_FIRE 66054
#define IDS_USERPORT_JOY_1_FIRE 66055
#define IDS_USERPORT_JOY_2_FIRE 66056
#define IDS_SIDCART_JOY_FIRE 66057
#define IDS_SET_INPUT_JOYSTICK_1 66058
#define IDS_SET_INPUT_JOYSTICK_2 66059
#define IDS_SET_INPUT_EXTRA_JOYSTICK_1 66060
#define IDS_SET_INPUT_EXTRA_JOYSTICK_2 66061
#define IDS_SET_INPUT_JOYLL_1 66062
#define IDS_SET_INPUT_JOYLL_2 66063
#define IDS_SET_INPUT_EXTRA_JOYLL_1 66064
#define IDS_SET_INPUT_EXTRA_JOYLL_2 66065
#define IDS_SAVE_SETTINGS_ON_EXIT 66066
#define IDS_NEVER_SAVE_SETTINGS_EXIT 66067
#define IDS_CONFIRM_QUITING_VICE 66068
#define IDS_NEVER_CONFIRM_QUITING_VICE 66069
#define IDS_PET_REU_SIZE 66070
#define IDS_PET_REU_FILENAME 66071
#define IDS_PET_REU_SETTINGS 66072
#define IDS_V364_SPEECH_FILENAME 66073
#define IDS_V364_SPEECH_SETTINGS 66074
#define IDS_PET_DWW_FILENAME 66075
#define IDS_PET_DWW_SETTINGS 66076
#define IDS_PLUS256K_SETTINGS 66077
#define IDS_PLUS60K_BASE 66078
#define IDS_PLUS60K_FILENAME 66079
#define IDS_PLUS60K_SETTINGS 66080
#define IDS_VALUE_FIRST_BYTE 66081
#define IDS_LENGTH_CONSTANT_VALUES 66082
#define IDS_LENGTH_CONSTANT_PATTERN 66083
#define IDS_RAM_SETTINGS 66084
#define IDS_READ_WRITE 66085
#define IDS_READ_ONLY 66086
#define IDS_RAMCART_READ_WRITE 66087
#define IDS_RAMCART_SIZE 66088
#define IDS_RAMCART_FILENAME 66089
#define IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED 66090
#define IDS_RAMCART_FILENAME_SELECT 66091
#define IDS_RAMCART_SETTINGS 66092
#define IDS_REU_SIZE 66093
#define IDS_REU_FILENAME 66094
#define IDS_SAVE_REU_IMAGE_WHEN_CHANGED 66095
#define IDS_REU_FILENAME_SELECT 66096
#define IDS_REU_SETTINGS 66097
#define IDS_BURST_MOD_SETTINGS 66098
#define IDS_PALETTE_SETTINGS 66099
#define IDS_COLOR_SETTINGS 66100
#define IDS_RENDER_FILTER_SETTINGS 66101
#define IDS_CRT_SETTINGS 66102
#define IDS_VICII_PALETTE_FILENAME 66103
#define IDS_VIC_PALETTE_FILENAME 66104
#define IDS_VDC_PALETTE_FILENAME 66105
#define IDS_CRTC_PALETTE_FILENAME 66106
#define IDS_TED_PALETTE_FILENAME 66107
#define IDS_PRINTER_OUTPUT_FILENAME_SELECT 66108
#define IDS_PRINTER_4_EMULATION 66109
#define IDS_PRINTER_5_EMULATION 66110
#define IDS_USERPORT_PRINTER_EMULATION 66111
#define IDS_PRINTER_4_DRIVER 66112
#define IDS_PRINTER_5_DRIVER 66113
#define IDS_USERPORT_PRINTER_DRIVER 66114
#define IDS_PRINTER_4_OUTPUT_TYPE 66115
#define IDS_PRINTER_5_OUTPUT_TYPE 66116
#define IDS_USERPORT_PRINTER_OUTPUT_TYPE 66117
#define IDS_PRINTER_4_OUTPUT_DEVICE 66118
#define IDS_PRINTER_5_OUTPUT_DEVICE 66119
#define IDS_USERPORT_PRINTER_OUTPUT_DEVICE 66120
#define IDS_PRINTER_4_SEND_FORMFEED 66121
#define IDS_PRINTER_5_SEND_FORMFEED 66122
#define IDS_USERPORT_PRINTER_SEND_FORMFEED 66123
#define IDS_PRINTER_DEVICE_1_FILENAME 66124
#define IDS_PRINTER_DEVICE_2_FILENAME 66125
#define IDS_PRINTER_DEVICE_3_FILENAME 66126
#define IDS_ENABLE_IEC_PRINTER_4 66127
#define IDS_ENABLE_IEC_PRINTER_5 66128
#define IDS_PRINTER_SETTINGS 66129
#define IDS_MAGIC_VOICE_FILENAME 66130
#define IDS_MAGIC_VOICE_SETTINGS 66131
#define IDS_USERPORT_RS232 66132
#define IDS_USERPORT_DEVICE 66133
#define IDS_USERPORT_BAUD_RATE 66134
#define IDS_RS232_USERPORT_SETTINGS 66135
#define IDS_FAST 66136
#define IDS_INTERPOLATING 66137
#define IDS_RESAMPLING 66138
#define IDS_FAST_RESAMPLING 66139
#define IDS_SID_STEREO 66140
#define IDS_AMOUNT_OF_EXTRA_SIDS 66141
#define IDS_STEREO_SID_AT 66142
#define IDS_TRIPLE_SID_AT 66143
#define IDS_SID_FILTERS 66144
#define IDS_SAMPLE_METHOD 66145
#define IDS_PASSBAND_0_90 66146
#define IDS_NOT_IMPLEMENTED_YET 66147
#define IDS_SID_SETTINGS 66148
#define IDS_FLEXIBLE 66149
#define IDS_ADJUSTING 66150
#define IDS_EXACT 66151
#define IDS_SAMPLE_RATE 66152
#define IDS_BUFFER_SIZE 66153
#define IDS_FRAGMENT_SIZE 66154
#define IDS_SPEED_ADJUSTMENT 66155
#define IDS_SOUND_SETTINGS 66156
#define IDS_VIC20_SETTINGS 66157
#define IDS_SPRITE_SPRITE_COL 66158
#define IDS_SPRITE_BACKGROUND_COL 66159
#define IDS_NEW_LUMINANCES 66160
#define IDS_VICII_SETTINGS 66161
#define IDS_VIC_SETTINGS 66162
#define IDS_TED_SETTINGS 66163
#define IDS_ATTACH_TAPE_IMAGE 66164
#define IDS_AUTOSTART_IMAGE 66165
#define IDS_IDE64_FILENAME 66166
#define IDS_IDE64_HD_1_SETTINGS 66167
#define IDS_IDE64_HD_2_SETTINGS 66168
#define IDS_IDE64_HD_3_SETTINGS 66169
#define IDS_IDE64_HD_4_SETTINGS 66170
#define IDS_IDE64_V4 66171
#define IDS_AUTODETECT 66172
#define IDS_CYLINDERS 66173
#define IDS_HEADS 66174
#define IDS_SECTORS 66175
#define IDS_IDE64_SETTINGS 66176
#define IDS_BIOS_REVISION 66177
#define IDS_BIOS_FLASH_JUMPER 66178
#define IDS_BANK_JUMPER 66179
#define IDS_SAVE_BIOS_WHEN_CHANGED 66180
#define IDS_BIOS_FILE 66181
#define IDS_SELECT_BIOS_FILE 66182
#define IDS_MMC64_IMAGE_READ_ONLY 66183
#define IDS_MMC64_IMAGE_FILE 66184
#define IDS_SD_TYPE 66185
#define IDS_SELECT_MMC64_IMAGE_FILE 66186
#define IDS_MMC64_SETTINGS 66187
#define IDS_SELECT_EEPROM_FILE 66188
#define IDS_SELECT_CARD_IMAGE_FILE 66189
#define IDS_CARD_FILE 66190
#define IDS_CARD_READ_WRITE 66191
#define IDS_EEPROM_FILE 66192
#define IDS_WRITE_TO_EEPROM_WHEN_CHANGED 66193
#define IDS_EEPROM_READ_WRITE 66194
#define IDS_RESCUE_MODE 66195
#define IDS_MMCREPLAY_SETTINGS 66196
#define IDS_RETROREPLAY_SETTINGS 66197
#define IDS_SELECT_GENERIC 66198
#define IDS_SELECT_FP 66199
#define IDS_SELECT_MEGACART 66200
#define IDS_SELECT_FINAL_EXPANSION 66201
#define IDS_SELECT_CARTRIDGE_IMAGE 66202
#define IDS_SID_CART 66203
#define IDS_SID_ENGINE_MODEL 66204
#define IDS_SID_ENGINE 66205
#define IDS_SID_MODEL 66206
#define IDS_SID_ADDRESS 66207
#define IDS_SID_CLOCK 66208
#define IDS_SID_DIGIBLASTER 66209
#define IDS_SIDCART_SETTINGS 66210
#define IDS_LOAD_FLIP_LIST_FILE 66211
#define IDS_CANNOT_READ_FLIP_LIST 66212
#define IDS_SAVE_FLIP_LIST_FILE 66213
#define IDS_CANNOT_WRITE_FLIP_LIST 66214
#define IDS_ATTACH_CART0_LOW 66215
#define IDS_ATTACH_CART0_HIGH 66216
#define IDS_ATTACH_CART1_LOW 66217
#define IDS_ATTACH_CART1_HIGH 66218
#define IDS_ATTACH_CART2_LOW 66219
#define IDS_ATTACH_CART2_HIGH 66220
#define IDS_ATTACH_CART 66221
#define IDS_SAVE_SNAPSHOT_IMAGE 66222
#define IDS_LOAD_SNAPSHOT_IMAGE 66223
#define IDS_SAVE_CURRENTLY_ATTACHED_DISKS 66224
#define IDS_SAVE_CURRENTLY_ATTACHED_ROMS 66225
#define IDS_CANNOT_WRITE_SNAPSHOT_S 66226
#define IDS_CANNOT_READ_SNAPSHOT_IMG 66227
#define IDS_SNAPSHOT_FILE 66228
#define IDS_SELECT_SNAPSHOT_FILE 66229
#define IDS_CRT_EMULATION 66230
#define IDS_SCALE2X 66231
#define IDS_RENDER_FILTER 66232
#define IDS_EXTERNAL_PALETTE_SELECT 66233
#define IDS_GAMMA_0_4 66234
#define IDS_SCANLINE_SHADE_0_1 66235
#define IDS_BLUR_0_1 66236
#define IDS_TINT_0_2 66237
#define IDS_ODDLINE_PHASE_0_2 66238
#define IDS_ODDLINE_OFFSET_0_2 66239
#define IDS_VICII_EXTERNAL_PALETTE 66240
#define IDS_VIC_EXTERNAL_PALETTE 66241
#define IDS_TED_EXTERNAL_PALETTE 66242
#define IDS_VDC_EXTERNAL_PALETTE 66243
#define IDS_CRTC_EXTERNAL_PALETTE 66244
#define IDS_VICII_PALETTE_NAME 66245
#define IDS_VIC_PALETTE_NAME 66246
#define IDS_TED_PALETTE_NAME 66247
#define IDS_VDC_PALETTE_NAME 66248
#define IDS_CRTC_PALETTE_NAME 66249
#define IDS_SATURATION_0_2 66250
#define IDS_CONTRAST_0_2 66251
#define IDS_BRIGHTNESS_0_2 66252
#define IDS_VIDEO_SETTINGS 66253
#define IDS_AUTO_FROM_ROM 66254
#define IDS_40_COLUMNS 66255
#define IDS_80_COLUMNS 66256
#define IDS_256_BYTE 66257
#define IDS_2_KBYTE 66258
#define IDS_GRAPHICS 66259
#define IDS_TEXT 66260
#define IDS_BUSINESS_UK 66261
#define IDS_MEMORY 66262
#define IDS_VIDEO_SIZE 66263
#define IDS_IO_SIZE 66264
#define IDS_KEYBOARD 66265
#define IDS_CRTC_CHIP 66266
#define IDS_SUPERPET_IO 66267
#define IDS_9xxx_AS_RAM 66268
#define IDS_Axxx_AS_RAM 66269
#define IDS_PET_SETTINGS 66270
#define IDS_CURRENT_MODEL 66271
#define IDS_PET_MODEL 66272
#define IDS_PLUS4_SETTINGS 66273
#define IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME 66274
#define IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME 66275
#define IDS_MACHINE_TYPE 66276
#define IDS_INTERNAL_FUNCTION_ROM 66277
#define IDS_EXTERNAL_FUNCTION_ROM 66278
#define IDS_RAM_BANKS_2_AND_3 66279
#define IDS_C128_SETTINGS 66280
#define IDS_SELECT_ROM_FILE 66281
#define IDS_COMPUTER_ROM_SETTINGS 66282
#define IDS_DRIVE_ROM_SETTINGS 66283
#define IDS_DIGIMAX_ENABLED 66284
#define IDS_DIGIMAX_BASE 66285
#define IDS_DIGIMAX_SETTINGS 66286
#define IDS_DS12C887RTC_ENABLED 66287
#define IDS_DS12C887RTC_BASE 66288
#define IDS_DS12C887RTC_SETTINGS 66289
#define IDS_SFX_SE_ENABLED 66290
#define IDS_SFX_SE_CHIP 66291
#define IDS_SFX_SS_ENABLED 66292
#define IDS_SFX_SE_SETTINGS 66293
#define IDS_SFX_SS_SETTINGS 66294
#define IDS_SOUND_RECORDING_STOPPED 66295
#define IDS_SOUND_RECORDING_STARTED 66296
#define IDS_SELECT_RECORD_FILE 66297
#define IDS_SOUND_RECORD_FORMAT 66298
#define IDS_SOUND_RECORD_FILE 66299
#define IDS_SOUND_RECORD_SETTINGS 66300
#define IDS_SMALL 66301
#define IDS_MEDIUM 66302
#define IDS_LARGE 66303
#define IDS_BORDER_MODE 66304
#define IDMS_NORMAL 66305
#define IDS_FULL 66306
#define IDS_DEBUG 66307
#define IDS_VOLUME 66308
#define IDS_SOUND_OUTPUT_MODE 66309
#define IDS_SYSTEM 66310
#define IDS_MONO 66311
#define IDS_STEREO 66312
#define IDS_MOUSE_TYPE 66313
#define IDS_MOUSE_SETTINGS 66314
#define IDS_MOUSE_PORT 66315
#define IDS_MOUSE_1351 66316
#define IDS_MOUSE_NEOS 66317
#define IDS_MOUSE_AMIGA 66318
#define IDS_MOUSE_PADDLES 66319
#define IDS_MOUSE_CX22 66320
#define IDS_MOUSE_ST 66321
#define IDS_MOUSE_SMART 66322
#define IDS_MOUSE_MICROMYS 66323
#define IDS_AUTOSTART_VIRTUAL_FS 66324
#define IDS_AUTOSTART_INJECT 66325
#define IDS_AUTOSTART_DISK 66326
#define IDS_WARP_ON_AUTOSTART 66327
#define IDS_AUTOSTART_RANDOM_DELAY 66328
#define IDS_RUN_WITH_COLON 66329
#define IDS_AUTOSTART_PRG_MODE 66330
#define IDS_AUTOSTART_LOAD_TO_BASIC_START 66331
#define IDS_AUTOSTART_DISK_IMAGE_FILENAME 66332
#define IDS_AUTOSTART_SETTINGS 66333
#define IDS_ERROR_SAVING_EASYFLASH_CRT 66334
#define IDS_EASYFLASH_JUMPER 66335
#define IDS_SAVE_EASYFLASH_CRT_ON_DETACH 66336
#define IDS_SAVE_EASYFLASH_CRT_NOW 66337
#define IDS_6569_PAL 66338
#define IDS_8565_PAL 66339
#define IDS_6569R1_OLD_PAL 66340
#define IDS_6567_NTSC 66341
#define IDS_8562_NTSC 66342
#define IDS_6567R56A_OLD_NTSC 66343
#define IDS_6572_PAL_N 66344
#define IDS_6526_OLD 66345
#define IDS_6526A_NEW 66346
#define IDS_DISCRETE 66347
#define IDS_CUSTOM_IC 66348
#define IDS_VICII_MODEL 66349
#define IDS_CIA1_MODEL 66350
#define IDS_CIA2_MODEL 66351
#define IDS_GLUE_LOGIC 66352
#define IDS_C64_MODEL_SETTINGS 66353
#define IDS_CIA_MODEL_SETTINGS 66354
#define IDS_PSID_SELECT 66355
#define IDGS_CANNOT_LOAD_SNAPSHOT_FILE 66356
#define IDGS_PLAYBACK_ERROR_DIFFERENT 66357
#define IDGS_CANNOT_CREATE_IMAGE 66358
#define IDGS_CANNOT_WRITE_IMAGE_FILE_S 66359
#define IDGS_CANNOT_FIND_MAPPED_NAME_S 66360
#define IDGS_CANT_CREATE_START_SNAP_S 66361
#define IDGS_ERROR_READING_END_SNAP_S 66362
#define IDGS_CANT_CREATE_END_SNAP_S 66363
#define IDGS_CANT_OPEN_END_SNAP_S 66364
#define IDGS_CANT_FIND_SECTION_END_SNAP 66365
#define IDGS_ERROR_READING_START_SNAP_TRIED 66366
#define IDGS_ERROR_READING_START_SNAP 66367
#define IDGS_SORRY_NO_MULTI_RECORDING 66368
#define IDGS_WRITE_TO_SOUND_DEVICE_FAILED 66369
#define IDGS_CANNOT_OPEN_SID_ENGINE 66370
#define IDGS_CANNOT_INIT_SID_ENGINE 66371
#define IDGS_INIT_FAILED_FOR_DEVICE_S 66372
#define IDGS_DEVICE_S_NOT_FOUND_SUPPORT 66373
#define IDGS_RECORD_DEVICE_S_NOT_EXIST 66374
#define IDGS_RECORD_DIFFERENT_PLAYBACK 66375
#define IDGS_WARNING_RECORDING_REALTIME 66376
#define IDGS_RECORD_NOT_SUPPORT_SOUND_PAR 66377
#define IDGS_SOUND_BUFFER_OVERFLOW_CYCLE 66378
#define IDGS_SOUND_BUFFER_OVERFLOW 66379
#define IDGS_CANNOT_FLUSH 66380
#define IDGS_FRAGMENT_PROBLEMS 66381
#define IDGS_RUNNING_TOO_SLOW 66382
#define IDGS_STORE_SOUNDDEVICE_FAILED 66383
#define IDGS_RESOURCE_S_BLOCKED_BY_S 66384
#define IDGS_TESTING_BEST_FRAME_DELAY 66385
#define IDGS_USING_D_FRAMES_DELAY 66386
#define IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER 66387
#define IDGS_SENDING_SNAPSHOT_TO_CLIENT 66388
#define IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT 66389
#define IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S 66390
#define IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S 66391
#define IDGS_SERVER_IS_WAITING_FOR_CLIENT 66392
#define IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT 66393
#define IDGS_CANNOT_RESOLVE_S 66394
#define IDGS_CANNOT_CONNECT_TO_S 66395
#define IDGS_RECEIVING_SNAPSHOT_SERVER 66396
#define IDGS_NETWORK_OUT_OF_SYNC 66397
#define IDGS_REMOTE_HOST_DISCONNECTED 66398
#define IDGS_REMOTE_HOST_SUSPENDING 66399
#define IDGS_FFMPEG_CANNOT_OPEN_VSTREAM 66400
#define IDGS_FFMPEG_CANNOT_OPEN_ASTREAM 66401
#define IDGS_FFMPEG_CANNOT_OPEN_S 66402
#define IDGS_IO_READ_COLL_AT_X_FROM 66403
#define IDGS_AND 66404
#define IDGS_ALL_DEVICES_DETACHED 66405
#define IDGS_ALL_DEVICES_EXCEPT 66406
#define IDGS_WILL_BE_DETACHED 66407
#define IDGS_NO_FILENAME 66408
#define IDGS_ILLEGAL_FILENAME 66409
#define IDGS_ERROR_CREATING_FILE_S 66410
#define IDGS_ERROR_WRITING_TO_FILE_S 66411
#define IDGS_DTV_ROM_CREATED 66412
#define IDGS_TYPE 66413
#define IDGS_COMMAND_S_UNKNOWN 66414
#define IDGS_NO_HELP_AVAILABLE_FOR_S 66415
#define IDGS_SYNTAX_S_S 66416
#define IDGS_ABBREVIATION_S 66417
#define IDGS_AVAILABLE_COMMANDS_ARE 66418
#define IDGS_MACHINE_STATE_COMMANDS 66419
#define IDGS_MEMSPACE 66420
#define IDGS_BANKNAME 66421
#define IDGS_MON_BANK_DESCRIPTION 66422
#define IDGS_MON_BACKTRACE_DESCRIPTION 66423
#define IDGS_MON_CPU_DESCRIPTION 66424
#define IDGS_COUNT 66425
#define IDGS_MON_CPUHISTORY_DESCRIPTION 66426
#define IDGS_FILENAME 66427
#define IDGS_MON_DUMP_DESCRIPTION 66428
#define IDGS_ADDRESS 66429
#define IDGS_MON_GOTO_DESCRIPTION 66430
#define IDGS_MON_IO_DESCRIPTION 66431
#define IDGS_MON_EXPORT_DESCRIPTION 66432
#define IDGS_MON_NEXT_DESCRIPTION 66433
#define IDGS_REG_NAME 66434
#define IDGS_NUMBER 66435
#define IDGS_MON_REGISTERS_DESCRIPTION 66436
#define IDGS_MON_RESET_DESCRIPTION 66437
#define IDGS_MON_RETURN_DESCRIPTION 66438
#define IDGS_MON_SCREEN_DESCRIPTION 66439
#define IDGS_MON_STEP_DESCRIPTION 66440
#define IDGS_MON_STOPWATCH_DESCRIPTION 66441
#define IDGS_MON_UNDUMP_DESCRIPTION 66442
#define IDGS_SYMBOL_TABLE_COMMANDS 66443
#define IDGS_LABEL 66444
#define IDGS_MON_ADD_LABEL_DESCRIPTION 66445
#define IDGS_MON_DELETE_LABEL_DESCRIPTION 66446
#define IDGS_MON_LOAD_LABELS_DESCRIPTION 66447
#define IDGS_MON_SAVE_LABELS_DESCRIPTION 66448
#define IDGS_MON_SHOW_LABELS_DESCRIPTION 66449
#define IDGS_ASSEMBLER_AND_MEMORY_COMMANDS 66450
#define IDGS_DATA_LIST 66451
#define IDGS_MON_WRITE_DESCRIPTION 66452
#define IDGS_INSTRUCTION 66453
#define IDGS_MON_ASSEMBLE_DESCRIPTION 66454
#define IDGS_ADDRESS_RANGE 66455
#define IDGS_MON_COMPARE_DESCRIPTION 66456
#define IDGS_CHECKNUM 66457
#define IDGS_MON_DELETE_DESCRIPTION 66458
#define IDGS_MON_DISASS_DESCRIPTION 66459
#define IDGS_MON_FILL_DESCRIPTION 66460
#define IDGS_MON_HUNT_DESCRIPTION 66461
#define IDGS_ADDRESS_OPT_RANGE 66462
#define IDGS_MON_I_DESCRIPTION 66463
#define IDGS_MON_II_DESCRIPTION 66464
#define IDGS_DATA_TYPE 66465
#define IDGS_MON_MEM_DESCRIPTION 66466
#define IDGS_MON_MEMCHAR_DESCRIPTION 66467
#define IDGS_FORMAT 66468
#define IDGS_MON_MEMMAPSAVE_DESCRIPTION 66469
#define IDGS_MASK 66470
#define IDGS_MON_MEMMAPSHOW_DESCRIPTION 66471
#define IDGS_MON_MEMMAPZAP_DESCRIPTION 66472
#define IDGS_MON_MEMSPRITE_DESCRIPTION 66473
#define IDGS_MON_MOVE_DESCRIPTION 66474
#define IDGS_CHECKPOINT_COMMANDS 66475
#define IDGS_COND_EXPR 66476
#define IDGS_MON_BREAK_DESCRIPTION 66477
#define IDGS_COMMAND 66478
#define IDGS_MON_COMMAND_DESCRIPTION 66479
#define IDGS_MON_CONDITION_DESCRIPTION 66480
#define IDGS_MON_DISABLE_DESCRIPTION 66481
#define IDGS_MON_ENABLE_DESCRIPTION 66482
#define IDGS_MON_IGNORE_DESCRIPTION 66483
#define IDGS_MON_UNTIL_DESCRIPTION 66484
#define IDGS_MON_WATCH_DESCRIPTION 66485
#define IDGS_MON_TRACE_DESCRIPTION 66486
#define IDGS_MONITOR_STATE_COMMANDS 66487
#define IDGS_MON_DEVICE_DESCRIPTION 66488
#define IDGS_MON_EXIT_DESCRIPTION 66489
#define IDGS_MON_QUIT_DESCRIPTION 66490
#define IDGS_MON_RADIX_DESCRIPTION 66491
#define IDGS_MON_SIDEFX_DESCRIPTION 66492
#define IDGS_DISK_COMMANDS 66493
#define IDGS_DISK_COMMAND 66494
#define IDGS_MON_AT_DESCRIPTION 66495
#define IDGS_DEVICE 66496
#define IDGS_FILE_INDEX 66497
#define IDGS_MON_AUTOSTART_DESCRIPTION 66498
#define IDGS_MON_AUTOLOAD_DESCRIPTION 66499
#define IDGS_MON_ATTACH_DESCRIPTION 66500
#define IDGS_MON_BLOAD_DESCRIPTION 66501
#define IDGS_TRACK 66502
#define IDGS_SECTOR 66503
#define IDGS_MON_BLOCK_READ_DESCRIPTION 66504
#define IDGS_MON_BSAVE_DESCRIPTION 66505
#define IDGS_MON_BLOCK_WRITE_DESCRIPTION 66506
#define IDGS_DIRECTORY 66507
#define IDGS_P_DIRECTORY 66508
#define IDGS_MON_CD_DESCRIPTION 66509
#define IDGS_MON_DETACH_DESCRIPTION 66510
#define IDGS_MON_DIR_DESCRIPTION 66511
#define IDGS_MON_LIST_DESCRIPTION 66512
#define IDGS_MON_LOAD_DESCRIPTION 66513
#define IDGS_MON_PWD_DESCRIPTION 66514
#define IDGS_MON_SAVE_DESCRIPTION 66515
#define IDGS_OTHER_COMMANDS 66516
#define IDGS_MON_DISPLAY_NUMBER_DESCRIPTION 66517
#define IDGS_MON_CARTFREEZE_DESCRIPTION 66518
#define IDGS_MON_HELP_DESCRIPTION 66519
#define IDGS_STRING 66520
#define IDGS_MON_KEYBUF_DESCRIPTION 66521
#define IDGS_MON_PLAYBACK_DESCRIPTION 66522
#define IDGS_EXPRESSION 66523
#define IDGS_MON_PRINT_DESCRIPTION 66524
#define IDGS_MON_RECORD_DESCRIPTION 66525
#define IDGS_RESOURCE 66526
#define IDGS_MON_RESOURCEGET_DESCRIPTION 66527
#define IDGS_VALUE 66528
#define IDGS_MON_RESOURCESET_DESCRIPTION 66529
#define IDGS_MON_LOAD_RESOURCES_DESCRIPTION 66530
#define IDGS_MON_SAVE_RESOURCES_DESCRIPTION 66531
#define IDGS_MON_STOP_DESCRIPTION 66532
#define IDGS_MON_SCREENSHOT_DESCRIPTION 66533
#define IDGS_MON_TAPECTRL_DESCRIPTION 66534
#define IDCLS_AUTOSTART_LOAD_TO_BASIC_START 66535
#define IDCLS_AUTOSTART_LOAD_WITH_1 66536
#define IDCLS_ENABLE_AUTOSTARTWITHCOLON 66537
#define IDCLS_DISABLE_AUTOSTARTWITHCOLON 66538
#define IDCLS_ENABLE_AUTOSTART_HANDLE_TDE 66539
#define IDCLS_DISABLE_AUTOSTART_HANDLE_TDE 66540
#define IDCLS_ENABLE_WARP_MODE_AUTOSTART 66541
#define IDCLS_DISABLE_WARP_MODE_AUTOSTART 66542
#define IDCLS_SET_AUTOSTART_MODE_FOR_PRG 66543
#define IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG 66544
#define IDCLS_SET_AUTOSTART_DELAY 66545
#define IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY 66546
#define IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY 66547
#define IDCLS_USE_PAL_SYNC_FACTOR 66548
#define IDCLS_USE_NTSC_SYNC_FACTOR 66549
#define IDCLS_USE_PALN_SYNC_FACTOR 66550
#define IDCLS_SET_BURST_MOD 66551
#define IDCLS_P_NAME 66552
#define IDCLS_SPECIFY_INT_KERNEL_NAME 66553
#define IDCLS_SPECIFY_DE_KERNEL_NAME 66554
#define IDCLS_SPECIFY_FI_KERNEL_NAME 66555
#define IDCLS_SPECIFY_FR_KERNEL_NAME 66556
#define IDCLS_SPECIFY_IT_KERNEL_NAME 66557
#define IDCLS_SPECIFY_NO_KERNEL_NAME 66558
#define IDCLS_SPECIFY_SV_KERNEL_NAME 66559
#define IDCLS_SPECIFY_BASIC_ROM_NAME_LOW 66560
#define IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH 66561
#define IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME 66562
#define IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME 66563
#define IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME 66564
#define IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME 66565
#define IDCLS_SPECIFY_C64_MODE_KERNAL_NAME 66566
#define IDCLS_SPECIFY_C64_MODE_BASIC_NAME 66567
#define IDCLS_ENABLE_OEM_JOY 66568
#define IDCLS_DISABLE_OEM_JOY 66569
#define IDCLS_ENABLE_IEE488 66570
#define IDCLS_DISABLE_IEE488 66571
#define IDCLS_P_REVISION 66572
#define IDCLS_PATCH_KERNAL_TO_REVISION 66573
#define IDCLS_ENABLE_DEXX_ACIA_RS232_EMU 66574
#define IDCLS_DISABLE_DEXX_ACIA_RS232_EMU 66575
#define IDCLS_ENABLE_ACIA_EMU 66576
#define IDCLS_DISABLE_ACIA_EMU 66577
#define IDCLS_P_NUMBER 66578
#define IDCLS_SPECIFY_KEYMAP_FILE_INDEX 66579
#define IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME 66580
#define IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME 66581
#define IDCLS_ACTIVATE_40_COL_MODE 66582
#define IDCLS_ACTIVATE_80_COL_MODE 66583
#define IDCLS_GO64_MODE 66584
#define IDCLS_GO128_MODE 66585
#define IDCLS_SPECIFY_INT_FUNC_ROM_NAME 66586
#define IDCLS_SPECIFY_EXT_FUNC_ROM_NAME 66587
#define IDCLS_ENABLE_INT_FUNC_ROM 66588
#define IDCLS_DISABLE_INT_FUNC_ROM 66589
#define IDCLS_ENABLE_EXT_FUNC_ROM 66590
#define IDCLS_DISABLE_EXT_FUNC_ROM 66591
#define IDCLS_USE_OLD_NTSC_SYNC_FACTOR 66592
#define IDCLS_P_MODEL 66593
#define IDCLS_SET_BOTH_CIA_MODELS 66594
#define IDCLS_SET_CIA1_MODEL 66595
#define IDCLS_SET_CIA2_MODEL 66596
#define IDCLS_SET_C64_MODEL 66597
#define IDCLS_SET_C128_MODEL 66598
#define IDCLS_SET_PLUS4_MODEL 66599
#define IDCLS_SET_DTV_MODEL 66600
#define IDCLS_SPECIFY_KERNAL_ROM_NAME 66601
#define IDCLS_SPECIFY_BASIC_ROM_NAME 66602
#define IDCLS_SPECIFY_CHARGEN_ROM_NAME 66603
#define IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2 66604
#define IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP 66605
#define IDCLS_SET_GLUE_LOGIC_TYPE 66606
#define IDCLS_ENABLE_HUMMER_ADC 66607
#define IDCLS_DISABLE_HUMMER_ADC 66608
#define IDCLS_SELECT_CONFLICT_HANDLING 66609
#define IDCLS_ENABLE_IEEE488_INTERFACE 66610
#define IDCLS_DISABLE_IEEE488_INTERFACE 66611
#define IDCLS_SPECIFY_IEEE488_INTERFACE_NAME 66612
#define IDCLS_ENABLE_GEORAM 66613
#define IDCLS_DISABLE_GEORAM 66614
#define IDCLS_SPECIFY_GEORAM_NAME 66615
#define IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE 66616
#define IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE 66617
#define IDCLS_SWAP_CART_IO 66618
#define IDCLS_DONT_SWAP_CART_IO 66619
#define IDCLS_MAP_CART_IO_2 66620
#define IDCLS_MAP_CART_IO_3 66621
#define IDCLS_P_SIZE_IN_KB 66622
#define IDCLS_GEORAM_SIZE 66623
#define IDCLS_ENABLE_PETREU 66624
#define IDCLS_DISABLE_PETREU 66625
#define IDCLS_SPECIFY_PETREU_NAME 66626
#define IDCLS_PETREU_SIZE 66627
#define IDCLS_SPECIFY_PETDWW_NAME 66628
#define IDCLS_ENABLE_PETDWW 66629
#define IDCLS_DISABLE_PETDWW 66630
#define IDCLS_ENABLE_USERPORT_DAC 66631
#define IDCLS_DISABLE_USERPORT_DAC 66632
#define IDCLS_ENABLE_USERPORT_RTC 66633
#define IDCLS_DISABLE_USERPORT_RTC 66634
#define IDCLS_SID_PLAYER_MODE 66635
#define IDCLS_OVERWRITE_PSID_SETTINGS 66636
#define IDCLS_SPECIFY_PSID_TUNE_NUMBER 66637
#define IDCLS_ENABLE_RAMCART 66638
#define IDCLS_DISABLE_RAMCART 66639
#define IDCLS_SPECIFY_RAMCART_NAME 66640
#define IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE 66641
#define IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE 66642
#define IDCLS_RAMCART_SIZE 66643
#define IDCLS_ENABLE_DQBB 66644
#define IDCLS_DISABLE_DQBB 66645
#define IDCLS_SPECIFY_DQBB_NAME 66646
#define IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE 66647
#define IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE 66648
#define IDCLS_ENABLE_ISEPIC 66649
#define IDCLS_DISABLE_ISEPIC 66650
#define IDCLS_SET_ISEPIC_FILENAME 66651
#define IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE 66652
#define IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE 66653
#define IDCLS_ENABLE_MMC64 66654
#define IDCLS_DISABLE_MMC64 66655
#define IDCLS_SPECIFY_MMC64_BIOS_NAME 66656
#define IDCLS_SPECIFY_MMC64_IMAGE_NAME 66657
#define IDCLS_MMC64_READONLY 66658
#define IDCLS_MMC64_READWRITE 66659
#define IDCLS_MMC64_BIOS_WRITE 66660
#define IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME 66661
#define IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE 66662
#define IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE 66663
#define IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE 66664
#define IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE 66665
#define IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE 66666
#define IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE 66667
#define IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE 66668
#define IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE 66669
#define IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE 66670
#define IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT 66671
#define IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT 66672
#define IDCLS_SET_RR_BANK_JUMPER 66673
#define IDCLS_UNSET_RR_BANK_JUMPER 66674
#define IDCLS_SET_RR_FLASH_JUMPER 66675
#define IDCLS_UNSET_RR_FLASH_JUMPER 66676
#define IDCLS_ENABLE_REU 66677
#define IDCLS_DISABLE_REU 66678
#define IDCLS_SPECIFY_REU_NAME 66679
#define IDCLS_ALLOW_WRITING_TO_REU_IMAGE 66680
#define IDCLS_DO_NOT_WRITE_TO_REU_IMAGE 66681
#define IDCLS_REU_SIZE 66682
#define IDCLS_ENABLE_TFE 66683
#define IDCLS_DISABLE_TFE 66684
#define IDCLS_TFE_INTERFACE 66685
#define IDCLS_ENABLE_TFE_AS_RRNET 66686
#define IDCLS_DISABLE_TFE_AS_RRNET 66687
#define IDCLS_CART_ATTACH_DETACH_RESET 66688
#define IDCLS_CART_ATTACH_DETACH_NO_RESET 66689
#define IDCLS_ATTACH_CRT_CART 66690
#define IDCLS_ATTACH_GENERIC_8KB_CART 66691
#define IDCLS_ATTACH_GENERIC_16KB_CART 66692
#define IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART 66693
#define IDCLS_ATTACH_RAW_STARDOS_CART 66694
#define IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART 66695
#define IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART 66696
#define IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART 66697
#define IDCLS_ATTACH_RAW_ACTION_REPLAY_CART 66698
#define IDCLS_ATTACH_RAW_CAPTURE_CART 66699
#define IDCLS_ATTACH_RAW_COMAL80_CART 66700
#define IDCLS_ATTACH_RAW_DELA_EP256_CART 66701
#define IDCLS_ATTACH_RAW_DELA_EP64_CART 66702
#define IDCLS_ATTACH_RAW_DELA_EP7X8_CART 66703
#define IDCLS_ATTACH_RAW_DINAMIC_CART 66704
#define IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART 66705
#define IDCLS_ATTACH_RAW_DQBB_CART 66706
#define IDCLS_ATTACH_RAW_EASY_FLASH_CART 66707
#define IDCLS_ATTACH_RAW_RETRO_REPLAY_CART 66708
#define IDCLS_ATTACH_RAW_REX_UTILITY_CART 66709
#define IDCLS_ATTACH_RAW_SS64_CART 66710
#define IDCLS_ATTACH_RAW_IDE64_CART 66711
#define IDCLS_ATTACH_RAW_ATOMIC_POWER_CART 66712
#define IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART 66713
#define IDCLS_ATTACH_RAW_EXOS_CART 66714
#define IDCLS_ATTACH_RAW_EXPERT_CART 66715
#define IDCLS_ATTACH_RAW_F64_CART 66716
#define IDCLS_ATTACH_RAW_FC1_CART 66717
#define IDCLS_ATTACH_RAW_FC3_CART 66718
#define IDCLS_ATTACH_RAW_FCPLUS_CART 66719
#define IDCLS_ATTACH_RAW_FREEZE_FRAME_CART 66720
#define IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART 66721
#define IDCLS_ATTACH_RAW_FP_PP_CART 66722
#define IDCLS_ATTACH_RAW_SS4_CART 66723
#define IDCLS_ATTACH_RAW_SS5_CART 66724
#define IDCLS_ATTACH_CBM_IEEE488_CART 66725
#define IDCLS_ATTACH_RAW_ISEPIC_CART 66726
#define IDCLS_ATTACH_RAW_KCS_CART 66727
#define IDCLS_ATTACH_RAW_KINGSOFT_CART 66728
#define IDCLS_ATTACH_RAW_MACH5_CART 66729
#define IDCLS_ATTACH_RAW_MAGIC_DESK_CART 66730
#define IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART 66731
#define IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART 66732
#define IDCLS_ATTACH_RAW_MMC64_CART 66733
#define IDCLS_ATTACH_RAW_MMC_REPLAY_CART 66734
#define IDCLS_ATTACH_RAW_MAGIC_VOICE_CART 66735
#define IDCLS_ATTACH_RAW_OCEAN_CART 66736
#define IDCLS_ATTACH_RAW_WESTERMANN_CART 66737
#define IDCLS_ATTACH_RAW_WARPSPEED_CART 66738
#define IDCLS_ATTACH_RAW_ZAXXON_CART 66739
#define IDCLS_ATTACH_RAW_PAGEFOX_CART 66740
#define IDCLS_ATTACH_RAW_P64_CART 66741
#define IDCLS_ATTACH_RAW_RAMCART_CART 66742
#define IDCLS_ATTACH_RAW_REU_CART 66743
#define IDCLS_ATTACH_RAW_REX_EP256_CART 66744
#define IDCLS_ATTACH_RAW_ROSS_CART 66745
#define IDCLS_ATTACH_RAW_GAME_KILLER_CART 66746
#define IDCLS_ATTACH_RAW_GEORAM_CART 66747
#define IDCLS_ATTACH_RAW_GAME_SYSTEM_CART 66748
#define IDCLS_ENABLE_EXPERT_CART 66749
#define IDCLS_DISABLE_EXPERT_CART 66750
#define IDCLS_SET_EXPERT_FILENAME 66751
#define IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE 66752
#define IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE 66753
#define IDCLS_DISABLE_CART 66754
#define IDCLS_SMART_ATTACH_CART 66755
#define IDCLS_SPECIFY_IDE64_NAME 66756
#define IDCLS_P_VALUE 66757
#define IDCLS_SET_AMOUNT_CYLINDERS_IDE64 66758
#define IDCLS_SET_AMOUNT_HEADS_IDE64 66759
#define IDCLS_SET_AMOUNT_SECTORS_IDE64 66760
#define IDCLS_AUTODETECT_IDE64_GEOMETRY 66761
#define IDCLS_NO_AUTODETECT_IDE64_GEOMETRY 66762
#define IDCLS_IDE64_V4 66763
#define IDCLS_IDE64_PRE_V4 66764
#define IDCLS_P_MODELNUMBER 66765
#define IDCLS_SPECIFY_CBM2_MODEL 66766
#define IDCLS_SPECIFY_TO_USE_VIC_II 66767
#define IDCLS_SPECIFY_TO_USE_CRTC 66768
#define IDCLS_P_LINENUMBER 66769
#define IDCLS_SPECIFY_CBM2_MODEL_HARDWARE 66770
#define IDCLS_P_RAMSIZE 66771
#define IDCLS_SPECIFY_SIZE_OF_RAM 66772
#define IDCLS_SPECIFY_CART_ROM_1000_NAME 66773
#define IDCLS_SPECIFY_CART_ROM_2000_NAME 66774
#define IDCLS_SPECIFY_CART_ROM_4000_NAME 66775
#define IDCLS_SPECIFY_CART_ROM_6000_NAME 66776
#define IDCLS_ENABLE_RAM_MAPPING_IN_0800 66777
#define IDCLS_DISABLE_RAM_MAPPING_IN_0800 66778
#define IDCLS_ENABLE_RAM_MAPPING_IN_1000 66779
#define IDCLS_DISABLE_RAM_MAPPING_IN_1000 66780
#define IDCLS_ENABLE_RAM_MAPPING_IN_2000 66781
#define IDCLS_DISABLE_RAM_MAPPING_IN_2000 66782
#define IDCLS_ENABLE_RAM_MAPPING_IN_4000 66783
#define IDCLS_DISABLE_RAM_MAPPING_IN_4000 66784
#define IDCLS_ENABLE_RAM_MAPPING_IN_6000 66785
#define IDCLS_DISABLE_RAM_MAPPING_IN_6000 66786
#define IDCLS_ENABLE_RAM_MAPPING_IN_C000 66787
#define IDCLS_DISABLE_RAM_MAPPING_IN_C000 66788
#define IDCLS_SPECIFY_KEYMAP_INDEX 66789
#define IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME 66790
#define IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME 66791
#define IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME 66792
#define IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME 66793
#define IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME 66794
#define IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME 66795
#define IDCLS_ENABLE_TRUE_DRIVE 66796
#define IDCLS_DISABLE_TRUE_DRIVE 66797
#define IDCLS_ENABLE_DRIVE_SOUND 66798
#define IDCLS_DISABLE_DRIVE_SOUND 66799
#define IDCLS_P_TYPE 66800
#define IDCLS_SET_DRIVE_TYPE 66801
#define IDCLS_P_METHOD 66802
#define IDCLS_P_COLOR 66803
#define IDCLS_OVERSIZED_HANDLING 66804
#define IDCLS_MULTICOLOR_HANDLING 66805
#define IDCLS_TED_LUM_HANDLING 66806
#define IDCLS_CRTC_TEXT_COLOR 66807
#define IDCLS_SET_DRIVE_EXTENSION_POLICY 66808
#define IDCLS_SPECIFY_1541_DOS_ROM_NAME 66809
#define IDCLS_SPECIFY_1541_II_DOS_ROM_NAME 66810
#define IDCLS_SPECIFY_1570_DOS_ROM_NAME 66811
#define IDCLS_SPECIFY_1571_DOS_ROM_NAME 66812
#define IDCLS_SPECIFY_1581_DOS_ROM_NAME 66813
#define IDCLS_SPECIFY_2000_DOS_ROM_NAME 66814
#define IDCLS_SPECIFY_4000_DOS_ROM_NAME 66815
#define IDCLS_SET_IDLE_METHOD 66816
#define IDCLS_ENABLE_DRIVE_RAM_2000 66817
#define IDCLS_DISABLE_DRIVE_RAM_2000 66818
#define IDCLS_ENABLE_DRIVE_RAM_4000 66819
#define IDCLS_DISABLE_DRIVE_RAM_4000 66820
#define IDCLS_ENABLE_DRIVE_RAM_6000 66821
#define IDCLS_DISABLE_DRIVE_RAM_6000 66822
#define IDCLS_ENABLE_DRIVE_RAM_8000 66823
#define IDCLS_DISABLE_DRIVE_RAM_8000 66824
#define IDCLS_ENABLE_DRIVE_RAM_A000 66825
#define IDCLS_DISABLE_DRIVE_RAM_A000 66826
#define IDCLS_PAR_CABLE_C64EXP_TYPE 66827
#define IDCLS_ENABLE_PROFDOS 66828
#define IDCLS_DISABLE_PROFDOS 66829
#define IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME 66830
#define IDCLS_ENABLE_SUPERCARD 66831
#define IDCLS_DISABLE_SUPERCARD 66832
#define IDCLS_SPECIFY_SUPERCARD_ROM_NAME 66833
#define IDCLS_PAR_CABLE_PLUS4EXP_TYPE 66834
#define IDCLS_SPECIFY_1571CR_DOS_ROM_NAME 66835
#define IDCLS_SPECIFY_2031_DOS_ROM_NAME 66836
#define IDCLS_SPECIFY_2040_DOS_ROM_NAME 66837
#define IDCLS_SPECIFY_3040_DOS_ROM_NAME 66838
#define IDCLS_SPECIFY_4040_DOS_ROM_NAME 66839
#define IDCLS_SPECIFY_1001_DOS_ROM_NAME 66840
#define IDCLS_SPECIFY_1551_DOS_ROM_NAME 66841
#define IDCLS_USE_AS_DIRECTORY_FSDEVICE_8 66842
#define IDCLS_USE_AS_DIRECTORY_FSDEVICE_9 66843
#define IDCLS_USE_AS_DIRECTORY_FSDEVICE_10 66844
#define IDCLS_USE_AS_DIRECTORY_FSDEVICE_11 66845
#define IDCLS_SET_AUDIO_STREAM_BITRATE 66846
#define IDCLS_SET_VIDEO_STREAM_BITRATE 66847
#define IDCLS_SPECIFY_PET_MODEL 66848
#define IDCLS_SPECIFY_EDITOR_ROM_NAME 66849
#define IDCLS_SPECIFY_4K_ROM_9XXX_NAME 66850
#define IDCLS_SPECIFY_4K_ROM_AXXX_NAME 66851
#define IDCLS_SPECIFY_4K_ROM_BXXX_NAME 66852
#define IDCLS_PET8296_ENABLE_4K_RAM_AT_9000 66853
#define IDCLS_PET8296_DISABLE_4K_RAM_AT_9000 66854
#define IDCLS_PET8296_ENABLE_4K_RAM_AT_A000 66855
#define IDCLS_PET8296_DISABLE_4K_RAM_AT_A000 66856
#define IDCLS_ENABLE_SUPERPET_IO 66857
#define IDCLS_DISABLE_SUPERPET_IO 66858
#define IDCLS_ENABLE_ROM_1_KERNAL_PATCHES 66859
#define IDCLS_DISABLE_ROM_1_KERNAL_PATCHES 66860
#define IDCLS_SWITCH_UPPER_LOWER_CHARSET 66861
#define IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET 66862
#define IDCLS_EOI_BLANKS_SCREEN 66863
#define IDCLS_EOI_DOES_NOT_BLANK_SCREEN 66864
#define IDCLS_ENABLE_USERPORT_DIAG_PIN 66865
#define IDCLS_DISABLE_USERPORT_DIAG_PIN 66866
#define IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME 66867
#define IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME 66868
#define IDCLS_SPECIFY_CART_1_LOW_ROM_NAME 66869
#define IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME 66870
#define IDCLS_SPECIFY_CART_2_LOW_ROM_NAME 66871
#define IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME 66872
#define IDCLS_SPECIFY_RAM_INSTALLED 66873
#define IDCLS_SET_SATURATION 66874
#define IDCLS_SET_CONTRAST 66875
#define IDCLS_SET_BRIGHTNESS 66876
#define IDCLS_SET_GAMMA 66877
#define IDCLS_SET_TINT 66878
#define IDCLS_SET_ODDLINES_PHASE 66879
#define IDCLS_SET_ODDLINES_OFFSET 66880
#define IDCLS_SET_BLUR 66881
#define IDCLS_SET_SCANLINE_SHADE 66882
#define IDCLS_SET_VICII_MODEL 66883
#define IDCLS_SPECIFY_PRT_DRIVER_4_NAME 66884
#define IDCLS_SPECIFY_PRT_DRIVER_5_NAME 66885
#define IDCLS_SPECIFY_PRT_DRIVER_USR_NAME 66886
#define IDCLS_SET_DEVICE_TYPE_4 66887
#define IDCLS_SET_DEVICE_TYPE_5 66888
#define IDCLS_ENABLE_USERPORT_PRINTER 66889
#define IDCLS_DISABLE_USERPORT_PRINTER 66890
#define IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME 66891
#define IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME 66892
#define IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME 66893
#define IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME 66894
#define IDCLS_SPECIFY_TEXT_DEVICE_4 66895
#define IDCLS_SPECIFY_TEXT_DEVICE_5 66896
#define IDCLS_SPECIFY_TEXT_USERPORT 66897
#define IDCLS_ENABLE_VIDEO_CACHE 66898
#define IDCLS_DISABLE_VIDEO_CACHE 66899
#define IDCLS_SPECIFY_RS232_1_NAME 66900
#define IDCLS_SPECIFY_RS232_2_NAME 66901
#define IDCLS_SPECIFY_RS232_3_NAME 66902
#define IDCLS_SPECIFY_RS232_4_NAME 66903
#define IDCLS_ENABLE_RS232_USERPORT 66904
#define IDCLS_DISABLE_RS232_USERPORT 66905
#define IDCLS_P_BAUD 66906
#define IDCLS_SET_BAUD_RS232_USERPORT 66907
#define IDCLS_SPECIFY_RS232_DEVICE_USERPORT 66908
#define IDCLS_ENABLE_IEC_4 66909
#define IDCLS_DISABLE_IEC_4 66910
#define IDCLS_ENABLE_IEC_5 66911
#define IDCLS_DISABLE_IEC_5 66912
#define IDCLS_ENABLE_IEC_8 66913
#define IDCLS_DISABLE_IEC_8 66914
#define IDCLS_ENABLE_IEC_9 66915
#define IDCLS_DISABLE_IEC_9 66916
#define IDCLS_ENABLE_IEC_10 66917
#define IDCLS_DISABLE_IEC_10 66918
#define IDCLS_ENABLE_IEC_11 66919
#define IDCLS_DISABLE_IEC_11 66920
#define IDCLS_P_ENGINE_MODEL 66921
#define IDCLS_P_AMOUNT 66922
#define IDCLS_AMOUNT_EXTRA_SIDS 66923
#define IDCLS_FASTSID_ENGINE_MODEL 66924
#define IDCLS_RESID_ENGINE_MODEL 66925
#define IDCLS_RESIDDTV_ENGINE_MODEL 66926
#define IDCLS_CATWEASELMKIII_ENGINE_MODEL 66927
#define IDCLS_HARDSID_ENGINE_MODEL 66928
#define IDCLS_PARSID_ENGINE_MODEL 66929
#define IDCLS_RESIDFP_ENGINE_MODEL 66930
#define IDCLS_ENABLE_SIDCART 66931
#define IDCLS_DISABLE_SIDCART 66932
#define IDCLS_P_BASE_ADDRESS 66933
#define IDCLS_SPECIFY_SID_2_ADDRESS 66934
#define IDCLS_SPECIFY_SID_3_ADDRESS 66935
#define IDCLS_ENABLE_SID_FILTERS 66936
#define IDCLS_DISABLE_SID_FILTERS 66937
#define IDCLS_RESID_SAMPLING_METHOD 66938
#define IDCLS_P_PERCENT 66939
#define IDCLS_PASSBAND_PERCENTAGE 66940
#define IDCLS_RESID_FILTER_BIAS 66941
#define IDCLS_RESID_GAIN_PERCENTAGE 66942
#define IDCLS_ENABLE_STRETCH_VERTICAL 66943
#define IDCLS_DISABLE_STRETCH_VERTICAL 66944
#define IDCLS_SET_VDC_MEMORY_16KB 66945
#define IDCLS_SET_VDC_MEMORY_64KB 66946
#define IDCLS_SET_VDC_REVISION 66947
#define IDCLS_P_SPEC 66948
#define IDCLS_SPECIFY_MEMORY_CONFIG 66949
#define IDCLS_ENABLE_VIC1112_IEEE488 66950
#define IDCLS_DISABLE_VIC1112_IEEE488 66951
#define IDCLS_SPECIFY_EXT_ROM_2000_NAME 66952
#define IDCLS_SPECIFY_EXT_ROM_4000_NAME 66953
#define IDCLS_SPECIFY_EXT_ROM_6000_NAME 66954
#define IDCLS_SPECIFY_EXT_ROM_A000_NAME 66955
#define IDCLS_SPECIFY_EXT_ROM_B000_NAME 66956
#define IDCLS_SPECIFY_GENERIC_ROM_NAME 66957
#define IDCLS_SPECIFY_MEGA_CART_ROM_NAME 66958
#define IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME 66959
#define IDCLS_SPECIFY_VIC_FP_ROM_NAME 66960
#define IDCLS_ENABLE_FINALEXPANSION_WRITEBACK 66961
#define IDCLS_DISABLE_FINALEXPANSION_WRITEBACK 66962
#define IDCLS_SET_MEGACART_NVRAM_NAME 66963
#define IDCLS_ENABLE_MEGACART_NVRAM_WRITE 66964
#define IDCLS_DISABLE_MEGACART_NVRAM_WRITE 66965
#define IDCLS_ENABLE_VICFP_ROM_WRITE 66966
#define IDCLS_DISABLE_VICFP_ROM_WRITE 66967
#define IDCLS_SET_BORDER_MODE 66968
#define IDCLS_ENABLE_SPRITE_BACKGROUND 66969
#define IDCLS_DISABLE_SPRITE_BACKGROUND 66970
#define IDCLS_ENABLE_SPRITE_SPRITE 66971
#define IDCLS_DISABLE_SPRITE_SPRITE 66972
#define IDCLS_USE_NEW_LUMINANCES 66973
#define IDCLS_USE_OLD_LUMINANCES 66974
#define IDCLS_ENABLE_DOUBLE_SIZE 66975
#define IDCLS_DISABLE_DOUBLE_SIZE 66976
#define IDCLS_ENABLE_DOUBLE_SCAN 66977
#define IDCLS_DISABLE_DOUBLE_SCAN 66978
#define IDCLS_ENABLE_AUDIO_LEAK 66979
#define IDCLS_DISABLE_AUDIO_LEAK 66980
#define IDCLS_ENABLE_HARDWARE_SCALING 66981
#define IDCLS_DISABLE_HARDWARE_SCALING 66982
#define IDCLS_SET_VIDEO_FILTER 66983
#define IDCLS_USE_INTERNAL_CALC_PALETTE 66984
#define IDCLS_USE_EXTERNAL_FILE_PALETTE 66985
#define IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME 66986
#define IDCLS_P_DEVICE 66987
#define IDCLS_SELECT_FULLSCREEN_DEVICE 66988
#define IDCLS_P_MODE 66989
#define IDCLS_SELECT_FULLSCREEN_MODE 66990
#define IDCLS_SPECIFY_ACIA_RS232_DEVICE 66991
#define IDCLS_SET_DEVICE_TYPE_8 66992
#define IDCLS_SET_DEVICE_TYPE_9 66993
#define IDCLS_SET_DEVICE_TYPE_10 66994
#define IDCLS_SET_DEVICE_TYPE_11 66995
#define IDCLS_ATTACH_READ_ONLY_8 66996
#define IDCLS_ATTACH_READ_WRITE_8 66997
#define IDCLS_ATTACH_READ_ONLY_9 66998
#define IDCLS_ATTACH_READ_WRITE_9 66999
#define IDCLS_ATTACH_READ_ONLY_10 67000
#define IDCLS_ATTACH_READ_WRITE_10 67001
#define IDCLS_ATTACH_READ_ONLY_11 67002
#define IDCLS_ATTACH_READ_WRITE_11 67003
#define IDCLS_ENABLE_AUTO_DATASETTE_RESET 67004
#define IDCLS_DISABLE_AUTO_DATASETTE_RESET 67005
#define IDCLS_SET_ZERO_TAP_DELAY 67006
#define IDCLS_SET_CYCLES_ADDED_GAP_TAP 67007
#define IDCLS_TRACE_MAIN_CPU 67008
#define IDCLS_DONT_TRACE_MAIN_CPU 67009
#define IDCLS_TRACE_DRIVE0_CPU 67010
#define IDCLS_DONT_TRACE_DRIVE0_CPU 67011
#define IDCLS_TRACE_DRIVE1_CPU 67012
#define IDCLS_DONT_TRACE_DRIVE1_CPU 67013
#define IDCLS_TRACE_DRIVE2_CPU 67014
#define IDCLS_DONT_TRACE_DRIVE2_CPU 67015
#define IDCLS_TRACE_DRIVE3_CPU 67016
#define IDCLS_DONT_TRACE_DRIVE3_CPU 67017
#define IDCLS_TRACE_MODE 67018
#define IDCLS_PLAYBACK_RECORDED_EVENTS 67019
#define IDCLS_EXECUTE_MONITOR_FROM_FILE 67020
#define IDCLS_SET_INITIAL_BREAKPOINT 67021
#define IDCLS_ENABLE_REMOTE_MONITOR 67022
#define IDCLS_DISABLE_REMOTE_MONITOR 67023
#define IDCLS_REMOTE_MONITOR_ADDRESS 67024
#define IDCLS_SPECIFY_FLIP_LIST_NAME 67025
#define IDCLS_SHOW_COMMAND_LINE_OPTIONS 67026
#define IDCLS_CONSOLE_MODE 67027
#define IDCLS_ALLOW_CORE_DUMPS 67028
#define IDCLS_DONT_ALLOW_CORE_DUMPS 67029
#define IDCLS_DONT_CALL_EXCEPTION_HANDLER 67030
#define IDCLS_CALL_EXCEPTION_HANDLER 67031
#define IDCLS_RESTORE_DEFAULT_SETTINGS 67032
#define IDCLS_P_FILE 67033
#define IDCLS_SPECIFY_CONFIG_FILE 67034
#define IDCLS_ATTACH_AND_AUTOSTART 67035
#define IDCLS_ATTACH_AND_AUTOLOAD 67036
#define IDCLS_ATTACH_AS_TAPE 67037
#define IDCLS_ATTACH_AS_DISK_8 67038
#define IDCLS_ATTACH_AS_DISK_9 67039
#define IDCLS_ATTACH_AS_DISK_10 67040
#define IDCLS_ATTACH_AS_DISK_11 67041
#define IDCLS_P_STRING 67042
#define IDCLS_PUT_STRING_INTO_KEYBUF 67043
#define IDCLS_SPECIFY_LOG_FILE_NAME 67044
#define IDCLS_ENABLE_VERBOSE_LOG_OUTPUT 67045
#define IDCLS_ENABLE_MOUSE_GRAB 67046
#define IDCLS_DISABLE_MOUSE_GRAB 67047
#define IDCLS_SELECT_MOUSE_JOY_PORT 67048
#define IDCLS_SELECT_MOUSE_TYPE 67049
#define IDCLS_ENABLE_PS2MOUSE 67050
#define IDCLS_DISABLE_PS2MOUSE 67051
#define IDCLS_SET_FIRST_RAM_ADDRESS_VALUE 67052
#define IDCLS_P_NUM_OF_BYTES 67053
#define IDCLS_LENGTH_BLOCK_SAME_VALUE 67054
#define IDCLS_LENGTH_BLOCK_SAME_PATTERN 67055
#define IDCLS_ENABLE_SOUND_PLAYBACK 67056
#define IDCLS_DISABLE_SOUND_PLAYBACK 67057
#define IDCLS_SET_SAMPLE_RATE_VALUE_HZ 67058
#define IDCLS_SET_SOUND_BUFFER_SIZE_MSEC 67059
#define IDCLS_SET_SOUND_FRAGMENT_SIZE 67060
#define IDCLS_SPECIFY_SOUND_DRIVER 67061
#define IDCLS_P_ARGS 67062
#define IDCLS_SPECIFY_SOUND_DRIVER_PARAM 67063
#define IDCLS_SPECIFY_RECORDING_SOUND_DRIVER 67064
#define IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM 67065
#define IDCLS_P_SYNC 67066
#define IDCLS_SET_SOUND_SPEED_ADJUST 67067
#define IDCLS_P_OUTPUT_MODE 67068
#define IDCLS_SOUND_OUTPUT_MODE 67069
#define IDCLS_P_PATH 67070
#define IDCLS_DEFINE_SYSTEM_FILES_PATH 67071
#define IDCLS_ENABLE_TRAPS_FAST_EMULATION 67072
#define IDCLS_DISABLE_TRAPS_FAST_EMULATION 67073
#define IDCLS_LIMIT_SPEED_TO_VALUE 67074
#define IDCLS_UPDATE_EVERY_VALUE_FRAMES 67075
#define IDCLS_ENABLE_WARP_MODE 67076
#define IDCLS_DISABLE_WARP_MODE 67077
#define IDCLS_P_ISO_LANGUAGE_CODE 67078
#define IDCLS_SPECIFY_ISO_LANG_CODE 67079
#define IDCLS_ENABLE_PLUS256K_EXPANSION 67080
#define IDCLS_DISABLE_PLUS256K_EXPANSION 67081
#define IDCLS_SPECIFY_PLUS256K_NAME 67082
#define IDCLS_ENABLE_PLUS60K_EXPANSION 67083
#define IDCLS_DISABLE_PLUS60K_EXPANSION 67084
#define IDCLS_SPECIFY_PLUS60K_NAME 67085
#define IDCLS_PLUS60K_BASE 67086
#define IDCLS_ENABLE_C64_256K_EXPANSION 67087
#define IDCLS_DISABLE_C64_256K_EXPANSION 67088
#define IDCLS_SPECIFY_C64_256K_NAME 67089
#define IDCLS_C64_256K_BASE 67090
#define IDCLS_ATTACH_RAW_STB_CART 67091
#define IDCLS_ATTACH_RAW_SE5_CART 67092
#define IDCLS_ATTACH_RAW_SUPER_GAMES_CART 67093
#define IDCLS_ATTACH_RAW_SILVERROCK_128_CART 67094
#define IDCLS_ATTACH_RAW_SIMONS_BASIC_CART 67095
#define IDCLS_ENABLE_CS256K_EXPANSION 67096
#define IDCLS_ENABLE_H256K_EXPANSION 67097
#define IDCLS_ENABLE_H1024K_EXPANSION 67098
#define IDCLS_ENABLE_H4096K_EXPANSION 67099
#define IDCLS_SPECIFY_DTV_REVISION 67100
#define IDCLS_ENABLE_DTV_BLITTER_LOG 67101
#define IDCLS_DISABLE_DTV_BLITTER_LOG 67102
#define IDCLS_ENABLE_DTV_DMA_LOG 67103
#define IDCLS_DISABLE_DTV_DMA_LOG 67104
#define IDCLS_SPECIFY_C64DTVROM_NAME 67105
#define IDCLS_ENABLE_C64DTVROM_RW 67106
#define IDCLS_DISABLE_C64DTVROM_RW 67107
#define IDCLS_ENABLE_DTV_FLASH_LOG 67108
#define IDCLS_DISABLE_DTV_FLASH_LOG 67109
#define IDCLS_USE_AS_DIRECTORY_FLASH_FS 67110
#define IDCLS_ENABLE_TRUE_FLASH_FS 67111
#define IDCLS_DISABLE_TRUE_FLASH_FS 67112
#define IDCLS_ENABLE_MIDI_EMU 67113
#define IDCLS_DISABLE_MIDI_EMU 67114
#define IDCLS_SPECIFY_C64_MIDI_TYPE 67115
#define IDCLS_ENABLE_DIGIBLASTER 67116
#define IDCLS_DISABLE_DIGIBLASTER 67117
#define IDCLS_ENABLE_PLUS4SPEECH 67118
#define IDCLS_DISABLE_PLUS4SPEECH 67119
#define IDCLS_ATTACH_SPEECH_ROM_IMAGE 67120
#define IDCLS_ENABLE_SIDCARTJOY 67121
#define IDCLS_DISABLE_SIDCARTJOY 67122
#define IDCLS_ENABLE_SFX_SE 67123
#define IDCLS_DISABLE_SFX_SE 67124
#define IDCLS_SET_YM_CHIP_TYPE 67125
#define IDCLS_ENABLE_SFX_SS 67126
#define IDCLS_DISABLE_SFX_SS 67127
#define IDCLS_ENABLE_LIGHTPEN_EMULATION 67128
#define IDCLS_DISABLE_LIGHTPEN_EMULATION 67129
#define IDCLS_SET_LIGHTPEN_TYPE 67130
#define IDCLS_ENABLE_EASYFLASH_JUMPER 67131
#define IDCLS_DISABLE_EASYFLASH_JUMPER 67132
#define IDCLS_ENABLE_EASYFLASH_CRT_WRITING 67133
#define IDCLS_DISABLE_EASYFLASH_CRT_WRITING 67134
#define IDCLS_ENABLE_DIGIMAX 67135
#define IDCLS_DISABLE_DIGIMAX 67136
#define IDCLS_DIGIMAX_BASE 67137
#define IDCLS_ENABLE_DS12C887RTC 67138
#define IDCLS_DISABLE_DS12C887RTC 67139
#define IDCLS_DS12C887RTC_BASE 67140
#define IDS_VICE_ERROR 67141
#define IDS_VICE_INFORMATION 67142
#define IDS_FFMPEG_DLL_MISMATCH 67143
#define IDS_DIRECTDRAW_ERROR 67144
#define IDS_CANNOT_SAVE_SETTINGS 67145
#define IDS_CANNOT_LOAD_SETTINGS 67146
#define IDS_DEFAULT_SETTINGS_RESTORED 67147
#define IDS_CANNOT_ATTACH_FILE 67148
#define IDS_START_MONITOR 67149
#define IDS_VICE_CPU_JAM 67150
#define IDS_EXTEND_TO_40_TRACKS 67151
#define IDS_DETACHED_DEVICE_S 67152
#define IDS_ATTACHED_S_TO_DEVICE_S 67153
#define IDS_HISTORY_RECORDED_UNKNOWN 67154
#define IDS_HISTORY_RECORDED_VICE_S 67155
#define IDS_PAUSED 67156
#define IDS_FRAME_NUMBER 67157
#define IDS_RESUMED 67158
#define IDS_TFE_PROBLEM 67159
#define IDS_TFE_RRNET_SUPPORT 67160
#define IDS_CANNOT_AUTOSTART_FILE 67161
#define IDS_SETTINGS_SAVED_SUCCESS 67162
#define IDS_SETTINGS_LOADED_SUCCESS 67163
#define IDS_ATTACH_DISK_IMAGE 67164
#define IDS_INVALID_CARTRIDGE 67165
#define IDS_BAD_CARTRIDGE_CONFIG 67166
#define IDS_INVALID_CARTRIDGE_IMAGE 67167
#define IDS_LOG_CONSOLE_OUTPUT_IMAGE 67168
#define IDS_LOG_FILES_TYPE 67169
#define IDS_CANNOT_WRITE_LOGFILE_S 67170
#define IDS_SELECT_KEYMAP_FILE 67171
#define IDS_SAVE_KEYMAP_FILE 67172
#define IDS_CANNOT_WRITE_KEYMAP_FILE 67173
#define IDS_SAVE_CONFIG_FILE 67174
#define IDS_LOAD_CONFIG_FILE 67175
#define IDS_MAPPING 67176
#define IDS_KEYBOARD_SETTINGS 67177
#define IDS_PLEASE_ENTER_A_FILENAME 67178
#define IDS_CANNOT_CREATE_IMAGE 67179
#define IDS_COMMAND_LINE_OPTIONS 67180
#define IDS_COMMAND_OPTIONS_AVAIL 67181
#define IDS_NO_DRIVER_SELECT_SUPPORT 67182
#define IDS_CANT_WRITE_SCREENSHOT_S 67183
#define IDS_AUTOSTART_DISK_IMAGE 67184
#define IDS_SELECT_FS_DIRECTORY 67185
#define IDS_PRINTER_USERPORT 67186
#define IDS_PRINTER_4 67187
#define IDS_PRINTER_5 67188
#define IDS_DRIVE_8 67189
#define IDS_DRIVE_9 67190
#define IDS_DRIVE_10 67191
#define IDS_DRIVE_11 67192
#define IDS_PERIPHERAL_SETTINGS 67193
#define IDS_CANT_WRITE_SNAPSHOT_FILE 67194
#define IDS_LOAD_S_ROM_IMAGE 67195
#define IDS_SELECT_ROMSET_ARCHIVE 67196
#define IDS_CANNOT_LOAD_ROMSET_ARCH 67197
#define IDS_CANNOT_SAVE_ROMSET_ARCH 67198
#define IDS_CANNOT_LOAD_ROMSET_FILE 67199
#define IDS_CANNOT_SAVE_ROMSET_FILE 67200
#define IDS_SELECT_ROMSET_FILE 67201
#define IDS_ROMSET 67202
#define IDS_COMPUTER 67203
#define IDS_DRIVE 67204
#define IDS_ROM_SETTINGS 67205
#define IDS_COULD_NOT_LOAD_PALETTE 67206
#define IDS_LOAD_VICE_PALETTE_FILE 67207
#define IDS_FULLSCREEN 67208
#define IDS_FILE_SYSTEM 67209
#define IDS_REAL_IEC_DEVICE 67210
#define IDS_RS232_DEVICE_I 67211
#define IDS_ATTACH_CRT_CART_IMAGE 67212
#define IDS_ATTACH_RAW_8KB_CART_IMAGE 67213
#define IDS_ATTACH_RAW_16KB_CART_IMG 67214
#define IDS_ATTACH_AR_CART_IMAGE 67215
#define IDS_ATTACH_AR3_CART_IMAGE 67216
#define IDS_ATTACH_AR4_CART_IMAGE 67217
#define IDS_ATTACH_STARDOS_CART_IMAGE 67218
#define IDS_ATTACH_ATOMIC_P_CART_IMG 67219
#define IDS_ATTACH_EPYX_FL_CART_IMG 67220
#define IDS_ATTACH_IEEE488_CART_IMG 67221
#define IDS_ATTACH_RETRO_R_CART_IMG 67222
#define IDS_ATTACH_MMC_REPLAY_CART_IMG 67223
#define IDS_ATTACH_IDE64_CART_IMAGE 67224
#define IDS_ATTACH_SS4_CART_IMAGE 67225
#define IDS_ATTACH_SS5_CART_IMAGE 67226
#define IDS_ATTACH_STB_CART_IMAGE 67227
#define IDS_MODEL 67228
#define IDS_SELECT_START_SNAP_EVENT 67229
#define IDS_SELECT_END_SNAP_EVENT 67230
#define IDS_VERSION_S_UNSTABLE 67231
#define IDS_VERSION_S 67232
#define IDS_VICE_CONTRIBUTORS 67233
#define IDS_WHO_MADE_WHAT 67234
#define IDS_LICENSE 67235
#define IDS_NO_WARRANTY 67236
#define IDS_VICE_WITHOUT_WARRANTY 67237
#define IDS_PRESS_KEY_NORTHWEST 67238
#define IDS_PRESS_KEY_NORTH 67239
#define IDS_PRESS_KEY_NORTHEAST 67240
#define IDS_PRESS_KEY_EAST 67241
#define IDS_PRESS_KEY_SOUTHEAST 67242
#define IDS_PRESS_KEY_SOUTH 67243
#define IDS_PRESS_KEY_SOUTHWEST 67244
#define IDS_PRESS_KEY_WEST 67245
#define IDS_PRESS_KEY_FIRE 67246
#define IDS_NO_USERPORT_ADAPTER 67247
#define IDS_CGA_USERPORT_ADAPTER 67248
#define IDS_PET_USERPORT_ADAPTER 67249
#define IDS_HUMMER_USERPORT_ADAPTER 67250
#define IDS_OEM_USERPORT_ADAPTER 67251
#define IDS_HIT_USERPORT_ADAPTER 67252
#define IDS_KINGSOFT_USERPORT_ADAPTER 67253
#define IDS_STARBYTE_USERPORT_ADAPTER 67254
#define IDS_NO_SIDCART_JOY 67255
#define IDS_NUMPAD_AND_RCTRL 67256
#define IDS_KEYSET_A 67257
#define IDS_KEYSET_B 67258
#define IDS_ALL_BUTTONS_AS_FIRE 67259
#define IDS_NUMERIC_SEE_ABOVE 67260
#define IDS_NO_BUTTON_NO_AUTOFIRE 67261
#define IDS_ALL_FILES_FILTER 67262
#define IDS_PALETTE_FILES_FILTER 67263
#define IDS_SNAPSHOT_FILES_FILTER 67264
#define IDS_CBM_IMAGE_FILES_FILTER 67265
#define IDS_IDE64_IMAGE_FILES_FILTER 67266
#define IDS_DISK_IMAGE_FILES_FILTER 67267
#define IDS_TAPE_IMAGE_FILES_FILTER 67268
#define IDS_ZIPPED_FILES_FILTER 67269
#define IDS_CRT_FILES_FILTER 67270
#define IDS_RAW_CART_FILES_FILTER 67271
#define IDS_FLIP_LIST_FILES_FILTER 67272
#define IDS_ROMSET_FILES_FILTER 67273
#define IDS_ROMSET_ARCHIVES_FILTER 67274
#define IDS_KEYMAP_FILES_FILTER 67275
#define IDS_PRGP00_FILES_FILTER 67276
#define IDS_SOUND_DRIVER_DIRECTX 67277
#define IDS_SOUND_DRIVER_WMM 67278
#define IDS_MEDIA_FILES_FILTER 67279
#define IDS_SPACE_KB 67280
#define IDS_CONFIGURE_KEYSET_A 67281
#define IDS_CONFIGURE_KEYSET_B 67282
#define IDS_SAVE_MEDIA_IMAGE 67283
#define IDS_TAPE 67284
#define IDS_JOYSTICK_C 67285
#define IDS_RECORDING 67286
#define IDS_PLAYBACK 67287
#define IDS_UNKNOWN 67288
#define IDS_P_NUMBER 67289
#define IDS_NO_SAVE_SETTINGS_ON_EXIT 67290
#define IDS_CONFIRM_QUIT_VICE 67291
#define IDS_NO_CONFIRM_QUIT_VICE 67292
#define IDS_USE_ALL_CPU_SMP 67293
#define IDS_USE_FIRST_CPU_SMP 67294
#define IDS_START_VICE_FULLSCREEN_MODE 67295
#define IDS_DISABLE_DX9 67296
#define IDS_RECEIVED_SIGNAL_D_S 67297
#define IDS_RECEIVED_SIGNAL_D 67298
#define IDS_INVALID_PORT_NUMBER 67299
#define IDS_ERROR_STARTING_SERVER 67300
#define IDS_ERROR_CONNECTING_CLIENT 67301
#define IDS_OK 67302
#define IDS_SPECIFY_MIDI_IN 67303
#define IDS_SPECIFY_MIDI_OUT 67304
#define IDS_NO_EASYFLASH_CART_INSERTED 67305
#define IDS_DATASETTE_CAPTION 67306
#define IDS_DATASETTE_RESET_WITH_CPU 67307
#define IDS_DATASETTE_MOTOR_GROUP 67308
#define IDS_DATASETTE_DELAY_TRIGGER 67309
#define IDS_DATASETTE_DELAY_AT_ZERO 67310
#define IDS_TOGGLE_USEIECDEVICE 67311
#define IDS_SELECTDISK 67312
#define IDS_SELECTDIR 67313
#define IDS_SELECTREAL 67314
#define IDS_SELECTNONE 67315
#define IDS_AUTOSTART 67316
#define IDS_BROWSEDIR 67317
#define IDS_TOGGLE_ATTACH_READONLY 67318
#define IDS_TOGGLE_READP00 67319
#define IDS_TOGGLE_WRITEP00 67320
#define IDS_TOGGLE_HIDENONP00 67321
#define IDS_JOYSTICK_CAPTION 67322
#define IDS_SELECT_FIRE_BUTTON 67323
#define IDS_AUTO_FIRE_BUTTON_SETTINGS 67324
#define IDS_AUTOFIRE_SPEED 67325
#define IDS_JOY_CONFIG_A 67326
#define IDS_JOY_CONFIG_B 67327
#define IDS_JOY_CALIBRATE 67328
#define IDS_EXTRA_JOYSTICK_CAPTION 67329
#define IDS_JOYSTICK_IN_EXTRA_PORT_1 67330
#define IDS_JOYSTICK_IN_EXTRA_PORT_2 67331
#define IDS_KEYSET_SW 67332
#define IDS_KEYSET_S 67333
#define IDS_KEYSET_SE 67334
#define IDS_KEYSET_W 67335
#define IDS_KEYSET_E 67336
#define IDS_KEYSET_NW 67337
#define IDS_KEYSET_N 67338
#define IDS_KEYSET_NE 67339
#define IDS_KEYSET_FIRE 67340
#define IDS_SOUND_CAPTION 67341
#define IDS_SOUND_DIRECTX 67342
#define IDS_SOUND_WMM 67343
#define IDS_SOUND_SAMPLE_FREQUENCY 67344
#define IDS_SOUND_BUFFER_SIZE 67345
#define IDS_SOUND_FRAGMENT_SIZE_LABEL 67346
#define IDS_SOUND_FRAGMENT_SIZE_SMALL 67347
#define IDS_SOUND_FRAGMENT_SIZE_MEDIUM 67348
#define IDS_SOUND_FRAGMENT_SIZE_LARGE 67349
#define IDS_SOUND_SYNCH_METHOD 67350
#define IDS_TOGGLE_SNAPSHOT_SAVE_DISKS 67351
#define IDS_TOGGLE_SNAPSHOT_SAVE_ROMS 67352
#define IDS_FULLSCREEN_DRIVER 67353
#define IDS_FULLSCREEN_DRVR_BITDEPTH 67354
#define IDS_FULLSCREEN_DRVR_RESOLUTION 67355
#define IDS_FULLSCREEN_DRVR_REFRESHRATE 67356
#define IDS_TOGGLE_VIDEO_VBLANK_SYNC 67357
#define IDS_TOGGLE_VIDEO_DX_PRIMARY 67358
#define IDS_TOGGLE_KEEP_ASPECT_RATIO 67359
#define IDS_TOGGLE_TRUE_ASPECT_RATIO 67360
#define IDS_VAL_F_FOR_S_OUT_RANGE_USE_F 67361
#define IDS_VAL_D_FOR_S_OUT_RANGE_USE_D 67362
#define IDS_AUDIO_LEAK 67363
#define IDS_COLORS_GAMMA 67364
#define IDS_COLORS_TINT 67365
#define IDS_COLORS_SATURATION 67366
#define IDS_COLORS_CONTRAST 67367
#define IDS_COLORS_BRIGHTNESS 67368
#define IDS_CRT_SCANLINE_SHADE 67369
#define IDS_CRT_BLUR 67370
#define IDS_CRT_ODDLINE_PHASE 67371
#define IDS_CRT_ODDLINE_OFFSET 67372
#define IDS_VICII_PALETTE 67373
#define IDS_VIC_PALETTE 67374
#define IDS_CRTC_PALETTE 67375
#define IDS_VDC_PALETTE 67376
#define IDS_TED_PALETTE 67377
#define IDS_VICII_COLORS 67378
#define IDS_VIC_COLORS 67379
#define IDS_CRTC_COLORS 67380
#define IDS_VDC_COLORS 67381
#define IDS_TED_COLORS 67382
#define IDS_VICII_CRT_EMULATION 67383
#define IDS_VIC_CRT_EMULATION 67384
#define IDS_CRTC_CRT_EMULATION 67385
#define IDS_VDC_CRT_EMULATION 67386
#define IDS_TED_CRT_EMULATION 67387
#define IDS_VICII_RENDER_FILTER 67388
#define IDS_VIC_RENDER_FILTER 67389
#define IDS_CRTC_RENDER_FILTER 67390
#define IDS_VDC_RENDER_FILTER 67391
#define IDS_TED_RENDER_FILTER 67392
#define IDS_VICII_AUDIO_LEAK 67393
#define IDS_VIC_AUDIO_LEAK 67394
#define IDS_CRTC_AUDIO_LEAK 67395
#define IDS_VDC_AUDIO_LEAK 67396
#define IDS_TED_AUDIO_LEAK 67397
#define IDS_TOGGLE_VIDEO_EXTPALETTE 67398
#define IDS_RAM_CAPTION 67399
#define IDS_RAM_INIT_AT_POWERUP 67400
#define IDS_RAM_VALUE_FIRST_BYTE 67401
#define IDS_RAM_LENGTH_CONSTANT_VALUES 67402
#define IDS_RAM_LENGTH_CONSTANT_PATTERN 67403
#define IDS_PRINTER_EMULATION 67404
#define IDS_PRINTER_FORMFEED 67405
#define IDS_FILESYSTEM_PRINTER 67406
#define IDS_PRINTER_DRVR 67407
#define IDS_OUTPUT 67408
#define IDS_OUTPUT_TO_FILE 67409
#define IDS_OUTPUT_FILE1_NAME 67410
#define IDS_OUTPUT_FILE2_NAME 67411
#define IDS_OUTPUT_FILE3_NAME 67412
#define IDS_ROMSET_SELECT_ARCHIVE 67413
#define IDS_ROMSET_ARCHIVE_LOAD 67414
#define IDS_ROMSET_ARCHIVE_SAVE 67415
#define IDS_ROMSET_CONFIGURATION 67416
#define IDS_ROMSET_ARCHIVE_APPLY 67417
#define IDS_ROMSET_ARCHIVE_NEW 67418
#define IDS_ROMSET_ARCHIVE_DELETE 67419
#define IDS_ROMSET_SELECT_FILE 67420
#define IDS_ROMSET_FILE_LOAD 67421
#define IDS_ROMSET_FILE_SAVE 67422
#define IDS_CUSTOM_SPEED_CAPTION 67423
#define IDS_ENTER_CUSTOM_SPEED 67424
#define IDS_NEW_CONFIGURATION 67425
#define IDS_ENTER_CONFIGURATION_NAME 67426
#define IDS_RS232_CAPTION 67427
#define IDS_RS232_DEV_1 67428
#define IDS_RS232_DEV_2 67429
#define IDS_RS232_DEV_3 67430
#define IDS_RS232_DEV_4 67431
#define IDS_NETWORK_CAPTION 67432
#define IDS_NETWORK_SERVER 67433
#define IDS_NETWORK_CLIENT 67434
#define IDS_NETWORK_DISCONNECT 67435
#define IDS_CONTROL 67436
#define IDS_SERVER 67437
#define IDS_CLIENT 67438
#define IDS_JOYSTICK_1 67439
#define IDS_JOYSTICK_2 67440
#define IDS_DEVICES 67441
#define IDS_SETTINGS 67442
#define IDS_TOGGLE_CONSOLE_APPEND 67443
#define IDS_ID 67444
#define IDS_TYPE 67445
#define IDS_BLANK_IMAGE 67446
#define IDS_SELECT_DRIVER 67447
#define IDS_FFMPEG_SETTINGS 67448
#define IDS_FORMAT 67449
#define IDS_AUDIO_CODEC 67450
#define IDS_BITRATE 67451
#define IDS_VIDEO_CODEC 67452
#define IDS_SOUND_RECORD_CAPTION 67453
#define IDS_SOUND_RECORD_FORMAT_LABEL 67454
#define IDS_SOUND_RECORD_FILE_LABEL 67455
#define IDS_KERNAL 67456
#define IDS_BASIC 67457
#define IDS_CHARACTER 67458
#define IDS_COMPUTER_RESOURCES_CAPTION 67459
#define IDS_COMPUTER_RESOURCES 67460
#define IDS_DRIVE_RESOURCES_CAPTION 67461
#define IDS_DRIVE_RESOURCES 67462
#define IDS_SYMBOLIC 67463
#define IDS_POSITIONAL 67464
#define IDS_DUMP_KEYSET 67465
#define IDS_DUMP_SHORTCUTS 67466
#define IDS_SYMBOLIC_US 67467
#define IDS_SYMBOLIC_DE 67468
#define IDS_GR_SYM 67469
#define IDS_GR_POS 67470
#define IDS_UK_SYM 67471
#define IDS_UK_POS 67472
#define IDS_DE_SYM 67473
#define IDS_DE_POS 67474
#define IDS_SELECT_DRIVE_EXTEND_NEVER 67475
#define IDS_SELECT_DRIVE_EXTEND_ASK 67476
#define IDS_SELECT_DRIVE_EXTEND_ACCESS 67477
#define IDS_SELECT_DRIVE_IDLE_TRAP_IDLE 67478
#define IDS_SELECT_DRIVE_IDLE_SKIP_CYC 67479
#define IDS_TOGGLE_DRIVE_PARALLEL_CABLE 67480
#define IDS_TOGGLE_DRIVE_EXPANSION_2000 67481
#define IDS_TOGGLE_DRIVE_EXPANSION_4000 67482
#define IDS_TOGGLE_DRIVE_EXPANSION_6000 67483
#define IDS_TOGGLE_DRIVE_EXPANSION_8000 67484
#define IDS_TOGGLE_DRIVE_EXPANSION_A000 67485
#define IDS_PLUS4_VIC20_MEMORY 67486
#define IDS_SID_GENGROUP1 67487
#define IDS_MP_FILE 67488
#define IDS_MP_ATTACH_DISK_IMAGE 67489
#define IDS_MP_DETACH_DISK_IMAGE 67490
#define IDS_MP_FLIP_LIST 67491
#define IDS_MP_DATASETTE_CONTROL 67492
#define IDS_MP_ATTACH_CARTRIDGE_IMAGE 67493
#define IDS_MP_RESET 67494
#define IDS_MP_DEBUG 67495
#define IDS_MP_MODE 67496
#define IDS_MP_EDIT 67497
#define IDS_MP_SNAPSHOT 67498
#define IDS_MP_RECORDING_START_MODE 67499
#define IDS_MP_OPTIONS 67500
#define IDS_MP_REFRESH_RATE 67501
#define IDS_MP_MAXIMUM_SPEED 67502
#define IDS_MP_VIDEO_STANDARD 67503
#define IDS_MP_DRIVE_SYNC_FACTOR 67504
#define IDS_MP_SETTINGS 67505
#define IDS_MP_CARTRIDGE_IO_SETTINGS 67506
#define IDS_MP_LANGUAGE 67507
#define IDS_MP_HELP 67508
#define IDS_MP_VIEW 67509
#define IDS_MP_WINDOW 67510
#define IDS_MI_EXIT 67511
#define IDS_MI_ABOUT 67512
#define IDS_MI_PAUSE 67513
#define IDS_MI_EDIT_COPY 67514
#define IDS_MI_EDIT_PASTE 67515
#define IDS_MI_AUTOSTART 67516
#define IDS_MI_RESET_HARD 67517
#define IDS_MI_RESET_SOFT 67518
#define IDS_MI_DRIVE8 67519
#define IDS_MI_DRIVE9 67520
#define IDS_MI_DRIVE10 67521
#define IDS_MI_DRIVE11 67522
#define IDS_MI_ATTACH_TAPE 67523
#define IDS_MI_DETACH_TAPE 67524
#define IDS_MI_DETACH_ALL 67525
#define IDS_MI_TOGGLE_SOUND 67526
#define IDS_MI_TOGGLE_DOUBLESIZE 67527
#define IDS_MI_TOGGLE_DOUBLESCAN 67528
#define IDS_MI_TOGGLE_DOUBLEVERTICAL 67529
#define IDS_MI_DRIVE_TRUE_EMULATION 67530
#define IDS_MI_DRIVE_SOUND_EMULATION 67531
#define IDS_MI_AUTOSTART_HANDLE_TDE 67532
#define IDS_MI_TOGGLE_VIDEOCACHE 67533
#define IDS_MI_DRIVE_SETTINGS 67534
#define IDS_MI_CART_SMART_ATTACH 67535
#define IDS_MI_CART_ATTACH_CRT 67536
#define IDS_MI_CART_ATTACH_8KB 67537
#define IDS_MI_CART_ATTACH_16KB 67538
#define IDS_MI_CART_ATTACH_AR 67539
#define IDS_MI_CART_ATTACH_AR3 67540
#define IDS_MI_CART_ATTACH_AR4 67541
#define IDS_MI_CART_ATTACH_STARDOS 67542
#define IDS_MI_CART_ATTACH_AT 67543
#define IDS_MI_CART_ATTACH_EPYX 67544
#define IDS_MI_CART_ATTACH_IEEE488 67545
#define IDS_MI_CART_ATTACH_RR 67546
#define IDS_MI_CART_ATTACH_MMC_REPLAY 67547
#define IDS_MI_CART_ATTACH_IDE64 67548
#define IDS_MI_CART_ATTACH_SS4 67549
#define IDS_MI_CART_ATTACH_SS5 67550
#define IDS_MI_CART_ATTACH_STB 67551
#define IDS_MI_FLIP_ADD 67552
#define IDS_MI_FLIP_REMOVE 67553
#define IDS_MI_FLIP_NEXT 67554
#define IDS_MI_FLIP_PREVIOUS 67555
#define IDS_MI_FLIP_LOAD 67556
#define IDS_MI_FLIP_SAVE 67557
#define IDS_MI_DATASETTE_STOP 67558
#define IDS_MI_DATASETTE_START 67559
#define IDS_MI_DATASETTE_FORWARD 67560
#define IDS_MI_DATASETTE_REWIND 67561
#define IDS_MI_DATASETTE_RECORD 67562
#define IDS_MI_DATASETTE_RESET 67563
#define IDS_MI_DATASETTE_RESET_COUNTER 67564
#define IDS_MI_CART_SET_DEFAULT 67565
#define IDS_MI_TOGGLE_CART_RESET 67566
#define IDS_MI_CART_DETACH 67567
#define IDS_MI_CART_FREEZE 67568
#define IDS_MI_MONITOR 67569
#define IDS_MI_DEBUG_MODE_NORMAL 67570
#define IDS_MI_DEBUG_MODE_SMALL 67571
#define IDS_MI_DEBUG_MODE_HISTORY 67572
#define IDS_MI_DEBUG_MODE_AUTOPLAY 67573
#define IDS_MI_TOGGLE_MAINCPU_TRACE 67574
#define IDS_MI_TOGGLE_DRIVE0CPU_TRACE 67575
#define IDS_MI_TOGGLE_DRIVE1CPU_TRACE 67576
#define IDS_MI_SNAPSHOT_LOAD 67577
#define IDS_MI_SNAPSHOT_SAVE 67578
#define IDS_MI_LOADQUICK 67579
#define IDS_MI_SAVEQUICK 67580
#define IDS_MI_EVENT_TOGGLE_RECORD 67581
#define IDS_MI_EVENT_TOGGLE_PLAYBACK 67582
#define IDS_MI_EVENT_SETMILESTONE 67583
#define IDS_MI_EVENT_RESETMILESTONE 67584
#define IDS_MI_EVENT_START_MODE_SAVE 67585
#define IDS_MI_EVENT_START_MODE_LOAD 67586
#define IDS_MI_EVENT_START_MODE_RESET 67587
#define IDS_MI_EVENT_START_MODE_PLAYBCK 67588
#define IDS_MI_EVENT_DIRECTORY 67589
#define IDS_MI_MEDIAFILE 67590
#define IDS_MI_SOUND_RECORD_START 67591
#define IDS_MI_SOUND_RECORD_STOP 67592
#define IDS_MI_REFRESH_RATE_AUTO 67593
#define IDS_MI_MAXIMUM_SPEED_NO_LIMIT 67594
#define IDS_MI_MAXIMUM_SPEED_CUSTOM 67595
#define IDS_MI_TOGGLE_WARP_MODE 67596
#define IDS_MI_TOGGLE_ALWAYSONTOP 67597
#define IDS_MI_TOGGLE_DX9DISABLE 67598
#define IDS_MI_SWAP_JOYSTICK 67599
#define IDS_MI_SWAP_EXTRA_JOYSTICK 67600
#define IDS_MI_ALLOW_JOY_OPPOSITE 67601
#define IDS_MI_JOYKEYS_TOGGLE 67602
#define IDS_MI_TOGGLE_VIRTUAL_DEVICES 67603
#define IDS_MI_MOUSE 67604
#define IDS_MI_C64MODEL_SETTINGS 67605
#define IDS_MI_AUTOSTART_SETTINGS 67606
#define IDS_MI_VIDEO_SETTINGS 67607
#define IDS_MI_DEVICEMANAGER 67608
#define IDS_MI_JOY_SETTINGS 67609
#define IDS_MI_USERPORT_JOY_SETTINGS 67610
#define IDS_MI_SIDCART_JOY_SETTINGS 67611
#define IDS_MI_KEYBOARD_SETTINGS 67612
#define IDS_MI_SOUND_SETTINGS 67613
#define IDS_MI_ROM_SETTINGS 67614
#define IDS_MI_RAM_SETTINGS 67615
#define IDS_MI_DATASETTE_SETTINGS 67616
#define IDS_MI_VICII_SETTINGS 67617
#define IDS_MI_MOUSE_SETTINGS 67618
#define IDS_MI_SID_SETTINGS 67619
#define IDS_MI_RS232_SETTINGS 67620
#define IDS_MI_REU_SETTINGS 67621
#define IDS_MI_GEORAM_SETTINGS 67622
#define IDS_MI_RAMCART_SETTINGS 67623
#define IDS_MI_DQBB_SETTINGS 67624
#define IDS_MI_EXPERT_SETTINGS 67625
#define IDS_MI_ISEPIC_SETTINGS 67626
#define IDS_MI_MMC64_SETTINGS 67627
#define IDS_MI_MMCREPLAY_SETTINGS 67628
#define IDS_MI_RR_SETTINGS 67629
#define IDS_MI_MAGICVOICE_SETTINGS 67630
#define IDS_MI_MIDI_SETTINGS 67631
#define IDS_MI_DIGIMAX_SETTINGS 67632
#define IDS_MI_DS12C887RTC_SETTINGS 67633
#define IDS_MI_LIGHTPEN_SETTINGS 67634
#define IDS_MI_IDE64_SETTINGS 67635
#define IDS_MI_TFE_SETTINGS 67636
#define IDS_MI_ACIA_SETTINGS 67637
#define IDS_MI_RS232USER_SETTINGS 67638
#define IDS_MI_EASYFLASH_SETTINGS 67639
#define IDS_MI_SFX_SE_SETTINGS 67640
#define IDS_MI_TOGGLE_SFX_SS 67641
#define IDS_MI_TOGGLE_USERPORT_RTC 67642
#define IDS_MI_SETTINGS_SAVE_FILE 67643
#define IDS_MI_SETTINGS_LOAD_FILE 67644
#define IDS_MI_SETTINGS_SAVE 67645
#define IDS_MI_SETTINGS_LOAD 67646
#define IDS_MI_SETTINGS_DEFAULT 67647
#define IDS_MI_SAVE_SETTINGS_ON_EXIT 67648
#define IDS_MI_CONFIRM_ON_EXIT 67649
#define IDS_MI_LANG_EN 67650
#define IDS_MI_LANG_DA 67651
#define IDS_MI_LANG_DE 67652
#define IDS_MI_LANG_ES 67653
#define IDS_MI_LANG_FR 67654
#define IDS_MI_LANG_HU 67655
#define IDS_MI_LANG_IT 67656
#define IDS_MI_LANG_KO 67657
#define IDS_MI_LANG_NL 67658
#define IDS_MI_LANG_PL 67659
#define IDS_MI_LANG_RU 67660
#define IDS_MI_LANG_SV 67661
#define IDS_MI_LANG_TR 67662
#define IDS_MI_CMDLINE 67663
#define IDS_MI_CONTRIBUTORS 67664
#define IDS_MI_LICENSE 67665
#define IDS_MI_WARRANTY 67666
#define IDS_MI_TOGGLE_FULLSCREEN 67667
#define IDS_MI_SIDCART_SETTINGS 67668
#define IDS_MI_MON_OPEN 67669
#define IDS_MI_MON_SAVE 67670
#define IDS_MI_MON_PRINT 67671
#define IDS_MI_MON_EXIT 67672
#define IDS_MI_MON_STOP_DEBUG 67673
#define IDS_MI_MON_STOP_EXEC 67674
#define IDS_MI_MON_STEP_INTO 67675
#define IDS_MI_MON_STEP_OVER 67676
#define IDS_MI_MON_SKIP_RETURN 67677
#define IDS_MI_MON_GOTO_CURSOR 67678
#define IDS_MI_MON_EVAL 67679
#define IDS_MI_MON_CURRENT 67680
#define IDS_MI_MON_WND_EVAL 67681
#define IDS_MI_MON_WND_REG 67682
#define IDS_MI_MON_WND_MEM 67683
#define IDS_MI_MON_WND_DIS 67684
#define IDS_MI_MON_WND_CONSOLE 67685
#define IDS_MI_MON_COMPUTER 67686
#define IDS_MI_MON_DRIVE8 67687
#define IDS_MI_MON_DRIVE9 67688
#define IDS_MI_MON_CASCADE 67689
#define IDS_MI_MON_TILE_VERT 67690
#define IDS_MI_MON_TILE_HORIZ 67691
#define IDS_MI_MON_ARRANGE_ICONS 67692
#endif
