//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#ifndef TIMEMACHINE_H
#define TIMEMACHINE_H
#include <vice.h>
#include <jni.h>

typedef struct {
    int widht;
    int height;
    int depth;
    jbyte* pixeldata;
} screenshot;
typedef struct {
    void* data;
    size_t size;
    size_t alloc_size;
    uint64_t timestamp;
    int valid;
    screenshot screen;
} moment;


typedef struct {
    void(*tick)(void* instance);
    void(*shutdown)(void* instance);
    void(*pause)(void* instance);
    void(*set_paused)(void* instance, int is_paused);
    int(*get_snapshot_count)(void* instance);
    void(*travel)(void* instance, int milisecs_ago, jobject runnable);
    int(*write_newest_entry)(void* instance, const char* path);
    int(*write_entry)(void* instance, int ellapsed_time, const char* path);
    void(*set_current_screendata)(void* p, int w, int h, int d, jbyte* data);
    moment* _ringbuffer;
    int _ringbuffer_size;
    struct timeval *_last_tick_time;
    int _ispaused;
    int _trap_pending;
    int _counter;
    int _first_after_timetravel;
    uint64_t _elapsed_time;
    int _ringbuffer_cursor;
    int _snapshot_interval;
    screenshot _screenshot;
} timemachine;

__attribute__((used)) void timemachine_init(int number_of_snapshots, int interval_in_ms);

void timemachine_tick();

__attribute__((used)) void timemachine_travel(int minimal_elapsed_seconds, jobject runnable);

__attribute__((used)) void timemachine_set_paused (int paused);

__attribute__((used)) int timemachine_is_paused ();

__attribute__((used)) int timemachine_store_last_entry(const char* path);


#endif //TIMEMACHINE_H

