//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <string.h>
#include "archdep.h"
#include "resources.h"
#include "logginghelpers.h"

__attribute__((used)) int get_int_resource(char* name, int defaultval)
{
    int ret;
    if (resources_get_int(name,&ret))
    {
        ret=defaultval;
    }
    return ret;
}

__attribute__((used)) char* get_string_resource(char* name,const char* defaultval)
{
    const char* ret;
    if (resources_get_string(name,&ret))
    {
        ret=defaultval;
    }
    return (char*)ret;
}

__attribute__((used)) int read_resources_from_string(char* s)
{
    char filename[1024];
    int paused = timemachine_is_paused();
    timemachine_set_paused(1);
    snprintf(filename,1024,"memmap::%p:%d",s,(int)strlen(s)+1);
    int ret = resources_load(filename);
    timemachine_set_paused(paused);
    return ret;
}

__attribute__((used)) int get_resource_type(const char* name) {
    enum resource_type_s type = resources_query_type(name);
    if (type == RES_INTEGER) {
        return 1;
    }
    if (type == RES_STRING) {
        return 2;
    }
    return 0;
}