//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#include <vice.h>
#include <joyport/mouse.h>
#include <string.h>
#include "mousedrv.h"
static mouse_func_t mousefunc = {NULL, NULL, NULL, NULL, NULL};
int mousedrv_resources_init(__unused mouse_func_t *funcs)
{
    memcpy(&mousefunc, funcs, sizeof(mouse_func_t));
	return 0;
}
extern int mousedrv_cmdline_options_init(void)
{
	return 0;
}
extern void mousedrv_init(void)
{
}
extern void mousedrv_mouse_changed(void)
{
}

__attribute__((used)) void mousebutton_pressed(int left, int right) {
    if (mousefunc.mbl) {
        mousefunc.mbl(left ? 1 :0);
    }
    if (mousefunc.mbr) {
        mousefunc.mbr(right ? 1 :0);
    }
}