//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include "messages.h"
#include "jnihelpers.h"
static void postString(char* methodname,char* value)
{
	jobject obj=CurrentActivity();
	jmethodID mth=GetMethodID(GetObjectClass(obj),methodname,"(Ljava/lang/String;)V");
	jstring s=NewStringUTF(value);
	CallVoidMethod(obj,mth,s);
	DeleteLocalRef(s);
}
void postMessage(char* value)
{
	postString("postMessage",value);
}
void postError(char* value)
{
	postString("postError",value);

}
