//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#include <stdio.h>
#include "archdep.h"
#include "jnihelpers.h"

#ifdef DEBUG
extern t_shared_data* g_shareddata;

__attribute__((used)) void dump_memory_leaks(const char* s) {
    FILE* f = fopen(s,"wb");
    if (f) {
        fprintf(f,"FILE,LINE,SIZE,ADRESS\n");
        int leakcount=get_leak_count();
        for (int i=0;i<leakcount;i++) {

            fprintf(f, "%s,%u,%u,%p\n",
                    get_leak_filename(i), get_leak_line(i),
                    get_leak_size(i), get_leak_address(i));
        }
        fclose(f);
    }

            /*
            LOGV("Leaks");
            int leakcount=0;//get_leak_count();
            for (int i=0;i<leakcount;i++) {


            LOGV("%s:%u: Warning: Memory block(s) allocated here was not free'd (Memory leak with size 0x%x at %p).",
                   get_leak_filename(i), get_leak_line(i),
                   get_leak_size(i), get_leak_address(i));
            }

             */
}
#endif