//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------



#ifndef EIGHTBITWONDERS_MACHINE_SPECIFIC_BINDINGS_H
#include "gen_machine_specific_bindings.h"
void populate_callbacks(t_machine_specific_bindings bindings);
void populate_machine_specific_functions();
void set_console_mode(int v);
void set_video_disabled_mode(int v);

#define COMMA ,
#define VALUE_RETURN_FUNCTION(type, label, paramdecl, paramnames, on_error_return) \
inline type label (paramdecl) {                                            \
    if (!bindings.label) {                                      \
        raiseException(#label);                                 \
        return on_error_return;                                     \
    }                                                           \
    return bindings.label(paramnames);                               \
}

#define VOID_FUNCTION(label, paramdecl, paramnames) \
inline void label (paramdecl) {                                            \
    if (!bindings.label) {                                      \
        raiseException(#label);                                 \
        return;                                     \
    }                                                           \
    bindings.label(paramnames);                               \
}

#endif //EIGHTBITWONDERS_MACHINE_SPECIFIC_BINDINGS_H