//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <vice.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <resources.h>
#include <keyboard.h>
#include <lib.h>
#include "kbd.h"
#include "jnihelpers.h"
#include "logginghelpers.h"

static char* keymapping="gtk3_pos.vkm";



static int set_keymapping(const char* val, __unused void *param) {
    int ret;
    int type;
    static jmethodID mth_clear = NULL;
    if (!val)
    {
        val="gtk3_pos.vkm";
    }
    if (strstr(val,"gtk3_pos")==val)
    {
        type=KBD_INDEX_USERPOS;
    }
    else
    {
        type=KBD_INDEX_USERSYM;
    }
    ret=keyboard_set_keymap_index(type,0);
    if (ret) {
        if (!mth_clear)
        {
            mth_clear = GetMethodID(GetObjectClass(CurrentActivity()),"clearStoredKeys","()V");
        }
        if (mth_clear) {
            CallVoidMethod(CurrentActivity(), mth_clear);
        }
        else {
            ret=-1;
        }
    }
    ret=ret?ret:keyboard_set_keymap_file((const char*)val,int_to_void_ptr(type));
    LOGV("set_keymapping(%s)->%d",val, ret);
    return ret;
}
static const resource_string_t resources_string[] = {
        { "keymapping", "pos", RES_EVENT_NO, NULL,
          &keymapping, set_keymapping, NULL },
        RESOURCE_STRING_LIST_END
};


extern void kbd_arch_init(void)
{
    resources_register_string(resources_string);
}
signed long kbd_arch_keyname_to_keynum(char *keyname)
{
    static jmethodID mth_add=NULL;
    static jmethodID mth_get=NULL;
    unsigned int keynum;

    if (!mth_get) {
        mth_get = GetMethodID(GetObjectClass(CurrentActivity()), "getGtkKeycode",
                                    "(Ljava/lang/String;)I");
    }

    if (mth_get) {
        jstring jstr = NewStringUTF(keyname);
        keynum = CallIntMethod(CurrentActivity(),mth_get,jstr);
        if (keynum > 0) {
            if (!mth_add) {
                mth_add = GetMethodID(GetObjectClass(CurrentActivity()), "storedKey", "(I)V");
            }
            if (mth_add) {
                CallVoidMethod(CurrentActivity(), mth_add, keynum);
            }
        }
        //ReleaseStringUTFChars(jstr,keyname);
        DeleteLocalRef(jstr);
        return (long) keynum;
    }
    return -1;

}

const char *kbd_arch_keynum_to_keyname(signed long keynum)
{
    static char keyname[20];

    memset(keyname, 0, 20);
    sprintf(keyname, "%li", keynum);
    return keyname;
}
extern void kbd_initialize_numpad_joykeys(__unused int *joykeys)
{
}
extern int get_keyboard_mapping(const char* language)
{
    mapping_info_t * map=keyboard_get_info_list();
    int i=0;
    while (1)
    {
        if (strcmp(map[i].mapping_name,language)==0)
        {
            return map[i].mapping;
        }
        if (!map[i].mapping_name)
        {
            return -1;
        }
        i++;
    }
}
