//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include "imagecontents.h"
#include "diskcontents.h"
#include "tapecontents.h"
#include "charset.h"
#include "logginghelpers.h"

struct image_contents_s* contentlist=NULL;
image_contents_file_list_t * cursor=NULL;
int imagecontentslist_create(const char* filename)
{
	if (contentlist)
	{
		image_contents_destroy(contentlist);
	}
    contentlist = diskcontents_filesystem_read(filename);
    if (contentlist == NULL) {
        contentlist = tapecontents_read(filename);
    }
    if (contentlist!=NULL)
    {
    	cursor=NULL;
    	return 0;
    }
	return -1;
}
char* imagecontentslist_getTitleName()
{
	//return contentlist?charset_petconvstring(contentlist->name,1):NULL;
	return (char*) (contentlist?contentlist->name:NULL);
}
char* imagecontentlist_getTitleId()
{
	//return contentlist?charset_petconvstring(contentlist->id,1):NULL
	return (char*) (contentlist?contentlist->id:NULL);
}
int imagecontentlist_getFreeBlocks()
{
	return contentlist?contentlist->blocks_free:-1;
}
char* imagecontentlist_getFileName()
{
	return (char*) (cursor?cursor->name:NULL);

}
char* imagecontentlist_getFileType()
{
	//return cursor?charset_petconvstring(cursor->type,1):NULL;
	return (char*) (cursor?cursor->type:NULL);
}
int imagecontentslist_nextEntry()
{
	if (cursor)
	{
		cursor=cursor->next;
		if (!cursor)
		{
			image_contents_destroy(contentlist);
			contentlist=NULL;
		}
	}
	else
	{
		cursor=contentlist->file_list;
	}
	return cursor!=NULL?1:0;
}
