//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifdef HAVE_COMMON_SO
#include <string.h>
#include "machine_specific_bindings.h"
#include "gen_machine_specific_bindings.h"

static t_machine_specific_bindings bindings = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,  NULL};

void raiseException(const char* missing_function);

void populate_callbacks(t_machine_specific_bindings machine_bindings) {
	memcpy(&bindings, &machine_bindings, sizeof(t_machine_specific_bindings));
}
VALUE_RETURN_FUNCTION (int,main_program,int argc COMMA  char **argv,argc COMMA argv,(int)0);
VOID_FUNCTION(main_exit,void,);
VALUE_RETURN_FUNCTION (struct raster_s*,vicii_init,unsigned int flag,flag,(struct raster_s*)0);
VOID_FUNCTION(mem_initialize_memory,void,);
VOID_FUNCTION(mem_powerup,void,);
VALUE_RETURN_FUNCTION (int,mem_load,void,,(int)0);
VOID_FUNCTION(mem_get_basic_text,uint16_t *start COMMA  uint16_t *end,start COMMA end);
VOID_FUNCTION(mem_set_basic_text,uint16_t start COMMA  uint16_t end,start COMMA end);
VOID_FUNCTION(mem_toggle_watchpoints,int flag COMMA  void *context,flag COMMA context);
VALUE_RETURN_FUNCTION (int,mem_rom_trap_allowed,uint16_t addr,addr,(int)0);
VOID_FUNCTION(mem_mmu_translate,unsigned int addr COMMA  uint8_t **base COMMA  int *start COMMA  int *limit,addr COMMA base COMMA start COMMA limit);
VOID_FUNCTION(mem_color_ram_to_snapshot,uint8_t *color_ram,color_ram);
VOID_FUNCTION(mem_color_ram_from_snapshot,uint8_t *color_ram,color_ram);
VALUE_RETURN_FUNCTION (uint8_t,mem_read_screen,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(mem_inject,uint32_t addr COMMA  uint8_t value,addr COMMA value);
VOID_FUNCTION(mem_inject_key,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (const char**,mem_bank_list,void,,(const char**)0);
VALUE_RETURN_FUNCTION (const int*,mem_bank_list_nos,void,,(const int*)0);
VALUE_RETURN_FUNCTION (int,mem_bank_from_name,const char *name,name,(int)0);
VALUE_RETURN_FUNCTION (int,mem_bank_index_from_bank,int bank,bank,(int)0);
VALUE_RETURN_FUNCTION (int,mem_bank_flags_from_bank,int bank,bank,(int)0);
VALUE_RETURN_FUNCTION (uint8_t,mem_bank_read,int bank COMMA  uint16_t addr COMMA  void *context,bank COMMA addr COMMA context,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,mem_bank_peek,int bank COMMA  uint16_t addr COMMA  void *context,bank COMMA addr COMMA context,(uint8_t)0);
VOID_FUNCTION(mem_bank_write,int bank COMMA  uint16_t addr COMMA  uint8_t byte COMMA  void *context,bank COMMA addr COMMA byte COMMA context);
VOID_FUNCTION(mem_bank_poke,int bank COMMA  uint16_t addr COMMA  uint8_t byte COMMA  void *context,bank COMMA addr COMMA byte COMMA context);
VOID_FUNCTION(mem_get_screen_parameter,uint16_t *base COMMA  uint8_t *rows COMMA  uint8_t *columns COMMA  int *bank,base COMMA rows COMMA columns COMMA bank);
VOID_FUNCTION(mem_get_cursor_parameter,uint16_t *screen_addr COMMA  uint8_t *cursor_column COMMA  uint8_t *line_length COMMA  int *blinking,screen_addr COMMA cursor_column COMMA line_length COMMA blinking);
VALUE_RETURN_FUNCTION (mem_ioreg_list_t*,mem_ioreg_list_get,void *context,context,(mem_ioreg_list_t*)0);
VALUE_RETURN_FUNCTION (int,mem_write_snapshot_module,struct snapshot_s *s COMMA  int save_roms,s COMMA save_roms,(int)0);
VALUE_RETURN_FUNCTION (int,mem_read_snapshot_module,struct snapshot_s *s,s,(int)0);
VOID_FUNCTION(mididrv_init,void,);
VALUE_RETURN_FUNCTION (int,mididrv_in_open,void,,(int)0);
VALUE_RETURN_FUNCTION (int,mididrv_out_open,void,,(int)0);
VOID_FUNCTION(mididrv_in_close,void,);
VOID_FUNCTION(mididrv_out_close,void,);
VALUE_RETURN_FUNCTION (int,mididrv_in,uint8_t *b,b,(int)0);
VOID_FUNCTION(mididrv_out,uint8_t b,b);
VALUE_RETURN_FUNCTION (int,mididrv_resources_init,void,,(int)0);
VOID_FUNCTION(mididrv_resources_shutdown,void,);
VALUE_RETURN_FUNCTION (int,mididrv_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(machine_printer_setup_context,struct machine_context_s *machine_context,machine_context);
VALUE_RETURN_FUNCTION (int,machine_printer_resources_init,void,,(int)0);
VOID_FUNCTION(machine_printer_resources_shutdown,void,);
VALUE_RETURN_FUNCTION (int,machine_printer_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(machine_printer_init,void,);
VOID_FUNCTION(machine_printer_shutdown,void,);
VOID_FUNCTION(vsyncarch_advance_frame,void,);
VALUE_RETURN_FUNCTION (int,vsyncarch_vbl_sync_enabled,void,,(int)0);
VALUE_RETURN_FUNCTION (int,ssi2001_drv_open,void,,(int)0);
VALUE_RETURN_FUNCTION (int,ssi2001_drv_close,void,,(int)0);
VALUE_RETURN_FUNCTION (int,ssi2001_drv_read,uint16_t addr COMMA  int chipno,addr COMMA chipno,(int)0);
VOID_FUNCTION(ssi2001_drv_store,uint16_t addr COMMA  uint8_t val COMMA  int chipno,addr COMMA val COMMA chipno);
VALUE_RETURN_FUNCTION (int,ssi2001_drv_available,void,,(int)0);
VALUE_RETURN_FUNCTION (int,machine_video_resources_init,void,,(int)0);
VOID_FUNCTION(machine_video_init,void,);
VALUE_RETURN_FUNCTION (struct video_canvas_s*,machine_video_canvas_get,unsigned int window,window,(struct video_canvas_s*)0);
VOID_FUNCTION(video_canvas_map,struct video_canvas_s *canvas,canvas);
VOID_FUNCTION(video_canvas_unmap,__unused struct video_canvas_s *canvas,canvas);
VOID_FUNCTION(maincpu_resync_limits,void,);
VOID_FUNCTION(maincpu_init,void,);
VOID_FUNCTION(maincpu_early_init,void,);
VOID_FUNCTION(maincpu_shutdown,void,);
VOID_FUNCTION(maincpu_reset,void,);
VOID_FUNCTION(maincpu_mainloop,void,);
VALUE_RETURN_FUNCTION (struct monitor_interface_s*,maincpu_monitor_interface_get,void,,(struct monitor_interface_s*)0);
VALUE_RETURN_FUNCTION (int,maincpu_snapshot_read_module,struct snapshot_s *s,s,(int)0);
VALUE_RETURN_FUNCTION (int,maincpu_snapshot_write_module,struct snapshot_s *s,s,(int)0);
VOID_FUNCTION(maincpu_set_pc,int p0,p0);
VOID_FUNCTION(maincpu_set_a,int p0,p0);
VOID_FUNCTION(maincpu_set_x,int p0,p0);
VOID_FUNCTION(maincpu_set_y,int p0,p0);
VOID_FUNCTION(maincpu_set_sign,int p0,p0);
VOID_FUNCTION(maincpu_set_zero,int p0,p0);
VOID_FUNCTION(maincpu_set_carry,int p0,p0);
VOID_FUNCTION(maincpu_set_interrupt,int p0,p0);
VALUE_RETURN_FUNCTION (unsigned int,maincpu_get_pc,void,,(unsigned int)0);
VALUE_RETURN_FUNCTION (unsigned int,maincpu_get_a,void,,(unsigned int)0);
VALUE_RETURN_FUNCTION (unsigned int,maincpu_get_x,void,,(unsigned int)0);
VALUE_RETURN_FUNCTION (unsigned int,maincpu_get_y,void,,(unsigned int)0);
VALUE_RETURN_FUNCTION (unsigned int,maincpu_get_sp,void,,(unsigned int)0);
VALUE_RETURN_FUNCTION (int,parsid_drv_open,void,,(int)0);
VOID_FUNCTION(parsid_drv_out_ctr,uint8_t parsid_ctrport COMMA  int chipno,parsid_ctrport COMMA chipno);
VALUE_RETURN_FUNCTION (uint8_t,parsid_drv_in_ctr,int chipno,chipno,(uint8_t)0);
VALUE_RETURN_FUNCTION (int,parsid_drv_close,void,,(int)0);
VALUE_RETURN_FUNCTION (uint8_t,parsid_drv_in_data,int chipno,chipno,(uint8_t)0);
VOID_FUNCTION(parsid_drv_out_data,uint8_t addr COMMA  int chipno,addr COMMA chipno);
VOID_FUNCTION(parsid_drv_sleep,int amount,amount);
VALUE_RETURN_FUNCTION (int,parsid_drv_available,void,,(int)0);
VALUE_RETURN_FUNCTION (int,machine_resources_init,void,,(int)0);
VOID_FUNCTION(machine_resources_shutdown,void,);
VALUE_RETURN_FUNCTION (int,machine_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(machine_setup_context,void,);
VALUE_RETURN_FUNCTION (int,machine_specific_init,void,,(int)0);
VOID_FUNCTION(machine_specific_reset,void,);
VOID_FUNCTION(machine_specific_powerup,void,);
VOID_FUNCTION(machine_specific_shutdown,void,);
VOID_FUNCTION(machine_set_restore_key,int v,v);
VALUE_RETURN_FUNCTION (int,machine_has_restore_key,void,,(int)0);
VALUE_RETURN_FUNCTION (long,machine_get_cycles_per_second,void,,(long)0);
VALUE_RETURN_FUNCTION (long,machine_get_cycles_per_frame,void,,(long)0);
VOID_FUNCTION(machine_set_cycles_per_frame,long cpf,cpf);
VOID_FUNCTION(machine_get_line_cycle,unsigned int *line COMMA  unsigned int *cycle COMMA  int *half_cycle,line COMMA cycle COMMA half_cycle);
VALUE_RETURN_FUNCTION (int,machine_write_snapshot,const char *name COMMA  int save_roms COMMA int save_disks COMMA  int even_mode,name COMMA save_roms COMMA save_disks COMMA even_mode,(int)0);
VALUE_RETURN_FUNCTION (int,machine_read_snapshot,const char *name COMMA  int even_mode,name COMMA even_mode,(int)0);
VOID_FUNCTION(machine_handle_pending_alarms,int num_write_cycles,num_write_cycles);
VALUE_RETURN_FUNCTION (int,machine_autodetect_psid,const char *name,name,(int)0);
VOID_FUNCTION(machine_play_psid,int tune,tune);
VALUE_RETURN_FUNCTION (int,machine_sid2_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid3_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid4_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid5_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid6_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid7_check_range,unsigned int sid_adr,sid_adr,(int)0);
VALUE_RETURN_FUNCTION (int,machine_sid8_check_range,unsigned int sid_adr,sid_adr,(int)0);
VOID_FUNCTION(machine_change_timing,int timeval COMMA  int border_mode,timeval COMMA border_mode);
VALUE_RETURN_FUNCTION (int,machine_screenshot,struct screenshot_s *screenshot COMMA struct video_canvas_s *canvas,screenshot COMMA canvas,(int)0);
VALUE_RETURN_FUNCTION (int,machine_canvas_async_refresh,struct canvas_refresh_s *ref COMMA struct video_canvas_s *canvas,ref COMMA canvas,(int)0);
VOID_FUNCTION(machine_update_memory_ptrs,void,);
VALUE_RETURN_FUNCTION (struct image_contents_s*,machine_diskcontents_bus_read,unsigned int unit,unit,(struct image_contents_s*)0);
VOID_FUNCTION(machine_romset_init,void,);
VALUE_RETURN_FUNCTION (int,machine_romset_file_load,const char *filename,filename,(int)0);
VALUE_RETURN_FUNCTION (int,machine_romset_file_save,const char *filename,filename,(int)0);
VALUE_RETURN_FUNCTION (char*,machine_romset_file_list,void,,(char*)0);
VALUE_RETURN_FUNCTION (int,machine_romset_archive_item_create,const char *romset_name,romset_name,(int)0);
VALUE_RETURN_FUNCTION (uint8_t,machine_tape_type_default,void,,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,machine_tape_behaviour,void,,(uint8_t)0);
VALUE_RETURN_FUNCTION (int,machine_addr_in_ram,unsigned int addr,addr,(int)0);
VALUE_RETURN_FUNCTION (const char*,machine_get_name,void,,(const char*)0);
VALUE_RETURN_FUNCTION (int,machine_get_num_keyboard_types,void,,(int)0);
VALUE_RETURN_FUNCTION (kbdtype_info_t*,machine_get_keyboard_info_list,void,,(kbdtype_info_t*)0);
VALUE_RETURN_FUNCTION (int,machine_get_keyboard_type,void,,(int)0);
VALUE_RETURN_FUNCTION (char*,machine_get_keyboard_type_name,int type,type,(char*)0);
VALUE_RETURN_FUNCTION (int,machine_register_userport,void,,(int)0);
VALUE_RETURN_FUNCTION (int,c64scui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,c64dtvui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,c64dtvui_init,void,,(int)0);
VOID_FUNCTION(c64dtvui_shutdown,void,);
VALUE_RETURN_FUNCTION (int,catweaselmkiii_drv_open,void,,(int)0);
VALUE_RETURN_FUNCTION (int,catweaselmkiii_drv_close,void,,(int)0);
VALUE_RETURN_FUNCTION (int,catweaselmkiii_drv_read,uint16_t addr COMMA  int chipno,addr COMMA chipno,(int)0);
VOID_FUNCTION(catweaselmkiii_drv_store,uint16_t addr COMMA  uint8_t val COMMA  int chipno,addr COMMA val COMMA chipno);
VOID_FUNCTION(catweaselmkiii_drv_set_machine_parameter,long cycles_per_sec,cycles_per_sec);
VALUE_RETURN_FUNCTION (int,catweaselmkiii_drv_available,void,,(int)0);
VOID_FUNCTION(disk_image_rawimage_name_set,disk_image_t *image COMMA  const char *name,image COMMA name);
VOID_FUNCTION(disk_image_rawimage_driver_name_set,disk_image_t *image,image);
VALUE_RETURN_FUNCTION (int,sidcart_cmdline_options_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sidcart_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sidcart_enabled,void,,(int)0);
VOID_FUNCTION(sidcart_sound_chip_init,void,);
VOID_FUNCTION(sidcart_detach,void,);
VALUE_RETURN_FUNCTION (int,sidcart_snapshot_write_module,snapshot_t *s,s,(int)0);
VALUE_RETURN_FUNCTION (int,sidcart_snapshot_read_module,snapshot_t *s,s,(int)0);
VALUE_RETURN_FUNCTION (export_list_t*,export_query_list,export_list_t *item,item,(export_list_t*)0);
VOID_FUNCTION(export_dump,void,);
VALUE_RETURN_FUNCTION (int,export_add,const export_resource_t *export_res,export_res,(int)0);
VALUE_RETURN_FUNCTION (int,export_remove,const export_resource_t *export_res,export_res,(int)0);
VALUE_RETURN_FUNCTION (int,export_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d000_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d000_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d000_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d100_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d100_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d100_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d200_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d200_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d200_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d300_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d300_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d300_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d400_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d400_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d400_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d500_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d500_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d500_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d600_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d600_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d600_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d700_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_d700_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_d700_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_de00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_de00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_de00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,c64io_df00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,c64io_df00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(c64io_df00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,vic20io0_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,vic20io0_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(vic20io0_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,vic20io2_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,vic20io2_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(vic20io2_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,vic20io3_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,vic20io3_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(vic20io3_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_d800_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_d800_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_d800_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_d900_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_d900_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_d900_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_da00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_da00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_da00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_db00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_db00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_db00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_dc00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_dc00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_dc00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_dd00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_dd00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_dd00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_de00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_de00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_de00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_df00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,cbm2io_df00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cbm2io_df00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8800_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8800_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8800_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8900_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8900_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8900_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8a00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8a00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8a00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8b00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8b00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8b00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8c00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8c00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8c00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8d00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8d00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8d00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8e00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8e00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8e00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_8f00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_8f00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_8f00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_e900_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_e900_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_e900_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_ea00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_ea00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_ea00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_eb00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_eb00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_eb00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_ec00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_ec00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_ec00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_ed00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_ed00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_ed00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_ee00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_ee00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_ee00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,petio_ef00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,petio_ef00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(petio_ef00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,plus4io_fd00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,plus4io_fd00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(plus4io_fd00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VALUE_RETURN_FUNCTION (uint8_t,plus4io_fe00_read,uint16_t addr,addr,(uint8_t)0);
VALUE_RETURN_FUNCTION (uint8_t,plus4io_fe00_peek,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(plus4io_fe00_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
VOID_FUNCTION(io_source_ioreg_add_list,struct mem_ioreg_list_s **mem_ioreg_list,mem_ioreg_list);
VALUE_RETURN_FUNCTION (io_source_list_t*,io_source_register,io_source_t *device,device,(io_source_list_t*)0);
VOID_FUNCTION(io_source_unregister,io_source_list_t *device,device);
VOID_FUNCTION(cartio_shutdown,void,);
VOID_FUNCTION(c64io_vicii_init,void,);
VOID_FUNCTION(c64io_vicii_deinit,void,);
VOID_FUNCTION(c64io_vicii_reinit,void,);
VALUE_RETURN_FUNCTION (int,cartio_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,cartio_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(cartio_set_highest_order,unsigned int nr,nr);
VOID_FUNCTION(machine_bus_init_machine,void,);
VALUE_RETURN_FUNCTION (int,machine_bus_lib_directory,unsigned int unit COMMA  const char *pattern COMMA uint8_t **buf,unit COMMA pattern COMMA buf,(int)0);
VALUE_RETURN_FUNCTION (int,machine_bus_lib_read_sector,unsigned int unit COMMA  unsigned int track COMMA unsigned int sector COMMA  uint8_t *buf,unit COMMA track COMMA sector COMMA buf,(int)0);
VALUE_RETURN_FUNCTION (int,machine_bus_lib_write_sector,unsigned int unit COMMA  unsigned int track COMMA unsigned int sector COMMA  uint8_t *buf,unit COMMA track COMMA sector COMMA buf,(int)0);
VALUE_RETURN_FUNCTION (unsigned int,machine_bus_device_type_get,unsigned int unit,unit,(unsigned int)0);
VOID_FUNCTION(machine_bus_status_truedrive_set,unsigned int enable,enable);
VOID_FUNCTION(machine_bus_status_drivetype_set,unsigned int unit COMMA unsigned int enable,unit COMMA enable);
VOID_FUNCTION(machine_bus_status_virtualdevices_set,unsigned int enable,enable);
VOID_FUNCTION(machine_bus_eof_callback_set,void (*func)(void),func);
VOID_FUNCTION(machine_bus_attention_callback_set,void (*func)(void),func);
VALUE_RETURN_FUNCTION (int,cbm2ui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,cbm2ui_init,void,,(int)0);
VOID_FUNCTION(cbm2ui_shutdown,void,);
VALUE_RETURN_FUNCTION (int,cbm5x0ui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,cbm5x0ui_init,void,,(int)0);
VOID_FUNCTION(cbm5x0ui_shutdown,void,);
VALUE_RETURN_FUNCTION (int,machine_drive_resources_init,void,,(int)0);
VOID_FUNCTION(machine_drive_resources_shutdown,void,);
VALUE_RETURN_FUNCTION (int,machine_drive_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(machine_drive_init,struct diskunit_context_s *drv,drv);
VOID_FUNCTION(machine_drive_shutdown,struct diskunit_context_s *drv,drv);
VOID_FUNCTION(machine_drive_reset,struct diskunit_context_s *drv,drv);
VOID_FUNCTION(machine_drive_mem_init,struct diskunit_context_s *drv COMMA  unsigned int type,drv COMMA type);
VOID_FUNCTION(machine_drive_setup_context,struct diskunit_context_s *drv,drv);
VOID_FUNCTION(machine_drive_idling_method,unsigned int dnr,dnr);
VOID_FUNCTION(machine_drive_rom_load,void,);
VOID_FUNCTION(machine_drive_rom_setup_image,unsigned int dnr,dnr);
VALUE_RETURN_FUNCTION (int,machine_drive_rom_check_loaded,unsigned int type,type,(int)0);
VOID_FUNCTION(machine_drive_rom_do_checksum,unsigned int dnr,dnr);
VALUE_RETURN_FUNCTION (int,machine_drive_snapshot_read,struct diskunit_context_s *ctxptr COMMA  struct snapshot_s *s,ctxptr COMMA s,(int)0);
VALUE_RETURN_FUNCTION (int,machine_drive_snapshot_write,struct diskunit_context_s *ctxptr COMMA  struct snapshot_s *s,ctxptr COMMA s,(int)0);
VALUE_RETURN_FUNCTION (int,machine_drive_image_attach,struct disk_image_s *image COMMA  unsigned int unit COMMA  unsigned int drive,image COMMA unit COMMA drive,(int)0);
VALUE_RETURN_FUNCTION (int,machine_drive_image_detach,struct disk_image_s *image COMMA  unsigned int unit COMMA  unsigned int drive,image COMMA unit COMMA drive,(int)0);
VOID_FUNCTION(machine_drive_port_default,struct diskunit_context_s *drv,drv);
VOID_FUNCTION(machine_drive_flush,void,);
VOID_FUNCTION(machine_drive_stub,void,);
VALUE_RETURN_FUNCTION (struct drive_type_info_s*,machine_drive_get_type_info_list,void,,(struct drive_type_info_s*)0);
VALUE_RETURN_FUNCTION (int,vsid_ui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,vsid_ui_init,void,,(int)0);
VOID_FUNCTION(vsid_ui_close,void,);
VOID_FUNCTION(vsid_ui_display_name,__unused const char *name,name);
VOID_FUNCTION(vsid_ui_display_author,__unused const char *author,author);
VOID_FUNCTION(vsid_ui_display_copyright,__unused const char *copyright,copyright);
VOID_FUNCTION(vsid_ui_display_sync,int sync,sync);
VOID_FUNCTION(vsid_ui_display_sid_model,int model,model);
VOID_FUNCTION(vsid_ui_display_tune_nr,int nr,nr);
VOID_FUNCTION(vsid_ui_display_nr_of_tunes,int count,count);
VOID_FUNCTION(vsid_ui_set_default_tune,int nr,nr);
VOID_FUNCTION(vsid_ui_display_time,unsigned int sec,sec);
VOID_FUNCTION(vsid_ui_display_irqtype,const char *irq,irq);
VOID_FUNCTION(vsid_ui_setdrv,char* driver_info_text,driver_info_text);
VOID_FUNCTION(vsid_ui_set_driver_addr,uint16_t addr,addr);
VOID_FUNCTION(vsid_ui_set_load_addr,uint16_t addr,addr);
VOID_FUNCTION(vsid_ui_set_init_addr,uint16_t addr,addr);
VOID_FUNCTION(vsid_ui_set_play_addr,uint16_t addr,addr);
VOID_FUNCTION(vsid_ui_set_data_size,uint16_t size,size);
VALUE_RETURN_FUNCTION (int,ps2mouse_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,ps2mouse_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(blockdev_init,void,);
VALUE_RETURN_FUNCTION (int,blockdev_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,blockdev_cmdline_options_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,blockdev_open,const char *name COMMA  unsigned int *read_only,name COMMA read_only,(int)0);
VALUE_RETURN_FUNCTION (int,blockdev_close,void,,(int)0);
VALUE_RETURN_FUNCTION (int,blockdev_read_sector,BYTE *buf COMMA  unsigned int track COMMA unsigned int sector,buf COMMA track COMMA sector,(int)0);
VALUE_RETURN_FUNCTION (int,blockdev_write_sector,const BYTE *buf COMMA  unsigned int track COMMA unsigned int sector,buf COMMA track COMMA sector,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_sb_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_ce_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_vidc_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_beos_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_bsp_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_flac_device,void,,(int)0);
VALUE_RETURN_FUNCTION (int,sound_init_vorbis_device,void,,(int)0);
VALUE_RETURN_FUNCTION (char*,sound_machine_dump_state,sound_t *psid,psid,(char*)0);
VOID_FUNCTION(sound_machine_prevent_clk_overflow,sound_t *psid COMMA  CLOCK sub,psid COMMA sub);
VOID_FUNCTION(sound_machine_enable,int enable,enable);
VALUE_RETURN_FUNCTION (int,iec_available_busses,void,,(int)0);
VOID_FUNCTION(iec_update_ports_embedded,void,);
VOID_FUNCTION(iec_drive_write,uint8_t data COMMA  unsigned int dnr,data COMMA dnr);
VALUE_RETURN_FUNCTION (uint8_t,iec_drive_read,unsigned int dnr,dnr,(uint8_t)0);
VOID_FUNCTION(parallel_cable_drive_write,int port COMMA  uint8_t data COMMA  int handshake COMMA  unsigned int dnr,port COMMA data COMMA handshake COMMA dnr);
VALUE_RETURN_FUNCTION (uint8_t,parallel_cable_drive_read,int port COMMA  int handshake,port COMMA handshake,(uint8_t)0);
VOID_FUNCTION(iec_fast_drive_write,uint8_t data COMMA  unsigned int dnr,data COMMA dnr);
VOID_FUNCTION(iec_fast_drive_direction,int direction COMMA  unsigned int dnr,direction COMMA dnr);
VOID_FUNCTION(iec_update_cpu_bus,uint8_t data,data);
VOID_FUNCTION(iec_update_ports,void,);
VOID_FUNCTION(plus4tcbm_update_pa,uint8_t byte COMMA  unsigned int dnr,byte COMMA dnr);
VOID_FUNCTION(plus4tcbm_update_pb,uint8_t byte COMMA  unsigned int dnr,byte COMMA dnr);
VOID_FUNCTION(plus4tcbm_update_pc,uint8_t byte COMMA  unsigned int dnr,byte COMMA dnr);
VOID_FUNCTION(ui_display_statustext,const char *text COMMA  int fade_out,text COMMA fade_out);
VALUE_RETURN_FUNCTION (int,plus4ui_init_early,void,,(int)0);
VALUE_RETURN_FUNCTION (int,plus4ui_init,void,,(int)0);
VOID_FUNCTION(plus4ui_shutdown,void,);
VALUE_RETURN_FUNCTION (int,uimon_get_columns,struct console_private_s *t,t,(int)0);
VOID_FUNCTION(uimon_write_to_terminal,struct console_private_s *t COMMA  const char *data COMMA  long length,t COMMA data COMMA length);
VALUE_RETURN_FUNCTION (int,uimon_get_string,struct console_private_s *t COMMA  char* string COMMA  int string_len,t COMMA string COMMA string_len,(int)0);
VALUE_RETURN_FUNCTION (bool,uimon_set_font,void,,(bool)0);
VALUE_RETURN_FUNCTION (int,uicolor_alloc_color,unsigned int red COMMA  unsigned int green COMMA unsigned int blue COMMA  unsigned long *color_pixel COMMA uint8_t *pixel_return,red COMMA green COMMA blue COMMA color_pixel COMMA pixel_return,(int)0);
VOID_FUNCTION(uicolor_free_color,unsigned int red COMMA  unsigned int green COMMA unsigned int blue COMMA  unsigned long color_pixel,red COMMA green COMMA blue COMMA color_pixel);
VOID_FUNCTION(uicolor_convert_color_table,unsigned int colnr COMMA  uint8_t *data COMMA long color_pixel COMMA  void *c,colnr COMMA data COMMA color_pixel COMMA c);
VALUE_RETURN_FUNCTION (int,uicolor_set_palette,struct video_canvas_s *c COMMA const struct palette_s *palette,c COMMA palette,(int)0);
VALUE_RETURN_FUNCTION (int,uicolor_alloc_colors,struct video_canvas_s *c,c,(int)0);
VALUE_RETURN_FUNCTION (iecbus_t*,iecbus_drive_port,void,,(iecbus_t*)0);
VOID_FUNCTION(cartridge_init,void,);
VALUE_RETURN_FUNCTION (int,cartridge_resources_init,void,,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_cmdline_options_init,void,,(int)0);
VOID_FUNCTION(cartridge_shutdown,void,);
VOID_FUNCTION(cartridge_resources_shutdown,void,);
VOID_FUNCTION(cartridge_init_config,void,);
VALUE_RETURN_FUNCTION (int,cartridge_detect,const char *filename,filename,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_attach_image,int type COMMA  const char *filename,type COMMA filename,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_enable,int type,type,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_disable,int type,type,(int)0);
VOID_FUNCTION(cartridge_detach_image,int type,type);
VOID_FUNCTION(cartridge_set_default,void,);
VOID_FUNCTION(cartridge_unset_default,void,);
VOID_FUNCTION(cartridge_reset,void,);
VOID_FUNCTION(cartridge_trigger_freeze,void,);
VOID_FUNCTION(cartridge_trigger_freeze_nmi_only,void,);
VOID_FUNCTION(cartridge_release_freeze,void,);
VALUE_RETURN_FUNCTION (const char*,cartridge_get_file_name,int type,type,(const char*)0);
VALUE_RETURN_FUNCTION (int,cartridge_type_enabled,int type,type,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_save_image,int type COMMA  const char *filename,type COMMA filename,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_bin_save,int type COMMA  const char *filename,type COMMA filename,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_crt_save,int type COMMA  const char *filename,type COMMA filename,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_flush_image,int type,type,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_can_flush_image,int crtid,crtid,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_can_save_image,int crtid,crtid,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_snapshot_read_modules,struct snapshot_s *s,s,(int)0);
VALUE_RETURN_FUNCTION (int,cartridge_snapshot_write_modules,struct snapshot_s *s,s,(int)0);
VOID_FUNCTION(cartridge_setup_context,struct machine_context_s *machine_context,machine_context);
VALUE_RETURN_FUNCTION (uint8_t,cartridge_peek_mem,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(cartridge_mmu_translate,unsigned int addr COMMA  uint8_t **base COMMA  int *start COMMA  int *limit,addr COMMA base COMMA start COMMA limit);
VOID_FUNCTION(cartridge_ram_init,void,);
VOID_FUNCTION(cartridge_sound_chip_init,void,);
VALUE_RETURN_FUNCTION (cartridge_info_t*,cartridge_get_info_list,void,,(cartridge_info_t*)0);
VOID_FUNCTION(machine_trigger_flux_change,unsigned int on,on);
VOID_FUNCTION(machine_set_tape_sense,int sense,sense);
VOID_FUNCTION(machine_set_tape_write_in,int val,val);
VOID_FUNCTION(machine_set_tape_motor_in,int val,val);
VOID_FUNCTION(machine_sid2_enable,int val,val);
VOID_FUNCTION(sid_sound_chip_init,void,);
VALUE_RETURN_FUNCTION (uint8_t,mem_read,uint16_t addr,addr,(uint8_t)0);
VOID_FUNCTION(mem_store,uint16_t addr COMMA  uint8_t value,addr COMMA value);
#endif