//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include "diskimage.h"
#include "tape.h"
#include "machine.h"
#include <stdlib.h>
#include "lib.h"
#include "p64.h"
#include "fsimage.h"
#include "crt.h"
#include "snapshot.h"
#include "de_rainerhock_eightbitwonders_vice_ViceEmulation.h"
static int is_diskimage(const char* filename)
{
    int ret;
    disk_image_t image;

    image.gcr = NULL;
    image.p64 = lib_malloc(sizeof(TP64Image));
    image.read_only = 1;
    fsimage_media_create(&image);
    fsimage_name_set(&image, strdup(filename));
    ret= fsimage_open(&image) == 0 ? 1 : 0;
    fsimage_media_destroy(&image);
    return ret;
}
static int is_tapeimage(const char* filename)
{
    int ret;
    tape_image_t image;
    image.read_only=1;
    image.name=strdup(filename);
    ret=tape_image_open(&image)==0?1:0;
    free(image.name);
    return ret;
}
/*
static int is_crt_image(const char* filename)
{
    int ret;
    char* abspath=strdup(filename);

    ret=crt_getid(abspath)>=0?1:0;
    free(abspath);
    return ret;
}
 */
static int is_snapshot(const char* filename)
{
    int ret;
    BYTE major_version_return;
    BYTE minor_version_return;

    snapshot_t *snapshot = snapshot_open(filename, &major_version_return, &minor_version_return, machine_get_name());
    ret=snapshot!=NULL?1:0;
    if (ret)
    {
        snapshot_close(snapshot);
    }
    return ret;
}
int get_filetype (const char* filename) {
    if (is_diskimage(filename))
    {
        return 1;
    }
    else if (is_tapeimage(filename))
    {
        return 2;
    }
    else if (is_snapshot(filename))
    {
        return 5;
    }
    return 0;
}
