//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vdrive-internal.h"
#include "charset.h"
#include "diskimage.h"
#include "cbmimage.h"
#include "lib.h"
#include "util.h"


__attribute__((used)) int create_emptydisk(const char* path, const char* diskname, const char* diskid, int disktype)
{
	char* diskfullname;
	char dname2[16+1], id2[2+1];
	int ret=-1;
    memset(dname2,0, sizeof (dname2));
    memset(id2,0, sizeof (id2));

    if (!diskid) {
        strcpy(id2, "00");
    }
    else
    {
        strncpy(id2, diskid,2);
    }
    charset_petconvstring((unsigned char*)id2, 0);
    if (!diskname)
    {
        dname2[0] = 0;
    }
    else
    {
        strncpy(dname2, diskname,16);
        charset_petconvstring((unsigned char*)dname2, 0);
    }
    diskfullname = util_concat(dname2, ",", id2, NULL);
	if (diskfullname)
	{
		ret=vdrive_internal_create_format_disk_image(path,diskfullname,disktype);
		lib_free(diskfullname);
	}
	return ret;


}



