//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders.vice;

import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import de.rainerhock.eightbitwonders.Emulation;
import de.rainerhock.eightbitwonders.R;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/**
 * This activity contains the vice-specific user-interface for the creation of
 * new disk- and tape-images.
 */
public final class ViceCreateImageActivity extends ViceMediaActionActivity {
    private void setButtonState() {
        EditText et = findViewById(R.id.et_name);
        Spinner sp = findViewById(R.id.sp_typ);
        Button b = findViewById(R.id.bn_create_image);
        b.setEnabled(!et.getText().toString().isEmpty() && sp.getSelectedItem().hashCode() >= 0);
    }
    static class FileExtension implements Emulation.DataEntry {
        private final int mId;
        private final String mText;
        FileExtension(final String key) {
            if (key.isEmpty()) {
                mId = 0;
                mText = "";
            } else {
                String[] split = key.split(":");
                mId = Integer.parseInt(split[0]);
                mText = split[1];
            }
        }
        @Override
        public boolean equals(@Nullable final Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return mId;
        }

        @NonNull
        @Override
        public String toString() {
            return mText;
        }

        @Override
        public String getText() {
            return toString();
        }
    }
    @Override
    protected void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_vice_create_image);
        ((EditText) findViewById(R.id.et_name)).addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(final CharSequence s,
                                          final int start,
                                          final int count,
                                          final int after) {
            }

            @Override
            public void onTextChanged(final CharSequence s,
                                      final int start,
                                      final int before,
                                      final int count) {
                setButtonState();
            }

            @Override
            public void afterTextChanged(final Editable s) {
            }
        });
        List<FileExtension> entries = new LinkedList<>();
        Spinner sp = findViewById(R.id.sp_typ);


        int pos = 0;
        int activeelement = 0;
        for (String s : getResources().getStringArray(R.array.image_extensions)) {
            FileExtension e = new FileExtension(s);
            entries.add(e);
            if (e.getText().equals(ViceEmulation.DEFAULT_IMAGE_EXTENSION)) {
                activeelement = pos;
            }
            pos++;
        }
        ArrayAdapter<FileExtension> adapter =
                new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, entries);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        sp.setAdapter(adapter);
        sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(final AdapterView<?> parent,
                                       final View view,
                                       final int position,
                                       final long id) {
                FileExtension o = (FileExtension) parent.getItemAtPosition(position);
                findViewById(R.id.diskcontent).setVisibility(
                        o.hashCode() > 0 && o.hashCode() != ViceEmulation.TYPE_DATASETTE
                                ? View.VISIBLE : View.GONE);
                setButtonState();
            }

            @Override
            public void onNothingSelected(final AdapterView<?> parent) {
            }
        });
        sp.setSelection(activeelement);
        findViewById(R.id.bn_create_image).setOnClickListener(v -> {
            Intent i = new Intent();
            Object selection = sp.getSelectedItem();
            int type = selection.hashCode();
            String id = ((EditText) findViewById(R.id.et_id)).getText().toString();
            String name = ((EditText) findViewById(R.id.et_name)).getText().toString();
            String extension = selection.toString();
            HashMap<String, String> createdata = new HashMap<>();
            createdata.put("name", name);
            createdata.put("type", String.valueOf(type));
            createdata.put("extension", extension);
            createdata.put("id", id);
            i.putExtra("createdata", createdata);
            i.putExtra("filename", name + "." + extension);
            setResult(RESULT_OK, i);
            finish();
        });
    }
}
