//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders.vice;

import androidx.annotation.Keep;

import de.rainerhock.eightbitwonders.EmulationConfiguration;
import de.rainerhock.eightbitwonders.EmulationUi;
import de.rainerhock.eightbitwonders.R;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Emulation for the C64.
 */
@Keep
final class C64Emulation extends C64C128CommonBase {
    /**
     * Constructor for C64-Emulation.
     * @param ui Implementation of the {@link de.rainerhock.eightbitwonders.EmulationUi}
     * interface for Callbacks to Userinterface
     * @param config Configuration
     */
    C64Emulation(final EmulationUi ui, final EmulationConfiguration config) {
        super(ui, config);
    }

    @Override
    protected ViceMachineSettingsFunctions getViceMachineSettingsFunctions() {
        return new ViceMachineSettingsFunctions("c64model_set",
                Arrays.asList("MachineVideoStandard", "SidModel", "CIA1Model", "CIA2Model",
                        "BoardType", "IECReset", "KernalRev"),
                Arrays.asList("KernalName", "ChargenName"),
                Arrays.asList(R.id.gh_c64_settings, R.id.gh_vic_ii_settings, R.id.sidsettings,
                        R.id.c64model),
                Arrays.asList(R.id.gh_c64_settings, R.id.gh_vic_ii_settings, R.id.sidsettings),
                null) {
            @Override
            protected String getDeviceSpecificModelDefault() {
                return getEmulationActivity().isInNtscRegion() ? "3" : "0";
            }

            @Override
            protected Map<String, String> getDeviceSpecificDefaultValues() {
                LinkedHashMap<String, String> ret = new LinkedHashMap<>(
                        super.getDeviceSpecificDefaultValues());
                ret.put("VICIIDoubleSize", "1");
                ret.put("VICIIFilter", "0");
                return ret;
            }
        };
    }

    @Override
    protected int getCompactKeyboardLayoutId(final int model) {
        return R.layout.fragment_c64_keyboard;
    }

    @Override
    protected int getExactKeyboardLayoutId(final int model) {
        return R.layout.fragment_c64_keyboard_fullsized;
    }
}
