//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.content.res.Resources;
import android.view.KeyEvent;

import java.util.Collections;
import java.util.Set;

abstract class VirtualJoystick extends SimpleSettingsJoystick {

    @Override
    int getHardwareId() {
        return VIRTUAL_HARDWARE_ID;
    }

    @Override
    String getHardwareDescriptor() {
        return "###virtual###";
    }
    abstract int getPseudoKeycode();

    @Override
    boolean hasSecondaryButton() {
        return false;
    }

    private boolean mGamepadButtonPressed = false;
    protected static final Set<Integer> FIRE_PRESSED
            = Collections.singleton(KeyEvent.KEYCODE_DPAD_CENTER);
    protected static final Set<Integer> FIRE_NOT_PRESSED = Collections.emptySet();
    protected void setRealButtonsPressed(final boolean isPressed) {
        setRealButtonsPressed(isPressed ? FIRE_PRESSED : FIRE_NOT_PRESSED);
    }
    @Override
    protected final void setRealButtonsPressed(final Set<Integer> buttons) {
        Emulation.GamepadFunctions gm = getmGamepadListener();
        if (gm != null) {
            boolean value = !buttons.isEmpty();
            if (value != mGamepadButtonPressed) {
                mGamepadButtonPressed = value;
                if (value) {
                    if (gm.onButtonPressed(getPseudoKeycode())) {
                        return;
                    }
                } else {
                    if (gm.onButtonReleased(getPseudoKeycode())) {
                        return;
                    }
                }

            }
        }
        super.setRealButtonsPressed(buttons);
    }
    abstract boolean isPreferredType(EmulationConfiguration.PreferredJoystickType type);
    private JoystickStickView mDirectionView = null;
    private JoystickFireView mFireView = null;

    protected boolean isRightHanded(final EmulationActivity activity) {
        Resources res = activity.getResources();
        String rightval = res.getString(R.string.value_joystick_button_right);
        String val = activity.getCurrentUseropts()
                .getStringValue(res.getString(R.string.key_joystick_horizontal), rightval);
        return val.equals(rightval);
    }


    protected JoystickStickView getDirectionView() {
        return mDirectionView;
    }

    protected void setDirectionView(final JoystickStickView directionView) {
        mDirectionView = directionView;
    }

    protected JoystickFireView getFireView() {
        return mFireView;
    }

    protected void setFireView(final JoystickFireView fireView) {
        mFireView = fireView;
    }
    @Override
    boolean deviceHasButtonWithKeycode(final int keycode) {
        return getPortnumber() != PORT_NOT_CONNECTED && keycode == getPseudoKeycode();
    }

}
