//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.content.Context;
import android.view.InputDevice;
import android.view.KeyEvent;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
public class KeyboardFragment extends Fragment {
    /**
     * Needed by android, do not use.
     */
    public KeyboardFragment() {
        super();
    }
    private Runnable mDismissListener = () -> { };
    private InputDevice mInputDevice = null;

    final void setDismissListener(@NonNull final Runnable r) {
        mDismissListener = r;
    }

    /**
     * Dismiss fragment.
     */
    public final void dismiss() {
        mDismissListener.run();
    }

    final void setTriggeringInputDevice(final InputDevice device) {
        mInputDevice = device;
    }

    /**
     * Check if the device connected to the given event was the one the keyboard was started with.
     * @param e keyevent to check the device
     * @return true if the keyboard was started with the same device a key was pressed or released
     * now
     */
    public final boolean isStartedWithSameDevice(final KeyEvent e) {
        return mInputDevice != null && mInputDevice.equals(e.getDevice());
    }

    /**
     * Delegate a keyevent to an @link {@link EmulationActivity}.
     * @param keyCode keyCode of the given event
     * @param event the geven keyevent
     * @return if the event was handled by the activity.
     */
    public final boolean delegateToActivity(final int keyCode, final KeyEvent event) {
        if (getActivity() instanceof EmulationActivity) {
            EmulationActivity ea = (EmulationActivity) getActivity();
            if (!ea.isTv() && ea.delegateToEmulatedInputDevices(keyCode, event)) {
                return true;
            }
            if (!isStartedWithSameDevice(event)) {

                return  ea.onKey(keyCode, event);
            }
        }
        return false;
    }

    @Override
    public final void onAttach(@NonNull final Context context) {
        super.onAttach(context);
        if (requireActivity() instanceof EmulationActivity) {
            EmulationActivity ea = (EmulationActivity) requireActivity();
            ea.addOnBackPressedCallback(this);
        }
    }
}
