//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import java.util.HashSet;
import java.util.Set;

class JoystickToKeysHelperImpl implements EmulationUi.JoystickToKeysHelper {
    private final Emulation.SoftkeyFunctions mMapper;
    private final String mUpKey;
    private final String mUpModificator;
    private final String mDownKey;
    private final String mDownModificator;
    private final String mLeftKey;
    private final String mLeftModificator;
    private final String mRightKey;
    private final String mRightModificator;
    private final String mFireKey;
    private final String mFireModificator;


    private String getKey(final EmulationActivity ui, final int resId, final int port) {
        String key = ui.getResources().getResourceName(resId)
                + "_" + port + "_key";
        return ui.getCurrentUseropts().getStringValue(key, null);
    }
    private String getModificator(final EmulationActivity ui, final int resId, final int port) {
        String key = ui.getResources().getResourceName(resId)
                + "_" + port + "_modificator";
        return ui.getCurrentUseropts().getStringValue(key, null);
    }
    JoystickToKeysHelperImpl(final EmulationActivity ui, final int port,
                             final Emulation.SoftkeyFunctions mapper) {
        mMapper = mapper;
        mUpKey = getKey(ui, R.id.tr_up_key, port);
        mUpModificator = getModificator(ui, R.id.tr_up_key, port);
        mDownKey = getKey(ui, R.id.tr_down_key, port);
        mDownModificator = getModificator(ui, R.id.tr_down_key, port);
        mLeftKey = getKey(ui, R.id.tr_left_key, port);
        mLeftModificator = getModificator(ui, R.id.tr_left_key, port);
        mRightKey = getKey(ui, R.id.tr_right_key, port);
        mRightModificator = getModificator(ui, R.id.tr_right_key, port);
        mFireKey = getKey(ui, R.id.tr_fire_key, port);
        mFireModificator = getModificator(ui, R.id.tr_fire_key, port);

    }
    private void handleSwitch(final boolean oldval, final boolean newval,
                              final String key, final String modificator) {
        if (oldval && !newval) {
            mMapper.releaseKey(key);
            mMapper.releaseKey(modificator);
        }
        if (!oldval && newval) {
            mMapper.pressKey(modificator);
            mMapper.pressKey(key);
        }
    }

    private boolean mSouth = false;
    private boolean mNorth = false;
    private boolean mEast = false;
    private boolean mWest = false;
    private Set<Emulation.InputButton> mButtons = new HashSet<>();
    @Override
    public void onJoystickChanged(final boolean north, final boolean south,
                                  final boolean east, final boolean west,
                                  final Set<Emulation.InputButton> buttons) {
        handleSwitch(mNorth, north, mUpKey, mUpModificator);
        handleSwitch(mSouth, south, mDownKey, mDownModificator);
        handleSwitch(mWest, west, mLeftKey, mLeftModificator);
        handleSwitch(mEast, east, mRightKey, mRightModificator);
        handleSwitch(!mButtons.isEmpty(), !buttons.isEmpty(), mFireKey, mFireModificator);
        mSouth = south;
        mNorth = north;
        mWest = west;
        mEast = east;
        mButtons = buttons;
    }
}
