//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;

import java.util.concurrent.TimeUnit;

/**
 * A linear layout that implements {@link EmulationTestInterface}.
 * Required for testing purposed
 */
public class EmulationDialogFragmentRootview extends LinearLayout
        implements EmulationTestInterface {
    /**
     * See {@link LinearLayout}.
     * @param context See {@link LinearLayout}
     */
    public EmulationDialogFragmentRootview(final Context context) {
        super(context);
    }

    /**
     * See {@link LinearLayout}.
     * @param context See {@link LinearLayout}
     * @param attrs See {@link LinearLayout}
     */
    public EmulationDialogFragmentRootview(final Context context,
                                           @Nullable final AttributeSet attrs) {
        super(context, attrs);
    }

    /**
     * See {@link LinearLayout}.
     * @param context See {@link LinearLayout}
     * @param attrs See {@link LinearLayout}
     * @param defStyleAttr See {@link LinearLayout}
     */
    public EmulationDialogFragmentRootview(final Context context,
                                           @Nullable final AttributeSet attrs,
                                           final int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public final boolean waitForScreenRedraw(final long t, final TimeUnit u) {
        //noinspection ConstantConditions
        return ((EmulationTestInterface) FragmentManager.findFragment(this)
                .getActivity().findViewById(R.id.gv_monitor))
                .waitForScreenRedraw(t, u);
    }

    @Override
    public final boolean waitForScreenInit(final long t, final TimeUnit u) {
        //noinspection ConstantConditions
        return ((EmulationTestInterface) FragmentManager.findFragment(this)
                .getActivity().findViewById(R.id.gv_monitor))
                .waitForScreenInit(t, u);

    }

    @Override
    public final boolean waitForBitmap(final byte[] data, final long t, final TimeUnit u) {
        //noinspection ConstantConditions
        return ((EmulationTestInterface) FragmentManager.findFragment(this)
                .getActivity().findViewById(R.id.gv_monitor))
                .waitForBitmap(data, t, u);
    }

    @Override
    public final boolean waitForAudio(final long t, final TimeUnit u) {
        //noinspection ConstantConditions
        return ((EmulationTestInterface) FragmentManager.findFragment(this)
                .getActivity().findViewById(R.id.gv_monitor))
                .waitForAudio(t, u);

    }
}
