//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

/**
 * Util class to remove comments from a text file.
 */
public final class CommentStripper {
    private CommentStripper() { }
    /**
     * Remove C-style comments like.
     * /*
     * this is a comment
     * *\/
     * or
     * // this is a comment
     * from String
     * @param value String with comments
     * @return String without comments.
     */
    public static String stripCStyleComments(final String value) {
        return stripMultilineComments(
                stripSinglelineComments(value));
    }
    private static final  int NOTFOUND = -1;
    private static String stripMultilineComments(final String data) {
        String input = data;
        StringBuilder output = new StringBuilder();
        while (true) {
            int begin = input.indexOf("/*");
            int end = input.indexOf("*/", begin + "/*".length());
            if (begin == NOTFOUND || end == NOTFOUND) {
                output.append(input);
                return output.toString();
            }
            output.append(input.substring(0, begin));
            input = input.substring(end + "*/".length());
        }
    }
    private static String stripSinglelineComments(final String input) {
        BufferedReader reader = new BufferedReader(new StringReader(input));
        String line = "";
        StringBuilder output = new StringBuilder();
        while (line != null) {
            try {
                line = reader.readLine();
                if (line != null) {
                    line = line.split("//")[0];
                    output.append(line).append(System.lineSeparator());
                }

            } catch (IOException e) {
                // ok
            }
        }
        return output.toString();
    }
}
