package de.rainerhock.eightbitwonders;

import static java.util.Collections.synchronizedMap;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.MimeTypeMap;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.PopupMenu;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class BrowserActivity extends EmulationLauncherActivity {
    private static final String TAG = BrowserActivity.class.getSimpleName();
    private static final int REQUEST_WRITE_PERMISSION = 100;
    private static final String SHOW_STARTUP_MESSAGE = "SHOW_STARTUP_MESSAGE";
    private String mRequestedUrl = null;

    static Intent createIntent(final @NonNull Context ctx,
                               final @NonNull String title,
                               final @NonNull String startURL, final @NonNull String rootURL,
                               final @Nullable String[] downloadableExtensions) {
        Intent i = new Intent(ctx, BrowserActivity.class);
        i.putExtra(TITLE, title);
        i.putExtra(STARTURL, startURL);
        i.putExtra(ROOTURL, rootURL);
        if (downloadableExtensions != null) {
            i.putExtra(EXTENSIONS, downloadableExtensions);
        }
        return i;

    }
    static Intent createArchiveOrgIntent(final @NonNull Context ctx,
                               final @NonNull String startURL,
                               final @Nullable List<String> installed) {
        Intent i = new Intent(ctx, BrowserActivity.class);
        i.putExtra(STARTURL, startURL);
        i.putExtra(SHOW_STARTUP_MESSAGE, true);
        if (installed != null) {
            i.putExtra("savedUrls", (Serializable) installed);
        }
        return i;

    }

    private static final String STARTURL = "_STARTURL_";
    private static final String ROOTURL = "_ROOTURL_";
    private static final String EXTENSIONS = "_EXTENSIONS_";
    private static final String TITLE = "_TITLE_";
    private final DownloadReceiver mDownloadReceiver = new DownloadReceiver();
    private final List<String> mSavedUrls = new LinkedList<>();
    private final List<String> mInitialExistingUrls = new LinkedList<>();

    static WebContentAdapter getWebContentAdapter(final String url) {
        for (Class<?> c : ArchiveOrgAccess.CONTENT_ADAPTERS) {
            try {
                WebContentAdapter a = (WebContentAdapter) c.newInstance();
                if (a.getRootURL().equals(url)) {
                    return a;
                }
            } catch (IllegalAccessException | InstantiationException e) {
                if (BuildConfig.DEBUG) {
                    throw new RuntimeException(e);
                } else {
                    Log.v(TAG, "Exception instantiating WebContentAdapater", e);
                }
            }
        }
        return null;
    }

    static List<String> getUrlsWithAdapter() {
        final List<String> ret = new LinkedList<>();
        for (Class<?> c : ArchiveOrgAccess.CONTENT_ADAPTERS) {
            try {
                WebContentAdapter a =
                        (WebContentAdapter) c.newInstance();
                Log.v(TAG, "Adding " + a);
                ret.add(a.getRootURL());
            } catch (IllegalAccessException | InstantiationException e) {
                if (BuildConfig.DEBUG) {
                    throw new RuntimeException(e);
                } else {
                    Log.v(TAG, "Exception instantiating WebContentAdapater", e);
                }
            }
        }
        return ret;
    }

    @Override
    public final boolean dispatchKeyEvent(final KeyEvent event) {
        return super.dispatchKeyEvent(remapKeyEvent(event));
    }
    @Override
    protected final void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter(Intent.ACTION_AIRPLANE_MODE_CHANGED);
        registerReceiver(mDownloadReceiver, filter);
    }

    @Override
    protected final void onStop() {
        super.onStop();
        unregisterReceiver(mDownloadReceiver);
    }
    private static final String FRAGMENT_LOADING_PAGE = "FRAGMENT_LOADING_PAGE";
    @SuppressLint("SetJavaScriptEnabled")
    @Override
    protected final void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_browser);
        if (getIntent().getBooleanExtra(SHOW_STARTUP_MESSAGE, false)) {
            Log.v("FRAGMENT_LOADING_PAGE", "Showing");
            FragmentManager fm = getSupportFragmentManager();
            new LoadingPageFragment().showNow(fm, FRAGMENT_LOADING_PAGE);
        }
        getOnBackPressedDispatcher().addCallback(this, new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                // Do custom work here
                if (isEnabled()) {

                    final WebView wv = findViewById(R.id.wv_contents);
                    if (wv != null && wv.canGoBack()) {
                        wv.goBack();
                    } else {
                        finish();
                    }
                }
            }
        });
        setTitle(getIntent().getStringExtra(TITLE));
        View cancelButton = findViewById(R.id.bn_cancel_navigation);
        View reloadButton = findViewById(R.id.bn_reload);
        final View backButton = findViewById(R.id.bn_back);
        final View forwardButton = findViewById(R.id.bn_forward);
        String[] extensions = getIntent().getStringArrayExtra(EXTENSIONS);

        String startURL = getIntent().getStringExtra(STARTURL);
        String rootURL = getIntent().getStringExtra(ROOTURL);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
        if (getIntent().getExtras() != null) {
            Serializable urlsFromIntent = getIntent().getExtras().getSerializable("savedUrls");
            if (urlsFromIntent instanceof List) {
                //noinspection unchecked
                mSavedUrls.addAll((List<String>) urlsFromIntent);
                mInitialExistingUrls.addAll(mSavedUrls);
            }
        }
        final WebView wv = findViewById(R.id.wv_contents);
        Runnable updater = () -> {
            cancelButton.setVisibility(View.GONE);
            reloadButton.setEnabled(true);
            reloadButton.setVisibility(View.VISIBLE);
            backButton.setEnabled(wv.canGoBack());
            forwardButton.setEnabled(wv.canGoForward());

        };

        WebViewClient defaultWvc = new WebViewClient() {
            @Override
            public void onPageStarted(final WebView view, final String url, final Bitmap favicon) {
                cancelButton.setVisibility(View.VISIBLE);
                reloadButton.setVisibility(View.GONE);
                backButton.setEnabled(false);
                forwardButton.setEnabled(false);

                super.onPageStarted(view, url, favicon);
            }

            @Override
            public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
                if (!url.startsWith(Objects.requireNonNull(rootURL))) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(url));
                    try {
                        startActivity(intent);
                    } catch (ActivityNotFoundException e) {
                        Toast.makeText(view.getContext(), R.string.cannot_open_app, Toast.LENGTH_LONG).show();
                    }
                    return true;
                }
                if (extensions != null) {
                    for (String s : extensions) {
                        try {
                            if (new URL(url).getPath().endsWith(s)) {
                                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.Q) {
                                    // Legacy permission request
                                    if (ContextCompat.checkSelfPermission(
                                            BrowserActivity.this,
                                            Manifest.permission.WRITE_EXTERNAL_STORAGE)
                                            != PackageManager.PERMISSION_GRANTED) {
                                        ActivityCompat.requestPermissions(
                                                BrowserActivity.this,
                                                new String[]{
                                                        Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                                REQUEST_WRITE_PERMISSION);
                                        mRequestedUrl = url;
                                    } else {
                                        startDownload(url);
                                    }
                                } else {
                                    // No permission needed on Android 10+
                                    startDownload(url);
                                }
                            }
                        } catch (MalformedURLException e) {
                            showUrlError();
                        }
                        return true;
                    }
                }
                return super.shouldOverrideUrlLoading(view, url);
            }


            @Override
            public void onPageFinished(final WebView view, final String url) {
                updater.run();
                super.onPageFinished(view, url);
            }
        };
        WebViewClient customWvc = addCustomWebViewClient(defaultWvc);
        wv.getSettings().setJavaScriptEnabled(true);
        wv.setWebViewClient(customWvc != null ? customWvc : defaultWvc);
        wv.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    updater.run();
                }
                super.onProgressChanged(view, newProgress);
            }
        });
        forwardButton.setOnClickListener(view -> wv.goForward());
        backButton.setOnClickListener(view -> wv.goBack());
        reloadButton.setOnClickListener(view -> wv.reload());
        cancelButton.setOnClickListener(view -> wv.stopLoading());
        PopupMenu pm = new PopupMenu(BrowserActivity.this, findViewById(R.id.bn_menu));
        Menu menu = pm.getMenu();
        pm.getMenuInflater().inflate(R.menu.browser, menu);
        for (int i = 0; i < menu.size(); i++) {
            menu.getItem(i).setOnMenuItemClickListener(mi -> {
                if (mi.getItemId() == R.id.home) {
                    wv.loadUrl(Objects.requireNonNull(startURL));
                    return true;
                }
                if (mi.getItemId() == R.id.external) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(wv.getUrl()));
                    startActivity(intent);
                    return true;

                }
                return false;
            });
        }

        findViewById(R.id.bn_menu).setOnClickListener(view -> pm.show());

        wv.loadUrl(Objects.requireNonNull(startURL));
    }

    private void showUrlError() {
    }
    /**
     * Add custom WebViewClient to handle events not handled by default webview.
     * Default WebViewClient handles the toolbar, everything else has to be done in the additional
     * WebViewClient.
     * @param current the current WebViewClient handling the toolbar and downloads.
     * @return an additional WebViewClient if one is required.
     */

    @Nullable
    WebViewClient addCustomWebViewClient(final WebViewClient current) {
        String url = getIntent().getStringExtra(STARTURL);
        WebContentAdapter adapter = getWebContentAdapter(url);

        if (adapter != null) {
            setTitle(adapter.getTitle(this));
            final WebView wv = findViewById(R.id.wv_contents);
            final View addContent = findViewById(R.id.bn_add_content);
            final View removeContent = findViewById(R.id.bn_remove_content);
            final View runEmulation = findViewById(R.id.bn_run_emulation);
            final TextView title = findViewById(R.id.tv_title);
            final View cancelNavigation = findViewById(R.id.bn_cancel_navigation);
            final View reloadPage = findViewById(R.id.bn_reload);
            final View buttonBar = findViewById(R.id.tb_packages);
            FragmentManager fm = getSupportFragmentManager();
            adapter.init(wv);

            WebViewClient ret = new WebViewClient() {

                @Override
                public void onPageStarted(final WebView wv, final String url,
                                          final Bitmap favicon) {
                    mActivity = BrowserActivity.this;
                    current.onPageStarted(wv, url, favicon);
                    buttonBar.setVisibility(View.GONE);
                }

                private void closeWaitDialog() {
                    Runnable delete = () -> {
                        FragmentManager fm = getSupportFragmentManager();
                        Fragment f = fm.findFragmentByTag(FRAGMENT_LOADING_PAGE);
                        if (f != null) {
                            Log.v("FRAGMENT_LOADING_PAGE", "removing");
                            try {
                                fm.beginTransaction().remove(f).commitNow();
                            } catch (IllegalStateException e) {
                                // that's OK
                            }
                        }

                    };
                    try {
                        Class<?> clz = Objects.requireNonNull(getClass().getClassLoader())
                                .loadClass("org.junit.Test");
                        if (clz != null) {
                            new Thread(() -> {
                                //final long end = System.currentTimeMillis();
                                try {
                                    Thread.sleep(DEFAULT_WAIT_TIME_IN_JUNIT_TEST);
                                } catch (InterruptedException e) {
                                    // ok
                                }
                                runOnUiThread(delete);
                            }).start();
                        } else {
                            delete.run();
                        }
                    } catch (ClassNotFoundException e) {
                        delete.run();
                    }
                }

                @Override
                public void onReceivedError(final WebView view, final int errorCode,
                                            final String description, final String failingUrl) {
                    closeWaitDialog();
                    super.onReceivedError(view, errorCode, description, failingUrl);
                }

                @Override
                public void onReceivedSslError(final WebView view,
                                               final SslErrorHandler handler,
                                               final SslError error) {
                    closeWaitDialog();
                    super.onReceivedSslError(view, handler, error);
                }

                @Override
                public void onReceivedHttpError(final WebView view,
                                                final WebResourceRequest request,
                                                final WebResourceResponse errorResponse) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        if (request.getUrl().toString().equals(view.getUrl())) {
                            closeWaitDialog();
                        }
                    }
                    super.onReceivedHttpError(view, request, errorResponse);
                }

                @Override
                public void onPageFinished(final @NonNull WebView wv, final String url) {
                    buttonBar.setVisibility(View.GONE);
                    current.onPageFinished(wv, url);
                    addContent.setVisibility(mSavedUrls.contains(url) ? View.GONE : View.VISIBLE);
                    removeContent.setVisibility(mSavedUrls.contains(url)
                            ? View.VISIBLE : View.GONE);
                    Log.v("removeContent", "setOnClickListener");
                    removeContent.setOnClickListener(view -> {

                        if (mInitialExistingUrls.contains(wv.getUrl()) && wv.getUrl() != null) {
                            Log.v("removeContent", "showReallyDeleteDialog");
                            showReallyDeleteDialog(
                                    () -> {
                                        Log.v("removeContent", "clearDownloadOnly");
                                        deleteConfiguration(wv.getUrl(), false);
                                        addContent.setVisibility(View.VISIBLE);
                                        removeContent.setVisibility(View.GONE);
                                    },
                                    () -> {
                                        Log.v("removeContent", "clearWithUseropts");
                                        deleteConfiguration(wv.getUrl(), true);
                                        addContent.setVisibility(View.VISIBLE);
                                        removeContent.setVisibility(View.GONE);
                                    });

                        } else {
                            deleteConfiguration(wv.getUrl(), false);
                            addContent.setVisibility(View.VISIBLE);
                            removeContent.setVisibility(View.GONE);

                            Toast.makeText(BrowserActivity.this,
                                    R.string.removed_from_start_screen, Toast.LENGTH_SHORT).show();
                        }
                    });
                    title.setText(wv.getTitle());
                    if (adapter.getEmulatorCheckScript() != null) {
                        wv.evaluateJavascript(adapter.getEmulatorCheckScript(), null);
                    } else {
                        closeWaitDialog();
                    }
                    super.onPageFinished(wv, url);
                }

                private BaseActivity mActivity = null;

                @JavascriptInterface
                @Keep
                public void removeFromStartPage(final String url,
                                                final String evaluateAfterRemove) {

                    runOnUiThread(() -> {
                        if (isOnStartPage(url)) {
                            showReallyDeleteDialog(
                                    () -> {
                                        deleteConfiguration(url, false);
                                        Toast.makeText(BrowserActivity.this,
                                                R.string.removed_from_start_screen,
                                                Toast.LENGTH_SHORT).show();
                                        wv.evaluateJavascript(evaluateAfterRemove, null);
                                    },
                                    () -> {
                                        deleteConfiguration(url, true);
                                        Toast.makeText(BrowserActivity.this,
                                                R.string.removed_from_start_screen,
                                                Toast.LENGTH_SHORT).show();
                                        wv.evaluateJavascript(evaluateAfterRemove, null);
                                    });
                        } else {
                            deleteConfiguration(url, false);
                            wv.evaluateJavascript(evaluateAfterRemove, null);
                            Toast.makeText(BrowserActivity.this,
                                    R.string.removed_from_start_screen, Toast.LENGTH_SHORT).show();

                        }

                    });
                }

                @JavascriptInterface
                @Keep
                public boolean isOnStartPage(final String url) {
                    Bundle extras = getIntent().getExtras();
                    if (extras != null) {
                        Serializable urlsFromIntent = extras.getSerializable("savedUrls");
                        if (urlsFromIntent instanceof List) {
                            return ((List<?>) urlsFromIntent).contains(url);
                        }
                    }
                    return false;
                }

                @Keep
                @JavascriptInterface
                public void setEmulationDescription(final String purpose, final String jsonString) {
                    if (!jsonString.isEmpty()) {
                        BrowserActivity.this.runOnUiThread(()
                                -> findViewById(android.R.id.content).setEnabled(false));
                        String s = jsonString.replaceAll("^\"|\"$", "").replace("\\\"", "\"");
                        Log.v(TAG, "metadata; " + s);
                        try {
                            JSONObject json = new JSONObject(s);
                            final String fragmentTag = "DOWNLOAD_DIALOG";
                            showDownloadDialog();
                            Thread t = new Thread(() -> {
                                if (purpose.equals("stream")) {
                                    ConfigurationFactory.StreamConfiguration conf
                                            = adapter.createConfiguration(mActivity, json, false);
                                    if (conf != null) {
                                        startEmulation(conf);
                                    }
                                }
                                if (purpose.equals("save")) {
                                    ConfigurationFactory.StreamConfiguration conf
                                            = adapter.createConfiguration(mActivity, json, true);
                                    if (conf != null) {
                                        conf.store(BrowserActivity.this,
                                                new File(getApplicationContext().getFilesDir()
                                                        + "/packages/streams"));
                                        Intent i = new Intent(
                                                "de.rainerhock.eightbitwonders.update");
                                        i.setPackage("de.rainerhock.eightbitwonders");
                                        sendBroadcast(i);
                                        mSavedUrls.add(conf.getWebAdress().toString());
                                        runOnUiThread(() -> {
                                            Fragment f = fm.findFragmentByTag(fragmentTag);
                                            if (f != null) {
                                                fm.beginTransaction().remove(f).commitNow();
                                            }
                                            findViewById(android.R.id.content).setEnabled(true);
                                            addContent.setVisibility(View.GONE);
                                            removeContent.setVisibility(View.VISIBLE);
                                            Toast.makeText(BrowserActivity.this, getResources()
                                                    .getString(R.string.added_to_start_screen,
                                                            conf.getName()), Toast.LENGTH_SHORT)
                                                    .show();

                                        });
                                    }
                                }
                            });
                            t.start();
                        } catch (JSONException e) {
                            //
                        }
                        BrowserActivity.this.runOnUiThread(() ->
                                findViewById(android.R.id.content).setEnabled(true));
                    }
                }

                @Keep
                @JavascriptInterface
                public void scriptFinished() {
                    runOnUiThread(this::closeWaitDialog);
                }

                @Keep
                @JavascriptInterface
                public void containsEmulation(final boolean result) {
                    if (result) {
                        wv.post(() -> {
                            findViewById(android.R.id.content).setEnabled(true);
                            buttonBar.setVisibility(View.VISIBLE);
                            addContent.setOnClickListener(view ->
                                    wv.evaluateJavascript(
                                            adapter.getEmulatorPropertiesScript()
                                                    .replace("_%%_CALL_ID_%%_",
                                                            "save"), null));

                            runEmulation.setOnClickListener(view -> {
                                BrowserActivity.this.findViewById(android.R.id.content)
                                        .setEnabled(false);
                                wv.evaluateJavascript(
                                        adapter.getEmulatorPropertiesScript()
                                                .replace("_%%_CALL_ID_%%_",
                                                        "stream"), null);
                                reloadPage.setVisibility(View.VISIBLE);
                                cancelNavigation.setVisibility(View.GONE);
                                closeWaitDialog();
                            });
                        });
                    } else {
                        wv.post(() -> {
                            reloadPage.setVisibility(View.VISIBLE);
                            cancelNavigation.setVisibility(View.GONE);
                            closeWaitDialog();
                        });
                    }

                }

                @Keep
                @JavascriptInterface
                public void logVerbose(final String data) {
                    Log.v(TAG, data);
                }

                @Keep
                @JavascriptInterface
                public void logError(final String data) {
                    Log.e(TAG, data);
                }

                @Override
                public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
                    String type;
                    String extension = MimeTypeMap.getFileExtensionFromUrl(String.valueOf(url));
                    if (extension != null) {
                        type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                        if (type != null) {
                            if (!type.split("/")[0].equals("image")) {
                                return true;
                            }
                        }
                    }
                    switch (BrowserActivity.this.handleURL(
                            adapter, url, !BrowserActivity.this.restrictPayments())) {
                        case WebContentAdapter.NAVIGATION_OK:
                            return super.shouldOverrideUrlLoading(view, url);
                        case WebContentAdapter.NAVIGATION_DENY:
                            String text = getResources().getString(
                                    R.string.page_not_accessible_in_app, url);
                            Toast.makeText(BrowserActivity.this, text, Toast.LENGTH_LONG)
                                    .show();
                            //view.post(view::goBack);
                            return true;
                        case WebContentAdapter.NAVIGATION_OPEN_EXTERNAL:
                            Intent i = new Intent(Intent.ACTION_VIEW);
                            i.setData(Uri.parse(url));
                            startActivity(i);
                            return true;
                        default:
                            return true;
                    }
                }
            };
            wv.addJavascriptInterface(ret, "callback");
            return ret;
        }
        return null;
    }

    @Override
    public final void onRequestPermissionsResult(final int requestCode,
                                                 final @NonNull String[] permissions,
                                                 final @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUEST_WRITE_PERMISSION
                && grantResults.length > 0
                && grantResults[0] == PackageManager.PERMISSION_GRANTED
                && mRequestedUrl != null) {
            try {
                startDownload(mRequestedUrl);
            } catch (MalformedURLException e) {
                // should not happen.
            }
            mRequestedUrl = null;
        }
    }

    private static final Map<Long, String> BROWSER_DOWNLOADS
            = synchronizedMap(new LinkedHashMap<>());

    @SuppressLint("UnspecifiedRegisterReceiverFlag")
    private void startDownload(final String url) throws MalformedURLException {

        DownloadManager downloadManager =
                (DownloadManager) getSystemService(Context.DOWNLOAD_SERVICE);
        Uri uri = Uri.parse(url);
        String basename = new File(new URL(url).getPath()).getName();
        DownloadManager.Request request = new DownloadManager.Request(uri);
        request.setTitle(basename);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, basename);
        } else {
            File file = new File(Environment.getExternalStoragePublicDirectory(
                    Environment.DIRECTORY_DOWNLOADS), basename);
            request.setDestinationUri(Uri.fromFile(file));
        }
        // Ensure file is scanned by MediaScanner
        request.allowScanningByMediaScanner();
        long downloadId = downloadManager.enqueue(request);
        BROWSER_DOWNLOADS.put(downloadId, basename);
    }

    interface WebContentAdapter extends Serializable {
        int NAVIGATION_DENY = -1;
        int NAVIGATION_OK = 0;
        int NAVIGATION_OPEN_EXTERNAL = 1;
        void init(WebView webView);

        String getRootURL();

        boolean allowSubdirsOnly();

        String getTitle(Context context);

        String getEmulatorCheckScript();
        String getEmulatorPropertiesScript();
        ConfigurationFactory.StreamConfiguration createConfiguration(
                BaseActivity activity, JSONObject data, boolean keep);

        int handleAdditionalURL(String url, boolean allowPayments);

        int getLicenseTextId();
        List<String> getEmulatorId();
    }

    public static class DownloadReceiver extends BroadcastReceiver {
        @Override
        public final void onReceive(final Context context, final Intent intent) {
            long downloadId = intent.getLongExtra(DownloadManager.EXTRA_DOWNLOAD_ID, View.NO_ID);
            if (BROWSER_DOWNLOADS.containsKey(downloadId)) {
                DownloadManager downloadManager = (DownloadManager) context.getSystemService(
                        Context.DOWNLOAD_SERVICE);
                DownloadManager.Query q = new DownloadManager.Query();
                q.setFilterById(downloadId);
                Cursor cursor = downloadManager.query(q);
                final int statusTitle = cursor.getColumnIndex(DownloadManager.COLUMN_TITLE);
                final int statusIndex = cursor.getColumnIndex(DownloadManager.COLUMN_STATUS);
                final int reasonIndex = cursor.getColumnIndex(DownloadManager.COLUMN_REASON);

                if (cursor.moveToFirst()) {
                    String name = cursor.getString(statusTitle);
                    int status = cursor.getInt(statusIndex);
                    if (status == DownloadManager.STATUS_SUCCESSFUL) {
                        String text = context.getResources().getString(
                                R.string.download_finished_description, name);
                        Log.v(getClass().getSimpleName(), text);
                        Toast.makeText(context, text, Toast.LENGTH_SHORT).show();
                    }
                    if (status == DownloadManager.STATUS_FAILED) {
                        String text = context.getResources().getString(
                                R.string.download_error_description, name,
                                cursor.getInt(reasonIndex));
                        Toast.makeText(context, text, Toast.LENGTH_LONG).show();
                    }
                    cursor.close();
                }
                BROWSER_DOWNLOADS.remove(downloadId);

            }
        }

    }

    private int handleURL(final WebContentAdapter adapter,
                          final String url,
                          final boolean allowPayments) {
        if (adapter.allowSubdirsOnly()) {
            if (url.startsWith(adapter.getRootURL())) {
                return WebContentAdapter.NAVIGATION_OK;
            }
        }
        return adapter.handleAdditionalURL(url, allowPayments);
    }
    private void deleteConfiguration(final String url, final boolean deleteUseropts) {
        for (String subfolder : SUBFOLDERS.keySet()) {
            if (subfolder.endsWith("/streams")) {
                String parentFolder = getApplicationContext().getFilesDir() + subfolder;
                File userconfigs = new File(parentFolder);
                if (userconfigs.exists() && userconfigs.isDirectory()) {
                    for (String path : Objects.requireNonNull(userconfigs.list())) {
                        if (deleteIfMatching(url, new File(userconfigs, path), deleteUseropts)) {
                            Log.v("removeContent", "deleteIfMatching(" + url + ") = true");
                            return;
                        }
                        Log.v("removeContent", "deleteIfMatching(" + url + ") = false");
                    }
                }
            }
        }
    }

    @Override
    final ActivityResultLauncher<Intent> getEmulationContract() {
        return registerForActivityResult(
                new ActivityResultContract<Intent, Intent>() {

                    @Override
                    public Intent parseResult(final int i, final @Nullable Intent intent) {
                        return intent;
                    }

                    @NonNull
                    @Override
                    public Intent createIntent(final @NonNull Context context,
                                               final Intent intent) {
                        return intent;
                    }
                },
                result -> {
                    EmulationLauncherActivity.setEmulationRunning(false);
                    if (result != null) {
                        if (result.getStringExtra("error-message") != null) {
                            showErrorDialog(null, result.getStringExtra("error-message"));
                        }
                        String todeleteEmulatorId = result.getStringExtra("todelete_emulatorId");
                        String todeleteConfigId = result.getStringExtra("todelete_id");
                        if (todeleteEmulatorId != null && todeleteConfigId != null) {
                            Useropts.delete(this, todeleteEmulatorId, todeleteConfigId);
                            new Deleter(getSnapshotPath(todeleteEmulatorId, todeleteConfigId))
                                    .run();
                        }

                    }
                });

    }
    private boolean deleteIfMatching(final @NonNull String url, final @NonNull  File folder,
                                     final boolean deleteUseropts) {
        Properties props = new Properties();
        try {
            if (new File(folder, "assets").exists()) {
                Log.v("removeContent", "folder exists");
                //noinspection IOStreamConstructor
                props.load(new FileInputStream(new File(folder, "properties")));
                if (props.containsKey("url")) {
                    Log.v("removeContent", "url property found");
                } else {
                    String l = String.join(", ", props.stringPropertyNames());
                    Log.v("removeContent", "url property not found in [" + l + "]");
                    return false;
                }
                String url2 = props.getProperty("url");
                String url1 = url;
                if (!url1.endsWith("/")) {
                    url1 = url1 + "/";
                }
                if (!url2.endsWith("/")) {
                    url2 = url2 + "/";
                }
                if (props.containsKey("url") && url1.equals(url2)) {
                    Log.v("removeContent", "url match");
                    String[] list = folder.list();
                    if (list != null) {
                        Log.v("removeContent", "list found");
                        for (String f : list) {
                            Log.v("removeContent", "deleting " + new File(folder, f));
                            //noinspection ResultOfMethodCallIgnored
                            new File(folder, f).delete();
                        }
                    } else {
                        Log.v("removeContent", "no list found");
                    }
                    if (deleteUseropts) {
                        String emu = props.getProperty("emulation");
                        String id = BaseActivity.hexSha256Hash(
                                url.getBytes(StandardCharsets.UTF_8));
                        Log.v("removeContent", "remove useropt with id " + id
                                + " from " + url);
                        Useropts.delete(BrowserActivity.this, emu, id);
                    }
                    //noinspection ResultOfMethodCallIgnored
                    folder.delete();
                    findViewById(R.id.bn_add_content).setVisibility(View.VISIBLE);
                    findViewById(R.id.bn_remove_content).setVisibility(View.GONE);
                    mSavedUrls.remove(props.getProperty("url"));
                    Intent i = new Intent(
                            "de.rainerhock.eightbitwonders.update");
                    i.setPackage("de.rainerhock.eightbitwonders");
                    sendBroadcast(i);

                    return true;
                } else {
                    Log.v("removeContent", "url no match " + url1 + " vs " + url2);
                }
            }
        } catch (IOException e) {
            // zombie folder.
            if (BuildConfig.DEBUG) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static final class LoadingPageFragment extends PleaseWaitDialogFragment {
        @Override
        int getTextId() {
            return R.string.loading_page;
        }
    }
}
