globalThis.titlescreen=false
globalThis.patchtask = null;
globalThis.highscorelist = false;
globalThis.joysticklistener = null;

function patchTask(patchTitlescreen) {
        emu.removeListener(patchtask);
        if (globalThis.titlescreen) {
            patchTitlescreen();
            globalThis.patchtask = emu.addTask(() => patchTask(patchTitlescreen),1);
        } else {
            globalThis.patchtask = null;
        }

}

monty_freedom_kit = new Int8Array([0x4d, 0x4f, 0x4e, 0x54, 0x59, 0x60,
                          0x46, 0x52, 0x45, 0x45, 0x44, 0x4f,
                          0x4d, 0x60, 0x4b, 0x49, 0x54])
                          .buffer;

press_fire_to_start = new Int8Array([0x50,0x52,0x45,0x53,0x53,0x60,0x46,0x49,0x52,0x45,
                        0x60,0x54,0x4f,0x60,0x53,0x54,0x41,0x52,0x54, 0x6e]).buffer;

press_fire_to_start_hidden = new Int8Array(press_fire_to_start.byteLength).fill(0x60).buffer

congratulations = new Int8Array([0x43, 0x4f, 0x4e, 0x47, 0x52, 0x41, 0x54, 0x55, 0x4c,
                                 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x60, 0x61, 0x61]).buffer;

prompt = new Int8Array([0x7e, 0x6a]).buffer;

const charbuffer = new ArrayBuffer(6*40);
const charview = new Int8Array(charbuffer);
charview.fill(0xff);
whitebuffer = new ArrayBuffer(40);
whiteview = new Int8Array(whitebuffer);
whiteview.fill(1);

const blackbuffer = new ArrayBuffer(6*40);
function patchTitlescreen() {
    emu.poke(emu.getColorAddress(0,18), whitebuffer);
    emu.poke(emu.getScreenAddress(0,19),charbuffer);
    emu.poke(emu.getColorAddress(0,19),blackbuffer);
    emu.poke(emu.getScreenAddress(10,18), globalThis.highscorelist ? press_fire_to_start_hidden : press_fire_to_start);
}
function removeJoysticklistener() {
    if (globalThis.joysticklistener != null) {
        emu.removeListener(globalThis.joysticklistener);
        globalThis.joysticklistener = null;
    }
}
function createJoysticklistener() {
        if (globalThis.joysticklistener == null) {
            globalThis.joysticklistener = emu.addJoystickListener(2, (n, s, w, e, f)=> {
                emu.log(emu.LOG_VERBOSE,"Joysticklistener!");
                if (f) {
                    if (!globalThis.highscorelist) {
                        removeJoysticklistener();
                        globalThis.titlescreen = false;
                    }
                    return globalThis.highscorelist;
                }
            return true;
        });
    }
}
emu.addTextVisibilityListener(monty_freedom_kit, emu.TO_VISIBLE, () => {

    globalThis.titlescreen = true;
    if (globalThis.patchtask == null) {
        if ((emu.peek(56320) & 16) == 16) {
            patchTitlescreen();
        }
        globalThis.patchtask = emu.addTask(() => patchTask(patchTitlescreen),1);
        createJoysticklistener();
    };
});

emu.addTextVisibilityListener(monty_freedom_kit, emu.TO_INVISIBLE, () => {
    emu.removeListener(globalThis.patchtask);
    globalThis.titlescreen = false;
    globalThis.patchtask = null;
    removeJoysticklistener();

});
emu.addTextVisibilityListener(congratulations, emu.TO_VISIBLE, () => {
    emu.log(emu.LOG_VERBOSE,"congrats visible.");
    globalThis.highscorelist = true;
    patchTitlescreen();
    promptlistener = emu.addTextVisibilityListener(prompt, emu.TO_VISIBLE, () => {
        emu.showVirtualKeyboard(emu.SCREENPART_CENTER);
        emu.addKeyboardListener(emu.KEY_RELEASED,0,1, () => {
            emu.restoreVirtualKeyboardVisibility();
            emu.removeListener(emu.getCurrentListenerId());
            emu.removeListener(promptlistener);
            removeJoysticklistener();
            createJoysticklistener();
            globalThis.highscorelist = false;
            return false;
        });
    });
});
