package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.MatcherAssert.assertThat;

import android.content.res.Resources;
import android.graphics.Point;

import androidx.annotation.StringRes;
import androidx.test.filters.SdkSuppress;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObject;
import androidx.test.uiautomator.UiObjectNotFoundException;
import androidx.test.uiautomator.UiSelector;
import androidx.test.uiautomator.Until;

import org.junit.Test;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@SdkSuppress(minSdkVersion=33, maxSdkVersion=34)
public class WidgetTest extends MainActivityTestBase{
    private static final long LAUNCH_TIMEOUT = 5000;

    private Point getScreenCentre() {
        return new Point(UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).getDisplayWidth()/2,
                UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).getDisplayHeight()/2);
    }
    private void create_and_start_widget(@StringRes int name) throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        final String launcherPackage = device.getLauncherPackageName();
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);

        device.swipe((Point[]) Arrays.asList(getScreenCentre(), getScreenCentre()).toArray(), 300);

        device.wait(Until.findObject(By.text("Widgets")),1000).click();
        Resources res = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources();
        String appname = res.getString(R.string.app_name);
        device.wait(Until.findObject(By.text(appname)),200).drag(new Point(getScreenCentre().x, getScreenCentre().y * 75 / 100), 1000);
        device.wait(Until.findObject(By.text(appname)),1000).click();
        waitForIdle(1, TimeUnit.SECONDS);
        String widgetname = res.getString(R.string.widgettitle);
        device.wait(Until.findObject(By.text(widgetname)),1000).drag(getScreenCentre(),1000);
        waitForIdle();
        onView(withText(name)).perform(click());
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.click();

    }
    @Test
    public void testCreatingAndRemoving() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        device.pressHome();
        create_and_start_widget(R.string.name_c64);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        device.pressHome();
        removeWidget();
    }

    private void removeWidget() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        final String launcherPackage = device.getLauncherPackageName();
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        waitForIdle();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.dragTo(getScreenCentre().x, getScreenCentre().y * 20 / 100, 50);
        waitForIdle();
        try {
            assertThat("Widget removed", !device.findObject(new UiSelector()
                    .description("8-Bit Wonders")).exists());
        } catch (AssertionError e) {
            waitForIdle();
            widget = device.findObject(new UiSelector()
                    .description("8-Bit Wonders"));
            widget.dragTo(getScreenCentre().x, getScreenCentre().y * 25 / 100, 50);
            assertThat("Widget removed", !device.findObject(new UiSelector()
                    .description("8-Bit Wonders")).exists());

        }
    }

    @Test
    public void testConcurrentLaunch() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        device.pressHome();
        create_and_start_widget(R.string.name_c64);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        removeWidget();
        create_and_start_widget(R.string.name_vic20);
        waitForIdle(5, TimeUnit.SECONDS);
        String title = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.currently_running, "C64");
        onView(withText(title)).check(matches(isDisplayed()));
        onView(withText(android.R.string.yes)).check(matches(isDisplayed()));
        onView(withText(android.R.string.no))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withText(R.string.pause)).check(matches(isDisplayed()));
        //onView(isRoot()).perform(waitForMatch(withId(R.id.monitorGLSurfaceView),5, TimeUnit.SECONDS));
        //onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        final String launcherPackage = device.getLauncherPackageName();
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.click();
        waitForIdle(5, TimeUnit.SECONDS);
        title = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.currently_running, "C64");
        onView(withText(title)).check(matches(isDisplayed()));
        onView(withText(android.R.string.no)).check(matches(isDisplayed()));
        onView(withText(android.R.string.yes))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-vic-machine-ready-ntsc.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        removeWidget();
    }
}
