package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.equalTo;

import androidx.test.espresso.assertion.PositionAssertions;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import de.rainerhock.eightbitwonders.vice.ViceFileActionActivity;

public class WheelJoystickTest extends C64EmulationTestBase {
    @Test
    public void t_0010_visibility () {
        /*
        Action: enable touch joystick in settings
        Expected result: Virtual fire button and joystick are visible, fire button is on the right side.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_wheel_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_wheel))
                .check(matches(isDisplayed()));

        onView(withId(R.id.jv_flipswitch))
                .check(matches(isDisplayed()))
                .check(PositionAssertions.isCompletelyRightOf(withId(R.id.jv_wheel)));
    }
    @Test
    public void t_0090_gearshift() {
        /*
        Action: enable touch joystick in settings
        Expected result: Virtual fire button and joystick are visible, fire button is on the right side.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_wheel_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();

        /*

        Action: autostart program displaying joystick values.
        Expected result: 255 is displayed, "gearshift" is centered
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForActivity(ViceFileActionActivity.class, 1, TimeUnit.SECONDS);
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 20, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        /*
        Action: Touch gearshift in the right middle
        Expected result: 255 is displayed, gearshift is centered
         */
        FingerState state = new FingerState();
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.DOWN,state, 80,50))
                .check(matches(withTagValue(equalTo("CENTER"))));
        /*
        Action: move finger to upper part of gearshift
        Expected result: 254 is displayed, gearshift is up
         */

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 15, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.MOVE, state, 80, 10))
                .check(matches(withTagValue(equalTo("UP"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up.pixelbuffer", 15, TimeUnit.SECONDS)));
        /*
        Action: remove finger from gearshift
        Expected result: 255 is displayed, gearshift is centered
         */
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.UP, state, 0, 0))
                .check(matches(withTagValue(equalTo("CENTER"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        /*
        Action: Touch gearshift in the right middle bottom
        Expected result: 253 is displayed, gearshift is down
         */

        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.DOWN, state, 80, 90))
                .check(matches(withTagValue(equalTo("DOWN"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: Touch gearshift in the left bottom
        Expected result: 237 is displayed, gearshift is down left
         */

        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.MOVE, state, 20, 90))
                .check(matches(withTagValue(equalTo("DOWN|FIRE"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down-fire.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: remove finger from gearshift
        Expected result: 255 is displayed, gearshift is centered.
         */
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.UP, state, 0, 0))
                .check(matches(withTagValue(equalTo("CENTER"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: Touch gearshift in the left middle
        Expected result: 239 is displayed, gearshift is left
         */
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.DOWN, state, 20, 50))
                .check(matches(withTagValue(equalTo("CENTER|FIRE"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_flipswitch)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        /*
        Action: open settings and select gear shift left
        Expected result: gear shift is left.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_left)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_flipswitch)).check(PositionAssertions.isCompletelyLeftOf(withId(R.id.jv_wheel)));
        /*
        Action: touch gearshift in the right middle
        Expected result: 239 is displayed, gearshift is right
         */
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.DOWN, state, 80, 50))
                .check(matches(withTagValue(equalTo("CENTER|FIRE"))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_flipswitch))
                .perform(doFingerAction(FingerAction.UP, state, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
    }
    @Test
    public void t_0170_wheel () {
         /*
        Action: enable touch joystick in settings
        Expected result: Virtual fire button and joystick are visible, fire button is on the right side.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_wheel_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        /*

        Action: autostart program displaying joystick values.
        Expected result: 255 is displayed, "gearshift" is centered
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("CENTERED"))));
        /*
        Action: Touch wheel at 10:00
        Expected result: 247 is shown, Steering is wheel is turning right
         */
        FingerState state = new FingerState();
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.DOWN, state, 20, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("EAST"))));

        /*
        Action: remove finger from wheel.
        Expected result: 255 is shown, Steering wheel is centered
         */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("CENTERED"))));

        /*
        Action: Touch wheel at 10:00
        Expected result: 247 is shown, Steering is wheel is turning right
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.DOWN, state, 20, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("EAST"))));
        /*
        Action: Move finger to 9:00
        Expected result: 255 is shown, Steering is wheel is centered
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.MOVE, state, 20, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("CENTERED"))));
        /*
        Action: Move finger to 8:00
        Expected result: 251 is shown, Steering is wheel is left
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.MOVE, state, 20, 70));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("WEST"))));
        /*
        Action: remove finger from wheel.
        Expected result: 255 is shown, Steering wheel is centered
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("CENTERED"))));
        /*
        Action: Touch wheel at 04:00
        Expected result: 247 is shown, Steering is wheel is turning right
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.DOWN, state, 80, 70));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("EAST"))));
        /*
        Action: Move finger to 3:00
        Expected result: 255 is shown, Steering is wheel is centered
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.MOVE, state, 80, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("CENTERED"))));
        /*
        Action: Move finger to 2:00
        Expected result: 251 is shown, Steering is wheel is centered
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.MOVE, state, 80, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("WEST"))));
        /*
        Action: Move finger to 10:00
        Expected result: 251 is shown, Steering is wheel is left
        */
        onView(withId(R.id.jv_wheel)).perform(doFingerAction(FingerAction.MOVE, state, 20, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_wheel)).check(matches(withTagValue(equalTo("WEST"))));
    }
}