package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.espresso.web.assertion.WebViewAssertions.webContent;
import static androidx.test.espresso.web.matcher.DomMatchers.hasElementWithXpath;
import static androidx.test.espresso.web.sugar.Web.onWebView;
import static androidx.test.espresso.web.webdriver.DriverAtoms.findElement;
import static androidx.test.espresso.web.webdriver.DriverAtoms.webClick;


import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import android.webkit.WebView;

import androidx.appcompat.widget.AlertDialogLayout;
import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.filters.SdkSuppress;
import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class WebContentAdapterTest extends MainActivityTestBase{
    private final static String GENERAL_TEST_TITLE ="Voodoomania (1998)(Civitas)(Side A)";
    private final static String GENERAL_TEST_URL ="https://archive.org/details/Voodoomania_1998_Civitas_Side_A";
    private final static String SINGLE_DISK_TEST_URL="https://archive.org/details/SYS_Diskett_19_199x_SYS_PD";
    //private final static String SINGLE_DISK_TEST_TITLE="Reiner's PD Nr. 06 (19xx)(Reiner Public Domain)(de)";
    private final static String TAPE_TEST_URL="https://archive.org/details/uta_Monty_on_the_Run_1985_Gremlin_Graphics_2858";
    private static final String PET_GAME_LABEL = "PET Game: BREAK-OUT";

    /*
    @Test
    @SpecialTest
    public void testLoop() {
        int loop = 1;
        while (true) {
            Log.e("WebContentAdapterTest", "Loop #"+loop);
            testArchiveOrgC64GeneralFunctions();
            pressBack();
            onView((withText(R.string.quit))).perform(click());
            waitForIdle();
            pressBack();
            waitForIdle();

            loop++;
        }
    }

     */
    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testArchiveOrgPetFunctions() {

        navigateToTitle("PET", "https://archive.org/details/d64_petgame_break-out", PET_GAME_LABEL,  "a4d3b356098b70ce1d09134ca3b4fdaf539d3c1d69fd606d9b1d0a4e8c7b124d");
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), 20, TimeUnit.SECONDS);
        pressBack();
        waitForView(allOf(withId(R.id.bn_reload),isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(createdTileAction(PET_GAME_LABEL, click()));
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.gh_petsettings)).perform(scrollTo()).perform(click());
        onData(isOption("4032")).inAdapterView(withId(R.id.sp_petmodel))
                .check(matches(isDisplayed()));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        //waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-breakout-pet.pixeldata", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();

        onView(withId(R.id.sp_petmodel)).check(matches(not(isDisplayed())));
        pressBack();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-breakout-pet-2.pixeldata", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(withText(containsString(PET_GAME_LABEL))).perform(click());
        //waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-breakout-pet.pixeldata", 15, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(PET_GAME_LABEL, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(PET_GAME_LABEL)).check(doesNotExist());


    }
    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testArchiveOrgC64GeneralFunctions() {
        /*
        Action: open C64 Software library via action menu
        Expected result:
        * Library page loading
        * add content and run emulation disabled
        * remove content not visible
        * reload button enabled.
         */
        navigateToC64TestTitle();
        /*
        Action: press "add content"
        Expected result:
        * Add content invisible
        * Remove content visible
         */
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.bn_remove_content))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        /*
        Action: press "run emulation"
        Expected result:
        * Main activity shown
        * Download dialog
        * Program starting.
         */
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForIdle();
        waitForDialog(anyOf(withText(R.string.downloading), withId(R.id.tv_starting_emulation)));
        waitForIdle();
        waitForActivity(SettingsActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania.pixeldata", TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS)));
        /*
        Action: Open settings and disable borders
        Expected result: screen without borders
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania-borderless.pixeldata", TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS)));
        /*
        Action: quit and restart
        Expected result: setting not applied
         */
        pressBack();
        waitForIdle();
        onView((withText(R.string.quit))).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.bn_apply)).perform(click());
        //onView(isRoot()).perform(waitForMatch(withId(R.id.monitorGLSurfaceView),HTTP_GET_DELAY, TimeUnit.SECONDS));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania.pixeldata", TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS)));
        /*
        Action: re-enable borders and set joystick
        Expected result: joystick is displayed.
        */

        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions)).check(matches(isDisplayed()));

        /*
        Action: quit, start archive.org, navigate to source
        Expected result: Add content invisible, remove content active.
         */
        pressBack();
        waitForIdle();
        onView((withText(R.string.quit))).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isContentSourceViewWithTitle(R.string.software_library_c64)).perform(scrollTo()).perform(click());
        waitForProgressDialog(withId(R.id.wv_contents));
        onView(withId(R.id.wv_contents)).perform(navigateTo(GENERAL_TEST_URL));
        waitForView(allOf(withId(R.id.bn_remove_content), isEnabled(), isDisplayed()), TestBase.HTTP_GET_DELAY , TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(android.R.id.content)).check(matches(isEnabled()));
        onView(withId(R.id.bn_remove_content)).check(matches(isEnabled()));
        onView(withId(R.id.bn_run_emulation)).check(matches(isEnabled()));
        onView(withId(R.id.bn_add_content)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_remove_content)).check(matches(isEnabled()));
        /*
        Action:
        * Remove content
        * Go back to main activity
        * Expected result: no tile
         */
        onView(withId(R.id.bn_remove_content)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_add_content)).check(matches(isEnabled()));
        onView(withId(R.id.bn_remove_content)).check(matches(not(isDisplayed())));
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60, TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withText(GENERAL_TEST_TITLE)).check(doesNotExist());
        waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
        onView(isContentSourceViewWithTitle(R.string.software_library_c64)).perform(click());
        waitForProgressDialog(withId(R.id.wv_contents));
        onView(withId(R.id.wv_contents)).perform(navigateTo(GENERAL_TEST_URL));
        waitForView(allOf(withId(R.id.bn_run_emulation), isEnabled(), isDisplayed()), TestBase.HTTP_GET_DELAY , TimeUnit.SECONDS);
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForIdle();
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania.pixeldata", TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(doesNotExist());
    }
    private void navigateToTitle(final String machine, final String url, final String label, final String id) {
        waitForIdle();
        prepareStreamUseropts(machine, id);
        onView(withText(label)).check(doesNotExist());
        waitForIdle();
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgC64LibraryAdapter()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext()))).perform(scrollTo()).perform(click());
        waitForProgressDialog(withId(R.id.wv_contents));
        onView(withId(R.id.bn_cancel_navigation)).check(matches(not(isDisplayed())));
        onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_reload)).check(matches(isDisplayed()));
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.bn_add_content)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_remove_content)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_run_emulation)).check(matches(not(isDisplayed())));
        /*
        Action: navigate to URL with content
        Expected result:
        * add content and run emulation enabled
        * remove content not visible
         */
        onView(withId(R.id.wv_contents)).perform(navigateTo(url));
        waitForView(allOf(withId(R.id.bn_add_content), isEnabled(), isDisplayed()), TestBase.HTTP_GET_DELAY , TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(android.R.id.content)).check(matches(isEnabled()));
        onView(withId(R.id.bn_add_content)).check(matches(isEnabled()));
        onView(withId(R.id.bn_run_emulation)).check(matches(isEnabled()));
        onView(withId(R.id.bn_remove_content)).check(matches(not(isDisplayed())));
    }
    private void navigateToC64TestTitle() {
        navigateToTitle("C64", GENERAL_TEST_URL, GENERAL_TEST_TITLE, "3234dbcdba505276634bd0b7171956db1d2a0246445d02896ea71c2c7bd9c973");

    }

    private void testNoFliplist(String configId, String url) {
        prepareStreamUseropts("C64", configId);
        waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
        waitForIdle();
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgC64LibraryAdapter()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext())))
                .perform(scrollTo())
                .perform(click());
        waitForProgressDialog(withId(R.id.wv_contents));
        onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
        /*
        Action: navigate to URL with content
        Expected result:
        * add content and run emulation enabled
        * remove content not visible
         */
        onView(withId(R.id.wv_contents)).perform(navigateTo(url));
        waitForView(allOf(withId(R.id.bn_run_emulation), isEnabled(), isDisplayed()), TestBase.HTTP_GET_DELAY , TimeUnit.SECONDS);
        waitForIdle();
        /*
        Action: press "add content"
        Expected result:
        * Add content invisible
        * Remove content visible
         */
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.flip_file)).check(doesNotExist());
        pressBack();
    }

    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testArchiveOrgC64Variants() {
        waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
        testNoFliplist("a83cc715b8457b671f1fb54ab63ba16e2313fb3114e5f47d8017ca8d8db141a9", SINGLE_DISK_TEST_URL);
        pressBack();
        onView((withText(R.string.quit))).perform(click());
        waitForIdle();
        //pressBack();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        testNoFliplist("dd34af84374266ffa6b4e95d08dc93b78184a570213a20b120e65be6cf8497de", TAPE_TEST_URL);
    }

    /** @noinspection SameParameterValue*/
    private void gotoWebsite(String url) {
        /*
        waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
        onView(withId(R.id.bn_info)).perform(click());
        waitForIdle();
        onView(withText(R.string.more_content)).perform(click());
        onView(withText(new ArchiveOrgAccess.ArchiveOrgC64LibraryAdapter()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext())))
                .perform(click());
        waitForIdle();
         */
        String text = new ArchiveOrgAccess.ArchiveOrgC64LibraryAdapter().getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext());

        onView(isContentSourceViewWithTitle(text)).perform(scrollTo()).perform(click());
        //waitForActivity(BrowserActivity.class);
        waitForProgressDialog(withId(R.id.wv_contents));
        onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
        /*
        Action: navigate to URL with content
        Expected result:
        * add content and run emulation enabled
        * remove content not visible
         */
        onView(withId(R.id.wv_contents)).perform(navigateTo(url));
        waitForView(allOf(withId(R.id.bn_add_content), isEnabled(), isDisplayed()), TestBase.HTTP_GET_DELAY , TimeUnit.SECONDS);
        waitForIdle();

    }
    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testSettings() {
        waitForIdle();
        prepareStreamUseropts("C64", "3234dbcdba505276634bd0b7171956db1d2a0246445d02896ea71c2c7bd9c973");
        onView(withText(GENERAL_TEST_TITLE)).check(doesNotExist());
        /*
        Action: run download
        Expected result: Settings activity shown up after download.
         */
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForActivity(SettingsActivity.class, HTTP_GET_DELAY,  TimeUnit.SECONDS);
        //waitForProgressDialog(withId(R.id.bn_apply));
        /*
        Action: disable borders, apply and open settings again.
        Expected result: borders still disabled.
         */
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        onView(withId(R.id.rb_c64_no_border)).check(matches(isChecked()));
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        pressBack();
        waitForView(allOf(isDisplayed(),withId(R.id.bn_reload)), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        /*
        Action: leave emulation and run it again.
        Expected result:
        * Settings activity shown up after download
        * default setting for border applied
        */
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForIdle();
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_standard_border)).check(matches(isChecked()));
        /*
        Action: leave emulation
        Expected result: Main activity showing up, no tile for download.
         */
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        pressBack();
        waitForView(allOf(isDisplayed(),withId(R.id.bn_reload)), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        onView(withText(GENERAL_TEST_TITLE)).check(doesNotExist());
        /*
        Action: add download and return to main activity
        Expected result: tile for download exists.
         */
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), 20, TimeUnit.SECONDS);
        waitForIdle();
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        /*
        Action: click on downloaded tile
        Expected result: settings activity showing up.
         */
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForIdle();
        waitForProgressDialog(withId(R.id.bn_apply));
        /*
        Action: disable borders and leave both settings app + emulation
        Expected result: Main activity showing up.
         */
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForView(withText(GENERAL_TEST_TITLE),5, TimeUnit.SECONDS);
        /*
        Action: click on downloaded tile
        Expected result: emulation starting without settings activity
         */
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForProgressDialog(withId(R.id.gv_monitor));
        /*
        Action: open settings
        Expected result: changed settings still valid.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        onView(withId(R.id.gh_vic_ii_settings)).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).check(matches(isChecked()));
        pressBack();
        waitForIdle();
        pressBack();
        /*
        Action: leave both settings app + emulation
        Expected result: Main activity showing up.
        */
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, longClick()));
        waitForIdle();
        /*
        Action: long tap on tile and select uninstall
        Expected result: tile removed
         */
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        /*
        Action: add download and return to main activity
        Expected result: tile for download exists.
        */
        onView(withText(GENERAL_TEST_TITLE)).check(doesNotExist());
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), HTTP_GET_DELAY, TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);

        /*
        Action: click on downloaded tile
        Expected result: emulation activity showing up.
         */
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForProgressDialog(withId(R.id.gv_monitor));
        /*
        Action: leave emulation
        Expected result: main activity is shown with tile

         */
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, longClick()));
        waitForIdle();
        /*
        Action: long tap on tile and select uninstall
        Expected result: tile removed
         */
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        /*
        Action: add download and return to main activity
        Expected result: tile for download does not exist.
        */
        onView(withText(GENERAL_TEST_TITLE)).check(doesNotExist());
        /*
        Action: run download again and run it
        Expected result: settings not shown initially
         */
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), 20, TimeUnit.SECONDS);
        waitForIdle();
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForIdle();
        waitForDownloadDialog();
        waitForIdle();
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);


        /*
        Action: Open settings
        Expected result: settings still have values from before the tile was removed.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_vic_ii_settings)).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_standard_border)).check(matches(not(isChecked())));
        /*
        Action: leave emulation, uninstall download _and_ settings
        Expected result: tile is removed.
         */
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        /*
        Action: run download again and run it
        Expected result: settings shown initially
         */
        gotoWebsite(GENERAL_TEST_URL);
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), 20, TimeUnit.SECONDS);
        waitForIdle();
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload), isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForIdle();
        waitForDownloadDialog();
        waitForIdle();
        waitForActivity(SettingsActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        /*
        Action: check settings
        Expected result: settings have default values
         */
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_standard_border)).check(matches(isChecked()));
        /*
        Action: leave settings and emulation, uninstall download
        Expected result: tile does not exist.
         */
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
    }

    private void openvic20Roms() {
        waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgVic20CommunitySoftware().getTitle(
                InstrumentationRegistry.getInstrumentation().getTargetContext())))
                .perform(scrollTo())
                .perform(click());
        waitForIdle();
        waitForProgressDialog(allOf(instanceOf(WebView.class), isDisplayed(), isEnabled()));
        onWebView().check(webContent(hasElementWithXpath("//button")));
    }
    private final static String GAME_LABEL = "Adventureland Adventure (World)";
    private final static String GAME_URL = "https://archive.org/download/vic20_202209/vic20.rar/vic20%2FAdventureland%20Adventure%20%28World%29%20%28SYS%2032592%29.zip";
    private final static String GAME_SCREENSHOT = "screenshot-adventureland.pixeldata";

    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testArchiveOrgVic20RomsFunctions() {
        installVic20TestGame();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GAME_LABEL, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(GAME_LABEL)).check(doesNotExist());
        openvic20Roms();
        onWebView().check(webContent(not(hasElementWithXpath("//*[@class='section']/div[contains(@style,'display: block')]"))));
        onWebView().withElement(findElement(Locator.XPATH, "//div[@id='"+GAME_URL+"']/button")).perform(webClick());
        onWebView().withElement(findElement(Locator.XPATH, "//*[@class='section']/div[contains(@style,'display: block')]//button[@id='run']")).perform(webClick());
        waitForIdle();
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.gh_vic20settings)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_PAL))
                .perform(scrollTo())
                .perform(click())
                .check(matches(isChecked()));

        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(GAME_SCREENSHOT, 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        pressBack();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(withText(GAME_LABEL)).check(doesNotExist());
    }

    private void installVic20TestGame() {
        prepareStreamUseropts("VIC20", "22da889796523c2d6f1974fa6d50929e6dc74ab93617576caed3571fdfc2b1e9");
        onView(withText(GAME_LABEL)).check(doesNotExist());
        openvic20Roms();
        onWebView().check(webContent(not(hasElementWithXpath("//*[@class='section']/div[contains(@style,'display: block')]"))));
        onWebView().withElement(findElement(Locator.XPATH, "//div[@id='"+GAME_URL+"']/button")).perform(webClick());
        onWebView().check(webContent(hasElementWithXpath("//*[@class='section']/div[contains(@style,'display: block')]")));
        onWebView().withElement(findElement(Locator.XPATH, "//*[@class='section']/div[contains(@style,'display: block')]//button[@id='save']")).perform(webClick());
        checkForToast(anyOf(withText(GAME_LABEL+" wurde zum Startbildschirm hinzugefügt."), withText(GAME_LABEL+" was added to the start screen.")));
        waitForIdle(10, TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GAME_LABEL, click()));
        waitForActivity(SettingsActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        pressBack();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(GAME_SCREENSHOT, 5, TimeUnit.SECONDS)));
    }

    @Test
    @SdkSuppress(minSdkVersion=20)
    @SpecialTest
    @NetworkAccessTest
    public void testDialogs() {
        waitForIdle();
        for (String url: BrowserActivity.getUrlsWithAdapter()) {
            new Useropts(InstrumentationRegistry.getInstrumentation().getTargetContext())
                    .setValue(Useropts.Scope.GLOBAL, "show_webcontent_hint_" + url, true);
            String menutext = Objects.requireNonNull(BrowserActivity.getWebContentAdapter(url))
                    .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext());
            int textId = Objects.requireNonNull(BrowserActivity.getWebContentAdapter(url)).getLicenseTextId();
            onView(isContentSourceViewWithTitle(menutext)).perform(scrollTo()).perform(click());
            waitForIdle();
            onView(isAssignableFrom(AlertDialogLayout.class)).check(matches(isDisplayed()));
            onView(withText(textId)).check(matches(isDisplayed()));
            onView(withText(android.R.string.ok)).perform(click());
            waitForProgressDialog(withId(R.id.wv_contents));
            onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
            pressBack();
            waitForView(withId(R.id.bn_info), 5, TimeUnit.SECONDS);
            onView(isContentSourceViewWithTitle(menutext)).perform(scrollTo()).perform(click());
            waitForProgressDialog(allOf(withId(R.id.wv_contents), isDisplayed()));
            onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
            pressBack();
        }

    }
    @Test
    @SpecialTest
    @NetworkAccessTest
    @SdkSuppress(minSdkVersion=20)
    public void testCustomInitialSnapshot() {
        navigateToC64TestTitle();
        onView(withId(R.id.bn_add_content)).perform(click());
        waitForView(allOf(withId(R.id.bn_remove_content), isDisplayed()), 20, TimeUnit.SECONDS);
        pressBack();
        waitForView(allOf(withId(R.id.bn_reload),isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForProgressDialog(withId(R.id.bn_apply));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania.pixeldata", TestBase.HTTP_GET_DELAY, TimeUnit.SECONDS)));
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania-started.pixeldata", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).perform(click());
        waitForIdle();
        onView(withText(R.string.start_from_here)).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        waitForIdle();
        onView((withText(R.string.quit))).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, click()));
        waitForIdle();
        waitForProgressDialog(withId(R.id.gv_monitor));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-voodomania-started.pixeldata")));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(GENERAL_TEST_TITLE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();

    }

}
