package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.clearText;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withParentIndex;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;

import android.view.KeyEvent;
import android.widget.TableRow;

import androidx.test.ext.junit.runners.AndroidJUnit4;
import androidx.test.filters.LargeTest;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

import java.util.concurrent.TimeUnit;

@RunWith(AndroidJUnit4.class)
@LargeTest
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserdefinedSoftkeysTest extends C64EmulationTestBase {
    private static <T> Matcher<T> withStringValue(final String name) {
        return new BaseMatcher<T>() {
            @Override
            public boolean matches(Object item) {
                return item.toString().equals(name);
            }

            @Override
            public void describeTo(Description description) {

            }
        };
    }

    @Test
    public void test_touch_softkeys() {
        final String shifttext = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.left_shift_key);
       /*
        Action: open in portrait mode
        Expected result: emulation running
         */
        rotate(orientationPortrait(), isDisplayed());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        /*
        Action: open keyboard section in settings
        Excepcted result: Table with row "no Softkeys defined"
         */
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withText(R.string.keyboard_input)).perform(click());
        onView(withId(R.id.tr_show_if_empty)).check(matches(isDisplayed()));
        /*
        Action: click on button "Add"
        Expected results:
        - Dialog to define a softkey is shown.
        - Spinner "Key" is enabled
        - Spinner "Modifier key" is disabled
        - Button "Apply" is disabled
         */
        onView(withId(R.id.bn_add_softkey)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));
        onView(withId(R.id.sp_key))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        onView(withId(R.id.sp_modificator_key))
                .check(matches(isDisplayed()))
                .check(matches(not(isEnabled())));
        onView(withId(R.id.bn_apply))
                .check(matches(isDisplayed()))
                .check(matches(not(isEnabled())));
        /*
        Action: select value "1" for key#
        Expected results:
        - "Modifier key" is enabled
        - Text "1" is visible as label
        - Button "Apply" is enabled.
         */
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("1")));
        onView(withId(R.id.bn_apply)).check(matches(isEnabled()));
        /*
        Action: choose left shift as modifier key
        Expected result: label = left shift + 1
         */
        onView(withId(R.id.sp_modificator_key))
                .check(matches(isEnabled()))
                .perform(click());
        onData(isOption(shifttext)).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText(shifttext + " + 1")));
        /*
        Actions:
        - clear text
        - type "One"
        - set modifier key to none
        Expected result: label stays "One

         */

        onView(withId(R.id.et_label))
                .perform(clearText())
                .check(matches(withText("")))
                .perform(typeText("One"))
                .check(matches(withText("One")));
        waitForIdle();
        onView(withId(R.id.sp_modificator_key)).perform(click());
        onData(isOption(R.string.IDS_NONE)).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("One")));
        onView(isRoot()).perform(closeSoftKeyboard());
        /*
        Action: apply results
        Excpected results:
        - New table row with entry "One"
        - No row "no Softkeys defined"
         */
        onView(withId(R.id.bn_apply)).perform(click());
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("One")));
        onView(withId(R.id.tr_show_if_empty)).check(matches(not(isDisplayed())));
        /*
        Action: click on button "Add"
        Expected result: Dialog to define a softkey is shown.
         */
        onView(withId(R.id.bn_add_softkey)).perform(click());
        /*
        Actions:
        - choose "1" as key
        - choose "Left shift" as modifier
        Excpected result:
        - Label is "Left shift + 1"
         */
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.sp_modificator_key))
                .perform(click());
        onData(isOption(shifttext)).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label))
                .check(matches(withText(shifttext + " + 1")));
        /*
        Action: Click Checkbox hide if virtual keyboard is displayed
        Expected result: Checkbox is checked
         */
        onView(withId(R.id.cb_hide_on_keyboard))
                .perform(click())
                .check(matches(isChecked()));
        /*
        Action: apply new button
        Expected result:
        - button defined in the step before still displayed as table row
        - new entry "Left shift + 1" in the second table row.
         */
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("One")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText(shifttext + " + 1")));
        /*
        Action: apply settings
        Expected result:
        - virtual keyboard still displayed
        - Button "One" is displayed
        - Button "Ledft shift + 1" not displayed
         */
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        onView(withText("One")).check(matches(isDisplayed()));
        onView(withText(shifttext + " + 1")).check(matches(not(isDisplayed())));
        /*
        Action: rotate screen
        Expected results:
        - Keyboard not visible
        - Buttons "One" and "Left shift + 1" displayed
         */
        rotate(orientationLandscape(), not(isDisplayed()));
        onView(withText("One")).check(matches(isDisplayed()));
        onView(withText(shifttext + " + 1")).check(matches(isDisplayed()));
        /*
        Action: press both buttons ("Left Shift + 1" first, "One" second)
        Expected result : "!1" is displayed as new text
         */
        onView(withText(shifttext + " + 1")).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withText("One")).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-exclmark-one.pixelbuffer", 5, TimeUnit.SECONDS)));
         /*
        Action: open keyboard section in settings
        Excepcted result: Table with both buttons defined befire.
         */
        rotate(orientationPortrait(), isDisplayed());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withId(R.id.tr_show_if_empty)).check(matches(not(isDisplayed())));
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("One")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText(shifttext + " + 1")));
        /*
        Action: click on edit for first row
        Expected result: dialog with values from defined button "One" is displayed
         */
        onView(allOf(withId(R.id.bn_edit), isInTableRow(1))).perform(click());
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));
        onView(withId(R.id.et_label)).check(matches(withText("One")));
        onView(withId(R.id.sp_key))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        onData(withStringValue("1")).inAdapterView(withId(R.id.sp_key)).check(matches(isDisplayed()));
        onView(withId(R.id.sp_modificator_key))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        /*
        Action: modify values for label and checkbox, apply
        Expected result: new value is displayed in table.

         */
        onView(withId(R.id.et_label)).perform(clearText());
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("2")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("2")));
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("2")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText(shifttext + " + 1")));
        /*
        Actions:
        - click on button remove in second row
        - confirm dialog
        Expected result: there is no second row.
         */
        onView(allOf(withId(R.id.bn_remove), isInTableRow(2))).perform(click());
        onView(withText(R.string.yes)).perform(click());
        onView(allOf(isDisplayed(), withParentIndex(2), instanceOf(TableRow.class))).check(doesNotExist());
        /*
        Action: apply settings
        Expected result:
        - only button "2" exists
         */
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(allOf(withParent(instanceOf(SoftkeysLinearLayout.class)), not(withText("2")))).check(doesNotExist());
        onView(allOf(withParent(instanceOf(SoftkeysLinearLayout.class)), withText("2")))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-exclmark-one-two.pixelbuffer")));
    }

    @Test
    public void test_gamepad_softkeys() {
       /*
        Action: open emulation
        Expected result: emulation running
         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        /*
        Action: open keyboard section in settings
        Excepcted result: Table with row "no Softkeys defined"
         */
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withText(R.string.keyboard_input)).perform(click());
        onView(withId(R.id.tr_show_if_empty)).check(matches(isDisplayed()));
        /*
        Action: click on button "Add"
        Expected results:
        - Dialog to define a softkey is shown.
        - Empty Table for controller buttons
        - Checkbox to disable controller buttons if controller connected hidden
        - Button to add controller buttons exists
         */
        onView(withId(R.id.bn_add_softkey)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));
        onView(withText(R.string.no_buttons_mapped)).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.tl_mapped_buttons)), withParentIndex(1))).check(doesNotExist());
        onView(withId(R.id.cb_hide_on_gamepad)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_add_button))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        /*
        Action Press button to add softkeys
        Expected result: Dialog is displayed
         */
        onView(withId(R.id.bn_add_button)).perform(click());
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        /*
        Action: press Cancel button
        Expected result: previous dialog visible and unchanged
         */
        onView(withText(R.string.cancel)).perform(click());
        onView(withText(R.string.no_buttons_mapped)).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.tl_mapped_buttons)), withParentIndex(1))).check(doesNotExist());
        onView(withId(R.id.cb_hide_on_gamepad)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_add_button))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        /*
        Action Press button to add softkeys
        Expected result: Dialog is displayed
         */
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        /*
        Action: press Button A on Gamepad
        Expected result: Table row for button a (bottom button) exists
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(matches(isDisplayed()));
        onView(withId(R.id.cb_hide_on_gamepad)).perform(click()).check(matches(not(isChecked())));
        onView(withText(R.string.no_buttons_mapped)).check(matches(not(isDisplayed())));



        /*
        Action: select tablerow just added
        Expected results:
        - Dialog is displayed
        - Previous key is displayed
         */
        onView(allOf(withText(R.string.change), isInTableRow(1))).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        onView(withText(containsString(InstrumentationRegistry.getInstrumentation()
                .getTargetContext().getResources().getString(R.string.button_south)))).check(matches(isDisplayed()));
        /*
        Action: Press Button B
        Expected results:
        - Table row for button b (right button) exists
        - No other table row exists.
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_B));
        waitForIdle();
        onView(allOf(withText(R.string.button_east), isInTableRow(1))).check(matches(isDisplayed()));
        onView(isInTableRow(2)).check(doesNotExist());
        /*
        Action: Set "1" as key and press apply.
        Expected result: new button "1" is displayed in a table row.
         */
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("1")));
        onView(withId(R.id.bn_apply)).perform(click());
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("1")));
        /*
        Action: click on button "Add"
        Expected results:
        - Dialog to define a softkey is shown.
        - Empty Table for softkeys
        - Checkbox to disable softkeys if controller connected hidden
        - Button to add softkeys exists
         */

        onView(withId(R.id.bn_add_softkey)).perform(click());
        waitForIdle();
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("2")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("2")));
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        /*
        Action: press Button A on Gamepad
        Expected result: Table row for button a (bottom button) exists
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_X));
        onView(allOf(withText(R.string.button_west), isInTableRow(1))).check(matches(isDisplayed()));
        /*
        Action: Press button Apply
        Expected result: Two rows for button A and B
         */
        onView(withId(R.id.bn_apply)).perform(click());
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("1")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText("2")));
        /*
        Action: press Button Apply
        Expected result: Emulation Running
         */
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        /*
        Action: open menu and choose settings
        Expected result: Settings Activity showing up, button definitions still there
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("1")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText("2")));
        /*
        Action: leave Settings Activity, disconnect joysticks
        Expected result: Emulation shown, both buttons visible
         */
        pressBack();
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(MouseController.class, false));
        waitForActivity(EmulationActivity.class);
        onView(allOf(withParent(withId(R.id.softkeys)), withText("1"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("2"))).check(matches(isDisplayed()));
        /*
        Action: connect gamepad with buttons a and b
        Expected result: button 2 is hidden.
         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, true));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("1"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("2"))).check(matches(isDisplayed()));
        /*
        Actions: Press Buttons A, B, X, Y
        Expected result: "12" is typed.
         */
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_B));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_B));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_X));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_X));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_Y));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_Y));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-12.pixelbuffer")));
        /*
        Action: open menu and choose settings
        Expected result: Settings Activity showing up, button definitions still there
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(allOf(withId(R.id.tv_label), isInTableRow(1))).check(matches(withText("1")));
        onView(allOf(withId(R.id.tv_label), isInTableRow(2))).check(matches(withText("2")));
        /*
        Action: Open first softkey and remove button mapping (Confirm with Yey).
        Expected result: button row removed from table
         */
        onView(allOf(withId(R.id.bn_edit), isInTableRow(1))).perform(click());
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));
        onView(allOf(withText(R.string.remove), isInTableRow(1))).perform(click());
        onView(withText(R.string.yes)).perform(click());
        onView(withId(R.id.tr_show_if_empty)).check(matches(isDisplayed()));

        /*
        Action: Apply button mapping and button setting
        Excpected result: There is only one Button "2"
         */
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withId(R.id.bn_apply)).inRoot(isDialog()).perform(click());
        onView(withId(R.id.gh_keyboard)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(allOf(withParent(withId(R.id.softkeys)), withText("1"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("2"))).check(matches(isDisplayed()));
        /*
        Action: Disconnect joystick
        Expected result: there is still only one button "2"
         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("1"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("2"))).check(matches(isDisplayed()));
        /*
        Action: Connect joystick and press buttons A, B, Y
        Expected result: no text typed.
         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, true));
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_B));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_B));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_Y));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_Y));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-12.pixelbuffer")));

    }

    @Test
    public void test_settings_avoid_double_buttonbindings() {
       /*
        Action: open emulation
        Expected result: emulation running
         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        /*
        Action: open keyboard section in settings
        Excepcted result: Table with row "no Softkeys defined"
         */
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withText(R.string.keyboard_input)).perform(click());
        onView(withId(R.id.tr_show_if_empty)).check(matches(isDisplayed()));
        /*
        Action: click on button "Add"
        Expected results:
        - Dialog to define a softkey is shown.
        - Empty Table for controller buttons
        - Checkbox to disable controller buttons if controller connected hidden
        - Button to add controller buttons exists
         */
        onView(withId(R.id.bn_add_softkey)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));
        /*
        Action: select "1" as key
        Expected result: "1" is displayed in spinner
         */
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("1")));

        /*
        Action Press button to add softkeys
        Expected result: Dialog is displayed
         */
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        /*
        Action: press Button A on Gamepad
        Expected result: Table row for button a (bottom button) exists
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(matches(isDisplayed()));
        onView(withId(R.id.cb_hide_on_gamepad)).perform(click()).check(matches(not(isChecked())));
        onView(withText(R.string.no_buttons_mapped)).check(matches(not(isDisplayed())));
        /*
        Action: apply change and add another softkey

         */
        onView(withText(R.string.apply)).perform(click());

        /*
        Action Press button to add another softkey
        Expected result: Dialog is displayed
         */
        onView(withId(R.id.bn_add_softkey)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(R.string.softkey)));

        /*
        Action: select "2" as key
        Expected result: "2" is displayed in spinner
         */
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption("2")).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label)).check(matches(withText("2")));
        /*
        Action Press button to add softkeys
        Expected result: Dialog is displayed
         */

        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();

        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        /*
        Action: press Button A on Gamepad
        Expected result: Dialog still visible with warning about button being already in use
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle();
        onView(withText(R.string.button_in_use_other_key)).check(matches(isDisplayed()));
        /*
        Action: cancel dialog, save new button and open first softkey
        Expected result: first key still has button A
         */
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        onView(allOf(withId(R.id.bn_edit), isInTableRow(1))).perform(click());
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(matches(isDisplayed()));
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();

        /*
        Actions:
        - go back to second softkey
        - add button again
        - press Button A on Gamepad
        Expected result: Dialog still visible with warning about button being already in use
         */
        pressBack();
        onView(allOf(withId(R.id.bn_edit), isInTableRow(2))).perform(click());
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(doesNotExist());
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withText(R.string.button_in_use_other_key)).check(matches(isDisplayed()));
        /*
        Action: press button again
        Expected result: button assigned and shown in table
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle();
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(matches(isDisplayed()));
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle();
        onView(withText(R.string.button_in_use_this_key)).check(matches(isDisplayed()));
        pressBack();
        onView(allOf(withText(R.string.button_south), isInTableRow(1))).check(matches(isDisplayed()));
        onView(allOf(withText(R.string.button_south), isInTableRow(2))).check(doesNotExist());
        onView(withText(R.string.apply)).perform(click());
        onView(withText(R.string.keyboard_input)).check(matches(isDisplayed()));
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(isC64Key("1")).perform(tap());
        onView(isRoot()).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-12.pixelbuffer")));
    }

    private void addSoftkey(final String label, final String key, final int keycode) {
        onView(withId(R.id.bn_add_softkey)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_key)).perform(click());
        onData(isOption(key)).inRoot(isPlatformPopup()).perform(click());
        onView(withId(R.id.et_label))
                .perform(clearText())
                .check(matches(withText("")))
                .perform(typeText(label));
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withId(R.id.et_label)).check(matches(withText(label)));
        onView(withId(R.id.bn_add_button)).perform(click());
        waitForIdle();
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(keycode));
    }

    @Test
    public void test_visibility() {
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        /*
        Action: open keyboard section in settings
        Excepcted result: Table with row "no Softkeys defined"
         */
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withText(R.string.keyboard_input)).perform(click());
        onView(withId(R.id.tr_show_if_empty)).check(matches(isDisplayed()));
        /*
        Action: Add a button "Always" that will not be hidden by gamepad or keyboard.
        Expected result: button visible in table
         */
        addSoftkey("Always", "1", KeyEvent.KEYCODE_BUTTON_A);
        onView(withId(R.id.cb_hide_on_keyboard)).check(matches(not(isChecked())));
        onView(withId(R.id.cb_hide_on_gamepad))
                .check(matches(isChecked()))
                .perform(click())
                .check(matches(not(isChecked())));
        onView(withText(R.string.apply)).perform(click());
        /*
        Action: Add a button "KB-" that will  be hidden by keyboard, but not by gamepad
        Expected result: button visible in table
         */
        addSoftkey("KB-", "2", KeyEvent.KEYCODE_BUTTON_B);
        onView(withId(R.id.cb_hide_on_keyboard))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(withId(R.id.cb_hide_on_gamepad))
                .check(matches(isChecked()))
                .perform(click())
                .check(matches(not(isChecked())));
        onView(withText(R.string.apply)).perform(click());
        /*
        Action: Add a button "GP-" that will  be hidden by gamepad, but not by keyboard
        Expected result: button visible in table
         */
        addSoftkey("GP-", "3", KeyEvent.KEYCODE_BUTTON_X);
        onView(withId(R.id.cb_hide_on_keyboard)).check(matches(not(isChecked())));
        onView(withId(R.id.cb_hide_on_gamepad)).check(matches(isChecked()));
        onView(withText(R.string.apply)).perform(click());
        /*
        Action: Add a button "KB-GP-" that will  be hidden by gamepad or keyboard
        Expected result: button visible in table
         */
        addSoftkey("KB-GP-", "4", KeyEvent.KEYCODE_BUTTON_Y);
        onView(withId(R.id.cb_hide_on_keyboard))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(withId(R.id.cb_hide_on_gamepad)).check(matches(isChecked()));
        onView(withText(R.string.apply)).perform(click());
        /*
        Action: Apply settings
        Expected results:
        - Emulation shown
        - Keyboard visible
         */
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        /*
        Action: disconnect all hardware joysticks
        expected result:
        - Button "Always" visible
        - Button "KB-" hidden
        - Button "GP-" visible
        - Button "KB-GP-" hidden
         */
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(MouseController.class, false));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("Always"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("GP-"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-GP-"))).check(matches(not(isDisplayed())));
        /*
        Action: connect gamepad
        Expected result:
        - Button "Always" visible
        - Button "KB-" hidden
        - Button "GP-" hidden
        - Button "KB-GP-" hidden
         */
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, true));
        waitForIdle();
        onView(allOf(withParent(withId(R.id.softkeys)), withText("Always"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("GP-"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-GP-"))).check(matches(not(isDisplayed())));
        /*
        Action: hide keyboard
        Expected result:
        - Button "Always" visible
        - Button "KB-" visible
        - Button "GP-" hidden
        - Button "KB-GP-" hidden

         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("Always"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("GP-"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-GP-"))).check(matches(not(isDisplayed())));
        /*
        Action: disconnect gamepad
        Expected result:
        - Button "Always" visible
        - Button "KB-" visible
        - Button "GP-" visible
        - Button "KB-GP-" visible
         */
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        waitForIdle();
        onView(allOf(withParent(withId(R.id.softkeys)), withText("Always"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("GP-"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-GP-"))).check(matches(isDisplayed()));
        /*
        Action: show keyboard
        Expected result:
        - Button "Always" visible
        - Button "KB-" hidden
        - Button "GP-" visible
        - Button "KB-GP-" hidden
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("Always"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-"))).check(matches(not(isDisplayed())));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("GP-"))).check(matches(isDisplayed()));
        onView(allOf(withParent(withId(R.id.softkeys)), withText("KB-GP-"))).check(matches(not(isDisplayed())));
    }
}
