package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;

import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;

import org.hamcrest.CoreMatchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TouchScreenshotsTest extends MainActivityTestBase{
    private void adoptJoystickView(@IdRes int joystickNameResId, @IdRes int joystickOrientationId, ViewAction orientationAction) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(joystickNameResId)).perform(click());
        onView(withTagValue(equalTo(getInstrumentation().getTargetContext().getString(joystickOrientationId)))).perform(click());
        //noinspection deprecation
        onView(allOf(isDisplayed(), withId(R.id.sb_joystick_transparency))).perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER));
        onView(withText(R.string.joysticks)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(isRoot()).perform(orientationAction);
        waitForIdle();
    }

    private void captureVirtualJoystick(@NonNull String captureName, @IdRes int joystickNameResId) {
        adoptJoystickView(joystickNameResId, R.string.value_joystick_button_right, orientationLandscape());
        captureDeviceScreen(captureName+"joystick_left_landscape");
        adoptJoystickView(joystickNameResId, R.string.value_joystick_button_left, orientationLandscape());
        captureDeviceScreen(captureName+"joystick_right_landscape");
        adoptJoystickView(joystickNameResId, R.string.value_joystick_button_right, orientationPortrait());
        captureDeviceScreen(captureName+"wheel_left_portrait");
        adoptJoystickView(joystickNameResId, R.string.value_joystick_button_left, orientationPortrait());
        captureDeviceScreen(captureName+"wheel_right_portrait");
    }

    @Test
    public void takeScreenshots() {
        try {
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }

        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        captureDeviceScreen("main-activity");
        onView(withId(R.id.bn_info)).perform(click());
        onView(withText(R.string.licences)).perform(click());
        waitForIdle();
        captureDeviceScreen("licences");
        pressBack();
        onView(withId(R.id.bn_info)).perform(click());
        waitForIdle();
        onView(withText(R.string.manual)).perform(click());
        waitForIdle(10, TimeUnit.SECONDS);
        onView(withId(R.id.bn_reload)).check(matches(isDisplayed()));
        captureDeviceScreen("manual");
        pressBack();
        waitForIdle();
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        captureDeviceScreen("c64-activity-default");
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        captureDeviceScreen("menu-portrait");
        onView(isRoot()).perform(orientationLandscape());
        waitForIdle();
        captureDeviceScreen("menu-landscape");
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        captureDeviceScreen("menu-portrait");
        onView(withText(R.string.rewind)).perform(click());
        captureDeviceScreen("timemachine-portrait");
        onView(isRoot()).perform(orientationLandscape());
        captureDeviceScreen("timemachine-landscape");
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        pressBack();

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        captureDeviceScreen("savestate-portrait");
        onView(isRoot()).perform(orientationLandscape());
        waitForIdle();
        captureDeviceScreen("savestate-landscape");
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).perform(click());
        captureDeviceScreen("savestates-extended-menu");
        pressBack();
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        captureDeviceScreen("add-to-start-screen");
        onView(isRoot()).perform((closeSoftKeyboard()));
        waitForIdle();
        captureDeviceScreen("add-to-start-screen-wo-keyboard");
        pressBack();
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).perform(click());
        onView(withText(R.string.share)).inRoot(isPlatformPopup()).perform(click());
        //onView(withText(R.string.share)).perform(click());
        waitForActivity(ShareEmulationActivity.class, 1, TimeUnit.SECONDS);
        captureDeviceScreen("share-activity");
        onView(isRoot()).perform((closeSoftKeyboard()));
        captureDeviceScreen("share-activity-wo-keyboard");
        pressBack();
        waitForIdle();
        pressBack();

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        waitForActivity(SettingsActivity.class, 1, TimeUnit.SECONDS);
        captureDeviceScreen("settings-all-closed");
        onView(withId(R.id.gh_keyboard)).perform(click());
        captureDeviceScreen("settings-keyboard");
        onView(withId(R.id.gh_keyboard)).perform(click());
        onView(withId(R.id.gh_joysticks)).perform(scrollTo()).perform(click());
        captureDeviceScreen("settings-joystick");
        onView(withId(R.id.gh_joysticks)).perform(click());
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo()).perform(click());
        captureDeviceScreen("settings-c64-devices");
        onView(withId(R.id.gh_c64_settings)).perform(click());
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        captureDeviceScreen("settings-c64-vic-ii");
        onView(withId(R.id.gh_vic_ii_settings)).perform(click());
        onView(withId(R.id.gh_sid)).perform(scrollTo()).perform(click());
        captureDeviceScreen("settings-c64-sid");
        onView(withId(R.id.gh_sid)).perform(click());
        onView(withId(R.id.gh_keyboard)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_add_softkey)).perform(click());
        onView(withId(R.id.sp_key)).perform(click());
        // that's a hack to replace non working
        // onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        // but i don't care.
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadDown();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadDown();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadDown();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadCenter();
        waitForIdle();
        //onData(isOption("1")).inRoot(isPlatformPopup()).perform(click());
        captureDeviceScreen("settings-add-softkey");
        onView(isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        captureDeviceScreen("settings-list-softkey");
        onView(withId(R.id.bn_remove)).perform(click());
        captureDeviceScreen("settings-remove-softkey");
        onView(withText(R.string.yes)).perform(click());
        onView(withId(R.id.gh_keyboard)).perform(scrollTo()).perform(click());


        pressBack();
        waitForIdle();
        try {
            openDocument(extractTestAsset("soundloop.tap"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();

        captureDeviceScreen("attach-tape");
        onView(withText(R.string.IDS_ATTACH))
                .check(matches(isDisplayed()))
                .perform((click()));
        waitForIdle();
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("attach-disk");
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        waitForIdle();
        try {
            openDocument(extractTestAsset("fliplist1.vfl"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("fliplist-from-file-selection");
        pressBack();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        captureDeviceScreen("menu-extended-portrait");
        onView(isRoot()).perform(orientationLandscape());
        waitForIdle();
        captureDeviceScreen("menu-extended-landscape");
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withId(R.id.iv_tape_status)).perform(click());
        captureDeviceScreen("tape-functions");
        pressBack();

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.detach_file)).perform(click());
        captureDeviceScreen("detach");
        pressBack();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.flip_file)).perform(click());
        captureDeviceScreen("fliplist-from-menu");
        pressBack();

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        captureDeviceScreen("reset");
        pressBack();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.create_and_attach_image)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("create-image");
        onView(isRoot()).perform(closeSoftKeyboard());
        pressBack();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_PAUSE)).perform(click());
        captureDeviceScreen("pause");
        pressBack();
        pressBack();
        captureDeviceScreen("quit");
        pressBack();

        captureVirtualJoystick("virtual-joystick",R.string.virtual_touch_joystick);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo());
        onView(allOf(isDisplayed(), withText(R.string.use_secondary_button)))
                .check(matches(not(isChecked())))
                .perform(click());
        onView(withText(R.string.joysticks)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        captureVirtualJoystick("virtual-joystick-with-2nd-button",R.string.virtual_touch_joystick);

        captureVirtualJoystick("virtual-wheel",R.string.virtual_wheel_joystick);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        captureDeviceScreen("joystick-portrait-no-keyboard");
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        waitForIdle();
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        onView(withTagValue(equalTo("FIRE"))).perform(scrollTo()).perform(click());
        captureDeviceScreen("keyboardjoystick-key-selection");
        pressBack();
        onView(withText(R.string.joysticks)).perform(scrollTo()).perform(click());
        pressBack();
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("Pac-Mania", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 30, TimeUnit.SECONDS);
        waitForView(withText("Highscores"), 10, TimeUnit.SECONDS);
        captureDeviceScreen("pac-mania-startscreen");
        onView(withText("Highscores")).perform(tap());
        waitForView(withText("OK"), 5, TimeUnit.SECONDS);
        captureDeviceScreen("pac-mania-highscore");
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle(5, TimeUnit.SECONDS);
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("Monty On The Run", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle(5, TimeUnit.SECONDS);
        captureDeviceScreen("monty-on-the-run-startscreen");
        waitForView(withId(R.id.jv_fire), 300, TimeUnit.SECONDS);
        onView(withId(R.id.jv_fire)).perform(tap());
        waitForIdle(5, TimeUnit.SECONDS);
        captureDeviceScreen("monty-on-the-run-ingame");
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(R.string.name_vic20, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-vic20.pixelbuffer")));
        captureDeviceScreen("vic20");
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(R.string.name_pet, click()));
        waitForActivity(EmulationActivity.class, 30, TimeUnit.SECONDS);
        switchToPetModel("4032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032.pixelbuffer", 10, TimeUnit.SECONDS)));
        captureDeviceScreen("pet4032-grkeyboard-alpha");
        onView(withId(R.id.sw_alpha_num)).check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        captureDeviceScreen("pet4032-grkeyboard-num");
        switchToPetModel("8032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet8032.pixelbuffer", 10, TimeUnit.SECONDS)));
        captureDeviceScreen("pet8032-bukeyboard-alpha");
        onView(withId(R.id.sw_alpha_num)).check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        captureDeviceScreen("pet8032-bukeyboard-num");
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_joysticks)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withText(R.string.drive9)).perform(scrollTo());
        waitForIdle();

        onView(withId(R.id.sw_enable_keystroke_joysticks)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#42"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        waitForIdle();

        onView(allOf(isDisplayed(), withId(R.id.keyassignment_container))).perform(scrollTo());
        captureDeviceScreen("map-actions-to-keyboard-table");
        onView(allOf(isDisplayed(), withParent(withParent(withId(R.id.tr_left_key))), withTagValue(equalTo("key")))).perform(click());
        captureDeviceScreen("map-actions-to-keyboard-keys");
        pressBack();
        waitForIdle();
        pressBack();
        waitForIdle();

        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withId(R.id.sw_enable_keystroke_joysticks)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#42"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        waitForIdle();

        onView(withId(R.id.gh_petsettings)).perform(scrollTo()).perform(click());
        captureDeviceScreen("map-actions-to-keyboard-settings");
        pressBack();
        waitForIdle();

        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        testExactKeyboardVisibility(R.string.name_c64, null, "c64");
        testExactKeyboardVisibility(R.string.name_vic20, null, "vic");
        testExactKeyboardVisibility(R.string.name_pet, () -> switchToPetModel("4032"), "petgr");
        testExactKeyboardVisibility(R.string.name_pet, () -> switchToPetModel("8032"), "petbu");
        testExactKeyboardVisibility(R.string.name_c128, null, "c128");
    }
}
