 package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.not;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Rp9ConfigurationTest extends MainActivityTestBase {
    private static final String AUF_WIDERSEHEN_MONTY = "Auf Wiedersehen Monty";
    private static final String OPERATION_FIREBALL = "Operation Fireball";
    private static final String DELIVERANCE_STORMLOAD_II = "Deliverance - Stormlord II";
    @Test
    @SpecialTest
    public void test_start() throws IOException {
        onView(withText(AUF_WIDERSEHEN_MONTY)).check(doesNotExist());
        setIntendedFile(new File(extractTestAsset("Auf Wiedersehen Monty (Gremlin, 1987, C64).rp9")));
        onView(isContentSourceViewWithTitle(R.string.import_local_content)).perform(scrollTo()).perform(click());
        onView(isRoot()).perform(createdTileAction(AUF_WIDERSEHEN_MONTY, click()));
        waitForActivity(EmulationActivity.class);
        waitForIdle(4, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-firstload-auf-wiedersehen-monty.pixelbuffer")));
        waitForIdle(10, TimeUnit.SECONDS);
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(AUF_WIDERSEHEN_MONTY, click()));
        waitForActivity(EmulationActivity.class);
        waitForIdle(4, TimeUnit.SECONDS);
        onView(withId(R.id.jv_directions)).check(doesNotExist());
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-firstload-auf-wiedersehen-monty.pixelbuffer"))));
        onView(isRoot())
                .perform(setJoysticksConnected(KeyboardJoystick.class, false));
        onView(isRoot())
                .perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot())
                .perform(setJoysticksConnected(GameControllerJoystick.class, false));

        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.jv_directions)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class);

        onView(isRoot()).perform(createdTileAction(AUF_WIDERSEHEN_MONTY, longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(AUF_WIDERSEHEN_MONTY)).check(doesNotExist());
        onView(withText(AUF_WIDERSEHEN_MONTY)).check(doesNotExist());
    }
    @Test
    @SpecialTest
    public void test_tape() throws IOException {
        onView(withText(OPERATION_FIREBALL)).check(doesNotExist());
        setIntendedFile(new File(extractTestAsset("Operation Fireball (Alternative Software, 1987, C64).rp9")));
        onView(isContentSourceViewWithTitle(R.string.import_local_content)).perform(scrollTo()).perform(click());
        onView(isRoot()).perform(createdTileAction(OPERATION_FIREBALL, click()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-operation-fireball.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(OPERATION_FIREBALL, longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(OPERATION_FIREBALL)).check(doesNotExist());
    }
    @Test
    @SpecialTest
    public void test_fliplist() throws IOException {
        onView(withText(DELIVERANCE_STORMLOAD_II)).check(doesNotExist());
        setIntendedFile(new File(extractTestAsset("Deliverance - Stormlord II (Hewson, 1990, C64).rp9")));
        onView(isContentSourceViewWithTitle(R.string.import_local_content)).perform(scrollTo()).perform(click());
        onView(isRoot()).perform(createdTileAction(DELIVERANCE_STORMLOAD_II, click()));
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.flip_file)).perform(click());
        waitForIdle();
        onView(withText("deliverance2.D64"))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        onView(withText("deliverance1.D64"))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()));
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(DELIVERANCE_STORMLOAD_II, longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(DELIVERANCE_STORMLOAD_II)).check(doesNotExist());
    }
    @Test
    @SpecialTest
    public void test_instant_run() throws IOException {
        Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
        Uri uri = Uri.fromFile(new File(extractTestAsset("Auf Wiedersehen Monty (Gremlin, 1987, C64).rp9")));
        Intent i = new Intent(ctx, ImportFileActivity.class);
        i.setData(uri);
        i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        ctx.startActivity(i);
        waitForActivity(ImportFileActivity.class);
        onView(withId(R.id.bn_run)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-firstload-auf-wiedersehen-monty.pixelbuffer")));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
    }
    @Test
    @SpecialTest
    public void test_import_by_intent() throws IOException {
        Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
        Uri uri = Uri.fromFile(new File(extractTestAsset("Auf Wiedersehen Monty (Gremlin, 1987, C64).rp9")));
        Intent i = new Intent(ctx, ImportFileActivity.class);
        i.setData(uri);
        i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        ctx.startActivity(i);
        waitForActivity(ImportFileActivity.class);
        onView(withId(R.id.bn_add)).perform(click());
        pressBack();
        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(AUF_WIDERSEHEN_MONTY, click()));
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-firstload-auf-wiedersehen-monty.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        onView(isRoot()).perform(createdTileAction(AUF_WIDERSEHEN_MONTY, longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());


    }
}
