package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.not;

import androidx.test.filters.SdkSuppress;

import org.junit.Test;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class PreConfigurationTest extends MainActivityTestBase {
    @Test
    @SdkSuppress(minSdkVersion=20)
    public void t_0010_bubble_escape() throws InterruptedException {
        setTestLocale(Locale.US);
        /*
        Action: disable hardware joysticks, launch Bubble Escape
        Expected result: bubble escape is shown, virtual touch joystick controls are visible
         */
        onView(withText("Bubble Escape"))
                .perform(setJoysticksConnected(DpadJoystick.class, false))
                .perform(setJoysticksConnected(GameControllerJoystick.class, false))
                .perform(scrollTo())
                .perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-bubble-escape.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_fire)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_directions)).check(matches(isDisplayed()));
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        /*
        Action: touch virtual joystick on the left
        Expected result: screen content changing.
         */
        FingerState state = new FingerState();
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, state, 20, 50));
        Thread.sleep(500);
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, state, 50, 50));
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-bubble-escape.pixelbuffer"))));
        onView(withId(R.id.jv_directions))
                .perform(setJoysticksConnected(DpadJoystick.class, true))
                .check(doesNotExist());
        /*
        Action: connect hardware joystick
        Expected result: virtual touch joystick is hidden.
         */
        onView(withId(R.id.jv_fire)).check(doesNotExist());




    }
}