package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;

import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.not;

import android.os.RemoteException;

import androidx.test.filters.SdkSuppress;
import androidx.test.uiautomator.UiDevice;

import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class PhoneOrTabletDisplayTest extends MainActivityTestBase{
    @Test
    public void testScreenOrientation() throws RemoteException {
        UiDevice device = UiDevice.getInstance(getInstrumentation());
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        device.setOrientationLandscape();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.mobile_device_settings)).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_screen_orientation_presetting)).check(matches(isChecked()));
        onView(withText(R.string.landscape)).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        waitForIdle(1, TimeUnit.SECONDS);
        device.setOrientationLandscape();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        device.setOrientationNatural();
        waitForIdle(1, TimeUnit.SECONDS);
        device.unfreezeRotation();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.mobile_device_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withText(R.string.landscape)).check(matches(isChecked()));
        onView(withText(R.string.portrait)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        device.setOrientationLandscape();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        device.setOrientationNatural();
        device.unfreezeRotation();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,5,TimeUnit.SECONDS);
    }
    @Test
    @SdkSuppress(minSdkVersion=20)
    public void testScreenOrientationPreinstalled() throws RemoteException {
        UiDevice device = UiDevice.getInstance(getInstrumentation());
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.mobile_device_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_screen_orientation_presetting)).check(matches(isChecked()));
        onView(withText(R.string.portrait)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        device.setOrientationNatural();
        device.unfreezeRotation();
        waitForIdle(1, TimeUnit.SECONDS);
    }
    @Test
    public void testKeyboardVisibility() throws RemoteException {
        UiDevice device = UiDevice.getInstance(getInstrumentation());
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        device.setOrientationLandscape();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);

        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.mobile_device_settings)).perform(click());
        onView(withId(R.id.rb_show_keyboard_default)).check(matches(isChecked()));
        onView(withText(R.string.never)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle();
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForView(allOf(not(isDisplayed()), withId(R.id.keyboardview)), 2, TimeUnit.SECONDS);
        device.setOrientationLandscape();
        waitForIdle();
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        //onView(withText(R.string.mobile_device_settings)).perform(scrollTo()).perform(click());
        onView(withText(R.string.never)).check(matches(isChecked()));
        onView(withText(R.string.always)).perform(scrollTo())
                .perform(click())
                .check(matches(isChecked()));
        onView(withText(R.string.apply)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);

        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));

        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        device.setOrientationLandscape();
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        //onView(withText(R.string.mobile_device_settings)).perform(click());
        onView(withText(R.string.always)).check(matches(isChecked()));
        onView(withText(R.string.portrait_mode_only)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        device.setOrientationPortrait();
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
    }

    @Test
    @SdkSuppress(minSdkVersion=20)
    public void testKeyboardVisibilityPreinstalled() throws RemoteException {
        UiDevice device = UiDevice.getInstance(getInstrumentation());
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isInLandscapeMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.mobile_device_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.rb_show_keyboard_default)).check(matches(isChecked()));
        onView(withText(R.string.portrait)).perform(scrollTo()).perform(click());
        onView(withText(R.string.portrait_mode_only)).perform(scrollTo()).perform(click());

        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        onView(isRoot()).check(matches(isInPortraitMode()));
        waitForIdle(1, TimeUnit.SECONDS);
        device.setOrientationNatural();
        device.unfreezeRotation();
        waitForIdle(1, TimeUnit.SECONDS);
    }

}
