package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;

import android.view.KeyEvent;

import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DpadJoystickTest extends C64JoystickTestBase {

    @Test
    public void t_0010_alltests() {
        /*
        Action choose Joystick and load JOYSTICKTEST from testprograms.
        Expected result: 255 is displayed.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick left
        Expected result: 251 is displayed
         */
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick right
        Expected result: 247 is displayed
         */
        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick up
        Expected result: 254 is displayed
         */

        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick down
        Expected result: 253 is displayed
         */

        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Center Joystick
        Expected result: 255 is displayed
         */
        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick up right
        Expected result: 246 is displayed
         */

        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up-right.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Keep Joystick up right, press fire
        Expected result: 230 is displayed
         */

        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up-right-fire.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Center Joystick, release fire
        Expected result: 255 is displayed
         */

        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Press fire
        Expected result: 239 is displayed
         */

        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Release fire
        Expected result: 255 is displayed
         */

        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: press Button other device
        Expected result: 255 is displayed
         */
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BUTTON_A, -1));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_A, -1));

        /*
        Action: Press select
        Expected result: 255 is displayed
         */
        //onView(withId(R.id.screen)).perform(pressKey(KeyEvent.KEYCODE_BUTTON_SELECT));
        //onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        //onView(withId(R.id.screen)).perform(releaseKey(KeyEvent.KEYCODE_BUTTON_SELECT));
    }
    @Test
    public void test_secondary_button_alt_functions() {
        test_specific_button(
                () -> onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BUTTON_B, DEVICE_ID)),
                () -> onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_B, DEVICE_ID)),
                () -> onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT)),
                () -> onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT)),
                new C64JoystickTestBase.UnitTestDpadJoystick().toString()
        );
    }

}