    package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasExtraWithKey;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;

import androidx.test.espresso.intent.Intents;
import androidx.test.espresso.intent.matcher.IntentMatchers;
import androidx.test.filters.SdkSuppress;

import org.junit.Test;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DownloaderFactoryTest extends MainActivityTestBase {
    @Test
    public void t_0140_start_c64() {
        removeSystemDownloads("C64");
        removeSystemDownloads("VIC20");
        removeSystemDownloads("DRIVES");
        removeSystemDownloads("PRINTER");
        removePackageDownloads("C64", "bubble_escape");
        waitForIdle();
        onView(withText(R.string.name_c64)).perform(click());
        waitForDownloadDialog();
        waitForEmulation();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,1,TimeUnit.SECONDS);
        setNetworkEnabled(false);
        onView(withText(R.string.name_c64)).perform(click());
        waitForEmulation();

        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
    }
    @Test
    public void t_0170_start_vic20()  {
        removeSystemDownloads("VIC20");
        removeSystemDownloads("DRIVES");
        removeSystemDownloads("PRINTER");
        removePackageDownloads("C64", "bubble_escape");
        waitForIdle();
        setNetworkEnabled(false);
        onView(withText(R.string.name_vic20)).perform(click());
        waitForError();
        pressBack();
        waitForIdle();
        setNetworkEnabled(true);
        onView(withText(R.string.name_vic20)).perform(click());
        waitForDownloadDialog();
        waitForEmulation("screenshot-machine-ready-vic20.pixelbuffer");
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
    }

    @Test
    @SdkSuppress(minSdkVersion=20)
    public void t_0240_start_system_and_package() {
        removeSystemDownloads("VIC20");
        removeSystemDownloads("C64");
        removeSystemDownloads("DRIVES");
        removeSystemDownloads("PRINTER");
        removePackageDownloads("C64", "bubble_escape");
        onView(withText(R.string.name_c64)).perform(click());
        waitForDownloadDialog();
        waitForActivity(EmulationActivity.class, 60, TimeUnit.SECONDS);
        waitForEmulation();
        waitForIdle();

        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        setNetworkEnabled(false);
        waitForActivity(MainActivity.class,5,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));

        waitForError();
        pressBack();
        waitForIdle();
        setNetworkEnabled(true);
        waitForActivity(MainActivity.class,1,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForDownloadDialog();
        waitForEmulation("screenshot-bubble-escape.pixelbuffer");

        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
    }

    @Test
    public void t_0400_localstorage() throws  IOException {
        setTestLocale(Locale.US);
        /*
        Action: clear cache and disable network, start VIC 20
        Expected result: Error
         */

            removeSystemDownloads("VIC20");
            removeSystemDownloads("C64");
            removeSystemDownloads("DRIVES");
            removeSystemDownloads("PRINTER");
        removePackageDownloads("C64", "bubble_escape");
        setNetworkEnabled(false);
            onView(withText(R.string.name_vic20)).perform(click());
            waitForError();
            /*
            Action: Enable network and click retry
            Expected result: VIC 20 showing up
             */
            setNetworkEnabled(true);
            onView(withText(R.string.retry)).perform(click());
            waitForEmulation("screenshot-machine-ready-vic20.pixelbuffer");
            /*
            Action: back to main screen, disable network, tap on C64
            Expected result: error about C64/kernal missing
             */
            pressBack();
            onView((withText(R.string.global_action_logout))).perform(click());
            waitForIdle();
            waitForActivity(MainActivity.class,1,TimeUnit.SECONDS);
            removeSystemDownloads("C64");
            removeSystemDownloads("DRIVES");
            setNetworkEnabled(false);
            onView(withText(R.string.name_c64)).perform(click());
            waitForError("C64/kernal");
            /*
            Action: click on "Choose file" and choose correct file kernal
            Expected result: Error about C64/chargen missing
             */
            setIntentCallback(extractTestAsset("kernal"));
            onView(withText(R.string.local_file)).perform(click());
            waitForError("C64/chargen");
            /*
            Action: click on "Choose file" and choose correct file chargen
            Expected result: Error about C64/basic missing
             */
            setIntentCallback(extractTestAsset("chargen"));
            onView(withText(R.string.local_file)).perform(click());
            waitForError();
            waitForError("C64/basic");
            pressBack();
            waitForIdle();
            onView(withText(R.string.name_c64)).perform(click());
            waitForError("C64/basic");
            /*
            Action:
            Choose wrong file kernal
            Expected result: Message with question, if this is the correct file.
             */
            setIntentCallback(extractTestAsset("chargen"));
            onView(withText(R.string.local_file)).perform(click());
            waitForError();
            /*
            Action
            Choose correct file basic
            Expected result: Error about DRIVES/dos1541 missing
             */
            setIntentCallback(extractTestAsset("basic"));
            onView(withText(R.string.choose_other)).perform(click());
            waitForError("DRIVES/dos1541");
            /*
            Action: click on "Choose file" and choose correct file dos1541
            Expected result: C64 showing up

             */
            setIntentCallback(extractTestAsset("dos1541"));
            onView(withText(R.string.local_file)).perform(click());
            waitForEmulation();
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                    .check(matches(isScreenUpdating()));
            /*
            Action:
            type LOAD "$",8
            Expected result: ? FILE NOT FOUND ERROR
             */
            type_load_directory(8);
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error.pixelbuffer", 5, TimeUnit.SECONDS)));

            pressBack();
            onView((withText(R.string.global_action_logout))).perform(click());
            waitForIdle();
            /*
            Action: Tap on Monty on the run
            Expected result: Error, Download failed.
             */

            removePackageDownloads("C64", "bubble_escape");
            removePackageDownloads("C64", "monty_on_the_run");
            waitForActivity(MainActivity.class,10,TimeUnit.SECONDS);
            onView(isRoot()).perform(createdTileAction("Monty On The Run", click()));
            waitForIdle();
            waitForError();
            /*
            Action: press back
            Expected result: Error disappears
             */
            pressBack();
            waitForIdle();
            /*
            Action: Tap on Bubble Escape
            Expected result: Error, Download failed.
             */

        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        /*
        Action: tap on link
        Expected result: Error disappears
         */
        Intents.release();
        Intents.init();
        intending(anyOf(allOf(IntentMatchers.hasAction(Intent.ACTION_CHOOSER), hasExtraWithKey(Intent.EXTRA_INTENT)), hasAction(Intent.ACTION_SEND))).respondWithFunction(
                intent -> new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        waitForError();
        onView(withText(R.string.share_link)).perform(click());
        waitForIdle();
        /*
        Action: Tap on Bubble Escape
        Expected result: Error, Download failed.
         */
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForError();
        /*
        Action: tap on Open File, import correct zip
        Expected result: Bubble Escape starting
         */
        setIntentCallback(extractTestAsset("8-bitwonders-builtin-games.zip"));
        onView(withText(R.string.open_file)).perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-bubble-escape.pixelbuffer",20, TimeUnit.SECONDS)));
        /*
        Action: leave emulation, confirm message, start Monty On The run
        Expected result: Monty on the urn starting.
         */
        pressBack();
        waitForIdle();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,5,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("Monty On The Run", click()));
        waitForActivity(EmulationActivity.class, 60, TimeUnit.SECONDS);

    }
}