package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.withId;

import junit.framework.AssertionFailedError;

import org.junit.ClassRule;
import org.junit.Test;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class C64CountryDefaultsUsTest extends C64EmulationTestBase {
    @ClassRule
    public static final ForceLocaleRule localeTestRule = new ForceLocaleRule(Locale.US);

    @Test
    public void tv_standard() {
        try {
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-ntsc.pixelbuffer", 10, TimeUnit.SECONDS)));
        } catch (AssertionFailedError e) {
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-ntsc-v2.pixelbuffer", 10, TimeUnit.SECONDS)));
        }
    }
}
