package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;

import androidx.test.espresso.NoMatchingViewException;

import org.junit.Test;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class C128SettingsTest extends MainActivityTestBase{
    @Test
    public void vicii_settings() {
        onView(withText(R.string.name_c128)).perform(click());
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-c128-typed-blerb.pixelbuffer", 300, TimeUnit.MILLISECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic_ii_vdc_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("VICIIBorderMode"))),withTagValue(equalTo("3"))))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("screenshot-c128-typed-blerb-borderless.pixelbuffer", 2, TimeUnit.SECONDS)));
    }
    @Test
    public void testMonitorSwitchMenu() {
        /*
        Action: run C64
        Expected result: no menu item to switch monitor
         */
        onView(isRoot()).perform(createdTileAction(R.string.name_c64, click()));
        waitForActivity(EmulationActivity.class,5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.switch_monitor_long)).check(doesNotExist());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_mobile_device_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.multimonitor_options)).check(matches(not(isDisplayed())));
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        /*
        Actions:
        - Run C128
        - Switch Output to VDC
        - Type "VDC
        Expected: result: 80 column screen visible with text VDC
         */
        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(R.string.name_c128, click()));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.tv_monitor)).check(matches(withText(R.string.c128_40cols)));
        for (String key: Arrays.asList("ESC", "X", "V", "D", "C")) {
            onView(isC64Key(key)).perform(tap());
        }
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("Drive8Type"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.switch_monitor_long)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-c128-80-col-text.pixelbuffer")));
        try {
            onView(withId(R.id.sw_alpha_num)).check(matches(not(isChecked()))).perform(click());
            waitForIdle();
        } catch (NoMatchingViewException e) {
            // that's ok
        }
        /*
        Action: turn on 40/80 key and restart emulation
        Expected result: starting in 80 column mode
         */
        onView(withId(R.id.toggle_40_80)).check(matches(not(isHighlightedC64Key()))).perform(tap());
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(R.string.name_c128, click()));
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128-80col.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Actions:
        - set last visible monitor to be default mode
        - switch to 40 columns
        - leave and restart emulation
        Expected result: Emulation starting in 80 column mode, but 40 column display visible
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_mobile_device_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.multimonitor_options)).perform(scrollTo());
        onView(withId(R.id.rb_machine_settings)).check(matches(isChecked()));
        onView(withId(R.id.rb_last_monitor_visible)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.switch_monitor_long)).perform(scrollTo()).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-c128-40col-inactive.pixelbuffer")));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction(R.string.name_c128, click()));
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-c128-40col-inactive.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());



    }
}
