package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import android.content.Context;
import android.content.pm.PackageManager;
import android.view.KeyEvent;

import androidx.appcompat.widget.AlertDialogLayout;

import androidx.test.espresso.NoMatchingViewException;
import androidx.test.filters.SdkSuppress;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class AAAPrepareFirstTest extends MainActivityTestBase {
    private void prepare(int resId) {
        try {
            waitForIdle();
            onView(isAssignableFrom(AlertDialogLayout.class)).check(matches(isDisplayed()));
            onView(withText(android.R.string.ok)).perform(click());

        } catch (NoMatchingViewException e) {
            // nothing
        }
        try {
            onView(withId(R.id.bn_close_changelog))
                    .check(matches(isDisplayed()))
                    .perform(click());

        } catch (NoMatchingViewException e) {
            // nothing
        }
        waitForActivity(MainActivity.class, 1, TimeUnit.SECONDS);
        onView(withText(resId)).perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
    }
    @Test
    @TvTest
    @NetworkAccessTest
    @PreviewScreenshotTest
    public void t_01_prepare_c64() {
        prepare(R.string.name_c64);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));
        try {
            openDocument(extractTestAsset("soundloop.t64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("SOUNDLOOP")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        pressBack();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadCenter();

    }
    @Test
    @TvTest
    @NetworkAccessTest
    @PreviewScreenshotTest
    public void t_02_prepare_vic20() {
        prepare(R.string.name_vic20);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-vic20.pixelbuffer",10,TimeUnit.SECONDS)));
        pressBack();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadCenter();
    }
    @Test
    @SdkSuppress(minSdkVersion=20)
    @NetworkAccessTest
    @SpecialTest
    @PreviewScreenshotTest
    public void t_03_prepareHints() {
        for (String url: BrowserActivity.getUrlsWithAdapter()) {
            String text = Objects.requireNonNull(BrowserActivity.getWebContentAdapter(url))
                    .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext());
            onView(isContentSourceViewWithTitle(text)).perform(scrollTo()).perform(click());
            waitForIdle();
            try {
                onView(isAssignableFrom(AlertDialogLayout.class)).check(matches(isDisplayed()));
                onView(withText(android.R.string.ok)).perform(click());
                waitForIdle();
            } catch (NoMatchingViewException e) {
                // ok
            }
            waitForIdle(1, TimeUnit.SECONDS);
            try {
                onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
            } catch (Exception e) {
                waitForProgressDialog(withId(R.id.wv_contents));
            }            waitForIdle();

            pressBack();
            waitForActivity(MainActivity.class, 1, TimeUnit.SECONDS);
        }
    }
    @Test
    @TvTest
    @NetworkAccessTest
    @PreviewScreenshotTest
    public void t_04_prepare_pet() {
        prepare(R.string.name_pet);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadCenter();

    }
    @Test
    @TvTest
    @NetworkAccessTest
    @PreviewScreenshotTest
    public void t_04_prepare_c128() {
        prepare(R.string.name_c128);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
        waitForIdle();
        pressBack();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadCenter();

    }
}
