package de.questmaster.wettkampf_funk_trainer.utilities;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.*;

public class PrefsHelperTest {

    @Mock
    private SharedPreferences mockSharedPreferences;

    @Mock
    private Editor mockEditor;

    private PrefsHelper prefsHelper;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks(this);

        when(mockSharedPreferences.edit()).thenReturn(mockEditor);
        when(mockEditor.putBoolean(anyString(), anyBoolean())).thenReturn(mockEditor);
        when(mockEditor.putInt(anyString(), anyInt())).thenReturn(mockEditor);
        doNothing().when(mockEditor).apply();

        prefsHelper = new PrefsHelper(mockSharedPreferences);
    }

    @Test
    public void isFirstLaunch_shouldReturnTrueByDefault() {
        when(mockSharedPreferences.getBoolean(anyString(), anyBoolean())).thenReturn(true);
        assertTrue(prefsHelper.isFirstLaunch());
    }

    @Test
    public void isFirstLaunch_shouldReturnFalseAfterSet() {
        when(mockSharedPreferences.getBoolean(anyString(), anyBoolean())).thenReturn(false);
        prefsHelper.setFirstLaunch(false);
        assertFalse(prefsHelper.isFirstLaunch());
    }

    @Test
    public void setFirstLaunch_shouldCallEditorPutBoolean() {
        prefsHelper.setFirstLaunch(false);
        verify(mockEditor).putBoolean(anyString(), eq(false));
        verify(mockEditor).apply();
    }

    @Test
    public void getAppLaunchCount_shouldReturnZeroByDefault() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(0);
        assertEquals(0, prefsHelper.getAppLaunchCount());
    }

    @Test
    public void addAppLaunch_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(5);
        prefsHelper.addAppLaunch();
        verify(mockEditor).putInt(anyString(), eq(6));
        verify(mockEditor).apply();
    }

    @Test
    public void addStartTrainingElCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(3);
        prefsHelper.addStartTrainingElCount();
        verify(mockEditor).putInt(anyString(), eq(4));
        verify(mockEditor).apply();
    }

    @Test
    public void addFinishTrainingElCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(2);
        prefsHelper.addFinishTrainingElCount();
        verify(mockEditor).putInt(anyString(), eq(3));
        verify(mockEditor).apply();
    }

    @Test
    public void addStartTrainingAtCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(1);
        prefsHelper.addStartTrainingAtCount();
        verify(mockEditor).putInt(anyString(), eq(2));
        verify(mockEditor).apply();
    }

    @Test
    public void addFinishTrainingAtCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(4);
        prefsHelper.addFinishTrainingAtCount();
        verify(mockEditor).putInt(anyString(), eq(5));
        verify(mockEditor).apply();
    }

    @Test
    public void addStartTrainingWtCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(6);
        prefsHelper.addStartTrainingWtCount();
        verify(mockEditor).putInt(anyString(), eq(7));
        verify(mockEditor).apply();
    }

    @Test
    public void addFinishTrainingWtCount_shouldIncrementCount() {
        when(mockSharedPreferences.getInt(anyString(), anyInt())).thenReturn(7);
        prefsHelper.addFinishTrainingWtCount();
        verify(mockEditor).putInt(anyString(), eq(8));
        verify(mockEditor).apply();
    }
}