package de.questmaster.wettkampf_funk_trainer.data;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThrows;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import android.content.SharedPreferences;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import timber.log.Timber;

//@Ignore("This class is currently under development")
public class FunkSpruecheTest {

    @Mock
    private SharedPreferences mockSharedPreferences;

    @Mock
    private Timber.Tree mockTree;

    private FunkSprüche funkSprüche;
    private static final String LÖSCHÜBUNG = "Löschangriff";
    private static final String GABC = "GABC";

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks(this);

        Timber.plant(mockTree);
        //doNothing().when(mockLogger).debug(anyString(), (Object) any());
        //doNothing().when(mockLogger).error(anyString(), (Object) any());
        //doNothing().when(mockLogger).debug(anyString());
    }

    @Test
    public void constructor_shouldInitializeLoeschangriff() {
        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("löschen");
        funkSprüche = new FunkSprüche(mockSharedPreferences, FunkSpruch.Sprecher.A_TRUPP) {
            @Override
            List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
                List<FunkSpruch> list = new ArrayList<>();
                list.add(new FunkSpruch(FunkSpruch.Sprecher.A_TRUPP, "Test Spruch 1"));
                return list;
            }

            @Override
            List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
                return null;
            }
        };

        assertNotNull(funkSprüche.funksprueche());
        assertEquals(1, funkSprüche.funksprueche().size());
        assertEquals("Test Spruch 1", funkSprüche.funksprueche().get(0).getSpruch());
        assertEquals(FunkSpruch.Sprecher.A_TRUPP, funkSprüche.getSprecher());
    }

    @Test
    public void constructor_shouldInitializeGABC() {
        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("gabc");
        funkSprüche = new FunkSprüche(mockSharedPreferences, FunkSpruch.Sprecher.W_TRUPP) {
            @Override
            List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
                return null;
            }

            @Override
            List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
                List<FunkSpruch> list = new ArrayList<>();
                list.add(new FunkSpruch(FunkSpruch.Sprecher.W_TRUPP, "Test Spruch 2"));
                return list;
            }
        };

        assertNotNull(funkSprüche.funksprueche());
        assertEquals(1, funkSprüche.funksprueche().size());
        assertEquals("Test Spruch 2", funkSprüche.funksprueche().get(0).getSpruch());
        assertEquals(FunkSpruch.Sprecher.W_TRUPP, funkSprüche.getSprecher());
    }

    @Test
    public void constructor_shouldThrowAssertionErrorForUnknownUebung() {
        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("Unknown");
        assertThrows(AssertionError.class, () -> {
            funkSprüche = new FunkSprüche(mockSharedPreferences, FunkSpruch.Sprecher.A_TRUPP) {
                @Override
                List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
                    return null;
                }

                @Override
                List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
                    return null;
                }
            };
        });
    }

    @Test
    public void funksprueche_shouldReturnCorrectList() {
        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("löschen");
        List<FunkSpruch> expectedList = new ArrayList<>();
        expectedList.add(new FunkSpruch(FunkSpruch.Sprecher.A_TRUPP, "Test Spruch 1"));
        funkSprüche = new FunkSprüche(mockSharedPreferences, FunkSpruch.Sprecher.A_TRUPP) {
            @Override
            List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
                return expectedList;
            }

            @Override
            List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
                return null;
            }
        };

        List<FunkSpruch> actualList = funkSprüche.funksprueche();

        assertEquals(expectedList, actualList);
    }

    @Test
    public void updateItems_shouldReinitializeLoeschangriff() {
        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("löschen");
        List<FunkSpruch> expectedList = new ArrayList<>();
        List<FunkSpruch> expectedList2 = new ArrayList<>();
        expectedList.add(new FunkSpruch(FunkSpruch.Sprecher.A_TRUPP, "Test Spruch 1"));
        expectedList2.add(new FunkSpruch(FunkSpruch.Sprecher.W_TRUPP, "Test Spruch 2"));
        funkSprüche = new FunkSprüche(mockSharedPreferences, FunkSpruch.Sprecher.A_TRUPP) {
            @Override
            List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
                return expectedList;
            }

            @Override
            List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
                return expectedList2;
            }
        };

        when(mockSharedPreferences.getString(anyString(), anyString())).thenReturn("gabc");
        funkSprüche.updateItems(mockSharedPreferences);

        assertEquals(expectedList2, funkSprüche.funksprueche());
    }

    @Test
    public void neu_shouldReturnNewFunkSpruch() {
        FunkSpruch fs = FunkSprüche.neu(FunkSpruch.Sprecher.A_TRUPP, "Test");
        assertEquals(FunkSpruch.Sprecher.A_TRUPP, fs.getSprecher());
        assertEquals("Test", fs.getSpruch());
    }
}