package de.questmaster.wettkampf_funk_trainer.data;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

public class FunkSpruchTest {

    @Test
    public void testConstructorAndGetters() {
        FunkSpruch.Sprecher sprecher = FunkSpruch.Sprecher.A_TRUPP;
        String message = "Test Nachricht";
        FunkSpruch funkSpruch = new FunkSpruch(sprecher, message);

        assertEquals(sprecher, funkSpruch.getSprecher());
        assertEquals(message, funkSpruch.getSpruch());
    }

    @Test
    public void testToNameString() {
        assertEquals("ZLST", FunkSpruch.Sprecher.ZLST.toNameString());
        assertEquals("AT", FunkSpruch.Sprecher.A_TRUPP.toNameString());
        assertEquals("WT", FunkSpruch.Sprecher.W_TRUPP.toNameString());
        assertEquals("EL", FunkSpruch.Sprecher.E_LEITER.toNameString());
        assertEquals("MA", FunkSpruch.Sprecher.MASCHI.toNameString());
        // KONTEXT hat keinen expliziten Fall in der Switch-Anweisung, daher wird ein leerer String zurückgegeben.
        assertEquals("", FunkSpruch.Sprecher.KONTEXT.toNameString());
        assertEquals("SR", FunkSpruch.Sprecher.SCHIRI.toNameString());
        assertEquals("ST", FunkSpruch.Sprecher.S_TRUPP.toNameString());
    }
}