package de.questmaster.wettkampf_funk_trainer.ui.home;

import android.content.res.Resources;

import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.AndroidViewModel;
import android.app.Application;

import de.questmaster.wettkampf_funk_trainer.R;

public class HomeViewModel extends AndroidViewModel {

    private final MutableLiveData<String> mWebviewAktuelles;

    public HomeViewModel(@NonNull Application application) {
        super(application);

        // Get the Application context
        Resources resources = getApplication().getResources();

        // Load the string resource
        String url = resources.getString(R.string.welcome_version_page);

        mWebviewAktuelles = new MutableLiveData<>();
        mWebviewAktuelles.setValue(url);
    }


    public LiveData<String> getWebviewAktuelles() {
        return mWebviewAktuelles;
    }
}