package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MaFunkSprüche extends FunkSprüche {

    private boolean lastSchlauchhaspel;
    private boolean lastGruppe;
    private boolean changedInLastUpdate = false;

    public MaFunkSprüche(SharedPreferences sp) {
        super(sp, FunkSpruch.Sprecher.MASCHI);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return super.isChangedInLastUpdate() || changedInLastUpdate;
    }

    private void checkForChanges(boolean currentSchlauchhaspel, boolean currentGruppe) {
        changedInLastUpdate = currentSchlauchhaspel != lastSchlauchhaspel || currentGruppe != lastGruppe;
        lastSchlauchhaspel = currentSchlauchhaspel;
        lastGruppe = currentGruppe;
    }

    List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
        boolean currentSchlauchhaspel = sp.getBoolean("schlauchhaspel", false);
        checkForChanges(currentSchlauchhaspel, lastGruppe);

        List<FunkSpruch> sprueche = new ArrayList<FunkSpruch>() {};

        // Hier option keine schlauchhaspel
        List<FunkSpruch> funkSpruchList_leer = List.of(
                neu(FunkSpruch.Sprecher.KONTEXT, "In diesem Szenario kein Text...")
        );

        // Hier option schlauchhaspel
        List<FunkSpruch> funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Zum Abnehmen der Schlauchhaspel..."),
                neu(FunkSpruch.Sprecher.MASCHI, "Wassertrupp zur Schlauchhaspel!")
        );
        if (currentSchlauchhaspel) {
            sprueche.addAll(funkSpruchList);
        } else {
            sprueche.addAll(funkSpruchList_leer);
        }

        return sprueche;
    }

    List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
        boolean currentSchlauchhaspel = sp.getBoolean("schlauchhaspel", false);
        boolean currentGruppe = sp.getBoolean("einheitGruppe", true);
        checkForChanges(currentSchlauchhaspel, currentGruppe);

        List<FunkSpruch> sprueche = new ArrayList<FunkSpruch>() {};

        if (!currentSchlauchhaspel && currentGruppe) {
            sprueche = List.of(
                    neu(FunkSpruch.Sprecher.KONTEXT, "In diesem Szenario kein Text...")
            );
        } else {
            // Hier option schlauchhaspel
            List<FunkSpruch> funkSpruchList = Arrays.asList(
                    neu(FunkSpruch.Sprecher.KONTEXT, "Zum Abnehmen der Schlauchhaspel..."),
                    neu(FunkSpruch.Sprecher.MASCHI, "Wassertrupp zur Schlauchhaspel!")
            );
            if (currentSchlauchhaspel) {
                sprueche.addAll(funkSpruchList);
            }

            funkSpruchList = Arrays.asList(
                    neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."),
                    neu(FunkSpruch.Sprecher.MASCHI, "Zum Aufbau der Sofort-Dekon \nmit Kübelspritze und Verbandkasten \nan die rechte Seite der Grenze des Gefahrenbereichs \nauf direktem Weg \nvor!")
            );
            if (!currentGruppe) {
                sprueche.addAll(funkSpruchList);
            }
        }

        return sprueche;
    }
}
