package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.List;

import timber.log.Timber;

public abstract class FunkSprüche implements IFunkSprüche {
    private FunkSpruch.Sprecher mSprecher;
    private List<FunkSpruch> funkSprueche;
    private String lastUebung = "";
    private boolean changedInLastUpdate = false;

    static FunkSpruch neu(FunkSpruch.Sprecher sprecher, String spruch) {
        return new FunkSpruch(sprecher, spruch);
    }

    public FunkSprüche(SharedPreferences sp, FunkSpruch.Sprecher sprecher) {
        initFunksprüche(sp);
        mSprecher = sprecher;
    }

    private void initFunksprüche(SharedPreferences sp) {
        Timber.d("initFunksprüche() called");
        String currentÜbung = sp.getString("leistungsübung", LÖSCHÜBUNG);
        changedInLastUpdate = !currentÜbung.equals(lastUebung);
        lastUebung = currentÜbung;

        if (currentÜbung.equals(LÖSCHÜBUNG)) {
            funkSprueche = initFunksprücheLoeschangriff(sp);
        } else if (currentÜbung.equals(GABC)) {
            funkSprueche = initFunksprücheGABC(sp);
        } else {
            Timber.e("Unknown Leistungsübung: %s", currentÜbung);
            assert (false);
        }
        Timber.d("initFunksprüche() finished. Size: %d", funkSprueche.size());
    }

    abstract List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp);

    abstract List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp);

    @Override
    public FunkSpruch.Sprecher getSprecher() {
        return mSprecher;
    }

    @Override
    public List<FunkSpruch> funksprueche() {
        return funkSprueche;
    }

    @Override
    public void updateItems(SharedPreferences sp) {
        initFunksprüche(sp);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return changedInLastUpdate;
    }
}
