package de.questmaster.wettkampf_funk_trainer;

import static android.os.Build.VERSION_CODES.UPSIDE_DOWN_CAKE;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;

import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.fragment.app.Fragment;

import com.github.appintro.AppIntro;
import com.github.appintro.AppIntroFragment;
import com.github.appintro.AppIntroPageTransformerType;

public class OnboardingActivity extends AppIntro {

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

/*      FIXME: Needed if not using immersive mode!

        Window window = getWindow();
        WindowCompat.setDecorFitsSystemWindows(window, false);

        // Now, add the insets handling:
        ViewCompat.setOnApplyWindowInsetsListener(window.getDecorView(), (view, insets) -> {
            Insets systemBarsInsets = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            // view.setBackgroundColor(getColor(R.color.enneNavyBlue));
            //  setBackgroundColor might interfere with AppIntro's slide backgrounds. Remove for now,
            //  or adjust if you want a global background color behind the slides.  You'd likely need
            //  to make this color transparent or match your first slide's background for a seamless
            //  transition.  If you intend a background *behind* the slides, you might need to adjust
            //  AppIntro's layout or use a different approach (e.g., a FrameLayout wrapping AppIntro).
            view.setPadding(0, systemBarsInsets.top, 0, systemBarsInsets.bottom);
            return insets;
        });

        WindowInsetsControllerCompat windowInsetsController =
                new WindowInsetsControllerCompat(window, window.getDecorView());
        // windowInsetsController.isAppearanceLightStatusBars = false
        windowInsetsController.setAppearanceLightStatusBars(false); // Or true for light status bar icons
        // Make navigation bar transparent (and dark icons/content if needed.)
        windowInsetsController.setAppearanceLightNavigationBars(false);  // For dark icons.  Set to true for light icons
        windowInsetsController.setSystemBarsBehavior(WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE);
*/

        addSlide(AppIntroFragment.createInstance(
                getResources().getString(R.string.onboarding_pref_einheit_titel),
                getResources().getString(R.string.onboarding_pref_einheit),
                R.drawable.appintro_einheit,
                R.color.appintro_example_orange
        ));

        addSlide(AppIntroFragment.createInstance(
                getResources().getString(R.string.onboarding_pref_ort_titel),
                getResources().getString(R.string.onboarding_pref_ort),
                R.drawable.appintro_austragung,
                R.color.appintro_example_lime
        ));

        addSlide(AppIntroFragment.createInstance(
                getResources().getString(R.string.onboarding_menu_titel),
                getResources().getString(R.string.onboarding_menu),
                R.drawable.appintro_burger,
                R.color.appintro_example_blue
        ));

        addSlide(AppIntroFragment.createInstance(
                getResources().getString(R.string.onboarding_texte_titel),
                getResources().getString(R.string.onboarding_texte),
                R.drawable.appintro_texte,
                R.color.appintro_example_blue_gray
        ));

        addSlide(AppIntroFragment.createInstance(
                getResources().getString(R.string.onboarding_lernen_titel),
                getResources().getString(R.string.onboarding_lernen),
                R.drawable.appintro_lernen,
                R.color.appintro_example_green
        ));

        // Fade Transition
        setTransformer(AppIntroPageTransformerType.Fade.INSTANCE);

        // Show/hide status bar
        showStatusBar(true);
        //Enable the color "fade" animation between two slides (make sure the slide implements SlideBackgroundColorHolder)
        setColorTransitionsEnabled(true);

        //Prevent the back button from exiting the slides
        setSystemBackButtonLocked(true);

        //Activate wizard mode (Some aesthetic changes)
        setWizardMode(true);

        //Enable immersive mode (no status and nav bar)
        if (Build.VERSION.SDK_INT >= UPSIDE_DOWN_CAKE) {
            setImmersiveMode();
        }

        //Enable/disable page indicators
        setIndicatorEnabled(true);

        //Dhow/hide ALL buttons
        setButtonsEnabled(true);
    }

    @Override
    protected void onSkipPressed(Fragment currentFragment) {
        super.onSkipPressed(currentFragment);
        startActivity(new Intent(this, SettingsActivity.class));
        finish();
    }

    @Override
    protected void onDonePressed(Fragment currentFragment) {
        super.onDonePressed(currentFragment);
        startActivity(new Intent(this, SettingsActivity.class));
        finish();
    }

}
