package de.questmaster.wettkampf_funk_trainer.utilities;

import android.content.Context;
import android.content.SharedPreferences;

public class PrefsHelper {

    private static final String PREFS_NAME = "app_prefs";
    private static final String KEY_FIRST_LAUNCH = "first_launch";
    private static final String KEY_APP_LAUNCH = "app_launch";

    // local statistics
    private static final String KEY_START_TRAINING_EL = "training_start_el";
    private static final String KEY_FINISH_TRAINING_EL = "training_finish_el";
    private static final String KEY_START_TRAINING_AT = "training_start_at";
    private static final String KEY_FINISH_TRAINING_AT = "training_finish_at";
    private static final String KEY_START_TRAINING_WT = "training_start_wt";
    private static final String KEY_FINISH_TRAINING_WT = "training_finish_wt";

    private final SharedPreferences sharedPreferences;

    public PrefsHelper(Context context) {
        this.sharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
    }

    public PrefsHelper(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    public boolean isFirstLaunch() {
        return sharedPreferences.getBoolean(KEY_FIRST_LAUNCH, true);
    }

    public void setFirstLaunch(boolean isFirstLaunch) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_FIRST_LAUNCH, isFirstLaunch);
        editor.apply();
    }

    public int getAppLaunchCount() {
        return sharedPreferences.getInt(KEY_APP_LAUNCH, 0);
    }

    public void addAppLaunch() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_APP_LAUNCH, getAppLaunchCount() + 1);
        editor.apply();
    }

    public void addStartTrainingElCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_START_TRAINING_EL, sharedPreferences.getInt(KEY_START_TRAINING_EL, 0) + 1);
        editor.apply();
    }

    public void addFinishTrainingElCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_FINISH_TRAINING_EL, sharedPreferences.getInt(KEY_FINISH_TRAINING_EL, 0) + 1);
        editor.apply();
    }

    public void addStartTrainingAtCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_START_TRAINING_AT, sharedPreferences.getInt(KEY_START_TRAINING_AT, 0) + 1);
        editor.apply();
    }

    public void addFinishTrainingAtCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_FINISH_TRAINING_AT, sharedPreferences.getInt(KEY_FINISH_TRAINING_AT, 0) + 1);
        editor.apply();
    }

    public void addStartTrainingWtCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_START_TRAINING_WT, sharedPreferences.getInt(KEY_START_TRAINING_WT, 0) + 1);
        editor.apply();
    }

    public void addFinishTrainingWtCount() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_FINISH_TRAINING_WT, sharedPreferences.getInt(KEY_FINISH_TRAINING_WT, 0) + 1);
        editor.apply();
    }
}