package de.questmaster.wettkampf_funk_trainer.ui.settings;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;
import androidx.preference.PreferenceManager;
import androidx.recyclerview.widget.RecyclerView;

import de.questmaster.wettkampf_funk_trainer.R;
import de.questmaster.wettkampf_funk_trainer.data.IFunkSprüche;

public class SettingsFragment extends PreferenceFragmentCompat implements SharedPreferences.OnSharedPreferenceChangeListener {
    private SharedPreferences sharedPreferences;
    private Preference pressluftatmerPref;
    private Preference schnellVerteilerPref;
    private Preference fahrzeugWasserPref;
    private final String LEISTUNGSÜBUNG_KEY = "leistungsübung";
    private final String PRESSLUFTATMER_KEY = "pressluftatmer";
    private final String SCHNELLVERTEILER_KEY = "schnellVerteiler";
    private final String FAHRZEUGWASSER_KEY = "fahrzeugWasser";

    @Override
    public void onCreatePreferences(Bundle savedInstanceState, String rootKey) {
        setPreferencesFromResource(R.xml.root_preferences, rootKey);

        sharedPreferences = PreferenceManager.getDefaultSharedPreferences(requireContext());
        pressluftatmerPref = findPreference(PRESSLUFTATMER_KEY);
        schnellVerteilerPref = findPreference(SCHNELLVERTEILER_KEY);
        fahrzeugWasserPref = findPreference(FAHRZEUGWASSER_KEY);

        // Set initial visibility
        updateÜbungPrefsVisibility();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Ensure RecyclerView handles padding correctly for scrolling
        RecyclerView recyclerView = getListView();
        if (recyclerView != null) {
            recyclerView.setClipToPadding(false);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        sharedPreferences.registerOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (LEISTUNGSÜBUNG_KEY.equals(key)) {
            updateÜbungPrefsVisibility();
        }
    }

    private void updateÜbungPrefsVisibility() {
        String löschübung = sharedPreferences.getString(LEISTUNGSÜBUNG_KEY, IFunkSprüche.LÖSCHÜBUNG);

        if (pressluftatmerPref != null) {
            pressluftatmerPref.setVisible(löschübung.equals(IFunkSprüche.LÖSCHÜBUNG));
        }
        if (schnellVerteilerPref != null) {
            schnellVerteilerPref.setVisible(löschübung.equals(IFunkSprüche.GABC));
        }
        if (fahrzeugWasserPref != null) {
            fahrzeugWasserPref.setVisible(löschübung.equals(IFunkSprüche.GABC));
        }
    }
}
