package de.questmaster.wettkampf_funk_trainer.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import de.questmaster.wettkampf_funk_trainer.R;
import de.questmaster.wettkampf_funk_trainer.data.FunkSpruch;

public class CustomItemDecoration extends RecyclerView.ItemDecoration {
    private final FunkSpruch.Sprecher sprecher;

    // Performance-Optimierung: Theme-Color nur einmal cachen
    private Integer cachedDefaultColor = null;

    public CustomItemDecoration(FunkSpruch.Sprecher sprecher) {
        this.sprecher = sprecher;
    }

    /**
     * Ermittelt die Standard-Textfarbe aus dem Theme.
     * Nutzt Caching um wiederholte Theme-Lookups zu vermeiden.
     *
     * Performance-Optimierung: Theme-Lookup ist teuer, wird nur beim ersten Aufruf durchgeführt.
     *
     * @param context Der Context für Theme-Zugriff
     * @return Die Standard-Textfarbe
     */
    private int getDefaultTextColor(Context context) {
        if (cachedDefaultColor == null) {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(android.R.attr.colorForeground, typedValue, true);
            cachedDefaultColor = typedValue.data;
        }
        return cachedDefaultColor;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        outRect.left = 0;
        outRect.right = 0;
        outRect.bottom = 0;
        outRect.top = 0;

        TextView numberView = view.findViewById(R.id.item_number);
        TextView textView = view.findViewById(R.id.content);

        String itemSprecher = numberView.getText().toString();

        if (!itemSprecher.equals(this.sprecher.toNameString())) {
            // anderer Sprecher
            textView.setTextColor(Color.GRAY);
        } else {
            // Aktueller Sprecher - gecachte Default-Color verwenden
            textView.setTextColor(getDefaultTextColor(view.getContext()));
        }
    }
}