package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WtFunkSprüche extends FunkSprüche {

    private String lastEinheit = "";
    private boolean lastEinheitGruppe;
    private boolean lastSchnellVerteiler;
    private boolean lastFahrzeugWasser;
    private boolean changedInLastUpdate = false;

    public WtFunkSprüche(SharedPreferences sp) {
        super(sp, FunkSpruch.Sprecher.W_TRUPP);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return super.isChangedInLastUpdate() || changedInLastUpdate;
    }

    private void checkForChanges(String currentEinheit, boolean currentEinheitGruppe, boolean currentSchnellVerteiler, boolean currentFahrzeugWasser) {
        // Defensive Null-Check für String-Parameter
        String safeCurrentEinheit = currentEinheit != null ? currentEinheit : "";

        changedInLastUpdate = !safeCurrentEinheit.equals(lastEinheit) || currentEinheitGruppe != lastEinheitGruppe || currentSchnellVerteiler != lastSchnellVerteiler
                || currentFahrzeugWasser != lastFahrzeugWasser;
        lastEinheit = safeCurrentEinheit;
        lastEinheitGruppe = currentEinheitGruppe;
        lastSchnellVerteiler = currentSchnellVerteiler;
        lastFahrzeugWasser = currentFahrzeugWasser;
    }

    @Override
    List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
        String currentEinheit = sp.getString("currentEinheit", "<Einheit fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        boolean currentSchnellVerteiler = sp.getBoolean("schnellVerteiler", true);
        boolean currentFahrzeugWasser = sp.getBoolean("fahrzeugWasser", true);
        checkForChanges(currentEinheit, currentEinheitGruppe, currentSchnellVerteiler, currentFahrzeugWasser);

        return new ArrayList<FunkSpruch>() {{
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Anschließen am Verteiler..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Wasser marsch!"));
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Ausrüsten als Sicherheitstrupp..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Wassertrupp als Sicherheitstrupp einsatzbereit!"));
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Zur Brandbekämpfung \nmit 2. Rohr \nzur rechten Gebäudeseite \nvon der Steckleiter \nvor!"));
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach 2. Rohr in Stellung bringen und Eigensicherung..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "(Truppmann) Fertig!"));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "2. Rohr Wasser marsch!"));
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Fallklappen umgespritzt..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Feuer aus!"));
        }};
    }

    @Override
    List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
        String currentEinheit = sp.getString("currentEinheit", "<Einheit fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        boolean currentSchnellVerteiler = sp.getBoolean("schnellVerteiler", true);
        boolean currentFahrzeugWasser = sp.getBoolean("fahrzeugWasser", true);
        checkForChanges(currentEinheit, currentEinheitGruppe, currentSchnellVerteiler, currentFahrzeugWasser);

        List<FunkSpruch> sprueche;
        String einheittyp = "Staffelführer";
        if (currentEinheitGruppe) {
            einheittyp = "Gruppenführer";
        }
        String finalEinheittyp = einheittyp;

        sprueche = new ArrayList<FunkSpruch>() {};

        // Hier option schnellVerteiler & fahrzeugWasser
        List<FunkSpruch> funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Nach fertigstellen der Wasserversorgung..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Wasser marsch!")
        );
        if (!(currentSchnellVerteiler && currentFahrzeugWasser)
            || !currentFahrzeugWasser) {
            sprueche.addAll(funkSpruchList);
        }

        funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Nach ausrüsten als Sicherheitstrupp..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Wassertrupp als Sicherheitstrupp einsatzbereit!"),

                neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Zur Menschenrettung \nmit Pressluftatmern und Krankentrage \nzur am Boden liegenden Person \nüber den Hof \nvor!"),

                neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Betreten des Gefahrenbereichs..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Lungenautomat angeschlossen, betreten Gefahrenbereich."),

                neu(FunkSpruch.Sprecher.KONTEXT, "Beim Retten der Person..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Wassertrupp, kommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Person erreicht, \nPerson ist bewusstlos und kontaminiert, \nbringen sie zur Sofort-Dekon, \nkommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Ende."),

                neu(FunkSpruch.Sprecher.KONTEXT, "Bei Übergabe an den Rettungsdienst..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Person ist bewusstlos und kontaminiert, \nSofort-Dekon durchgeführt."),

                neu(FunkSpruch.Sprecher.KONTEXT, "Meldung nach der Übergabe an Rettungsdienst..."),
                neu(FunkSpruch.Sprecher.W_TRUPP, "Eine Person gerettet, \nSofort-Dekon durchgeführt und dem Rettungsdienst übergeben.")

        );
        sprueche.addAll(funkSpruchList);

        return sprueche;
    }
}
