package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StFunkSprüche extends FunkSprüche {

    private boolean lastEinheitGruppe;
    private boolean changedInLastUpdate = false;

    public StFunkSprüche(SharedPreferences sp) {
        super(sp, FunkSpruch.Sprecher.S_TRUPP);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return super.isChangedInLastUpdate() || changedInLastUpdate;
    }

    private void checkForChanges(boolean currentEinheitGruppe) {
        changedInLastUpdate = currentEinheitGruppe != lastEinheitGruppe;
        lastEinheitGruppe = currentEinheitGruppe;
    }

    List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
        checkForChanges(lastEinheitGruppe);

        return List.of(
                neu(FunkSpruch.Sprecher.KONTEXT, "In diesem Szenario kein Text...")
        );
    }

    List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        checkForChanges(currentEinheitGruppe);

        List<FunkSpruch> sprueche = new ArrayList<FunkSpruch>() {};

        // Hier option staffel
        List<FunkSpruch> funkSpruchList_leer = List.of(
                neu(FunkSpruch.Sprecher.KONTEXT, "In diesem Szenario kein Text...")
        );

        // Hier option gruppe
        List<FunkSpruch> funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."),
                neu(FunkSpruch.Sprecher.S_TRUPP, "Zum Aufbau der Sofort-Dekon \nmit Kübelspritze und Verbandkasten \nan die rechte Seite der Grenze des Gefahrenbereichs \nauf direktem Weg \nvor!")
        );
        if (currentEinheitGruppe) {
            sprueche.addAll(funkSpruchList);
        } else {
            sprueche.addAll(funkSpruchList_leer);
        }

        return sprueche;
    }
}
