package de.questmaster.wettkampf_funk_trainer.data;

public class FunkSpruch {

    public enum Sprecher {
        ZLST, A_TRUPP, W_TRUPP, E_LEITER, MASCHI, KONTEXT, SCHIRI, S_TRUPP;

        // Performance-Optimierung: Cache für toNameString() - verhindert wiederholte String-Allokationen
        private String cachedName = null;

        public String toNameString() {
            // Lazy initialization: Nur beim ersten Aufruf berechnen, dann aus Cache
            if (cachedName == null) {
                cachedName = computeName();
            }
            return cachedName;
        }

        private String computeName() {
            switch (this) {
                case ZLST:
                    return "ZLST";
                case A_TRUPP:
                    return "AT";
                case W_TRUPP:
                    return "WT";
                case E_LEITER:
                    return "EL";
                case MASCHI:
                    return "MA";
                case SCHIRI:
                    return "SR";
                case S_TRUPP:
                    return "ST";
                default:
                    return "";
            }
        }
    }

    private Sprecher sprecher;
    private String spruch;

    public FunkSpruch(Sprecher sprecher, String spruch) {
        this.sprecher = sprecher;
        this.spruch = spruch;
    }

    public String getSpruch() {
        return spruch;
    }

    public Sprecher getSprecher() {
        return sprecher;
    }
}
