package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ElFunkSprüche extends FunkSprüche {

    private String lastEinheit = "";
    private String lastAustragungsort = "";
    private boolean lastEinheitGruppe;
    private boolean lastPressluftatmer;
    private boolean changedInLastUpdate = false;

    public ElFunkSprüche(SharedPreferences sp) {
        super(sp, FunkSpruch.Sprecher.E_LEITER);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return super.isChangedInLastUpdate() || changedInLastUpdate;
    }

    private void checkForChanges(String currentEinheit, String currentAustragungsort, boolean currentEinheitGruppe, boolean currentPressluftatmer) {
        // Defensive Null-Checks für String-Parameter
        String safeCurrentEinheit = currentEinheit != null ? currentEinheit : "";
        String safeCurrentAustragungsort = currentAustragungsort != null ? currentAustragungsort : "";

        changedInLastUpdate = !safeCurrentEinheit.equals(lastEinheit) || !safeCurrentAustragungsort.equals(lastAustragungsort)
                || currentEinheitGruppe != lastEinheitGruppe || currentPressluftatmer != lastPressluftatmer;
        lastEinheit = safeCurrentEinheit;
        lastAustragungsort = safeCurrentAustragungsort;
        lastEinheitGruppe = currentEinheitGruppe;
        lastPressluftatmer = currentPressluftatmer;
    }

    @Override
    List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
        String currentEinheit = sp.getString("einheit", "<Einheit fehlt>");
        String currentAustragungsort = sp.getString("ort", "<Austragungsort fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        boolean currentPressluftatmer = sp.getBoolean("pressluftatmer", true);
        checkForChanges(currentEinheit, currentAustragungsort, currentEinheitGruppe, currentPressluftatmer);

        List<FunkSpruch> sprueche;
        String einheitTyp = "Staffelführer";
        Integer einheitGröße = 5;
        String befehlSteckleiter = "Angriffstrupp unterstützt beim";
        if (currentEinheitGruppe) {
            einheitTyp = "Gruppenführer";
            einheitGröße = 8;
            befehlSteckleiter = "Schlauchtrupp mit Unterstützung des Melders zum";
        }
        String finalEinheittyp = einheitTyp;
        Integer finalEinheitGröße = einheitGröße;
        String finalBefehlSteckleiter = befehlSteckleiter;

        sprueche = new ArrayList<FunkSpruch>() {{
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Alarmierung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Sie haben alarmiert, Frage was liegt an, kommen?"));
            add(neu(FunkSpruch.Sprecher.ZLST, "Wohnungsbrand " + currentAustragungsort + ", ein RTW auf der Anfaht, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Wohnungsbrand " + currentAustragungsort + ", ein RTW auf der Anfahrt, Besatzung 1/" + finalEinheitGröße + ", auf dem Weg zur Einsatzstelle, kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, Ende."));

// TODO: AGTs im FZG oder außen? Hier innen!

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach erreichen der E-Stelle..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "An der Einsatzstelle eingetroffen, kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Verlassen des Fahrzeugs..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Absitzen!"));

// TODO: AGTs außerhalb FZG

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl am Fahrzeug..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Wasserentnahme nächster Unterflurhydrant, \nVerteiler zehn Meter vor den Hauseingang, \nMaschinist übernimmt Atemschutzüberwachung, \nzum Einsatz fertig!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Fragen zur Erkundung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "- Personen im Gebäude? \n- Aufenthaltsort der Personen? \n- Zugang ins Gebäude?"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl an Angriffstrupp..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Angriffstrupp zur Menschenrettung \nmit Pressluftatmern und 1. Rohr \nins Wohnzimmer \ndurch den Hauseingang \nvor!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Lagemeldung nach Erkundung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Lagemeldung: " + currentAustragungsort + ", Wohnungsbrand, eine Person im Gebäude vermisst, Menschenrettung ist eingeleitet, benötige weiteres Löschgruppenfahrzeug und einen Notarzt, kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Wohnungsbrand, eine Person im Gebäude vermisst, Menschenrettung wurde eingeleitet, weiteres Löschgruppenfahrzeug und ein Notarzt werden benötigt, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Betreten des Gebäudes..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Lungenautomat angeschlossen, betreten Gebäude, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Beim Erreichen des Wohnzimmers..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Wohnzimmer erreicht, Person gefunden, Menschenrettung erst nach Brandbekämpfung möglich, Brandbekämpfung eingeleitet, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Ansprechen der Person..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Person bewusstlos, bringen sie ins Freie, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Abschließende Meldung..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Eine Person aus dem Gebäude gerettet und dem Rettungsdienst übergeben, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));
        }};

        // Hier option pressluftatmer
        List<FunkSpruch> funkSpruchList = Arrays.asList(
            neu(FunkSpruch.Sprecher.KONTEXT, "Zurück am Verteiler..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Angriffstrupp und Wassertrupp, Pressluftatmer ablegen.")
        );
        if (currentPressluftatmer) {
            sprueche.addAll(funkSpruchList);
        }

        funkSpruchList = Arrays.asList(
            neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl Wassertrupp..."),
            neu(FunkSpruch.Sprecher.E_LEITER, finalBefehlSteckleiter + " In-Stellung-bringen der Steckleiter. \nWassertrupp zur Brandbekämpfung \nmit 2. Rohr \nzur rechten Gebäudeseite \nvon der Steckleiter \nvor!"),

            neu(FunkSpruch.Sprecher.KONTEXT, "Lagemeldung nach Einsatzbefehl Wassertrupp..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."),
            neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Lagemeldung: "+ currentAustragungsort +", eine Person aus dem Gebäude gerettet, Person dem Rettungsdienst übergeben, 2. Rohr im Außenangriff in Vorbereitung, kommen."),
            neu(FunkSpruch.Sprecher.ZLST, "Eine Person aus dem Gebäude gerettet, 2. Rohr im Außenangriff in Vorbereitung, kommen."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, Ende."),

            neu(FunkSpruch.Sprecher.KONTEXT, "Nach Anlegen der Leiter..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Angriffstruppführer bedient Verteiler!"),
            neu(FunkSpruch.Sprecher.KONTEXT, "Nach Feuer aus..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Übung beendet!"),

            neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Knotengestell..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Knoten und Stiche anlegen!"),

            neu(FunkSpruch.Sprecher.KONTEXT, "Abschluss Knoten..."),
            neu(FunkSpruch.Sprecher.E_LEITER, "Fertig!")
        );
        sprueche.addAll(funkSpruchList);

        return sprueche;
    }

    @Override
    List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
        String currentEinheit = sp.getString("einheit", "<Einheit fehlt>");
        String currentAustragungsort = sp.getString("ort", "<Austragungsort fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        checkForChanges(currentEinheit, currentAustragungsort, currentEinheitGruppe, lastPressluftatmer);

        List<FunkSpruch> sprueche;
        String einheitTyp = "Staffelführer";
        Integer einheitGröße = 5;
        String einheitSofortDekon = "Maschinist";
        if (currentEinheitGruppe) {
            einheitTyp = "Gruppenführer";
            einheitGröße = 8;
            einheitSofortDekon = "Schlauchtrupp";
        }
        String finalEinheittyp = einheitTyp;
        Integer finalEinheitGröße = einheitGröße;
        String finalEinheitSofortDekon = einheitSofortDekon;

        sprueche = new ArrayList<FunkSpruch>() {{
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Alarmierung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Sie haben alarmiert, Frage was liegt an, kommen?"));
            add(neu(FunkSpruch.Sprecher.ZLST, "H Gefahr I, Unfall mit Gefahrstoffaustritt, \n" + currentAustragungsort + ", \nein RTW auf der Anfahrt, \nkommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "H Gefahr I, Unfall mit Gefahrstoffaustritt, \n" + currentAustragungsort + ", \nein RTW auf der Anfahrt, \nBesatzung 1/" + finalEinheitGröße + ", \nauf dem Weg zur Einsatzstelle, \nkommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, Ende."));

// TODO: AGTs im FZG oder außen? Hier innen!

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach erreichen der E-Stelle..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "An der Einsatzstelle eingetroffen. \nRegal in einem offenen Lagerbereich eines Industrieunternehmens beschädigt, \nmehrere Gebinde heruntergefallen, \nes brennt ein Gabelstapler und eine Flüssigkeitslache, \neine Person am Boden liegend und vom Brand bedroht, \nbenötige einen Notarzt, \nkommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Verlassen des Fahrzeugs..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Absitzen!"));

 // TODO: AGTs außerhalb FZG

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl am Fahrzeug..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Wasserentnahme nächster Unterflurhydrant, \nVerteiler an die Grenze des Gefahrenbereichs, \nAngriffstrupp markiert Gefahrenbereich in der Einfahrt zum Firmengelände mit einer Leine, \nMaschinist übernimmt Atemschutzüberwachung, \nzum Einsatz fertig!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Fragen zur Erkundung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "- Betroffene Personen? \n- Weiter Personen auf Gelände? \n- Gesundheitszustand Mitarbeiter? \n- Kontaminierung Mitarbeiter? \n- Antrieb/Zustand Gabelstapler? \n- Gefahrstoffname? \n- Eigenschaften Gefahrstoff? \n- Löschmittel? \n- Gefahrstoffinformationen?"));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Bleiben sie bitte hier an der Absperrung stehen und halten sich für weitere Rückfragen bereit!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl an Angriffstrupp..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Zur Lage: Brennt gasbetriebener Gabelstapler und eine Lache ausgetretener [Gefahrstoff]. \nGasflasche des Gabelstaplers ist wärmebeaufschlagt. \nEine Person am Boden liegend und vom Brand bedroht.\nMenschenrettung erst nach Brandbekämpfung möglich.\n Angriffstrupp zur Brandbekämpfung und Kühlung der Gasflasche \nmit Pressluftatmern und 1. Rohr \nzur brennenden Gefahrgutlache und Stapler \nüber den Hof \nvor!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl an " + finalEinheitSofortDekon + "..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, finalEinheitSofortDekon + " zum Aufbau der Sofort-Dekon \nmit Kübelspritze und Verbandkasten \nan die rechte Seite der Grenze des Gefahrenbereichs \nauf direktem Weg \nvor!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Einsatzbefehl an Wassertrupp..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Wassertrupp zur Menschenrettung \nmit Pressluftatmern und Krankentrage \nzur am Boden liegenden Person \nüber den Hof \nvor!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Lagemeldung nach Einsatzbefehlen..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Lagemeldung: " + currentAustragungsort + ", \nausgetretener Gefahrstoff ist [Gefahrstoff, UN-Nummer xxxx], \nein Gabelstapler und 10 m² ausgetretener Gefahrstoff in Brand geraten, \neine Person am Boden liegend und vom Brand bedroht, \nBrandbekämpfung und Menschenrettung mit zwoh Trupps eingeleitet, \nkommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Beim Einleiten der Brandbekämpfung..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Einsatzziel erreicht, Brandbekämpfung aufgenommen, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Beim Retten der Person..."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Wassertrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Person erreicht, Person ist bewusstlos und kontaminiert, bringen sie zur Sofort-Dekon, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.W_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Übergabe der Person an Rettungsdienst..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit +" " + finalEinheittyp + " von "+ currentEinheit +" Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier "+ currentEinheit +" " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Feuer aus, Gasflasche gekühlt, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Lagemeldung nach Feuer aus..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Leitstelle Übung von "+ currentEinheit +", kommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Hier Leitstelle Übung, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Lagemeldung: "+ currentAustragungsort +", Feuer aus, \neine bewusstlose Person gerettet und Sofort-Dekon durchgeführt, \nPerson dem Rettungsdienst übergeben, \nkommen."));
            add(neu(FunkSpruch.Sprecher.ZLST, "Verstanden, Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Lagemeldung..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Übung beendet!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Knotengestell..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Knoten und Stiche anlegen!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Abschluss Knoten..."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Fertig!"));
    }};

        return sprueche;
    }
}
